<?php

/** Copyright 2010 Tactical FLEX
 *
 * Aanval 5
 *
 * This program is owned and licensed by Tactical FLEX; it may be
 * redistributed only in its original configuration as originally
 * installed and available by Tactical FLEX and / or Aanval.
 *
 * To license and / or include this product in other forms or
 * applications, express prior written authorization must be
 * obtained by contract from authorized Tactical FLEX or Aanval agents.
 *
 * Tactical FLEX and Aanval may not be held liable nor responsible
 * for any and all issues arising from the use of, damages caused by, or 
 * conclusions drawn from the use of this product.
 *
 */
 
class dataStore {

	function setVar($key, $value) {
		$this->s_vars[$key] = $value;
	}

	function getVar($key) {
		$this->s_vars[$key] = stripslashes($this->s_vars[$key]);
		return $this->s_vars[$key];
	}
	
	function dataStore() {
		global $idsDB;
		
		// Check for auto increment by event count (data store settings)
		if (ops("site_dataStoreRotationType") == 2) {
			
			if ($this->getCurrentEventID() >= ops("site_dataStoreRotationEvents")) {
				
				// Turn on dataswitch ops variable
				ops("site_dataSwitch", "1");
			
				dblog("Processor A", "DataStore Switch Detected", $flag, "Automated - By Event Count");
					
			}
		}
		
		// Check for auto increment by day (data store settings)
		if (ops("site_dataStoreRotationType") == 1) {
			
			$idsQueryA = $idsDB->query("SELECT UNIX_TIMESTAMP(created) FROM idsDataStore_" . ops("site_activeDataStore") . "_Master ORDER BY id ASC LIMIT 1");
	    	while (list($d1) = mysql_fetch_row($idsQueryA)) {
	    		$timestamp = $d1;
			}
			
			if ($timestamp) {
			
				$comp = time() - (ops("site_dataStoreRotationDays") * 86400);
				
				if ($timestamp <= $comp) {
				
					// Turn on dataswitch ops variable
					ops("site_dataSwitch", "1");
					
					dblog("Processor A", "DataStore Switch Detected", $flag, "Automated - By Day");
					
				}
				
			}

		}
		
		// Test for datastore switching
		if (ops("site_dataSwitch") == 1) {
			
			$oldStore = ops("site_activeDataStore");
			$newStore = ops("site_activeDataStore") + 1;
			
			// Create new dataStore table structures
			$idsQueryA = $idsDB->query("CREATE TABLE idsDataStore_" . $newStore . "_Master LIKE idsDataStore_" . $oldStore . "_Master");
			$idsQueryA = $idsDB->query("CREATE TABLE idsDataStore_" . $newStore . "_Events LIKE idsDataStore_" . $oldStore . "_Events");
			$idsQueryA = $idsDB->query("CREATE TABLE idsDataStore_" . $newStore . "_Text LIKE idsDataStore_" . $oldStore . "_Text");
			$idsQueryA = $idsDB->query("CREATE TABLE idsDataStore_" . $newStore . "_Text_Index LIKE idsDataStore_" . $oldStore . "_Text_Index");
			$idsQueryA = $idsDB->query("CREATE TABLE idsDataStore_" . $newStore . "_Timescale LIKE idsDataStore_" . $oldStore . "_Timescale");

			// Increment datastore by 1
			ops("site_activeDataStore", $newStore);
			
			// Turn off dataswitch ops variable
			ops("site_dataSwitch", "0");
			
			dblog("Processor A", "New Datastore", $flag, "Store: " . ops("site_activeDataStore"));
			
			insertUserMessage(0, 3, "Datastore changed to: $newStore");
			
			// Update all users to new store
			$idsDB->query("update idsUsers set activeSearchStore = '$newStore'");
			
		}
		
	}
	
    function getCurrentEventID() {
        global $idsDB;

		$idsQueryA = $idsDB->query("SELECT id from idsDataStore_" . ops("site_activeDataStore") . "_Master order by id desc limit 1");
    	while (list($id) = mysql_fetch_row($idsQueryA)) {
    		$eventid = $id;
		}

		if (!$eventid) $eventid = 0;
		
		return $eventid;
	}		
	
	function getLastEventIDFromStore($store) {
        global $idsDB;

		$store = trim($store);	

		$idsQueryA = $idsDB->query("SELECT id from idsDataStore_" . $store . "_Master order by id desc limit 1");
    	while (list($id) = mysql_fetch_row($idsQueryA)) {
    		$eventid = $id;
		}

		if (!$eventid) $eventid = 0;

		return $eventid;
	}	
	
}

?>