<?php

/** Copyright 2010 Tactical FLEX
 *
 * Aanval 5
 *
 * This program is owned and licensed by Tactical FLEX; it may be
 * redistributed only in its original configuration as originally
 * installed and available by Tactical FLEX and / or Aanval.
 *
 * To license and / or include this product in other forms or
 * applications, express prior written authorization must be
 * obtained by contract from authorized Tactical FLEX or Aanval agents.
 *
 * Tactical FLEX and Aanval may not be held liable nor responsible
 * for any and all issues arising from the use of, damages caused by, or 
 * conclusions drawn from the use of this product.
 *
 */
 
class coreSearch {

	function setVar($key, $value) {
		$this->s_vars[$key] = $value;
	}

	function getVar($key) {
		$this->s_vars[$key] = stripslashes($this->s_vars[$key]);
		return $this->s_vars[$key];
	}

	function coreSearch() {
		
		if (login("login") == true) {
			$this->setVar("store", login("activeSearchStore"));
		} else {
			$this->setVar("store", ops("site_activeDataStore"));
		}
		
	}
	
	function searchProcess() {
		global $idsDB;

		$search = trim(strtolower($this->getVar("query")));

		// Delete Check
		if (strstr($search, "delete:")) {
			$search = trim(str_replace("delete:", "", $search));
			$deleteWrite = 1;
		}
		
		// Report Check (trigger background queue for processing)
		if (strstr($search, "rqueue:")) {
			$search = trim(str_replace("rqueue:", "", $search));
			$reportQueue = 1;
		}	
		
		// Perform query
		$q = $idsDB->query($this->buildSearchQuery($search));
		while ($row = mysql_fetch_array($q)) {
		
			// Build array of id's
			$endArray[] = $row[0];
		
		}

		if ($reportQueue == 1) {
			
			$reportObj = new coreReport();
			$reportObj->setVar("store", $this->getVar("store"));
			
			$out .= $reportObj->reportProcess($endArray, $search);
	
		} else if ($deleteWrite == 1) {

			// Delete
			writeEventDeleteFile($this->getVar("store"), $endArray);
			
		} else {
			
			return $endArray;
			
		}
		
		return $out;
	}
	
	function buildSearchQuery($search) {
	
		// DEFAULTS
		
		$order = "DESC";
		$limit = "";
	
		// Set sensorList to current user sensors so we can alter it for queries
	
		$sensorList = login("sensors");
		
		// This is an option specific to the live monitor for the selection of specific sensors to view
		
		if ($this->getVar("sensor")) {

			$tmp = explode(",", $sensorList);
		
			$getList = explode(",", $this->getVar("sensor"));
			
			foreach ($getList as $gs) {

				if (in_array($gs, $tmp)) {
				
					$sensorListArray[] = $gs;
				
				}
				
			}
			
			$sensorList = implode(",", $sensorListArray);
		
		}
		
		foreach (explode(" ", $search) as $item) {
	
			$_and = true;
			$_not = false;
	
			if ($preAction == "AND") {
				$_and = true;
				$_not = false;
				unset($preAction);
			} else if ($preAction == "NOT") {
				$_and = false;
				$_not = true;
				unset($preAction);
			}
		
			if (strtoupper($item) == "AND") {
				$preAction = "AND";
			} else if (strtoupper($item) == "NOT") {
				$preAction = "NOT";
			} else {
			
				if ($_and == true) {
	
					if (substr($item, 0, 1) == "!") {
						$qArray[] = array('op' => '-', 'term' => substr($item, 1));
					} else {
						$qArray[] = array('op' => '+', 'term' => $item);
					}
							
				} else if ($_not == true) {
					$qArray[] = array('op' => '-', 'term' => $item);
				}
	
			}
		
		}
		
		foreach ($qArray as $query) {
	
			// Set negative parameter
			if ($query['op'] == "+") { $_not = ""; $_notw = ""; } else if ($query['op'] == "-") { $_not = "!"; $_notw = "NOT"; }
		
			if (strstr($query['term'], ":")) {
		
				$tmp = explode(":", $query['term']);
	
				switch (strtoupper($tmp[0])) {
	
					case 'EVENT':
					case 'EVENTID':

						if (strstr($tmp[1], ",")) {

							$kArray[] = "evt.id $_notw IN (" . $tmp[1] . ")";

						} else {
	
							$kArray[] = "evt.id $_not= '" . $tmp[1] . "'";
							
						}
						
						break;
						
					case 'COLLECTION':

						$collectionQuery_p1 = "LEFT JOIN idsCollectionStore AS col ON evt.id = col.event";
						
						$kArray[] = "(col.cid $_notw IN (" . $tmp[1] . ") AND col.store = '" . $this->getVar("store") . "')";

						break;						

					case 'PAYLOAD':
	
						$tArray[] = "txt.text LIKE '%" . $tmp[1] . "%'";
						break;
				
					case 'SIP':
	
						if (strstr($tmp[1], "/")) {
						
							if ($_not) $tmp_not = "NOT";
						
							$tmpArray = explode("-", cidrconv($tmp[1]));
							$tmpArray[0] = ipToLong($tmpArray[0]);
							$tmpArray[1] = ipToLong($tmpArray[1]);
						
							$kArray[] = "evt.sip $tmp_not BETWEEN " . implode(" AND ", $tmpArray) . "";
						
						} else {
	
							$kArray[] = "evt.sip $_not= '" . ipToLong($tmp[1]) . "'";
							
						}
						
						break;
	
					case 'DIP':

						if (strstr($tmp[1], "/")) {
						
							if ($_not) $tmp_not = "NOT";
						
							$tmpArray = explode("-", cidrconv($tmp[1]));
							$tmpArray[0] = ipToLong($tmpArray[0]);
							$tmpArray[1] = ipToLong($tmpArray[1]);
						
							$kArray[] = "evt.dip $tmp_not BETWEEN " . implode(" AND ", $tmpArray) . "";
						
						} else {
	
							$kArray[] = "evt.dip $_not= '" . ipToLong($tmp[1]) . "'";
							
						}

						break;
	
					case 'SPORT':
					
						if (strstr($tmp[1], ",")) {
					
							$kArray[] = "evt.sport $_notw IN (" . $tmp[1] . ")";
							
						} else {

							$kArray[] = "evt.sport $_not= '" . $tmp[1] . "'";
						
						}
						
						break;
	
					case 'DPORT':

						if (strstr($tmp[1], ",")) {
					
							$kArray[] = "evt.dport $_notw IN (" . $tmp[1] . ")";
							
						} else {

							$kArray[] = "evt.dport $_not= '" . $tmp[1] . "'";
						
						}
	
						break;
	
					case 'WIN':
					
						$kArray[] = "evt.hdr_win $_not= '" . $tmp[1] . "'";
						break;
	
					case 'TTL':
					
						$kArray[] = "evt.ip_ttl $_not= '" . $tmp[1] . "'";
						break;
						
					case 'LEN':
					
						$kArray[] = "evt.hdr_len $_not= '" . $tmp[1] . "'";
						break;
	
					case 'ACK':
					
						$kArray[] = "evt.hdr_ack $_not= '" . $tmp[1] . "'";
						break;
						
					case 'SEQ':
					
						$kArray[] = "evt.hdr_seq $_not= '" . $tmp[1] . "'";
						break;
						
					case 'PROTOCOL':
					
						$kArray[] = "evt.protocol $_not= '" . $tmp[1] . "'";
						break;
	
					case 'SIGNATURE':
					
						$kArray[] = "evt.signature $_not= '" . $tmp[1] . "'";
						break;
						
					case 'CATEGORY':
					
						$kArray[] = "evt.category $_not= '" . $tmp[1] . "'";
						break;
						
					case 'SENSOR':
					case 'SENSORID':
					
						if (strstr($tmp[1], ",")) {
					
							$kArray[] = "mas.sensorID $_notw IN (" . $tmp[1] . ")";
							
						} else {

							$kArray[] = "mas.sensorID $_not= '" . $tmp[1] . "'";
						
						}
						break;
						
					case 'MODULE':
					case 'MODULEID':

						if (strstr($tmp[1], ",")) {
					
							$kArray[] = "mas.moduleID $_notw IN (" . $tmp[1] . ")";
							
						} else {

							$kArray[] = "mas.moduleID $_not= '" . $tmp[1] . "'";
						
						}
					
						break;
	
					case 'SNORT':
					
						$kArray[] = "evt.moduleID $_not= '1'";
						break;
	
					case 'SYSLOG':
					
						$kArray[] = "evt.moduleID $_not= '2'";
						break;
						
					case 'LEVEL':
					case 'RISK':
					case 'PRIORITY':
					
						$kArray[] = "evt.priority $_not= '" . $tmp[1] . "'";
						break;
	
					case 'EPOCH':
					
						if (!strstr($tmp[1], "-")) $tmp[1] = $tmp[1] . "-" . $tmp[1];
					
						$kArray[] = "evt.timestamp BETWEEN " . implode(" AND ", explode("-", $tmp[1])) . "";
						break;
						
					case 'DATE':
					
						$kArray[] = "evt.timestamp BETWEEN " . implode(" AND ", $this->generalDateTimeCalculations($tmp[1])) . "";
						break;
						
					case 'LASTHOUR':
	
						$hour = $tmp[1];
						if (!$hour || $hour == "") $hour = 1;
	
						$kArray[] = "evt.timestamp BETWEEN " . implode(" AND ", $this->timeHourCalculations($hour)) . "";
						break;
	
					case 'TODAY':
	
						$kArray[] = "evt.timestamp BETWEEN " . implode(" AND ", $this->timeDayCalculations(1)) . "";
						break;
	
					case 'YESTERDAY':
	
						$kArray[] = "evt.timestamp BETWEEN " . implode(" AND ", $this->timeDayCalculations(2)) . "";
						break;
	
					case 'LASTWEEK':
	
						$kArray[] = "evt.timestamp BETWEEN " . implode(" AND ", $this->timeDayCalculations(3)) . "";
						break;
	
					case 'LASTMONTH':
	
						$kArray[] = "evt.timestamp BETWEEN " . implode(" AND ", $this->timeDayCalculations(4)) . "";
						break;
	
					case 'LASTQUARTER':
	
						$kArray[] = "evt.timestamp BETWEEN " . implode(" AND ", $this->timeDayCalculations(5)) . "";
						break;
						
					case 'LASTYEAR':
	
						$kArray[] = "evt.timestamp BETWEEN " . implode(" AND ", $this->timeDayCalculations(6)) . "";
						break;
						
					case 'RECENT':

						$limit = "LIMIT " . $tmp[1];
						
						$recentQuery = true;
						break;
						
					case 'ASORT':

						$order = "ASC";
					
						break;

					case 'DSORT':
				
						$order = "DESC";
					
						break;
						
					default;
					
						break;
				
				}
				
			} else {
			
				if ($query['op'] == "+") {
					$tArray[] = "txt.text = '" . $query['term'] . "'";
				} else {
					$tArray_not[] = "txt.text = '" . $query['term'] . "'";
				}
			}
		
		}
		
		if (($tArray || $tArray_not) && $kArray) {
	
			// text	& keyword
		
			if (!ops("site_custom_snortGroup")) {
		
				if (!$tArray_not) {
					$query = "SELECT mas.id FROM idsDataStore_" . $this->getVar("store") . "_Master AS mas LEFT JOIN idsDataStore_" . $this->getVar("store") . "_Events AS evt ON mas.id = evt.id LEFT JOIN idsDataStore_" . $this->getVar("store") . "_Text_Index AS idx ON evt.id = idx.loc LEFT JOIN idsDataStore_" . $this->getVar("store") . "_Text AS txt ON txt.id = idx.id $collectionQuery_p1 WHERE (" . implode(" OR ", $tArray) . ") AND (" . implode(" AND ", $kArray) . ") AND mas.sensorID IN (" . $sensorList . ") GROUP BY mas.id HAVING COUNT(mas.id) = " . count($tArray) . " ORDER BY mas.created $order $limit";
				} else {
					$query = "SELECT mas.id FROM idsDataStore_" . $this->getVar("store") . "_Master AS mas LEFT JOIN idsDataStore_" . $this->getVar("store") . "_Events AS evt ON mas.id = evt.id LEFT JOIN idsDataStore_" . $this->getVar("store") . "_Text_Index AS idx ON evt.id = idx.loc LEFT JOIN idsDataStore_" . $this->getVar("store") . "_Text AS txt ON txt.id = idx.id $collectionQuery_p1 WHERE (" . implode(" OR ", $tArray) . ") AND (mas.id NOT IN (SELECT evt.id FROM idsDataStore_" . $this->getVar("store") . "_Events AS evt LEFT JOIN idsDataStore_" . $this->getVar("store") . "_Text_Index as idx ON evt.id = idx.loc LEFT JOIN idsDataStore_" . $this->getVar("store") . "_Text AS txt ON txt.id = idx.id WHERE (" . implode(" OR ", $tArray_not) . "))) AND (" . implode(" AND ", $kArray) . ") AND mas.sensorID IN (" . $sensorList . ") GROUP BY mas.id HAVING COUNT(mas.id) = " . count($tArray) . " ORDER BY mas.created $order $limit";
				}
				
			} else {

				if (!$tArray_not) {

					$query = "SELECT mas.id FROM idsDataStore_" . $this->getVar("store") . "_Master AS mas LEFT JOIN idsDataStore_" . $this->getVar("store") . "_Events AS evt ON mas.id = evt.id LEFT JOIN idsDataStore_" . $this->getVar("store") . "_Text_Index AS idx ON evt.id = idx.loc LEFT JOIN idsDataStore_" . $this->getVar("store") . "_Text AS txt ON txt.id = idx.id $collectionQuery_p1 WHERE (" . implode(" OR ", $tArray) . ") AND (" . implode(" AND ", $kArray) . ") AND evt.customGrouping RLIKE REPLACE ( REPLACE ( REPLACE ('" . $sensorList . "','+','[+]'), ' ', ''), ',', '|') GROUP BY mas.id HAVING COUNT(mas.id) = " . count($tArray) . " ORDER BY mas.created $order $limit";

				} else {

					// custom grouping

					$query = "SELECT mas.id FROM idsDataStore_" . $this->getVar("store") . "_Master AS mas LEFT JOIN idsDataStore_" . $this->getVar("store") . "_Events AS evt ON mas.id = evt.id LEFT JOIN idsDataStore_" . $this->getVar("store") . "_Text_Index AS idx ON evt.id = idx.loc LEFT JOIN idsDataStore_" . $this->getVar("store") . "_Text AS txt ON txt.id = idx.id $collectionQuery_p1 WHERE (" . implode(" OR ", $tArray) . ") AND (mas.id NOT IN (SELECT evt.id FROM idsDataStore_" . $this->getVar("store") . "_Events AS evt LEFT JOIN idsDataStore_" . $this->getVar("store") . "_Text_Index as idx ON evt.id = idx.loc LEFT JOIN idsDataStore_" . $this->getVar("store") . "_Text AS txt ON txt.id = idx.id WHERE (" . implode(" OR ", $tArray_not) . "))) AND (" . implode(" AND ", $kArray) . ") AND evt.customGrouping RLIKE REPLACE ( REPLACE ( REPLACE ('" . $sensorList . "','+','[+]'), ' ', ''), ',', '|') GROUP BY mas.id HAVING COUNT(mas.id) = " . count($tArray) . " ORDER BY mas.created $order $limit";

				}
			
			}
		
		} else if ($tArray) {
		
			// text
	
			if (!ops("site_custom_snortGroup")) {
	
				if (!$tArray_not) {

					$query = "SELECT mas.id FROM idsDataStore_" . $this->getVar("store") . "_Master AS mas LEFT JOIN idsDataStore_" . $this->getVar("store") . "_Events AS evt ON mas.id = evt.id LEFT JOIN idsDataStore_" . $this->getVar("store") . "_Text_Index AS idx ON evt.id = idx.loc LEFT JOIN idsDataStore_" . $this->getVar("store") . "_Text AS txt ON txt.id = idx.id $collectionQuery_p1 WHERE (" . implode(" OR ", $tArray) . ") AND mas.sensorID IN (" . $sensorList . ") GROUP BY mas.id HAVING COUNT(mas.id) = " . count($tArray) . " ORDER BY mas.created $order $limit";

				} else {

					// custom grouping

					$query = "SELECT mas.id FROM idsDataStore_" . $this->getVar("store") . "_Master AS mas LEFT JOIN idsDataStore_" . $this->getVar("store") . "_Events AS evt ON mas.id = evt.id LEFT JOIN idsDataStore_" . $this->getVar("store") . "_Text_Index AS idx ON evt.id = idx.loc LEFT JOIN idsDataStore_" . $this->getVar("store") . "_Text AS txt ON txt.id = idx.id $collectionQuery_p1 WHERE (" . implode(" OR ", $tArray) . ") AND (mas.id NOT IN (SELECT evt.id FROM idsDataStore_" . $this->getVar("store") . "_Events AS evt LEFT JOIN idsDataStore_" . $this->getVar("store") . "_Text_Index as idx ON evt.id = idx.loc LEFT JOIN idsDataStore_" . $this->getVar("store") . "_Text AS txt ON txt.id = idx.id WHERE (" . implode(" OR ", $tArray_not) . "))) AND mas.sensorID IN (" . $sensorList . ") GROUP BY mas.id HAVING COUNT(mas.id) = " . count($tArray) . " ORDER BY mas.created $order $limit";

				}
				
			} else {

				if (!$tArray_not) {
				
					$query = "SELECT mas.id FROM idsDataStore_" . $this->getVar("store") . "_Master AS mas LEFT JOIN idsDataStore_" . $this->getVar("store") . "_Events AS evt ON mas.id = evt.id LEFT JOIN idsDataStore_" . $this->getVar("store") . "_Text_Index AS idx ON evt.id = idx.loc LEFT JOIN idsDataStore_" . $this->getVar("store") . "_Text AS txt ON txt.id = idx.id $collectionQuery_p1 WHERE (" . implode(" OR ", $tArray) . ") AND evt.customGrouping RLIKE REPLACE ( REPLACE ( REPLACE ('" . $sensorList . "','+','[+]'), ' ', ''), ',', '|') GROUP BY mas.id HAVING COUNT(mas.id) = " . count($tArray) . " ORDER BY mas.created $order $limit";
				} else {
				
					// custom grouping
				
					$query = "SELECT mas.id FROM idsDataStore_" . $this->getVar("store") . "_Master AS mas LEFT JOIN idsDataStore_" . $this->getVar("store") . "_Events AS evt ON mas.id = evt.id LEFT JOIN idsDataStore_" . $this->getVar("store") . "_Text_Index AS idx ON evt.id = idx.loc LEFT JOIN idsDataStore_" . $this->getVar("store") . "_Text AS txt ON txt.id = idx.id $collectionQuery_p1 WHERE (" . implode(" OR ", $tArray) . ") AND (mas.id NOT IN (SELECT evt.id FROM idsDataStore_" . $this->getVar("store") . "_Events AS evt LEFT JOIN idsDataStore_" . $this->getVar("store") . "_Text_Index as idx ON evt.id = idx.loc LEFT JOIN idsDataStore_" . $this->getVar("store") . "_Text AS txt ON txt.id = idx.id WHERE (" . implode(" OR ", $tArray_not) . "))) AND evt.customGrouping RLIKE REPLACE ( REPLACE ( REPLACE ('" . $sensorList . "','+','[+]'), ' ', ''), ',', '|') GROUP BY mas.id HAVING COUNT(mas.id) = " . count($tArray) . " ORDER BY mas.created $order $limit";
				}
			
			}
		
		} else if ($kArray) {
		
			// keyword
	
			if (!ops("site_custom_snortGroup")) {
	
				$query = "SELECT mas.id FROM idsDataStore_" . $this->getVar("store") . "_Master AS mas LEFT JOIN idsDataStore_" . $this->getVar("store") . "_Events AS evt USING (id) $collectionQuery_p1 WHERE " . implode(" AND ", $kArray) . " AND mas.sensorID IN (" . login("sensors") . ") GROUP BY mas.id ORDER BY mas.created $order $limit";
				
			} else {

				// custom grouping

				$query = "SELECT mas.id FROM idsDataStore_" . $this->getVar("store") . "_Master AS mas LEFT JOIN idsDataStore_" . $this->getVar("store") . "_Events AS evt USING (id) $collectionQuery_p1 WHERE " . implode(" AND ", $kArray) . " AND evt.customGrouping RLIKE REPLACE ( REPLACE ( REPLACE ('" . $sensorList . "','+','[+]'), ' ', ''), ',', '|') GROUP BY mas.id ORDER BY mas.created $order $limit";
			
			}
		
		} else if ($recentQuery) {

			// recent
	
			if (!ops("site_custom_snortGroup")) {
			
				$query = "SELECT mas.id FROM idsDataStore_" . $this->getVar("store") . "_Master AS mas WHERE mas.sensorID IN (" . $sensorList . ") ORDER BY mas.created $order $limit";
			
			} else {

				// custom grouping

				$query = "SELECT mas.id FROM idsDataStore_" . $this->getVar("store") . "_Master AS mas LEFT JOIN idsDataStore_" . $this->getVar("store") . "_Events AS evt USING (id) WHERE evt.customGrouping RLIKE REPLACE ( REPLACE ( REPLACE ('" . $sensorList . "','+','[+]'), ' ', ''), ',', '|') ORDER BY mas.created $order $limit";
			
			}
		
		}		

#		echo "\nQ: $query\n";

		return $query;
	
	}
	
	function timeHourCalculations($hour) {
	
		$diff = $hour * 3600;

		$startEpoch = strtotime(date("y-m-d H:i")) - $diff;
		$endEpoch = strtotime(date("y-m-d H:i"));
		
		return array($startEpoch, $endEpoch);
		
	}
	
	function timeDayCalculations($type) {
	
		// 1 = Today | 2 = Yesterday | 3 = Lastweek | 4 = Lastmonth | 5 = LastQuarter | 6 = Lastyear
		
		if ($type == 1) {
			$startEpoch = strtotime(date("y-m-d"));
			$endEpoch = time();
		} else if ($type == 2) {
			$startEpoch = strtotime(date("y-m-d")) - 86400;
			$endEpoch = strtotime(date("y-m-d")) - 1;
		} else if ($type == 3) {
			$startEpoch = strtotime(date("y-m-d")) - 604800;
			$endEpoch = time();
		} else if ($type == 4) {
			$startEpoch = strtotime(date("y-m-d")) - 2592000;
			$endEpoch = time();
		} else if ($type == 5) {
			$startEpoch = strtotime(date("y-m-d")) - 7776000;
			$endEpoch = time();
		} else if ($type == 6) {
			$startEpoch = strtotime(date("y-m-d")) - 31536000;
			$endEpoch = time();
		}	
	
		return array($startEpoch, $endEpoch);
	
	}
	
	function generalDateTimeCalculations($string) {

		if (strstr($string, "-")) {
		
			$query = explode("-", $string);
		
			$query[0] = strtotime($query[0]);
			$query[1] = strtotime($query[1]);
			
		} else {
		
			$query = array(strtotime($string), strtotime($string));
			
		}

		return $query;
		
	}		
	
	function getDetailsByID($event) {
		global $idsDB;
	
		$idsQueryA = $idsDB->query("SELECT * FROM idsDataStore_" . $this->getVar("store") . "_Master as mas LEFT JOIN idsDataStore_" . $this->getVar("store") . "_Events as evt on (mas.id = evt.id) where mas.id = '$event'");
		while ($row = mysql_fetch_assoc($idsQueryA)) {
	
			foreach ($row as $key => $val) {
		
				$eventArray[$key] = $val;
		
			}
			
		}
	
		return $eventArray;
	
	}

	function getTotalEventsInCurrentStore() {
		global $idsDB;
	
		$idsQueryA = $idsDB->query("SELECT count(*) FROM idsDataStore_" . $this->getVar("store") . "_Master as mas");
    	while (list($res) = mysql_fetch_row($idsQueryA)) {
    		$eventTotal = $res;
		}

		return $eventTotal;
	
	}	
	
}

?>