<?php

/** Copyright 2010 Tactical FLEX
 *
 * Aanval 5
 *
 * This program is owned and licensed by Tactical FLEX; it may be
 * redistributed only in its original configuration as originally
 * installed and available by Tactical FLEX and / or Aanval.
 *
 * To license and / or include this product in other forms or
 * applications, express prior written authorization must be
 * obtained by contract from authorized Tactical FLEX or Aanval agents.
 *
 * Tactical FLEX and Aanval may not be held liable nor responsible
 * for any and all issues arising from the use of, damages caused by, or 
 * conclusions drawn from the use of this product.
 *
 */
 
function emailTextReport($reportData, $fromEmail, $toEmail, $subject) {

	$fromName = $fromEmail;
	$toName = $toEmail;

	$body = processReportXMLToText($reportData);

    // Send email
    sendmail($fromEmail, $fromName, $toEmail, $toName, $subject, $body);

}

function emailPDFReport($reportData, $fromEmail, $toEmail, $subject) {

	$fromName = $fromEmail;
	$toName = $toEmail;

	if (extension_loaded("gd")) {

		$data = processReportXMLToPDF($reportData);
	
		$body = $data->output("", "s");
	
	    // Send email
	    sendmailWithAttachment($fromEmail, $fromName, $toEmail, $toName, $subject, $body);
	    
	} else {
	
		dblog("PDF Reporting", "Email not sent, GD not installed");
	
	}

}

function emailScanResults($data, $fromEmail, $toEmail, $subject) {

	$fromName = $fromEmail;
	$toName = $toEmail;

	$body = $data;

    // Send email
    sendmail($fromEmail, $fromName, $toEmail, $toName, $subject, $body);

}

function sendmail($fromEmail, $fromName, $toEmail, $toName, $subject, $message, $deliver = 0) {
    global $idsDB;
        
    if ($deliver == 0) {
        $deliver = time();
    }   
        
    $subject = addslashes($subject);
    
    $message = addslashes($message);
    $message .= "\n\n---\nThis message was generated from the " . ops("site_consoleName") . " Intrusion Detection and Correlation Console.\n" . ops("site_mainURL") . "\n---\n";
                        
    if (strstr($fromEmail, ",")) {
        $tmp = explode(",", $fromEmail);
        $fromEmail = trim($tmp[0]);
    }                           
                        
    if (strstr($toEmail, ",")) {
        $list = explode(",", $toEmail);
        foreach ($list as $te) { 
            $te = trim($te);
            $idsQueryA = $idsDB->query("insert into idsEmail (uid, type, fromName, fromEmail, toName, toEmail, subject, message, intime, sent, deliver)
            values ('" . login("id") . "', 1, '$fromName', '$fromEmail', '$te', '$te', '$subject', '$message', '" . time() . "', 0, '$deliver')");
        }
    } else {
        $idsQueryA = $idsDB->query("insert into idsEmail (uid, type, fromName, fromEmail, toName, toEmail, subject, message, intime, sent, deliver)
        values ('" . login("id") . "', 1, '$fromName', '$fromEmail', '$toName', '$toEmail', '$subject', '$message', '" . time() . "', 0, '$deliver')");
    }   
}

function sendmailWithAttachment($fromEmail, $fromName, $toEmail, $toName, $subject, $message, $deliver = 0) {
    global $idsDB;
        
    if ($deliver == 0) {
        $deliver = time();
    }   
        
    $subject = addslashes($subject);
    
    $message = addslashes($message);
                        
    if (strstr($fromEmail, ",")) {
        $tmp = explode(",", $fromEmail);
        $fromEmail = trim($tmp[0]);
    }                           
                        
    if (strstr($toEmail, ",")) {
        $list = explode(",", $toEmail);
        foreach ($list as $te) { 
            $te = trim($te);
            $idsQueryA = $idsDB->query("insert into idsEmail (uid, type, fromName, fromEmail, toName, toEmail, subject, message, intime, sent, deliver)
            values ('" . login("id") . "', 3, '$fromName', '$fromEmail', '$te', '$te', '$subject', '$message', '" . time() . "', 0, '$deliver')");
        }
    } else {
        $idsQueryA = $idsDB->query("insert into idsEmail (uid, type, fromName, fromEmail, toName, toEmail, subject, message, intime, sent, deliver)
        values ('" . login("id") . "', 3, '$fromName', '$fromEmail', '$toName', '$toEmail', '$subject', '$message', '" . time() . "', 0, '$deliver')");
    }   
}

?>