<?php

/** Copyright 2010 Tactical FLEX
 *
 * Aanval 5
 *
 * This program is owned and licensed by Tactical FLEX; it may be
 * redistributed only in its original configuration as originally
 * installed and available by Tactical FLEX and / or Aanval.
 *
 * To license and / or include this product in other forms or
 * applications, express prior written authorization must be
 * obtained by contract from authorized Tactical FLEX or Aanval agents.
 *
 * Tactical FLEX and Aanval may not be held liable nor responsible
 * for any and all issues arising from the use of, damages caused by, or 
 * conclusions drawn from the use of this product.
 *
 */
 
function processReportXMLToHTML($data) {

	$xml = new SimpleXMLElement($data);
	
	$w1 = "110";
	
	$c1 = "#EDECE8";
	$c2 = "#D1C6B3";
	
	$out = "<html>";
		$out .= "<body>";

			$out .= "<table border=0 cellpadding=0 cellspacing=0 width='800' align=center><tr><td>";

			// Report Heading
			
			$out .= "The following report was generated on " . $xml->data->generatedText . "<p>";

			$out .= "Search query used to generate this report: " . $xml->data->searchText . "<p>";

			$out .= "" . $xml->data->confidentialText . "<p>";

			$out .= "" . $xml->data->objectiveText . "<p>";

			// Summary

			$out .= "<table border=1 bordercolor='$c2' cellpadding=1 cellspacing=1 width='100%'>";

			$out .= "<tr bgcolor='$c1'><td>Statistic</td><td width='$w1'>Events</td></tr>";

			foreach ($xml->data->reportStatistics->item as $tmp) {
			
				$out .= "<tr><td>" . $tmp->name . "</td><td width='$w1'>" . $tmp->total . "</td></tr>";
			
			}
			
			$out .= "</table>";

			$out .= "<p>";

			// Sensor Summary

			$out .= "<table border=1 bordercolor='$c2' cellpadding=1 cellspacing=1 width='100%'>";

			$out .= "<tr bgcolor='$c1'><td>Sensor</td><td width='$w1'>Events</td></tr>";

			foreach ($xml->data->sensorSummary->item as $tmp) {
			
				$out .= "<tr><td>" . $tmp->name . "</td><td width='$w1'>" . $tmp->total . "</td></tr>";
			
			}
			
			$out .= "</table>";

			$out .= "<p>";

			// Priority Summary

			$out .= "<table border=1 bordercolor='$c2' cellpadding=1 cellspacing=1 width='100%'>";

			$out .= "<tr bgcolor='$c1'><td>Risk</td><td width='$w1'>Events</td></tr>";

			foreach ($xml->data->prioritySummary->item as $tmp) {
			
				$out .= "<tr><td>" . $tmp->name . "</td><td width='$w1'>" . $tmp->total . "</td></tr>";
			
			}
			
			$out .= "</table>";

			$out .= "<p>";

			// Module Summary

			$out .= "<table border=1 bordercolor='$c2' cellpadding=1 cellspacing=1 width='100%'>";

			$out .= "<tr bgcolor='$c1'><td>Module</td><td width='$w1'>Events</td></tr>";

			foreach ($xml->data->moduleSummary->item as $tmp) {
			
				$out .= "<tr><td>" . $tmp->name . "</td><td width='$w1'>" . $tmp->total . "</td></tr>";
			
			}
			
			$out .= "</table>";

			$out .= "<p>";

			// Signature Summary

			$out .= "<table border=1 bordercolor='$c2' cellpadding=1 cellspacing=1 width='100%'>";

			$out .= "<tr bgcolor='$c1'><td>Signature</td><td width='$w1'>Events</td></tr>";

			foreach ($xml->data->signatureSummary->item as $tmp) {
			
				$out .= "<tr><td>" . $tmp->name . "</td><td width='$w1'>" . $tmp->total . "</td></tr>";
			
			}
			
			$out .= "</table>";

			$out .= "<p>";

			// Class Summary

			$out .= "<table border=1 bordercolor='$c2' cellpadding=1 cellspacing=1 width='100%'>";

			$out .= "<tr bgcolor='$c1'><td>Category</td><td width='$w1'>Events</td></tr>";

			foreach ($xml->data->classSummary->item as $tmp) {
			
				$out .= "<tr><td>" . $tmp->name . "</td><td width='$w1'>" . $tmp->total . "</td></tr>";
			
			}
			
			$out .= "</table>";

			$out .= "<p>";

			// Protocol Summary

			$out .= "<table border=1 bordercolor='$c2' cellpadding=1 cellspacing=1 width='100%'>";

			$out .= "<tr bgcolor='$c1'><td>Protocol</td><td width='$w1'>Events</td></tr>";

			foreach ($xml->data->protocolSummary->item as $tmp) {
			
				$out .= "<tr><td>" . $tmp->name . "</td><td width='$w1'>" . $tmp->total . "</td></tr>";
			
			}
			
			$out .= "</table>";

			$out .= "<p>";

			// SIP Summary

			$out .= "<table border=1 bordercolor='$c2' cellpadding=1 cellspacing=1 width='100%'>";

			$out .= "<tr bgcolor='$c1'><td>Source Address</td><td width='$w1'>Events</td></tr>";

			foreach ($xml->data->sipSummary->item as $tmp) {
			
				$out .= "<tr><td>" . $tmp->name . "</td><td width='$w1'>" . $tmp->total . "</td></tr>";
			
			}
			
			$out .= "</table>";

			$out .= "<p>";

			// DIP Summary

			$out .= "<table border=1 bordercolor='$c2' cellpadding=1 cellspacing=1 width='100%'>";

			$out .= "<tr bgcolor='$c1'><td>Destination Address</td><td width='$w1'>Events</td></tr>";

			foreach ($xml->data->dipSummary->item as $tmp) {
			
				$out .= "<tr><td>" . $tmp->name . "</td><td width='$w1'>" . $tmp->total . "</td></tr>";
			
			}
			
			$out .= "</table>";

			$out .= "<p>";

			// SPort Summary

			$out .= "<table border=1 bordercolor='$c2' cellpadding=1 cellspacing=1 width='100%'>";

			$out .= "<tr bgcolor='$c1'><td>Source Port</td><td width='$w1'>Events</td></tr>";

			foreach ($xml->data->sportSummary->item as $tmp) {
			
				$out .= "<tr><td>" . $tmp->name . "</td><td width='$w1'>" . $tmp->total . "</td></tr>";
			
			}
			
			$out .= "</table>";

			$out .= "<p>";

			// DPort Summary

			$out .= "<table border=1 bordercolor='$c2' cellpadding=1 cellspacing=1 width='100%'>";

			$out .= "<tr bgcolor='$c1'><td>Destination Port</td><td width='$w1'>Events</td></tr>";

			foreach ($xml->data->dportSummary->item as $tmp) {
			
				$out .= "<tr><td>" . $tmp->name . "</td><td width='$w1'>" . $tmp->total . "</td></tr>";
			
			}
			
			$out .= "</table>";

			$out .= "<p>";

			$out .= "Generated by the " . ops("site_consoleName") . "Intrusion Detection and Correlation Console.<br>";
			$out .= ops("site_mainURL");

			$out .= "<p>";

			$out .= "Copyright &copy; 2010, All Rights Reserved";

			$out .= "</td></tr></table>";

		$out .= "</body>";
	$out .= "</html>";
	
	return $out;
}

function processReportXMLToText($data) {

	$xml = new SimpleXMLElement($data);
	
	// Report Heading
	
	$out .= "The following report was generated on " . $xml->data->generatedText . "\n\n";

	$out .= "Search query used to generate this report: " . $xml->data->searchText . "\n\n";

	$out .= "Confidentiality Statement\n" . $xml->data->confidentialText . "\n\n";

	$out .= "Objective Statement\n" . $xml->data->objectiveText . "\n\n";

	// Summary

	$out .= "Report Summary\n";

	foreach ($xml->data->reportStatistics->item as $tmp) {
	
		$out .= $tmp->name . ": " . $tmp->total . "\n";
	
	}

	$out .= "\n";

	// Sensor Summary

	$out .= "Sensor Summary\n";

	foreach ($xml->data->sensorSummary->item as $tmp) {
	
		$out .= $tmp->name . ": " . $tmp->total . "\n";
	
	}

	$out .= "\n";

	// Priority Summary

	$out .= "Priority Summary\n";

	foreach ($xml->data->prioritySummary->item as $tmp) {
	
		$out .= $tmp->name . ": " . $tmp->total . "\n";
	
	}

	$out .= "\n";

	// Module Summary

	$out .= "Module Summary\n";

	foreach ($xml->data->moduleSummary->item as $tmp) {
	
		$out .= $tmp->name . ": " . $tmp->total . "\n";
	
	}

	$out .= "\n";

	// Signature Summary

	$out .= "Signature Summary\n";

	foreach ($xml->data->signatureSummary->item as $tmp) {
	
		$out .= $tmp->name . ": " . $tmp->total . "\n";
	
	}

	$out .= "\n";

	// Class Summary

	$out .= "Category Summary\n";

	foreach ($xml->data->classSummary->item as $tmp) {
	
		$out .= $tmp->name . ": " . $tmp->total . "\n";
	
	}

	$out .= "\n";

	// Protocol Summary

	$out .= "Protocol Summary\n";

	foreach ($xml->data->protocolSummary->item as $tmp) {
	
		$out .= $tmp->name . ": " . $tmp->total . "\n";
	
	}

	$out .= "\n";
	
	// SIP Summary

	$out .= "Source Address Summary\n";

	foreach ($xml->data->sourceSummary->item as $tmp) {
	
		$out .= $tmp->name . ": " . $tmp->total . "\n";
	
	}

	$out .= "\n";	
	
	// DIP Summary

	$out .= "Destination Address Summary\n";

	foreach ($xml->data->dipSummary->item as $tmp) {
	
		$out .= $tmp->name . ": " . $tmp->total . "\n";
	
	}

	$out .= "\n";	
	
	// SPort Summary

	$out .= "Source Port Summary\n";

	foreach ($xml->data->sportSummary->item as $tmp) {
	
		$out .= $tmp->name . ": " . $tmp->total . "\n";
	
	}

	$out .= "\n";

	// DPort Summary

	$out .= "Destination Port Summary\n";

	foreach ($xml->data->dportSummary->item as $tmp) {
	
		$out .= $tmp->name . ": " . $tmp->total . "\n";
	
	}

	$out .= "\n";
	
	$out .= "Generated by the " . ops("site_consoleName") . " Intrusion Detection and Correlation Console.\n";
	$out .= ops("site_mainURL");
	$out .= "\n\n";

	$out .= "Copyright (c) 2010, All Rights Reserved\n";

	return $out;
}

function processReportXMLToPDF($data) {

	$c1 = "#EDECE8";
	$c2 = "#D1C6B3";

	$w0 = 160;
	$w1 = 30;
	
	$imW = 139;
	$imH = $imW / 1.83;

    # Cell($w, $h=0, $txt='', $border=0, $ln=0, $align='', $fill=false, $link='')

	$pdf = new FPDF();
	$pdf->AliasNbPages();
	$pdf->AddPage();
	$pdf->SetFont('Arial','',10);
	$pdf->SetFillColor(237, 236, 232);

	$xml = new SimpleXMLElement($data);
	
	// Report Heading
	
	$pdf->Write(5, "The following report was generated on " . $xml->data->generatedText);
    $pdf->Ln(8);

	$pdf->Write(5, "Search query used to generate this report: " . $xml->data->searchText);
    $pdf->Ln(8);

	$pdf->Write(5, "Confidentiality Statement\n" . $xml->data->confidentialText);
    $pdf->Ln(8);

	$pdf->Write(5, "Objective Statement\n" . $xml->data->objectiveText);
    $pdf->Ln(8);

	// Summary

	$pdf->Write(5, "Report Summary");
    $pdf->Ln(6);

    $pdf->Cell($w0, 6, 'Statistics', 'LRTB', 0, '', 1);
    $pdf->Cell($w1, 6, 'Events', 'LRBT', 0, '', 1);
    $pdf->Ln();
    
	foreach ($xml->data->reportStatistics->item as $tmp) {

        $pdf->Cell($w0, 6, $tmp->name, 'LRB');
        $pdf->Cell($w1, 6, $tmp->total,'LRB');
        $pdf->Ln();

		$nameArray[] = $tmp->name;
		$countArray[] = $tmp->total;

	}    

    $pdf->Ln(5);

	$png = pieChart("Report Statistics", $nameArray, $countArray);
	$pdf->Image($png, null, null, $imW, $imH);
	unset($nameArray, $countArray);

	// Sensor Summary

	$pdf->AddPage();
	$pdf->Write(5, "Sensor Summary");
    $pdf->Ln(6);

    $pdf->Cell($w0, 6, 'Sensor', 'LRTB', 0, '', 1);
    $pdf->Cell($w1, 6, 'Events', 'LRBT', 0, '', 1);
    $pdf->Ln();
    
	foreach ($xml->data->sensorSummary->item as $tmp) {

        $pdf->Cell($w0, 6, $tmp->name, 'LRB');
        $pdf->Cell($w1, 6, $tmp->total,'LRB');
        $pdf->Ln();

		$nameArray[] = $tmp->name;
		$countArray[] = $tmp->total;

	}    

    $pdf->Ln(5);

	$png = pieChart("Sensor Summary", $nameArray, $countArray);
	$pdf->Image($png, null, null, $imW, $imH);
	unset($nameArray, $countArray);

	// Priority Summary

	$pdf->AddPage();
	$pdf->Write(5, "Priority Summary");
    $pdf->Ln(6);

    $pdf->Cell($w0, 6, 'Priority', 'LRTB', 0, '', 1);
    $pdf->Cell($w1, 6, 'Events', 'LRBT', 0, '', 1);
    $pdf->Ln();
    
	foreach ($xml->data->prioritySummary->item as $tmp) {

        $pdf->Cell($w0, 6, $tmp->name, 'LRB');
        $pdf->Cell($w1, 6, $tmp->total,'LRB');
        $pdf->Ln();

		$nameArray[] = $tmp->name;
		$countArray[] = $tmp->total;

	}    

    $pdf->Ln(5);

	$png = pieChart("Priority Summary", $nameArray, $countArray);
	$pdf->Image($png, null, null, $imW, $imH);
	unset($nameArray, $countArray);
	
	// Module Summary

	$pdf->AddPage();
	$pdf->Write(5, "Module Summary");
    $pdf->Ln(6);

    $pdf->Cell($w0, 6, 'Module', 'LRTB', 0, '', 1);
    $pdf->Cell($w1, 6, 'Events', 'LRBT', 0, '', 1);
    $pdf->Ln();
    
	foreach ($xml->data->moduleSummary->item as $tmp) {

        $pdf->Cell($w0, 6, $tmp->name, 'LRB');
        $pdf->Cell($w1, 6, $tmp->total,'LRB');
        $pdf->Ln();

		$nameArray[] = $tmp->name;
		$countArray[] = $tmp->total;

	}    

    $pdf->Ln(5);

	$png = pieChart("Module Summary", $nameArray, $countArray);
	$pdf->Image($png, null, null, $imW, $imH);
	unset($nameArray, $countArray);
	
	// Signature Summary

	$pdf->AddPage();
	$pdf->Write(5, "Signature Summary");
    $pdf->Ln(6);

    $pdf->Cell($w0, 6, 'Signature', 'LRTB', 0, '', 1);
    $pdf->Cell($w1, 6, 'Events', 'LRBT', 0, '', 1);
    $pdf->Ln();
    
	foreach ($xml->data->signatureSummary->item as $tmp) {

        $pdf->Cell($w0, 6, $tmp->name, 'LRB');
        $pdf->Cell($w1, 6, $tmp->total,'LRB');
        $pdf->Ln();

		$nameArray[] = $tmp->name;
		$countArray[] = $tmp->total;

	}    

    $pdf->Ln(5);

	$png = pieChart("Signature Summary", $nameArray, $countArray);
	$pdf->Image($png, null, null, $imW, $imH);
	unset($nameArray, $countArray);

	// Class Summary

	$pdf->AddPage();
	$pdf->Write(5, "Category Summary");
    $pdf->Ln(6);

    $pdf->Cell($w0, 6, 'Category', 'LRTB', 0, '', 1);
    $pdf->Cell($w1, 6, 'Events', 'LRBT', 0, '', 1);
    $pdf->Ln();
    
	foreach ($xml->data->classSummary->item as $tmp) {

        $pdf->Cell($w0, 6, $tmp->name, 'LRB');
        $pdf->Cell($w1, 6, $tmp->total,'LRB');
        $pdf->Ln();

		$nameArray[] = $tmp->name;
		$countArray[] = $tmp->total;

	}    

    $pdf->Ln(5);

	$png = pieChart("Category Summary", $nameArray, $countArray);
	$pdf->Image($png, null, null, $imW, $imH);
	unset($nameArray, $countArray);

	// Protocol Summary

	$pdf->AddPage();
	$pdf->Write(5, "Protocol Summary");
    $pdf->Ln(6);

    $pdf->Cell($w0, 6, 'Protocol', 'LRTB', 0, '', 1);
    $pdf->Cell($w1, 6, 'Events', 'LRBT', 0, '', 1);
    $pdf->Ln();
    
	foreach ($xml->data->protocolSummary->item as $tmp) {

        $pdf->Cell($w0, 6, $tmp->name, 'LRB');
        $pdf->Cell($w1, 6, $tmp->total,'LRB');
        $pdf->Ln();

		$nameArray[] = $tmp->name;
		$countArray[] = $tmp->total;

	}    

    $pdf->Ln(5);

	$png = pieChart("Protocol Summary", $nameArray, $countArray);
	$pdf->Image($png, null, null, $imW, $imH);
	unset($nameArray, $countArray);
	
	// SIP Summary

	$pdf->AddPage();
	$pdf->Write(5, "Source Address Summary");
    $pdf->Ln(6);

    $pdf->Cell($w0, 6, 'Source Address', 'LRTB', 0, '', 1);
    $pdf->Cell($w1, 6, 'Events', 'LRBT', 0, '', 1);
    $pdf->Ln();
    
	foreach ($xml->data->sipSummary->item as $tmp) {

        $pdf->Cell($w0, 6, $tmp->name, 'LRB');
        $pdf->Cell($w1, 6, $tmp->total,'LRB');
        $pdf->Ln();

		$nameArray[] = $tmp->name;
		$countArray[] = $tmp->total;

	}    

    $pdf->Ln(5);

	$png = pieChart("Source Address Summary", $nameArray, $countArray);
	$pdf->Image($png, null, null, $imW, $imH);
	unset($nameArray, $countArray);
	
	// DIP Summary

	$pdf->AddPage();
	$pdf->Write(5, "Destination Address Summary");
    $pdf->Ln(6);

    $pdf->Cell($w0, 6, 'Destination Address', 'LRTB', 0, '', 1);
    $pdf->Cell($w1, 6, 'Events', 'LRBT', 0, '', 1);
    $pdf->Ln();
    
	foreach ($xml->data->dipSummary->item as $tmp) {

        $pdf->Cell($w0, 6, $tmp->name, 'LRB');
        $pdf->Cell($w1, 6, $tmp->total,'LRB');
        $pdf->Ln();

		$nameArray[] = $tmp->name;
		$countArray[] = $tmp->total;

	}    

    $pdf->Ln(5);

	$png = pieChart("Destination Address Summary", $nameArray, $countArray);
	$pdf->Image($png, null, null, $imW, $imH);
	unset($nameArray, $countArray);
	
	// SPort Summary

	$pdf->AddPage();
	$pdf->Write(5, "Source Port Summary");
    $pdf->Ln(6);

    $pdf->Cell($w0, 6, 'Source Port', 'LRTB', 0, '', 1);
    $pdf->Cell($w1, 6, 'Events', 'LRBT', 0, '', 1);
    $pdf->Ln();
    
	foreach ($xml->data->sportSummary->item as $tmp) {

        $pdf->Cell($w0, 6, $tmp->name, 'LRB');
        $pdf->Cell($w1, 6, $tmp->total,'LRB');
        $pdf->Ln();

		$nameArray[] = $tmp->name;
		$countArray[] = $tmp->total;

	}    

    $pdf->Ln(5);

	$png = pieChart("Source Port Summary", $nameArray, $countArray);
	$pdf->Image($png, null, null, $imW, $imH);
	unset($nameArray, $countArray);

	// DPort Summary

	$pdf->AddPage();
	$pdf->Write(5, "Destination Port Summary");
    $pdf->Ln(6);

    $pdf->Cell($w0, 6, 'Destination Port', 'LRTB', 0, '', 1);
    $pdf->Cell($w1, 6, 'Events', 'LRBT', 0, '', 1);
    $pdf->Ln();
    
	foreach ($xml->data->dportSummary->item as $tmp) {

        $pdf->Cell($w0, 6, $tmp->name, 'LRB');
        $pdf->Cell($w1, 6, $tmp->total,'LRB');
        $pdf->Ln();

		$nameArray[] = $tmp->name;
		$countArray[] = $tmp->total;

	}    

    $pdf->Ln(5);

	$png = pieChart("Destination Port Summary", $nameArray, $countArray);
	$pdf->Image($png, null, null, $imW, $imH);
	unset($nameArray, $countArray);

	$pdf->Write(5, "Generated by the " . ops("site_consoleName") . " Intrusion Detection and Correlation Console.\n" . ops("site_mainURL") . "");
    $pdf->Ln(8);

	$pdf->Write(5, "Copyright (c) 2010, All Rights Reserved");
    $pdf->Ln(8);

	foreach (glob("../../tmp/pdfImage_*") as $filename) {
		unlink($filename);
	}

	// page no


	return $pdf;
}
 
?>
