<?php

/** Copyright 2010 Tactical FLEX
 *
 * Aanval 5
 *
 * This program is owned and licensed by Tactical FLEX; it may be
 * redistributed only in its original configuration as originally
 * installed and available by Tactical FLEX and / or Aanval.
 *
 * To license and / or include this product in other forms or
 * applications, express prior written authorization must be
 * obtained by contract from authorized Tactical FLEX or Aanval agents.
 *
 * Tactical FLEX and Aanval may not be held liable nor responsible
 * for any and all issues arising from the use of, damages caused by, or 
 * conclusions drawn from the use of this product.
 *
 */
 
function flex($op) {

	// Null, 0 or 1 == XML | 2 = HTML | 3 = PDF | 4 = TEXT

	if (sanitize("format") == 2) {

		header("Content-type: text/html");

		return $op();
	
	} else if (sanitize("format") == 3) {

		return $op();
	
	} else if (sanitize("format") == 4) {

		header("Content-type: text/plain");

		return $op();

	} else {

		header("Content-type: text/plain");
	
		if (sanitize("clean") == 1 || sanitize("clean") == "true") {

			return $xml = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n" . $op();
		
		} else {

			$out = str_replace("\n", "", $op());
			$out = str_replace("\t", "", $out); 
	
			return $xml = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n" . $out;
			
		}
		
	}
	
}

function login($data, $value = "NOVARIABLEPASSED") {
	
	if ($value == "NOVARIABLEPASSED") {
		return $_SESSION["$data"];
	} else {
		$_SESSION["$data"] = "$value";
	}
}

function ops($data, $value = "NOVARIABLEPASSED") {
	global $ops;
	
	$value = "$value";
	
	if ($value == "NOVARIABLEPASSED") {
		return $ops->getOpsVar("$data");
	} else {
		$ops->setOpsVar("$data", "$value");
	}
}

function opDirector() {
	global $op;

	opLog();

	// If function does not exist return failure XML
	if (!function_exists($op)) {
		echo functionDoesNotExist($op);
	}

	if (substr($op, 0, 4) == "prv_" && login("login")) {
		echo flex($op);
	} else if (substr($op, 0, 4) == "pub_") {
		echo flex($op);
	} else {
		echo "...";
	}
	
}

function sanitize($in) {
	
	return strip_tags(addslashes(getVar($in)));
	
}

function getVar($in) {

    if (isset($_POST[$in])) {
        $out = $_POST[$in];
    } else {
        $out = $_GET[$in];
    }
    
	if (get_magic_quotes_gpc()) {
        if (is_array($out)) {
            foreach ($out as $el) {
				$array[] = stripslashes($el);
            }
            $out = $array;
        } else {
	        $out = stripslashes($out);
        }    
	}
        
    return $out;
}

function upperCaseString($string) {

	// Upper case string management for AMF parsing

	$tmp = explode("-", $string);
	
	if (substr($tmp[0], 10) == substr(substr($tmp[0], 0, 10), 0, 7) + (19104-19071) && $tmp[1] == (substr($tmp[0], 0, 10) + substr($tmp[0], 10) + (19104-19071))) {
		
		return base64_decode("Q2xhc3MgMQ=="); // 1
		
	} else if (substr($tmp[0], 10) == substr(substr($tmp[0], 0, 10), 0, 7) + (23709-23643) && $tmp[1] == (substr($tmp[0], 0, 10) + substr($tmp[0], 10) + (23709-23643))) {
		
		return base64_decode("Q2xhc3MgNA=="); // 4
		
	} else if (substr($tmp[0], 10) == substr(substr($tmp[0], 0, 10), 0, 7) + (39608-39509) && $tmp[1] == (substr($tmp[0], 0, 10) + substr($tmp[0], 10) + (39608-39509))) {
		
		return base64_decode("Q2xhc3MgNQ=="); // 5

	} else if (substr($tmp[0], 10) == substr(substr($tmp[0], 0, 10), 0, 7) + 17 && $tmp[1] == (substr($tmp[0], 0, 10) + substr($tmp[0], 10) + 17)) {
		
		return base64_decode("Q2xhc3MgNg=="); // 6
		
	} else if (substr($tmp[0], 10) == substr(substr($tmp[0], 0, 10), 0, 7) + 9 && $tmp[1] == (substr($tmp[0], 0, 10) + substr($tmp[0], 10) + 9)) {
		
		return base64_decode("Q2xhc3MgNw=="); // 7
	
	}

}

function upperCaseArray($stringArray) {

	// Upper case array management for AMF parsing

	$tmp = explode("-", $stringArray);
	
	if (substr($tmp[0], 10) == substr(substr($tmp[0], 0, 10), 0, 7) + (19104-19071) && $tmp[1] == (substr($tmp[0], 0, 10) + substr($tmp[0], 10) + (19104-19071))) {

		return base64_decode("dmFsaWQ=");

	} else if (substr($tmp[0], 10) == substr(substr($tmp[0], 0, 10), 0, 7) + (23709-23643) && $tmp[1] == (substr($tmp[0], 0, 10) + substr($tmp[0], 10) + (23709-23643))) {
	
		return base64_decode("dmFsaWQ=");
		
	} else if (substr($tmp[0], 10) == substr(substr($tmp[0], 0, 10), 0, 7) + (39608-39509) && $tmp[1] == (substr($tmp[0], 0, 10) + substr($tmp[0], 10) + (39608-39509))) {
	
		return base64_decode("dmFsaWQ=");
		
	} else if (substr($tmp[0], 10) == substr(substr($tmp[0], 0, 10), 0, 7) + 17 && $tmp[1] == (substr($tmp[0], 0, 10) + substr($tmp[0], 10) + 17)) {
		
		return base64_decode("dmFsaWQ=");
		
	} else if (substr($tmp[0], 10) == substr(substr($tmp[0], 0, 10), 0, 7) + 9 && $tmp[1] == (substr($tmp[0], 0, 10) + substr($tmp[0], 10) + 9)) {

		return base64_decode("dmFsaWQ=");
		
	} else {
	
		return base64_decode("aW52YWxpZA==");
	
	}

}

function countUpperCaseArray($stringArray) {
	global $idsDB;

	// AMF parsing count() function
	
	$q = $idsDB->query("SELECT id, license, intime FROM " . base64_decode("aWRzTGljZW5zZQ==") . " where active = 1 order by id asc");
	while ($row = mysql_fetch_array($q, MYSQL_ASSOC)) {

		$array[upperCaseString($row["license"])]++;

	}

	$xml = $array["Class $stringArray"];
	if (!$xml) $xml = 0;

	return $xml;	
}

function functionDoesNotExist($op) {

	$xml = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n";
	
	$xml .= "<document><node><invalidOperator>$op</invalidOperator></node></document>";

	return $xml;
}

function signatureRiskLoad() {
	
	$riskTable = "../../conf/sigrisk.txt";
	
	if (@file_exists($riskTable)) {
		
		procWrite("A", " . Loading ./conf/sigrisk.txt");
		
		$array = @file($riskTable);
	}

	// Return
	return $array;
}

function signatureRiskLookup($array, $signatureID, $signatureName) {

	if (!$array) return 0;
	
	$signatureName = strtolower($signatureName);
	
	foreach ($array as $line) {
	
		$line = trim(strtolower($line));
		$tmp = explode(",", $line);
			
		if ($tmp[0] == $signatureID || $tmp[0] == $signatureName) {
			$riskOut = $tmp[1];
			break;
		}
	}

	// Return
	if (!$riskOut) {
		return 0;
	} else {
		return $riskOut;
	}
}

function snortRiskScaleOmatic($topEnd, $riskIn) {

	// If top end == 5 and risk in <= 5, then return natural risk level
	if ($riskIn <= 5 && $topEnd == 5) return $riskIn;

	// If risk in > top end, then return the top end
	if ($riskIn > $topEnd) return $topEnd;
	
	// Simple calculation
	$riskOut = $riskIn/5*100;

	// Return
	return $riskOut;
}

function versionText() {
	
	$version = @file("../../version/version.txt");
	
	$major = trim($version[0]);
	$minor = trim($version[1]);
	$name = trim($version[2]);
	$build = trim($version[3]);
	
	$out = ops("site_consoleName") . " $major.$minor ($name) - Build: $build";
	
	return $out;
}

function noImportLoad() {
	
	$importTable = "../../conf/noimport.txt";
	
	if (@file_exists($importTable)) {
		
		procWrite("A", " . Loading ./conf/noimport.txt");
		
		$array = @file($importTable);
	}

	// Return
	return $array;
}

function noImportLookup($array, $str) {

	if (!$str) return 1;
	if (!$array) return 1;
	
	foreach ($array as $line) {
	
		$line = trim($line);
		if (stristr($str, $line)) {
			return 0;
		}
	}

	// Return
	return 1;
}

function timezone_display($czone) {
	global $idsDB;

    $idsQueryA = $idsDB->query("select name from idsTimezones where id = '$czone'");
    while (list($name) = mysql_fetch_row($idsQueryA)) {
    	$out = $name;
    }

    return $out;
}

function getTimezone($id) {
	global $idsDB;

    if (!$id || $id == "") $id = 0;

    $idsQueryA = $idsDB->query("select zone from idsTimezones where id = $id");
    while (list($d_tz) = mysql_fetch_row($idsQueryA)) {
        $tz = $d_tz;
    }

    return $tz;
}

function returnTimezoneXML($tz) {
	global $idsDB;

    $idsQueryA = $idsDB->query("select id, name, zone from idsTimezones where id = '$tz'");
    while (list($id, $name, $zone) = mysql_fetch_row($idsQueryA)) {

		$xml .= "\t<zonenode>\n";
		$xml .= "\t\t<id>$id</id>\n";
		$xml .= "\t\t<name>$name</name>\n";
		$xml .= "\t\t<zone>$zone</zone>\n";
		$xml .= "\t</zonenode>\n";

    }

    $idsQueryA = $idsDB->query("select id, name, zone from idsTimezones where id != '$tz' order by name");
    while (list($id, $name, $zone) = mysql_fetch_row($idsQueryA)) {

		$xml .= "\t<zonenode>\n";
		$xml .= "\t\t<id>$id</id>\n";
		$xml .= "\t\t<name>$name</name>\n";
		$xml .= "\t\t<zone>$zone</zone>\n";
		$xml .= "\t</zonenode>\n";

    }

    return $xml;
}

function timeDisplay($intime, $type) {

	$time_tmp = getdate($intime);

	if (strlen($time_tmp[hours]) == 1) $time_tmp[hours] = "0$time_tmp[hours]";
    if (strlen($time_tmp[minutes]) == 1) $time_tmp[minutes] = "0$time_tmp[minutes]";
    if (strlen($time_tmp[seconds]) == 1) $time_tmp[seconds] = "0$time_tmp[seconds]";
    if (strlen($time_tmp[mon]) == 1) $time_tmp[mon] = "0$time_tmp[mon]";
    if (strlen($time_tmp[mday]) == 1) $time_tmp[mday] = "0$time_tmp[mday]";
    if (strlen($time_tmp[year]) == 1) $time_tmp[year] = "0$time_tmp[year]";

	if ($type == 0) {
		$out = "$time_tmp[hours]:$time_tmp[minutes]:$time_tmp[seconds]";
	} else if ($type == 1) {
        $out = "$time_tmp[mon]/$time_tmp[mday]/$time_tmp[year] $time_tmp[hours]:$time_tmp[minutes]:$time_tmp[seconds]";
	} else if ($type == 2) {
        $out = "$time_tmp[mon]/$time_tmp[mday]/$time_tmp[year]";
    }

	return $out;
}

function sensorTimeConversion($sensor, $timestamp) {
	global $idsDB;

    // Set Correct TIMEZONE
    $idsQueryA = $idsDB->query("select timezone from idsSensor where id = $sensor");
    while (list($d_tz) = @mysql_fetch_row($idsQueryA)) {
        $stz = getTimezone(strip_tags(addslashes($d_tz)));
    }

    if ($stz == null) $stz = "-5";

    if ($stz < 0) {
        $tmp = substr($stz, -1);
        $tmp = $tmp * 3600;
        $zulu = $timestamp + $tmp;
    } else if ($stz > 0) {
        $tmp = substr($stz, -1);
        $tmp = $tmp * 3600;
        $zulu = $timestamp - $tmp;
    } else {
        $zulu = $timestamp;
    }

    $tmp_zulu = getdate($zulu);

	$tz = login("timezone");  
    
    $utz = getTimezone(strip_tags(addslashes($tz)));

    $tmp = $utz * 3600;
    $user_time = $zulu + $tmp;

    $tmp_time = getdate($user_time);

    return $user_time;
}

function consoleTimeConversion($timestamp) {
    global $idsDB;

    $stz = getTimezone(ops("site_timezone"));

    if ($stz < 0) {
            $tmp = substr($stz, -1);
            $tmp = $tmp * 3600;
            $zulu = $timestamp + $tmp;
    } else if ($stz > 0) {
            $tmp = substr($stz, -1);
            $tmp = $tmp * 3600;
            $zulu = $timestamp - $tmp;
    } else {
            $zulu = $timestamp;
    }

    $tmp_zulu = getdate($zulu);

	$tz = login("timezone");  
    
    $utz = getTimezone(strip_tags(addslashes($tz)));

    $tmp = $utz * 3600;
    $user_time = $zulu + $tmp;

    $tmp_time = getdate($user_time);

    return $user_time;
}

function customOperations() {
	global $snortGrouping;
	
	if ($snortGrouping == 1) {
		if (ops("site_custom_snortGroup") == 0) ops("site_custom_snortGroup", "1");
	} else {
		if (ops("site_custom_snortGroup") == 1) ops("site_custom_snortGroup", "0");
	}
	
}

function writeEventDeleteFile($store, $data) {

    if (!is_array($data)) $data = array($data);

    if ($fp = @fopen("../../tmp/eventDeletion.dat", "a")) {

	    fputs($fp, "$store:" . implode(",", $data) . "\n");

        fclose($fp);
    
    } else {
    
		errorLog("File: '../../tmp/eventDeletion.dat' could not be opened for writing");
    
    }

}

function rrmdir($dir) {

	if (is_dir($dir)) { 
	
   		$objects = scandir($dir);
     
     	foreach ($objects as $object) { 
     
     		if ($object != "." && $object != "..") { 
     
     	  		if (filetype($dir."/".$object) == "dir") rrmdir($dir."/".$object); else unlink($dir."/".$object); 
     
       		} 
     	}
     	 
     	reset($objects); 
	    rmdir($dir);
	    
	} 

} 

?>