<?php

/** Copyright 2010 Tactical FLEX
 *
 * Aanval 5
 *
 * This program is owned and licensed by Tactical FLEX; it may be
 * redistributed only in its original configuration as originally
 * installed and available by Tactical FLEX and / or Aanval.
 *
 * To license and / or include this product in other forms or
 * applications, express prior written authorization must be
 * obtained by contract from authorized Tactical FLEX or Aanval agents.
 *
 * Tactical FLEX and Aanval may not be held liable nor responsible
 * for any and all issues arising from the use of, damages caused by, or 
 * conclusions drawn from the use of this product.
 *
 */

include "initialize.php";

function prv_accountList() {
	global $idsDB;

	$cnt = 0;

	$xml = "<document>\n";

	$q = $idsDB->query("SELECT id, type, username, sensors, fname, lname, email, organization, phone, city, state, country, logintime, UNIX_TIMESTAMP(intime) as intime, enabled FROM idsUsers order by id asc");
	while ($row = mysql_fetch_array($q, MYSQL_ASSOC)) {

		$cnt++;

		$xml .= "\t<node>\n";

		if ($row["type"] == 1) {
			$row["privilege"] = "User";
		} else if ($row["type"] == 10) {
			$row["privilege"] = "Administrator";
		}

		$row["intime"] = date("m.d.Y H:i:s", consoleTimeConversion($row["intime"]));

		foreach ($row as $key => $val) {

			$xml .= "\t\t<$key><![CDATA[$val]]></$key>\n";
			
		}

		$xml .= "\t</node>\n";
		
	}

	$xml .= "\t<total>$cnt</total>\n";

	if (ops("site_custom_snortGroup") == 1) {
		$xml .= "\t<custom>\n";
		$xml .= "\t\t<grouping>1</grouping>\n";
		$xml .= "\t</custom>\n";
	}
	
	$xml .= "</document>\n";

	return $xml;	
}

function prv_accountUpdate() {
	global $idsDB;

	$id = sanitize("id");
	if (!$id) return;

	$username = sanitize("username");
	$fname = sanitize("fname");
	$lname = sanitize("lname");
	$email = sanitize("email");
	$city = sanitize("city");
	$state = sanitize("state");
	$country = sanitize("country");
	$phone = sanitize("phone");

	$enabled = sanitize("enabled");
	if (!$enabled) $enabled = 0;

	$type = sanitize("type");
	if (!$type) $type = 1;

	$pass1 = sanitize("pass1");
	$pass2 = sanitize("pass2");

	// Custom grouping feature
	if (ops("site_custom_snortGroup") == 1) {

		$grouping = sanitize("grouping");

		$idsDB->query("update idsUsers set username = '$username', sensors = '$grouping', fname = '$fname', lname = '$lname', email = '$email', city = '$city', state = '$state', country = '$country', phone = '$phone', type = '$type', enabled = '$enabled' where id = '$id'");
	
	} else {

		$idsDB->query("update idsUsers set username = '$username', fname = '$fname', lname = '$lname', email = '$email', city = '$city', state = '$state', country = '$country', phone = '$phone', type = '$type', enabled = '$enabled' where id = '$id'");

	}
	
	if (strlen($pass1) > 3) {
	
		if ($pass1 == $pass2) {
		
			$idsDB->query("update idsUsers set password = md5('$pass1') where id = '$id'");
		
		}
	
	}
	
	$xml = "<success>1</success>\n";

	return $xml;
}

function prv_accountCreate() {
	global $idsDB;

	$username = sanitize("username");
	
	$fname = sanitize("fname");
	$lname = sanitize("lname");
	$email = sanitize("email");
	$city = sanitize("city");
	$state = sanitize("state");
	$country = sanitize("country");
	$phone = sanitize("phone");

	$type = sanitize("type");
	if (!$type) $type = 1;

	$pass1 = sanitize("pass1");
	$pass2 = sanitize("pass2");

	if (!$username) return;
	if (strlen($pass1) < 3) return;

	$idsDB->query("insert into idsUsers (username, fname, lname, email, city, state, country, phone, password, type, enabled, activeSearchStore) values ('$username', '$fname', '$lname', '$email', '$city', '$state', '$country', '$phone', md5('$pass1'), '$type', '1', '" . ops("site_activeDataStore") . "')");

	$xml = "<success>1</success>\n";

	return $xml;
}

function prv_accountDelete() {
	global $idsDB;

	$id = sanitize("id");
	if (!$id) return;

	$idsDB->query("delete from idsUsers where id = '$id'");

	$xml = "<success>1</success>\n";

	return $xml;
}

function prv_myAccountDetails() {
	global $idsDB;

	$id = login("id");
	if (!$id) return;

	$xml = "<document>\n";

	$q = $idsDB->query("SELECT id, type, username, fname, lname, email, organization, phone, city, state, country, timezone, logintime, UNIX_TIMESTAMP(intime) as intime FROM idsUsers where id = '$id'");
	while ($row = mysql_fetch_array($q, MYSQL_ASSOC)) {

		$xml .= "\t<node>\n";

		if ($row["type"] == 1) {
			$row["privilege"] = "User";
		} else if ($row["type"] == 10) {
			$row["privilege"] = "Administrator";
		}

		$row["intime"] = date("m.d.Y H:i:s", consoleTimeConversion($row["intime"]));

		foreach ($row as $key => $val) {

			$xml .= "\t\t<$key><![CDATA[$val]]></$key>\n";
			
		}

		$xml .= returnTimezoneXML($row["timezone"]);
		
		$xml .= "\t</node>\n";
		
	}

	$xml .= "</document>\n";

	return $xml;	
}

function prv_myAccountUpdate() {
	global $idsDB;

	$id = login("id");
	if (!$id) return;

	$username = sanitize("username");
	$fname = sanitize("fname");
	$lname = sanitize("lname");
	$email = sanitize("email");
	$city = sanitize("city");
	$state = sanitize("state");
	$country = sanitize("country");
	$phone = sanitize("phone");
	$timezone = sanitize("timezone");

	$pass1 = sanitize("pass1");
	$pass2 = sanitize("pass2");

	$idsDB->query("update idsUsers set username = '$username', fname = '$fname', lname = '$lname', email = '$email', city = '$city', state = '$state', country = '$country', timezone = '$timezone',  phone = '$phone' where id = '$id'");

	if (strlen($pass1) > 3) {
	
		if ($pass1 == $pass2) {
		
			$idsDB->query("update idsUsers set password = md5('$pass1') where id = '$id'");
		
		}
	
	}
	
	$xml = "<document>\n";
	
	$xml .= "<success>1</success>\n";

	$xml .= "</document>\n";

	return $xml;
}

?>

