<?php

/** Copyright 2010 Tactical FLEX
 *
 * Aanval 5
 *
 * This program is owned and licensed by Tactical FLEX; it may be
 * redistributed only in its original configuration as originally
 * installed and available by Tactical FLEX and / or Aanval.
 *
 * To license and / or include this product in other forms or
 * applications, express prior written authorization must be
 * obtained by contract from authorized Tactical FLEX or Aanval agents.
 *
 * Tactical FLEX and Aanval may not be held liable nor responsible
 * for any and all issues arising from the use of, damages caused by, or 
 * conclusions drawn from the use of this product.
 *
 */

include "initialize.php";

function prv_actionManagerList() {
	global $idsDB;

	// TF

	$cnt = 0;

	$xml = "<document>\n";

	$q = $idsDB->query("SELECT id, enabled, name, description, threshold, thresholdtime, onetime, matchtype, count, weight, senderName, senderEmail, senderSubject, senderBody, intime FROM idsActionMaster where userid = '" . login("id") . "' order by weight asc");
	while ($row = mysql_fetch_array($q, MYSQL_ASSOC)) {

		$cnt++;

		$xml .= "\t<node>\n";

		$row["intime"] = date("m.d.Y H:i:s", consoleTimeConversion($row["intime"]));

		if ($row["enabled"] == 1) {
			$row["statustext"] = "Enabled";
		} else {
			$row["statustext"] = "Disabled";
		}

		if ($row["senderName"] == "") $row["senderName"] = login("fname") . " " . login("lname");
		if ($row["senderEmail"] == "") $row["senderEmail"] = login("email");
		if ($row["senderSubject"] == "") $row["senderSubject"] = "! " . ops("site_consoleName") . " Alert (SIG_NAME)";

		if ($row["senderBody"] == "") {
		
			$body = "The following alert was generated by the " . ops("site_consoleName") . " Intrusion Detection Console.\n---\n\n";
			$body .= "Timestamp: TIMESTAMP\n\n";
			$body .= "Risk Level: RISK_LEVEL\n\n";
			$body .= "Source IP: SOURCE_IP : SOURCE_PORT\n";
			$body .= "Destination IP: DESTINATION_IP : DESTINATION_PORT\n";
			$body .= "Sensor: SENSOR\n\n";
			$body .= "Detected Event: SIG_NAME (SIG_NAME_ID)\n\n";
			$body .= "Detected Event Category: SIG_CLASS (SIG_CLASS_ID)\n\n";
			$body .= "" . ops("site_consoleName") . " ID: AANVALID\n";
			$body .= "Action ID: ACTIONID\n";
			$body .= "---\n";
			$body .= "Payload:\n";
			$body .= "PAYLOAD\n";
			
			$row["senderBody"] = $body;
		}

		foreach ($row as $key => $val) {

			$xml .= "\t\t<$key><![CDATA[$val]]></$key>\n";
			
		}
		
		$xml .= "\t</node>\n";
		
	}

	$xml .= "\t<total>$cnt</total>\n";
	$xml .= "</document>\n";

	return $xml;	
}

function prv_actionStoreList() {
	global $idsDB;

	// TF

	$id = sanitize("id");
	if (!$id) return;

	$xml = "<document>\n";

	$q = $idsDB->query("SELECT id, masterid, class, type, data, intime FROM idsActionStore where masterid = '$id' and class = 1 order by id asc");
	while ($row = mysql_fetch_array($q, MYSQL_ASSOC)) {

		$xml .= "\t<node1>\n";

		$row["intime"] = date("m.d.Y H:i:s", consoleTimeConversion($row["intime"]));

		if ($row["enabled"] == 1) {
			$row["statustext"] = "Enabled";
		} else {
			$row["statustext"] = "Disabled";
		}

		if ($row["type"] == 1) $row["text"] = "Source IP";
		if ($row["type"] == 2) $row["text"] = "Destination IP";
		if ($row["type"] == 3) $row["text"] = "Source Port";
		if ($row["type"] == 4) $row["text"] = "Destination Port";
		if ($row["type"] == 5) $row["text"] = "Protocol";
		if ($row["type"] == 6) $row["text"] = "Risk Level";
		if ($row["type"] == 7) $row["text"] = "Sensor";
		if ($row["type"] == 8) $row["text"] = "Module";
		if ($row["type"] == 9) $row["text"] = "Signature ID";
		if ($row["type"] == 10) $row["text"] = "Category ID";
		if ($row["type"] == 11) $row["text"] = "Text / String";

		foreach ($row as $key => $val) {

			$xml .= "\t\t<$key><![CDATA[$val]]></$key>\n";
			
		}
		
		$xml .= "\t</node1>\n";
		
	}
	
	$q = $idsDB->query("SELECT id, masterid, class, type, data, intime FROM idsActionStore where masterid = '$id' and class = 2 order by id asc");
	while ($row = mysql_fetch_array($q, MYSQL_ASSOC)) {

		$xml .= "\t<node2>\n";

		$row["intime"] = date("m.d.Y H:i:s", consoleTimeConversion($row["intime"]));

		if ($row["enabled"] == 1) {
			$row["statustext"] = "Enabled";
		} else {
			$row["statustext"] = "Disabled";
		}

		if ($row["type"] == 1) $row["text"] = "Do Nothing";
		if ($row["type"] == 2) $row["text"] = "Ignore";
		if ($row["type"] == 3) $row["text"] = "Send Email";
		if ($row["type"] == 4) $row["text"] = "Audio Alarm";
		if ($row["type"] == 5) $row["text"] = "Add to Collection";
		if ($row["type"] == 6) $row["text"] = "Exec Shell Command";
		if ($row["type"] == 7) $row["text"] = "Delete";

		foreach ($row as $key => $val) {

			$xml .= "\t\t<$key><![CDATA[$val]]></$key>\n";
			
		}
		
		$xml .= "\t</node2>\n";
		
	}	

	$xml .= "</document>\n";

	return $xml;	
}

function prv_actionManagerCreate() {
	global $idsDB;

	// TF

	$name = sanitize("name");
	if (!$name) $name = "New Action (Not named)";
	
	$description = sanitize("description");
	if (!$description) $description = "Created - " . date("r");

	$enabled = sanitize("enabled");
	$onetime = sanitize("onetime");
	$matchstyle = sanitize("matchstyle");
	$threshold = sanitize("threshold");
	$thresholdtime = sanitize("thresholdtime");

	$idsDB->query("insert into idsActionMaster (userid, name, description, enabled, matchtype, onetime, threshold, thresholdtime, thresholdeventtime, count, thresholdcount, deleted, intime) values ('" . login("id") . "', '$name', '$description', '$enabled', '$matchstyle', '$onetime', '$threshold', '$thresholdtime', '0', '0', '0', '0', '" . time() . "')");

	$lastWrite = mysql_insert_id();
	
	$idsDB->query("update idsActionMaster set weight = '$lastWrite' where id = '$lastWrite'");

	$xml = "<document>\n";
		$xml .= "\t<node>\n";
	
			$xml .= "\t\t<success>1</success>\n";
	
		$xml .= "\t</node>\n";
	$xml .= "</document>\n";

	return $xml;

}

function prv_actionMasterWeight() {
	global $idsDB;

	// TF

	$data = sanitize("data");
	if (!$data) return;

	$tmpArray = explode(",", $data);

	foreach ($tmpArray as $tmp) {
	
		$wdata = explode(":", $tmp);
		
		$idsDB->query("update idsActionMaster set weight = '" . $wdata[1] . "' where id = '" . $wdata[0] . "' and userid = '" . login("id") . "'");

	}

	$xml = "<document>\n";
		$xml .= "\t<node>\n";
	
			$xml .= "\t\t<success>1</success>\n";
	
		$xml .= "\t</node>\n";
	$xml .= "</document>\n";

	return $xml;

}

function prv_actionManagerUpdate() {
	global $idsDB;

	// TF

	$id = sanitize("id");
	if (!$id) return;

	$name = sanitize("name");
	$enabled = sanitize("enabled");
	$onetime = sanitize("onetime");
	$matchstyle = sanitize("matchstyle");
	$description = sanitize("description");
	$threshold = sanitize("threshold");
	$thresholdtime = sanitize("thresholdtime");

	$idsQueryA = $idsDB->query("update idsActionMaster set name = '$name', enabled = '$enabled', description = '$description', threshold = '$threshold', thresholdtime = '$thresholdtime', onetime = '$onetime', matchtype = '$matchstyle' where id = '$id' and userid = '" . login("id") . "'");
	
	$xml = "<document>\n";
		$xml .= "\t<node>\n";
	
			$xml .= "\t\t<success>1</success>\n";
	
		$xml .= "\t</node>\n";
	$xml .= "</document>\n";

	return $xml;
}

function prv_actionManagerDelete() {
	global $idsDB;

	// TF

	$id = sanitize("id");
	if (!$id) return;

	$idsDB->query("delete from idsActionMaster where id = '$id'");
	$idsDB->query("delete from idsActionStore where masterid = '$id'");

	$xml = "<document>\n";
		$xml .= "\t<node>\n";
	
			$xml .= "\t\t<success>1</success>\n";
	
		$xml .= "\t</node>\n";
	$xml .= "</document>\n";

	return $xml;

}

function prv_actionStoreDelete() {
	global $idsDB;

	// TF

	$id = sanitize("id");
	if (!$id) return;

	$idsDB->query("delete from idsActionStore where id = '$id'");

	$xml = "<document>\n";
		$xml .= "\t<node>\n";
	
			$xml .= "\t\t<success>1</success>\n";
	
		$xml .= "\t</node>\n";
	$xml .= "</document>\n";

	return $xml;

}

function prv_actionManagerToggle() {
	global $idsDB;

	// TF

	$id = sanitize("id");
	if (!$id) return;

	$status = sanitize("status");
	if (!$status && $status != "0") return;

	if ($status == 1) {
		$enabled = 0;
	} else {
		$enabled = 1;
	}

	$idsDB->query("update idsActionMaster set enabled = '$enabled' where id = '$id'");

	$xml = "<document>\n";
		$xml .= "\t<node>\n";
	
			$xml .= "\t\t<success>1</success>\n";
	
		$xml .= "\t</node>\n";
	$xml .= "</document>\n";

	return $xml;

}

function prv_resetActionCount() {
	global $idsDB;

	// TF

	$id = sanitize("id");
	if (!$id) return;

	$idsDB->query("update idsActionMaster set count = 0 where id = '$id' and userid = '" . login("id") . "'");

	$xml = "<document>\n";
		$xml .= "\t<node>\n";
	
			$xml .= "\t\t<success>1</success>\n";
	
		$xml .= "\t</node>\n";
	$xml .= "</document>\n";

	return $xml;

}

function prv_criteriaSubmit() {
	global $idsDB;

	// TF

	$id = sanitize("id");
	if (!$id) return;

	$class = sanitize("ctype");
	$type = sanitize("type");
	$data = sanitize("data");

	$idsDB->query("insert into idsActionStore (masterid, class, type, data, intime) values ('$id', '$class', '$type', '$data', '" . time() . "')");

	$xml = "<document>\n";
		$xml .= "\t<node>\n";
	
			$xml .= "\t\t<success>1</success>\n";
	
		$xml .= "\t</node>\n";
	$xml .= "</document>\n";

	return $xml;

}

function prv_criteriaUpdate() {
	global $idsDB;

	// TF

	$id = sanitize("id");
	if (!$id) return;

	$data = sanitize("data");

	$idsDB->query("update idsActionStore set data = '$data' where id = '$id'");

	$xml = "<document>\n";
		$xml .= "\t<node>\n";
	
			$xml .= "\t\t<success>1</success>\n";
	
		$xml .= "\t</node>\n";
	$xml .= "</document>\n";

	return $xml;

}

function prv_actionCustomEmailUpdate() {
	global $idsDB;

	// TF

	$id = sanitize("id");
	if (!$id) return;

	$senderEail = sanitize("email");
	$senderName = sanitize("name");
	$senderSubject = sanitize("subject");
	$senderBody = sanitize("body");

	$idsDB->query("update idsActionMaster set senderEmail = '$senderEmail', senderName = '$senderName', senderSubject = '$senderSubject', senderBody = '$senderBody' where id = '$id'");

	$xml = "<document>\n";
		$xml .= "\t<node>\n";
	
			$xml .= "\t\t<success>1</success>\n";
	
		$xml .= "\t</node>\n";
	$xml .= "</document>\n";

	return $xml;

}

?>
