<?php

/** Copyright 2010 Tactical FLEX
 *
 * Aanval 5
 *
 * This program is owned and licensed by Tactical FLEX; it may be
 * redistributed only in its original configuration as originally
 * installed and available by Tactical FLEX and / or Aanval.
 *
 * To license and / or include this product in other forms or
 * applications, express prior written authorization must be
 * obtained by contract from authorized Tactical FLEX or Aanval agents.
 *
 * Tactical FLEX and Aanval may not be held liable nor responsible
 * for any and all issues arising from the use of, damages caused by, or 
 * conclusions drawn from the use of this product.
 *
 */

include "initialize.php";

function pub_communicationTest() {
	
	$xml .= "<document>\n";
		
		$xml .= "\t<state>$state</state>\n";
	
	$xml .= "</document>\n";

	return $xml;	
		
}

function pub_consoleState() {
	
	// Returns live, upgrade, install status
	
	if (file_exists("../../installation/install.cert")) {
		
		// Installation Exists
	
		if (file_exists("../../installation/upgrade")) {
	
			// Upgrade
	
			$state = 2;
	
		} else {
			
			// Nothing to do
				
			$state = 0;
		
		}
		
	} else {
		
		// New Install
		
		$state = 1;
		
	}

	$xml .= "<document>\n";
		
		$xml .= "\t<state>$state</state>\n";
	
	$xml .= "</document>\n";

	return $xml;	
		
}

function pub_heartbeat() {
	global $idsDB;

	// Defaults

	$newVersion = 0;

	if ($_SESSION["login"] == 1) {
	
		$version = @file("../../version/version.txt");
		$currentBuild = trim($version[3]);
	
		$version = @file("../../version/ver");
		$newBuild = trim($version[3]);
	
		if ($newBuild > $currentBuild) {
			$newVersion = 1;
		}

		// Test if BPU's are running
		
		foreach (array("A", "B", "C", "D", "E") as $bpu) {
		
			if (file_exists("../../logs/bpu$bpu.sts")) {

				$bpuFound = true;
				
			}
			
		}
		
		if (!$bpuFound) {

			insertUserMessage($_SESSION["id"], 2, "BPU's have not been started!");
		
		}
	
	}

	$xml .= "<document>\n";
	$xml .= "\t<session>\n";

	foreach ($_SESSION as $key => $val) {

		$xml .= "\t\t<$key><![CDATA[$val]]></$key>\n";
		
	}

	$xml .= "\t</session>\n";

	$xml .= "\t<ops>\n";
	
	$query = $idsDB->query("SELECT var, val FROM idsOps ORDER BY var DESC");
	while ($row = mysql_fetch_assoc($query)) {

		$xml .= "\t\t<" . $row["var"] . "><![CDATA[" . $row["val"] . "]]></" . $row["var"] . ">\n";

	}
	
	$xml .= "\t</ops>\n";

	$xml .= "\t<newVersion>$newVersion</newVersion>\n";

	$xml .= "</document>\n";

	return $xml;	

}

function prv_getNoImportData() {

	$importTable = "../../conf/noimport.txt";

	if (@file_exists($importTable)) {
		
		$data = file_get_contents($importTable);
		
	} else {
	
		$data = "";
	
	}
	
	$xml .= "<document>\n";
		
		$xml .= "\t<data><![CDATA[$data]]></data>\n";
	
	$xml .= "</document>\n";

	return $xml;	
	
}    

function prv_updateNoImportData() {

	$data = getVar("data");

	$importTable = "../../conf/noimport.txt";

	if ($fp = fopen($importTable, "w")) {
	
		fwrite($fp, $data);
		fclose($fp);

	}
	
	$xml .= "<document>\n";
		
		$xml .= "\t<success>1</success>\n";
	
	$xml .= "</document>\n";

	return $xml;	
	
}

function prv_getSigRiskImportData() {

	$importTable = "../../conf/sigrisk.txt";

	if (@file_exists($importTable)) {
		
		$data = file_get_contents($importTable);
		
	} else {
	
		$data = "";
	
	}
	
	$xml .= "<document>\n";
		
		$xml .= "\t<data><![CDATA[$data]]></data>\n";
	
	$xml .= "</document>\n";

	return $xml;	
	
}    

function prv_updateSigRiskImportData() {

	$data = getVar("data");

	$importTable = "../../conf/sigrisk.txt";

	if ($fp = fopen($importTable, "w")) {
	
		fwrite($fp, $data);
		fclose($fp);

	}
	
	$xml .= "<document>\n";
		
		$xml .= "\t<success>1</success>\n";
	
	$xml .= "</document>\n";

	return $xml;	
	
} 

?>