<?php

/** Copyright 2009 Tactical FLEX
 *
 * Aanval 5
 *
 * This program is owned and licensed by Tactical FLEX; it may be
 * redistributed only in its original configuration as originally
 * installed and available by Tactical FLEX and / or Aanval.
 *
 * To license and / or include this product in other forms or
 * applications, express prior written authorization must be
 * obtained by contract from authorized Tactical FLEX or Aanval agents.
 *
 * Tactical FLEX and Aanval may not be held liable nor responsible
 * for any and all issues arising from the use of, damages caused by, or 
 * conclusions drawn from the use of this product.
 *
 */

include "initialize.php";

function prv_generalCorrelation() {
	global $idsDB;

	$totalResults = 0;
	$totalInSet = 0;

	$searchObj = new coreSearch();
	$searchObj->setVar("query", "recent:750");

	$xml = "<document>\n";

	foreach ($searchObj->searchProcess() as $id) {

		$totalInSet++;

		$eventData = $searchObj->getDetailsByID($id);

		if (!$eventData["sport"]) $eventData["sport"] = "-";
		if (!$eventData["dport"]) $eventData["dport"] = "-";

		$xml .= "\t<event ";
		$xml .= "id=\"" . $id . "\" ";
		$xml .= "store=\"" . $searchObj->getVar("store") . "\" ";
		$xml .= "module=\"" . $eventData["moduleID"] . "\" ";
		$xml .= "risk=\"" . $eventData["priority"] . "\" ";
		$xml .= "datetime=\"" . date("m.d.Y H:i:s", $eventData["timestamp"]) . "\" ";
		$xml .= "sensorid=\"" . $eventData["sensorID"] . "\" ";
		$xml .= "sensorname=\"" . getSensorNameByID($eventData["sensorID"]) . "\" ";
		$xml .= "sip=\"" . longToIP($eventData["sip"]) . "\" ";
		$xml .= "dip=\"" . longToIP($eventData["dip"]) . "\" ";
		$xml .= "sport=\"" . $eventData["sport"] . "\" ";
		$xml .= "dport=\"" . $eventData["dport"] . "\" ";
		$xml .= "signame=\"" . htmlentities($eventData["signatureName"]) . "\" ";
		$xml .= "sigclassname=\"" . htmlentities($eventData["className"]) . "\" ";
		$xml .= " />\n";
	
	}

	if ($totalInSet > $totalResults) $totalResults = $totalInSet;

	$xml .= "\t<totalinset>$totalInSet</totalinset>\n";
	$xml .= "\t<totalresults>$totalResults</totalresults>\n";
	$xml .= "</document>\n";

	return $xml;	
}

?>

