<?php

/** Copyright 2010 Tactical FLEX
 *
 * Aanval 5
 *
 * This program is owned and licensed by Tactical FLEX; it may be
 * redistributed only in its original configuration as originally
 * installed and available by Tactical FLEX and / or Aanval.
 *
 * To license and / or include this product in other forms or
 * applications, express prior written authorization must be
 * obtained by contract from authorized Tactical FLEX or Aanval agents.
 *
 * Tactical FLEX and Aanval may not be held liable nor responsible
 * for any and all issues arising from the use of, damages caused by, or 
 * conclusions drawn from the use of this product.
 *
 */

include "initialize.php";

function prv_eventDetails() {
	global $idsDB;

	$id = sanitize("id");
	if (!$id) return;

	$searchObj = new coreSearch();

	$store = sanitize("store");
	if (!$store) $store = login("activeSearchStore");

	$searchObj->setVar("store", $store);

	$eventData = $searchObj->getDetailsByID($id);

	$xml = "<document>\n";
	
	$srcHost = doHostnameLookup(longToIP($eventData["sip"]));
	$dstHost = doHostnameLookup(longToIP($eventData["dip"]));
	
	// Defaults
	
	if ($srcHost == longToIP($eventData["sip"])) $srcHost = "unavailable";
	if ($dstHost == longToIP($eventData["dip"])) $dstHost = "unavailable";

	if (!$eventData["sport"]) $eventData["sport"] = "null";
	if (!$eventData["dport"]) $eventData["dport"] = "null";

	if (!$eventData["signatureName"]) $eventData["signatureName"] = "null";
	if (!$eventData["signature"]) $eventData["signature"] = "null";

	if (!$eventData["className"]) $eventData["className"] = "null";
	if (!$eventData["class"]) $eventData["class"] = "null";

	if (!$eventData["priority"]) $eventData["priority"] = "null";

	if ($eventData["moduleID"] == 1) {
		$imageModule = "console/assets/images/transparentSnortLogo.gif";
	} else {
		$imageModule = "console/assets/images/transparentSnortLogo.gif";
	}

	if (!$eventData["protocol"]) { 
		$eventData["protocol"] == "null";
	} else {
		$protocolName = protoToName($eventData["protocol"]);
	}

	$noteCount = 0;

	// XML Start

	$xml .= "\t<id>" . $eventData["id"] . "</id>\n";
	$xml .= "\t<module>" . $eventData["moduleID"] . "</module>\n";
	$xml .= "\t<moduleimage>" . $imageModule . "</moduleimage>\n";

	$xml .= "\t<protocol>" . $eventData["protocol"] . "</protocol>\n";
	$xml .= "\t<protocolname>" . $protocolName . "</protocolname>\n";

	$xml .= "\t<risk>" . $eventData["priority"] . "</risk>\n";

	$xml .= "\t<sensorid>" . $eventData["sensorID"] . "</sensorid>\n";
	$xml .= "\t<sensorname><![CDATA[" . getSensorNameByID($eventData["sensorID"]) . "]]></sensorname>\n";

	$xml .= "\t<datetime>" . date("m.d.Y H:i:s",  sensorTimeConversion($eventData["sensorID"], $eventData["timestamp"])) . "</datetime>\n";

	$xml .= "\t<srchost>" . $srcHost . "</srchost>\n";
	$xml .= "\t<dsthost>" . $dstHost . "</dsthost>\n";

	$xml .= "\t<sip>" . longToIP($eventData["sip"]) . "</sip>\n";
	$xml .= "\t<dip>" . longToIP($eventData["dip"]) . "</dip>\n";
	$xml .= "\t<sport>" . $eventData["sport"] . "</sport>\n";
	$xml .= "\t<dport>" . $eventData["dport"] . "</dport>\n";

	$xml .= "\t<signame><![CDATA[" . $eventData["signatureName"] . "]]></signame>\n";
	$xml .= "\t<sigclassname><![CDATA[" . $eventData["className"] . "]]></sigclassname>\n";

	$xml .= "\t<sigid>" . $eventData["signature"] . "</sigid>\n";
	$xml .= "\t<sigclassid>" . $eventData["class"] . "</sigclassid>\n";

	$xml .= "\t\t<payload><![CDATA[" . $eventData["payload"] . "]]></payload>\n";

	$xml .= "\t<hdr_seq>" . $eventData["hdr_seq"] . "</hdr_seq>\n";
	$xml .= "\t<hdr_ack>" . $eventData["hdr_ack"] . "</hdr_ack>\n";
	$xml .= "\t<hdr_off>" . $eventData["hdr_off"] . "</hdr_off>\n";
	$xml .= "\t<hdr_res>" . $eventData["hdr_res"] . "</hdr_res>\n";
	$xml .= "\t<hdr_flags>" . $eventData["hdr_flags"] . "</hdr_flags>\n";
	$xml .= "\t<hdr_win>" . $eventData["hdr_win"] . "</hdr_win>\n";
	$xml .= "\t<hdr_csum>" . $eventData["hdr_csum"] . "</hdr_csum>\n";
	$xml .= "\t<hdr_urp>" . $eventData["hdr_urp"] . "</hdr_urp>\n";
	$xml .= "\t<hdr_len>" . $eventData["hdr_len"] . "</hdr_len>\n";
	$xml .= "\t<hdr_id>" . $eventData["hdr_id"] . "</hdr_id>\n";
	$xml .= "\t<hdr_code>" . $eventData["hdr_code"] . "</hdr_code>\n";
	$xml .= "\t<hdr_type>" . $eventData["hdr_type"] . "</hdr_type>\n";

	$xml .= "\t<ip_ver>" . $eventData["ip_ver"] . "</ip_ver>\n";
	$xml .= "\t<ip_hlen>" . $eventData["ip_hlen"] . "</ip_hlen>\n";
	$xml .= "\t<ip_tos>" . $eventData["ip_tos"] . "</ip_tos>\n";
	$xml .= "\t<ip_len>" . $eventData["ip_len"] . "</ip_len>\n";
	$xml .= "\t<ip_id>" . $eventData["ip_id"] . "</ip_id>\n";
	$xml .= "\t<ip_off>" . $eventData["ip_off"] . "</ip_off>\n";
	$xml .= "\t<ip_flags>" . $eventData["ip_flags"] . "</ip_flags>\n";
	$xml .= "\t<ip_ttl>" . $eventData["ip_ttl"] . "</ip_ttl>\n";
	$xml .= "\t<ip_csum>" . $eventData["ip_csum"] . "</ip_csum>\n";

	$xml .= "\t<opt_code>" . $eventData["opt_code"] . "</opt_code>\n";
	$xml .= "\t<opt_len>" . $eventData["opt_len"] . "</opt_len>\n";
	$xml .= "\t<opt_data>" . $eventData["opt_data"] . "</opt_data>\n";
	$xml .= "\t<opt_proto>" . $eventData["opt_proto"] . "</opt_proto>\n";

	$q = $idsDB->query("SELECT count(id) as cnt FROM idsNotes where enabled = 1 and storeid = '" . login("activeSearchStore") . "' and trackid = '$id' and (userid = '" . login("id") . "' or read_access = 1) order by id asc");
	while ($row = mysql_fetch_array($q, MYSQL_ASSOC)) {
		$noteCount = $row["cnt"];
	}

	$xml .= "\t<notecount>" . $noteCount . "</notecount>\n";

	$xml .= "</document>\n";

	return $xml;	
}

function prv_sensorTimescaleData() {
	global $idsDB;

	$num = sanitize("num");
	if (!$num) $num = 1;

	$startTimestamp = strtotime(date("y-m-d")) - (86400 * $num);

	$xml = "<document>\n";

	$q = $idsDB->query("SELECT timestamp, sensor, total from idsDataStore_" . login("activeSearchStore") . "_Timescale where sensor in (" . login("sensors") . ") and timestamp > $startTimestamp order by timestamp asc");
	while ($row = mysql_fetch_array($q, MYSQL_ASSOC)) {

		$tmpArray[$row['sensor']][] = array($row['timestamp'], $row['total']);

	}

	foreach ($tmpArray as $key => $outerArray) {

		$xml .= "\t<sensor>\n";

		$xml .= "\t\t<id>" . $key . "</id>\n";
		$xml .= "\t\t<name><![CDATA[" . getSensorNameByID($key) . "]]></name>\n";

		foreach ($outerArray as $innerArray => $data) {
	
			$xml .= "\t\t<node>\n";
	
				$xml .= "\t\t\t<timestamp>" . $data[0] . "</timestamp>\n";
				$xml .= "\t\t\t<timedisplay>" . date("m.d.Y H:i:s", $data[0]) . "</timedisplay>\n";
				$xml .= "\t\t\t<total>" . $data[1] . "</total>\n";
	
			$xml .= "\t\t</node>\n";
				
		}

		$xml .= "\t</sensor>\n";

	}

	$xml .= "</document>\n";

	return $xml;	

}

function prv_eventBrowserData() {
	global $idsDB;

	$xml = "<document>\n";

	$sensorArray = explode(",", login("sensors"));

	foreach ($sensorArray as $sensor) {

		$xml .= "\t<sensors>\n";

		$xml .= "\t\t<sensor>\n";
		$xml .= "\t\t<id>$sensor</id>\n";
		$xml .= "\t\t<name><![CDATA[" . getSensorNameByID($sensor) . "]]></name>\n";
		$xml .= "\t\t</sensor>\n";

		$xml .= "\t</sensors>\n";
	}
	
	$xml .= "\t<stores>\n";	

	$q = $idsDB->query("show tables like 'idsDataStore%Master'");
	while ($row = mysql_fetch_array($q)) {

		$tmp = explode("_", $row[0]);

		$xml .= "\t\t<store>\n";
		$xml .= "\t\t\t<id>" . $tmp[1] . "</id>\n";

		$name = $tmp[1];

		$q1 = $idsDB->query("select name from idsDataStore where store = '" . $tmp[1] . "'");
		while ($row1 = mysql_fetch_array($q1)) {
		
			$name = "(" . $tmp[1] . ") " . $row1[0];
		
		}

		$xml .= "\t\t\t<name><![CDATA[" . $name . "]]></name>\n";
		$xml .= "\t\t</store>\n";
		
	}

	$xml .= "\t</stores>\n";	

	$xml .= "</document>\n";

	return $xml;	

}

function prv_wordListByAlpha() {
	global $idsDB;

	$alpha = strtolower(sanitize("alpha"));
	if (!$alpha) $alpha = "a";

	$xml = "<document>\n";

	$xml .= "\t<words>\n";

	$q = $idsDB->query("select count(txt.id) as cnt, txt.text from idsDataStore_" . login("activeSearchStore") . "_Text_Index as idx LEFT JOIN idsDataStore_" . login("activeSearchStore") . "_Text as txt USING (id) where txt.text like '$alpha%' group by txt.text order by cnt desc");
	while ($row = mysql_fetch_array($q)) {

		$xml .= "\t\t<word>\n";

		$xml .= "\t\t\t<total>" . $row[0] . "</total>\n";
		$xml .= "\t\t\t<text><![CDATA[" . $row[1] . "]]></text>\n";

		$xml .= "\t\t</word>\n";

	}
	
	$r = $idsDB->query("select count(txt.id) from idsDataStore_" . login("activeSearchStore") . "_Text as txt");
	while ($row = mysql_fetch_array($r)) {

		$total = $row[0];

	}

	$xml .= "\t\t\t<total>" . $total . "</total>\n";

	$xml .= "\t</words>\n";

	$xml .= "</document>\n";

	return $xml;	

}

?>

