<?php

/** Copyright 2010 Tactical FLEX
 *
 * Aanval 5
 *
 * This program is owned and licensed by Tactical FLEX; it may be
 * redistributed only in its original configuration as originally
 * installed and available by Tactical FLEX and / or Aanval.
 *
 * To license and / or include this product in other forms or
 * applications, express prior written authorization must be
 * obtained by contract from authorized Tactical FLEX or Aanval agents.
 *
 * Tactical FLEX and Aanval may not be held liable nor responsible
 * for any and all issues arising from the use of, damages caused by, or 
 * conclusions drawn from the use of this product.
 *
 */

include "initialize.php";

function pub_communicationCheck() {

	$xml = "<document>\n";
	$xml .= "\t<node>\n";

	$xml .= "\t\t<communication>1</communication>\n";
	$xml .= "\t\t<message>Success</message>\n";

	$xml .= "\t</node>\n";
	
	$xml .= "</document>\n";

	iuLog("Console communication test");

	return $xml;
}

function pub_upgradeInstallCheck() {

	// TF
	
	iuLog("Installation / upgrade check initiated");
	
	$xml = "<document>\n";
	
	// Install / Upgrade
	$xml .= "\t<consoleMode>\n";
		
		if (file_exists("../../installation/install.cert")) {
		
			// Installation Exists
			
			if (file_exists("../../installation/upgrade")) {
	
				// Upgrade
	
				iuLog("Switching to upgrade mode");
	
				$code = 2;
	
			} else {
			
				// Nothing to do
				
				iuLog("Nothing to do");
				
				$code = 0;
		
			}
		
		} else {
		
			// New Install
		
			iuLog("Switching to installation mode");
		
			$code = 1;
		
		}	
	
		$xml .= "\t\t<code>$code</code>\n";
		
	$xml .= "\t</consoleMode>\n";
		
	$xml .= "</document>\n";
	
	return $xml;

}

function pub_processUpgrade() {
	global $idsDB;
	
	iuLog("Upgrade started");
	
	// If installed already, exit
	if (!file_exists("../../installation/upgrade")) {
	
		iuLog("Upgrade exited: no upgrade trigger found");

		return;
		
	}
	
	$code = sanitize("id");

	// Simple stumble-upon prevention string
	if ($code != "274409387238989734528814393837001") {
	
		iuLog("Upgrade exited: invalid stumble code");
	
		return;
		
	} else {
	
		iuLog("Stumble code okay");
	
	}

	$xml = "<document>\n";

	createAllTables();

	// Table and data modifications go here (post release)

	iuLog("Upgrade post release modifications started");

	# Email type (Added 04/23/09)
    $xmlData .= alterTable("idsEmail", "ALTER TABLE idsEmail ADD type int(2)");

	# Snort Signature Updates (Added 06/29/10)
    $xmlData .= updateTableData("idsOps", "UPDATE idsOps SET val = 'snortrules-snapshot-2860.tar.gz,snortrules-snapshot-2853.tar.gz' WHERE var = 'site_sigDownloadURL'");

	# Signatures msg (Added 07/10/10)
	$xmlData .= alterTable("idsSignatures", "ALTER TABLE idsSignatures ADD msg varchar(200)");

	# Signatures gid (Added 07/10/10)
	$xmlData .= alterTable("idsSignatures", "ALTER TABLE idsSignatures ADD gid int(10)");

	# Signatures pkg (Added 07/10/10)
	$xmlData .= alterTable("idsSignatures", "ALTER TABLE idsSignatures ADD source varchar(100)");

	# Signatures indexes
	$xmlData .= alterTable("idsSignatures", "CREATE INDEX rev_index ON idsSignatures (rev)");
	$xmlData .= alterTable("idsSignatures", "CREATE INDEX sid_gid_index ON idsSignatures (sid,gid)");

	# Drop idsSignaturesIndex (Added 07/10/10)
	$xmlData .= alterTable("idsSignaturesIndex", "DROP TABLE idsSignaturesIndex");

	# Signatures idsDataStore_1000_Events (Added 07/27/10)
	$xmlData .= alterTable("idsDataStore_1000_Events", "ALTER TABLE idsDataStore_1000_Events ADD sip_ipv6 bigint(11) unsigned");
	$xmlData .= alterTable("idsDataStore_1000_Events", "ALTER TABLE idsDataStore_1000_Events ADD dip_ipv6 bigint(11) unsigned");

	iuLog("Upgrade post release modifications complete");

	// Load Table Data
	loadAllTableData();	
	
	// Complete
	@unlink("../../installation/upgrade");
	
	installSendmail("UPGRADE");
	
	$xml .= "\t<success>1</success>\n";
	$xml .= "</document>\n";

	iuLog("Upgrade complete");

	return $xml;
}

function pub_processInstall_alpha() {
	global $idsDB;

	iuLog("Install part 1 of 2 started");

	// If installed already, exit
	if (file_exists("../../installation/install.cert")) {
	
		iuLog("Install exited: console already certified");
	
		return;
		
	}

	$code = sanitize("id");

	$type = sanitize("type");
	
	$db = sanitize("db");
	$dbhost = sanitize("dbhost");
	$dbuser = sanitize("dbuser");
	$dbpass = sanitize("dbpass");

	// Simple stumble-upon prevention string
	if ($code != "274409387238989734528814393837001") {
	
		iuLog("install exited: invalid stumble code");
	
		return;
		
	} else {
	
		iuLog("Stumble code okay");
	
	}

	// Process install part 1
	
	$xml = "<document>\n";

    // Check Database Connect and Select | return if invalid
    if ($link = @mysql_connect("$dbhost", "$dbuser", "$dbpass")) {
    
		iuLog("Database connection successful");
    
    	if ($type == 1) {
    
			if (@mysql_select_db($db)) {
				
				iuLog("Database selection successful");
				
				$goodToGo = 1;
				
			} else {
			
				iuLog("Database selection failure: " . mysql_error());
			
				$xml .= "\t<select>0</select>\n";
			
			}
			
		} else if ($type == 0) {
		
			@mysql_unbuffered_query("create database `$db`", $link);
            if (@mysql_select_db($db)) {		
		
				iuLog("Database creation successful");
		
				$goodToGo = 1;
		
			} else {

				iuLog("Database creation failure: " . mysql_error());
			
				$xml .= "\t<create>0</create>\n";
			
			}
		
		}

		@mysql_close($link);
			
		if ($goodToGo == 1) {

			$success = writeConfigFile($db, $dbuser, $dbpass, $dbhost);
			
			$xml .= "\t<write>$success</write>\n";

		}
		
    } else {
    
		iuLog("Database connection failure: " . mysql_error());
    
		$xml .= "\t<connect>0</connect>\n";
		
    }
	
	$xml .= "</document>\n";

	iuLog("Install part 1 of 2 complete");

	return $xml;
		
}

function pub_processInstall_bravo() {
	global $idsDB;

	iuLog("Install part 2 of 2 started");

	// If installed already, exit
	if (file_exists("../../installation/install.cert")) {
	
		iuLog("Install exited: console already certified");
	
		return;
		
	}

	$code = sanitize("id");

	// Simple stumble-upon prevention string
	if ($code != "381409387238989734528814393837555") {
	
		iuLog("install exited: invalid stumble code");
	
		return;
		
	} else {
	
		iuLog("Stumble code okay");
	
	}

	// Process install part 2
	
	$xml = "<document>\n";
	
	$xmlData .= createAllTables();

	// Table modifications go here (Post release)

	// Load Table Data
	loadAllTableData();
	
	// Complete
	@unlink("../../installation/upgrade");
	@touch("../../installation/install.cert");
	
	$xml .= $xmlData;
	
	installSendmail("INSTALL");

	$xml .= "\t<success>1</success>\n";
	
	$xml .= "</document>\n";

	iuLog("Install part 2 of 2 complete");

	return $xml;

}

function createAllTables() {

	iuLog("Table creation started");

	// Create tables
	
	$xmlData .= createTable("idsUsers", "CREATE TABLE idsUsers (id int(11) NOT NULL auto_increment, username varchar(50) default NULL, fname varchar(20) default NULL, lname varchar(20) default NULL, organization varchar(40) default NULL, email varchar(50) default NULL, phone varchar(30) default NULL, secword varchar(50) default NULL, password varchar(100) default NULL, enabled int(3) default NULL, loginip varchar(20) default NULL, logintime varchar(50) default NULL, type int(10) default NULL, pgp text, country varchar(50) default NULL, state varchar(50) default NULL, city varchar(50) default NULL, sensors varchar(200) default NULL, timezone int(10) default NULL, activeSearchStore int(10) default NULL, intime timestamp NOT NULL default CURRENT_TIMESTAMP, PRIMARY KEY (id))");
	$xmlData .= createTable("idsUserMessages", "CREATE TABLE idsUserMessages (id int(11) NOT NULL auto_increment, uid int(11) default NULL,priority int(11) default '3', message text, enabled int(11) default '1', timestamp timestamp NOT NULL default CURRENT_TIMESTAMP, PRIMARY KEY  (id), KEY msgTimestamp (timestamp))");
	
	$xmlData .= createTable("idsSensor", "CREATE TABLE idsSensor ( id int(10) NOT NULL auto_increment, sid varchar(20) default NULL,  name varchar(200) default NULL,  location varchar(200) default NULL,  description text,  os varchar(100) default NULL,  module smallint(3) default NULL,  timezone varchar(100) default NULL,  enabled int(10) default NULL,  lastEvent varchar(100) default NULL,  intime varchar(100) default NULL,  smtid varchar(20) default NULL,  emailOnStatusFailure varchar(250) default NULL,  emailOnCommFailure varchar(250) default NULL,  path varchar(100) default NULL,  tracker1 varchar(100) default NULL,  tracker2 longblob,  hb varchar(20) default NULL,  hbcount int(10) default '0',  status int(10) default NULL,  confFile varchar(100) default NULL,  confPolicy varchar(100) default NULL,  countCommFailure int(10) default '0',  countStatusFailure int(10) default '0',  lastCommFailure varchar(20) default NULL,  lastStatusCheck varchar(20) default NULL,  lastVersionCheck varchar(20) default NULL,  lastStatusFailure varchar(20) default NULL,  type int(10) default NULL,  PRIMARY KEY  (id))");
	$xmlData .= createTable("idsSensorManage", "CREATE TABLE idsSensorManage (sid int(10) NOT NULL,  status int(10),  hb int(10), hbcount int(10) default '0', snortconf text)");
	$xmlData .= createTable("idsSensorManageMessages", "CREATE TABLE idsSensorManageMessages (id int(10) NOT NULL auto_increment,  sid int(10), message varchar(200), enabled int(10), issued int(10), received int(10), PRIMARY KEY  (id))");
	$xmlData .= createTable("idsSensorPolicy", "CREATE TABLE idsSensorPolicy (id int(10) not null auto_increment, name varchar(100), PRIMARY KEY  (id))");

	$xmlData .= createTable("idsSyslogModule", "CREATE TABLE idsSyslogModule (id int(10) NOT NULL auto_increment, source varchar(250) default NULL, type varchar(250) default NULL, f_date varchar(250) default NULL, f_time varchar(250) default NULL, f_sip varchar(250) default NULL, f_dip varchar(250) default NULL, f_sport varchar(250) default NULL, f_dport varchar(250) default NULL, f_protocol varchar(250) default NULL, f_level varchar(250) default NULL, f_ename varchar(250) default NULL, f_etypename varchar(250) default NULL, f_payload varchar(250) default NULL, f_misc1 varchar(250) default NULL, f_misc2 varchar(250) default NULL, f_misc3 varchar(250) default NULL, f_misc4 varchar(250) default NULL, f_misc5 varchar(250) default NULL, PRIMARY KEY  (id))");
	$xmlData .= createTable("idsImportFilters", "CREATE TABLE idsImportFilters (id int(10) not null auto_increment, enabled int(5), name varchar(100), description varchar(200), filter text, sample text, PRIMARY KEY (id))");

	$xmlData .= createTable("idsCollection", "CREATE TABLE idsCollection (id int(10) NOT NULL auto_increment,  userid int(10) default NULL,  name varchar(100) default NULL,  description varchar(200) default NULL, enabled int(10) default NULL,  access int(5), timestamp varchar(100) default NULL,  PRIMARY KEY  (id))");
	$xmlData .= createTable("idsCollectionStore", "CREATE TABLE idsCollectionStore (cid int(10) NOT NULL, store int(10) NOT NULL, event int(10) NOT NULL, KEY cid_store (cid,store))");

	$xmlData .= createTable("idsScannerSchedule", "CREATE TABLE idsScannerSchedule (id int(10) not null auto_increment, name varchar(100), runonce int(5), type int(5), host longblob, status int(5), options longblob, mon int(2), tue int(2), wed int(2), thu int(2), fri int(2), sat int(2), sun int(2), runtime varchar(100), runlast int(3), enabled int(3), intime int(10), userid int(10), email varchar(200), viewed varchar(100), PRIMARY KEY  (id))");
	$xmlData .= createTable("idsScannerResults", "CREATE TABLE idsScannerResults (id int(10) not null auto_increment, userid int(10), scanid int(10), data longblob, intime varchar(100), PRIMARY KEY (id))");

	$xmlData .= createTable("idsSignatures", "CREATE TABLE idsSignatures (id int(10) not null auto_increment, sid int(10), gid int(10), rev int(10), class varchar(100), msg varchar(200), file varchar(100), source varchar(100), data text, intime varchar(100),  PRIMARY KEY  (id), KEY rev_index (rev), KEY sid_gid_index (sid,gid))");
	$xmlData .= createTable("idsSignaturePolicyIndex", "CREATE TABLE idsSignaturePolicyIndex (id int(10) not null auto_increment, pid int(10), sid int(10), PRIMARY KEY  (id))");
	$xmlData .= createTable("idsSignatureSources", "CREATE TABLE idsSignatureSources (id int(10) not null auto_increment, name varchar(100), location varchar(200), lastDownload varchar(20) default '0', lastFilesize varchar(20) default '0', enabled int(10) default '0', PRIMARY KEY  (id))");

	$xmlData .= createTable("idsOps", "CREATE TABLE idsOps ( var varchar(100) NOT NULL default '', val text, type int(5) default NULL, cat int(5) default NULL, mod_date timestamp NOT NULL default CURRENT_TIMESTAMP, intime timestamp NOT NULL default '0000-00-00 00:00:00', PRIMARY KEY (var))");
	$xmlData .= createTable("idsModules", "CREATE TABLE idsModules (id int(10) NOT NULL auto_increment,  module varchar(20) default NULL,  enabled int(10) default NULL,  auth_db_user varchar(50) default NULL,  auth_db varchar(50) default NULL,  auth_db_pass varchar(50) default NULL,  auth_db_host varchar(50) default NULL,  PRIMARY KEY  (id))");
	$xmlData .= createTable("idsQueries", "CREATE TABLE idsQueries (id int(10) not null auto_increment, uid int(10), query text, intime varchar(100), PRIMARY KEY (id))");
	$xmlData .= createTable("idsEmail", "CREATE TABLE idsEmail (id int(10) not null auto_increment, uid int(10), type int(2), fromName varchar(200), fromEmail varchar(200), toName varchar(200), toEmail varchar(200), subject varchar(200), message text, sent int(10), senttime varchar(100), deliver varchar(100), intime varchar(100), PRIMARY KEY  (id))");
	$xmlData .= createTable("idsHostnames", "CREATE TABLE idsHostnames (ip int(10) unsigned NOT NULL default '0',  hostname varchar(200) default NULL, timestamp varchar(100) default NULL,  PRIMARY KEY  (ip))");
	$xmlData .= createTable("idsNotes", "CREATE TABLE idsNotes (id int(10) NOT NULL auto_increment,  storeid int(10) default NULL, trackid int(10) default NULL, collectionid int(10) default NULL,  note text,  timestamp varchar(100) default NULL,  enabled int(10) default NULL,  userid int(10) default NULL,  read_access int(10) default NULL,  write_access int(10) default NULL,  PRIMARY KEY  (id))");
	$xmlData .= createTable("idsTimezones", "CREATE TABLE idsTimezones (id int(10) NOT NULL auto_increment,  name varchar(100) default NULL,  zone int(10) default NULL,  PRIMARY KEY  (id))");

	$xmlData .= createTable("idsActionMaster", "CREATE TABLE idsActionMaster (id int(10) NOT NULL auto_increment,  userid smallint(5) default NULL, name varchar(200) default NULL, enabled int(10) default NULL,  intime varchar(100) default NULL,  matchtype int(3) default NULL, threshold int(10) default NULL,  thresholdcount int(10) default '0',  count int(10) default '0',  description varchar(250) default NULL,  onetime tinyint(3) default NULL, thresholdtime int(10) default NULL,  deleted int(3), thresholdeventtime int(10) unsigned default NULL, senderName varchar(200), senderEmail varchar(200), senderSubject varchar(200), senderBody blob, weight int(10), PRIMARY KEY  (id))");
	$xmlData .= createTable("idsActionStore", "CREATE TABLE idsActionStore (id int(10) NOT NULL auto_increment, masterid int(10), class int(3), type int(3), data varchar(220), intime varchar(100), primary key (id))"); 

	$xmlData .= createTable("idsReportSchedule", "CREATE TABLE idsReportSchedule (id int(10) not null auto_increment, name varchar(100), type int(5), status int(5), query text, store varchar(100), mon int(2), tue int(2), wed int(2), thu int(2), fri int(2), sat int(2), sun int(2), runtime varchar(100), runlast int(3), enabled int(3), intime int(10), userid int(10), email varchar(200), data longblob, viewed varchar(100),PRIMARY KEY  (id))");

	$xmlData .= createTable("idsDataStore", "CREATE TABLE idsDataStore (id int(11) unsigned NOT NULL auto_increment, name varchar(200) default NULL, store smallint(11) unsigned default NULL, `index` int(11) unsigned default NULL, PRIMARY KEY  (id))");
	$xmlData .= createTable("idsDataStore_1000_Master", "CREATE TABLE idsDataStore_1000_Master (id int(11) unsigned NOT NULL auto_increment, moduleID tinyint(11) unsigned default '0',  sensorID smallint(11) unsigned default '0',  created timestamp NOT NULL default CURRENT_TIMESTAMP, enabled tinyint(11) unsigned default '1', actionated tinyint(11) unsigned default '0', PRIMARY KEY  (id), KEY masterMODULEID (moduleID), KEY masterCREATED (created), KEY masterSENSORID (sensorID))");
	$xmlData .= createTable("idsDataStore_1000_Events", "CREATE TABLE idsDataStore_1000_Events (id int(11) unsigned NOT NULL, eventID int(11) unsigned default NULL, signature mediumint(11) unsigned default NULL, signatureName varchar(255) default NULL, class mediumint(11) unsigned default NULL, className varchar(255) default NULL, gid mediumint(11) unsigned default NULL, sensor smallint(11) unsigned default NULL, sip bigint(11) unsigned default NULL, sip_ipv6 bigint(11) unsigned default NULL, dip bigint(11) unsigned default NULL, dip_ipv6 bigint(11) unsigned default NULL, sport smallint(11) unsigned default NULL, dport smallint(11) unsigned default NULL, priority tinyint(11) unsigned default NULL, protocol tinyint(11) unsigned default NULL, payload text, hdr_seq int(11) unsigned default NULL, hdr_ack int(11) unsigned default NULL, hdr_off tinyint(11) unsigned default NULL, hdr_res tinyint(11) unsigned default NULL, hdr_flags tinyint(11) unsigned default NULL, hdr_win smallint(11) unsigned default NULL, hdr_csum smallint(11) unsigned default NULL, hdr_urp smallint(11) unsigned default NULL, hdr_len smallint(11) unsigned default NULL, hdr_id smallint(11) unsigned default NULL, hdr_code tinyint(11) unsigned default NULL, hdr_type tinyint(11) unsigned default NULL, ip_ver tinyint(11) unsigned default NULL, ip_hlen tinyint(11) unsigned default NULL, ip_tos tinyint(11) unsigned default NULL, ip_len smallint(11) unsigned default NULL, ip_id smallint(11) unsigned default NULL, ip_off smallint(11) unsigned default NULL, ip_flags tinyint(11) unsigned default NULL, ip_ttl tinyint(11) unsigned default NULL, ip_csum smallint(11) unsigned default NULL, opt_proto tinyint(11) unsigned default NULL, opt_code tinyint(11) unsigned default NULL, opt_len smallint(11) default NULL, opt_data text, customGrouping text, timestamp int(11) default NULL, PRIMARY KEY  (id), KEY event_id (eventID), KEY eventSIP (sip), KEY eventDIP (dip), KEY eventSIGNAME (signatureName), KEY eventCLASSNAME (className), KEY eventDPORT (dport), KEY eventSPORT (sport), KEY eventSIG (signature), KEY eventCLASS (class), KEY eventTIMESTAMP (timestamp))");
	$xmlData .= createTable("idsDataStore_1000_Text", "CREATE TABLE idsDataStore_1000_Text (id int(10) NOT NULL auto_increment, text varchar(64) NOT NULL default '', PRIMARY KEY  (id), UNIQUE KEY keyword (text)) AUTO_INCREMENT=139950");
	$xmlData .= createTable("idsDataStore_1000_Text_Index", "CREATE TABLE idsDataStore_1000_Text_Index (id int(11) unsigned default NULL, loc int(11) unsigned default NULL, rel smallint(11) unsigned default '0', KEY indexID (id),	KEY indexLOC (loc))");
 	$xmlData .= createTable("idsDataStore_1000_Timescale", "CREATE TABLE idsDataStore_1000_Timescale (timestamp int(11) unsigned NOT NULL default '0', sensor int(5) unsigned NOT NULL default '0', total int(11) unsigned default '0', PRIMARY KEY  (timestamp,sensor))");

	$xmlData .= createTable("idsLicense", "CREATE TABLE idsLicense (id int(10) not null auto_increment, license varchar(200), licensekey int(10), active int(10), intime varchar(100), PRIMARY KEY  (id))");
	
	iuLog("Table creation complete");
	
	return $xmlData;

}

function loadAllTableData() {

	iuLog("Loading table data started");

    # idsModules
    insertTableData("idsModules", "INSERT INTO idsModules VALUES (1,'snort',0,'default_username','db_name','password','localhost')");
    insertTableData("idsModules", "INSERT INTO idsModules VALUES (2,'syslog',0,'default_username','db_name','password','localhost')");

    # idsUsers
    insertTableData("idsUsers", "INSERT INTO idsUsers 
    	(
    	id, 
    	username, 
    	fname, 
    	lname, 
    	organization, 
    	email, 
    	phone, 
    	secword, 
    	password, 
    	enabled, 
    	type, 
    	country, 
    	state, 
    	city, 
    	timezone, 
    	activeSearchStore
    	)
    	
    	VALUES
    	
    	(
    	'1',
    	'root',
    	'Admin',
    	'Account',
    	'Aanval by Tactical FLEX',
    	'default@email.com',
    	'800.921.2584',
    	'Secret Passphrase',
    	'b7c087f49d2394c3e93835605ff147b8',
    	'1',
    	'10',
    	'USA',
    	'IL',
    	'Chicago',
    	'62',
    	'1000'
    	)");    
    
    # idsTimezones
    insertTableData("idsTimezones", "INSERT INTO idsTimezones VALUES (1,'London, England',0)");
    insertTableData("idsTimezones", "INSERT INTO idsTimezones VALUES (2,'Dublin, Ireland',0)");
    insertTableData("idsTimezones", "INSERT INTO idsTimezones VALUES (3,'Edinburgh, Scotland',0)");
    insertTableData("idsTimezones", "INSERT INTO idsTimezones VALUES (4,'Lisbon, Portugal',0)");
    insertTableData("idsTimezones", "INSERT INTO idsTimezones VALUES (5,'Reykjavik, Iceland',0)");
    insertTableData("idsTimezones", "INSERT INTO idsTimezones VALUES (6,'Casablanca, Morocco',0)");
    insertTableData("idsTimezones", "INSERT INTO idsTimezones VALUES (7,'Paris, France',1)");
    insertTableData("idsTimezones", "INSERT INTO idsTimezones VALUES (8,'Berlin, Germany',1)");
    insertTableData("idsTimezones", "INSERT INTO idsTimezones VALUES (9,'Amsterdam, Holland',1)");
    insertTableData("idsTimezones", "INSERT INTO idsTimezones VALUES (10,'Netherlands',1)");
    insertTableData("idsTimezones", "INSERT INTO idsTimezones VALUES (11,'Brussels, Belgium',1)");
    insertTableData("idsTimezones", "INSERT INTO idsTimezones VALUES (12,'Vienna, Austria',1)");
    insertTableData("idsTimezones", "INSERT INTO idsTimezones VALUES (13,'Madrid, Spain',1)");
    insertTableData("idsTimezones", "INSERT INTO idsTimezones VALUES (14,'Rome, Italy',1)");
    insertTableData("idsTimezones", "INSERT INTO idsTimezones VALUES (15,'Bern, Switzerland',1)");
    insertTableData("idsTimezones", "INSERT INTO idsTimezones VALUES (16,'Stockholm, Sweden',1)");
    insertTableData("idsTimezones", "INSERT INTO idsTimezones VALUES (17,'Oslo, Norway',1)");
    insertTableData("idsTimezones", "INSERT INTO idsTimezones VALUES (18,'Athens, Greece',2)");
    insertTableData("idsTimezones", "INSERT INTO idsTimezones VALUES (19,'Helsinki, Finland',2)");
    insertTableData("idsTimezones", "INSERT INTO idsTimezones VALUES (20,'Istanbul, Turkey',2)");
    insertTableData("idsTimezones", "INSERT INTO idsTimezones VALUES (21,'Jerusalem, Israel',2)");
    insertTableData("idsTimezones", "INSERT INTO idsTimezones VALUES (22,'Harare, Zimbabwe',2)");
    insertTableData("idsTimezones", "INSERT INTO idsTimezones VALUES (23,'Kuwait',3)");
    insertTableData("idsTimezones", "INSERT INTO idsTimezones VALUES (24,'Nairobi, Kenya',3)");
    insertTableData("idsTimezones", "INSERT INTO idsTimezones VALUES (25,'Riyadh, Saudi Arabia',3)");
    insertTableData("idsTimezones", "INSERT INTO idsTimezones VALUES (26,'Moscow, Russia',3)");
    insertTableData("idsTimezones", "INSERT INTO idsTimezones VALUES (27,'Tehran, Iran',3)");
    insertTableData("idsTimezones", "INSERT INTO idsTimezones VALUES (28,'Adu Dhabi, UAE',4)");
    insertTableData("idsTimezones", "INSERT INTO idsTimezones VALUES (29,'Muscat',4)");
    insertTableData("idsTimezones", "INSERT INTO idsTimezones VALUES (30,'Tblisi',4)");
    insertTableData("idsTimezones", "INSERT INTO idsTimezones VALUES (31,'Volgograd',4)");
    insertTableData("idsTimezones", "INSERT INTO idsTimezones VALUES (32,'Kabul',4)");
    insertTableData("idsTimezones", "INSERT INTO idsTimezones VALUES (33,'Afghanistan',4)");
    insertTableData("idsTimezones", "INSERT INTO idsTimezones VALUES (34,'India',5)");
    insertTableData("idsTimezones", "INSERT INTO idsTimezones VALUES (35,'Cocos Islands',6)");
    insertTableData("idsTimezones", "INSERT INTO idsTimezones VALUES (36,'China',8)");
    insertTableData("idsTimezones", "INSERT INTO idsTimezones VALUES (37,'Japan',9)");
    insertTableData("idsTimezones", "INSERT INTO idsTimezones VALUES (38,'Darwin, Australia',9)");
    insertTableData("idsTimezones", "INSERT INTO idsTimezones VALUES (39,'Adelaide, Australia',9)");
    insertTableData("idsTimezones", "INSERT INTO idsTimezones VALUES (40,'Guam',10)");
    insertTableData("idsTimezones", "INSERT INTO idsTimezones VALUES (41,'Lord Howe Island',10)");
    insertTableData("idsTimezones", "INSERT INTO idsTimezones VALUES (42,'Norfolk Island',11)");
    insertTableData("idsTimezones", "INSERT INTO idsTimezones VALUES (43,'Wellington, New Zealand',12)");
    insertTableData("idsTimezones", "INSERT INTO idsTimezones VALUES (44,'Fiji',12)");
    insertTableData("idsTimezones", "INSERT INTO idsTimezones VALUES (45,'Marshall, Islands',12)");
    insertTableData("idsTimezones", "INSERT INTO idsTimezones VALUES (46,'Rawaki Islands',13)");
    insertTableData("idsTimezones", "INSERT INTO idsTimezones VALUES (47,'Line Islands',14)");
    insertTableData("idsTimezones", "INSERT INTO idsTimezones VALUES (48,'Azores, Cape Verde Islands',-1)");
    insertTableData("idsTimezones", "INSERT INTO idsTimezones VALUES (49,'Brasilia, Brazil',-3)");
    insertTableData("idsTimezones", "INSERT INTO idsTimezones VALUES (50,'Buenos Aires, Argentina',-3)");
    insertTableData("idsTimezones", "INSERT INTO idsTimezones VALUES (51,'Georgetown, Guyana',-3)");
    insertTableData("idsTimezones", "INSERT INTO idsTimezones VALUES (52,'Newfoundland',-3)");
    insertTableData("idsTimezones", "INSERT INTO idsTimezones VALUES (53,'Caracas',-4)");
    insertTableData("idsTimezones", "INSERT INTO idsTimezones VALUES (54,'La Paz',-4)");
    insertTableData("idsTimezones", "INSERT INTO idsTimezones VALUES (55,'Bogota',-5)");
    insertTableData("idsTimezones", "INSERT INTO idsTimezones VALUES (56,'Lima, Peru',-5)");
    insertTableData("idsTimezones", "INSERT INTO idsTimezones VALUES (57,'New York, USA',-5)");
    insertTableData("idsTimezones", "INSERT INTO idsTimezones VALUES (58,'Miami, USA',-5)");
    insertTableData("idsTimezones", "INSERT INTO idsTimezones VALUES (59,'Boston, USA',-5)");
    insertTableData("idsTimezones", "INSERT INTO idsTimezones VALUES (60,'Mexico City, Mexico',-6)");
    insertTableData("idsTimezones", "INSERT INTO idsTimezones VALUES (61,'Saskatchewan, Canada',-6)");
    insertTableData("idsTimezones", "INSERT INTO idsTimezones VALUES (62,'Chicago, USA',-6)");
    insertTableData("idsTimezones", "INSERT INTO idsTimezones VALUES (63,'Dallas, USA',-6)");
    insertTableData("idsTimezones", "INSERT INTO idsTimezones VALUES (64,'Kansas City, USA',-6)");
    insertTableData("idsTimezones", "INSERT INTO idsTimezones VALUES (65,'Boise, USA',-7)");
    insertTableData("idsTimezones", "INSERT INTO idsTimezones VALUES (66,'Salt Lake City, USA',-7)");
    insertTableData("idsTimezones", "INSERT INTO idsTimezones VALUES (67,'Albuquerque, USA',-7)");
    insertTableData("idsTimezones", "INSERT INTO idsTimezones VALUES (68,'Seattle, USA',-8)");
    insertTableData("idsTimezones", "INSERT INTO idsTimezones VALUES (69,'Portland, USA',-8)");
    insertTableData("idsTimezones", "INSERT INTO idsTimezones VALUES (70,'Los Angeles, USA',-8)");
    insertTableData("idsTimezones", "INSERT INTO idsTimezones VALUES (71,'Alaska, USA',-10)");
    insertTableData("idsTimezones", "INSERT INTO idsTimezones VALUES (72,'Hawaii, USA',-10)");
    insertTableData("idsTimezones", "INSERT INTO idsTimezones VALUES (73,'Nome',-11)");
    insertTableData("idsTimezones", "INSERT INTO idsTimezones VALUES (74,'Jakarta, Indonesia',7)");
    insertTableData("idsTimezones", "INSERT INTO idsTimezones VALUES (75,'Warsaw, Poland',1)");
    insertTableData("idsTimezones", "INSERT INTO idsTimezones VALUES (76,'Riga, Latvia',2)");
    insertTableData("idsTimezones", "INSERT INTO idsTimezones VALUES (77,'Ukraine',2)");
    insertTableData("idsTimezones", "INSERT INTO idsTimezones VALUES (78,'Sydney, Australia',9)");

	// OPS Load Here
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('site_timezone','62',1,1,20040616202338,20040616195044)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('site_dir_syslog','syslog/',1,1,20040618075729,20040618075729)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('hostnameReprocess','0',1,1,20040629012801,20040520011130)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('siteLicenseMonitor','0',1,1,20040618081055,20040618081055)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('site_dataStoreRotationDays','30',1,1,20040629012801,20040520011130)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('site_dataStoreRotationEvents','500000',1,1,20040629012801,20040520011130)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('site_dataStoreRotationType','2',1,1,20040629012801,20040520011130)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('site_sigProcessorEnabled','0',1,1,20040629012801,20040520011130)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('site_sigProcessorFrequency','86400',1,1,20040629012801,20040520011130)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('site_sigProcessorSiteA','signature01.aanval.com',1,1,20040629012801,20040520011130)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('site_sigProcessorSiteB','signature02.aanval.com',1,1,20040629012801,20040520011130)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('site_proxyEnabled','0',1,1,20040629012801,20040520011130)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('site_proxyHost','127.0.0.1',1,1,20040629012801,20040520011130)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('site_proxyPort','8080',1,1,20040629012801,20040520011130)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('site_proxyUsername','',1,1,20040629012801,20040520011130)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('site_proxyPassword','',1,1,20040629012801,20040520011130)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('site_versionChecking','1',1,1,20040629012801,20040520011130)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('site_registration','',1,1,20040629012801,20040520011130)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('site_sigProcessorNow','0',1,1,20040629012801,20040520011130)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('site_sigProcessorSite','A',1,1,20040629012801,20040520011130)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('site_hostnameLookups','1',1,1,20040629012801,20040520011130)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('site_versionUpdateNow','0',1,1,20040629012801,20040520011130)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('loadOpsContinue','0',1,1,20040629012801,20040520011130)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('loadProcessor','1',1,1,20040629012801,20040520011130)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('indexReprocess','0',1,1,20040629012801,20040520011130)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('site_brandLicense','',1,1,20040629012801,20040520011130)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('site_snortTruncate','0',1,1,20040618081150,20040618081150)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('site_processorEventRun','500',1,1,20040629012801,20040520011130)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('site_processorIndexRun','500',1,1,20040629012801,20040520011130)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('site_dailyStatsReportEmail','',1,1,20040629012801,20040520011130)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('site_dailyStatsReportTime','08:00',1,1,20040629012801,20040520011130)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('site_dailyStatsReportLast','',1,1,20040629012801,20040520011130)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('site_dailyStatsReportFrom','email@aanvalconsole.com',1,1,20040629012801,20040520011130)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('site_dailyStatsReportSubject','Daily Statistics Report',1,1,20040629012801,20040520011130)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('site_smtpEnabled','',1,1,20040629012801,20040520011130)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('site_smtpServer','smtp.server.com',1,1,20040629012801,20040520011130)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('site_smtpUsername','',1,1,20040629012801,20040520011130)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('site_smtpPassword','',1,1,20040629012801,20040520011130)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('site_sendmailLocal','/usr/sbin/sendmail -t',1,1,20040629012801,20040520011130)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('site_sendmailEnabled','',1,1,20040629012801,20040520011130)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('site_sigFileCustom','',1,1,20040629012801,20040520011130)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('site_emailFloodProtection','1',1,1,20040629012801,20040520011130)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('site_emailFloodLimit','10',1,1,20040629012801,20040520011130)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('site_wget_path','/usr/bin/wget',1,1,20040629012801,20040520011130)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('site_permChecking','1',1,1,20040629012801,20040520011130)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('site_snortAutoTrim','0',1,1,20040629012801,20040520011130)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('site_snortAutoTrimMax','500000',1,1,20040629012801,20040520011130)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('site_snortStats','0',1,1,20040629012801,20040520011130)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('site_corEngineLevelA','1',1,1,20040629012801,20040520011130)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('site_consoleName','Aanval',1,1,20040629012801,20040520011130)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('site_consoleDescription','Snort and Syslog Intrusion Detection and Correlation Console',1,1,20040629012801,20040520011130)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('site_companyName','Tactical FLEX',1,1,20040629012801,20040520011130)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('site_loginMainImage','images/mat_d3.jpg',1,1,20040629012801,20040520011130)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('site_mainURL','http://www.aanval.com/',1,1,20040629012801,20040520011130)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('site_reportLogoA','images/mat_d3.jpg',1,1,20040629012801,20040520011130)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('site_loginLegalText','Unauthorized Access Prohibited',1,1,20040629012801,20040520011130)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('site_riskRankBottom','1',1,1,20040629012801,20040520011130)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('site_riskRankTop','5',1,1,20040629012801,20040520011130)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('site_bpuIndexStart','0',1,1,20040629012801,20040520011130)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('site_bpuIndexEnd','23',1,1,20040629012801,20040520011130)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('site_activeDataStore','1000',1,1,20040629012801,20040520011130)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('site_activeIndexStore','1000',1,1,20040629012801,20040520011130)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('site_dataSwitch','0',1,1,20040629012801,20040520011130)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('site_actionRunLimit','500',1,1,20040629012801,20040520011130)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('site_signatureUpdateEmail','',1,1,20040629012801,20040520011130)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('site_signatureUpdateEmailSubject','Signature Update Report',1,1,20040629012801,20040520011130)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('site_custom_snortGroup','0',1,1,20040629012801,20040520011130)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('site_hostnameRunLimit','100',1,1,20040629012801,20040520011130)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('site_corEngineLimitA','300',1,1,20040629012801,20040520011130)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('site_bpuSleepA','5',1,1,20040629012801,20040520011130)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('site_bpuSleepB','5',1,1,20040629012801,20040520011130)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('site_bpuSleepC','5',1,1,20040629012801,20040520011130)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('site_bpuSleepD','5',1,1,20040629012801,20040520011130)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('site_bpuSleepE','5',1,1,20040629012801,20040520011130)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('site_bpuIterationA','5',1,1,20040629012801,20040520011130)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('site_bpuIterationB','5',1,1,20040629012801,20040520011130)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('site_bpuIterationC','5',1,1,20040629012801,20040520011130)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('site_bpuIterationD','25',1,1,20040629012801,20040520011130)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('site_bpuIterationE','25',1,1,20040629012801,20040520011130)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('site_permDelete','1',1,1,20040629012801,20040520011130)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('indexDeletion','0',1,1,20040629012801,20040520011130)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('site_nmapBinaryLocation','/usr/bin/nmap',1,1,20040629012801,20040520011130)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('site_sigLastDownload','',1,1,20040629012801,20040520011130)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('site_iPhoneAccess','1',1,1,20040629012801,20040520011130)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('site_reportDisplayRows','25',1,1,20040629012801,20040520011130)");

    # idsSignatureSources
    insertTableData("idsSignatureSources", "INSERT INTO idsSignatureSources VALUES (1,'Emerging Threats - Latest (via Aanval)','http://signature01.aanval.com/?pkg=emerging.rules.tar.gz&omc=null','0','0',1)");

    insertTableData("idsSignatureSources", "INSERT INTO idsSignatureSources VALUES (2,'Snort Rules 2861 - Registered (via Aanval)','http://signature01.aanval.com/?pkg=snortrules-snapshot-2861.tar.gz&type=reg&omc=OMC','0','0',1)");
    insertTableData("idsSignatureSources", "INSERT INTO idsSignatureSources VALUES (3,'Snort Rules 2860 - Registered (via Aanval)','http://signature01.aanval.com/?pkg=snortrules-snapshot-2860.tar.gz&type=reg&omc=OMC','0','0',0)");
    insertTableData("idsSignatureSources", "INSERT INTO idsSignatureSources VALUES (4,'Snort Rules 2861 - Subscription (via Aanval)','http://signature01.aanval.com/?pkg=snortrules-snapshot-2861.tar.gz&type=sub&omc=OMC','0','0',0)");
    insertTableData("idsSignatureSources", "INSERT INTO idsSignatureSources VALUES (5,'Snort Rules 2860 - Subscription (via Aanval)','http://signature01.aanval.com/?pkg=snortrules-snapshot-2860.tar.gz&type=sub&omc=OMC','0','0',0)");

    insertTableData("idsSignatureSources", "INSERT INTO idsSignatureSources VALUES (6,'Snort Rules 2861 - Registered','http://www.snort.org/reg-rules/snortrules-snapshot-2861.tar.gz/OMC','0','0',0)");
    insertTableData("idsSignatureSources", "INSERT INTO idsSignatureSources VALUES (7,'Snort Rules 2860 - Registered','http://www.snort.org/reg-rules/snortrules-snapshot-2860.tar.gz/OMC','0','0',0)");
    insertTableData("idsSignatureSources", "INSERT INTO idsSignatureSources VALUES (8,'Snort Rules 2861 - Subscription','http://www.snort.org/sub-rules/snortrules-snapshot-2861.tar.gz/OMC','0','0',0)");
    insertTableData("idsSignatureSources", "INSERT INTO idsSignatureSources VALUES (9,'Snort Rules 2860 - Subscription','http://www.snort.org/sub-rules/snortrules-snapshot-2860.tar.gz/OMC','0','0',0)");

    insertTableData("idsSignatureSources", "INSERT INTO idsSignatureSources VALUES (10,'Local Rules File','/path/to/rules/file.tar.gz','0','0',0)");

	iuLog("Loading table data complete");

}

function createTable($table, $createQuery) {
	global $idsDB;

	if ($idsDB->query("SELECT * FROM $table LIMIT 1")) {
		
		iuLog("Table exists: $table (this is okay)");
		
	} else {

		if ($idsDB->query("$createQuery")) {
		
			iuLog("Table created: $table");

		} else {
		
			$xml = "\t\t<fail>$table</fail>\n";
			
			iuLog("Table creation failed: $table - " . mysql_error());
			
		}
	}
	
	return $xml;
}

function alterTable($table, $alterQuery) {
	global $idsDB;

    if ($idsDB->query("$alterQuery")) {

    } else {

		# If error contains "Duplicate" -- this is okay; it's for a duplicate column
	
		if (!stristr(mysql_error(), "duplicate")) {

			iuLog("Table alter failure: $table - " . mysql_error());

			$xml = "\t\t<fail>$table</fail>\n";
			
		}
		
    }

	return $xml;    
}

function insertTableData($table, $insertQuery) {
	global $idsDB;

	if ($idsDB->query("$insertQuery")) {

	} else {
	
		# If error contains "Duplicate" -- this is okay; it's for a duplicate key
	
		if (!stristr(mysql_error(), "duplicate")) {
	
			iuLog("Table insert failure: $table - " . mysql_error());
	
			$xml = "\t\t<fail>$table</fail>\n";
			
		}
		
	}

	return $xml;
}

function updateTableData($table, $updateQuery) {
	global $idsDB;

	if ($idsDB->query("$updateQuery")) {

	} else {
	
		# If error contains "Duplicate" -- this is okay; it's for a duplicate key
	
		if (!stristr(mysql_error(), "duplicate")) {
	
			iuLog("Table data update failure: $table - " . mysql_error());
	
			$xml = "\t\t<fail>$table</fail>\n";
			
		}
		
	}

	return $xml;
}

function writeConfigFile($dbname, $dbusername, $dbuserpass, $dbhost) {

	$out .= "<?php\n";
	$out .= "\n";
	$out .= "#\n";
	$out .= "# Aanval Intrusion Detection and Correlation Console\n";
	$out .= "# Primary Configuration File\n";
	$out .= "#\n";
	$out .= "# Copyright (c) 2010 - Tactical FLEX - All Rights Reserved\n";
	$out .= "#\n";
	$out .= "\$aanvaldb = \"$dbname\";\n";
	$out .= "\$aanvaldbuser = \"$dbusername\";\n";
	$out .= "\$aanvaldbpass = \"$dbuserpass\";\n";
	$out .= "\$aanvaldbhost = \"$dbhost\";\n";
	$out .= "\n";
	$out .= "?>\n";

	if ($fp = @fopen ("../../conf/conf.php", "w")) {
	
		fputs($fp, "$out");
		fclose($fp);

		iuLog("Configuration file creation successful");

		return 1;
		
	} else {

		iuLog("Configuration file creation failure!");
	
		return 0;
		
	}

}

function installSendmail($typeText) {

	$message = "Aanval 5 $typeText Confirmation. Aanval " . getVersionText() . "\n\nNetwork Address: " . $_SERVER['REMOTE_ADDR'] . "\n\n** This email is to confirm, and only confirm a successful installation or upgrade of Aanval 5. This email does not contain sensitive or critical information, and is an automated operation of the install and upgrade process.\n\nAanval - Intrusion Detection and Correlation Console\nhttp://www.aanval.com/\n";
	$headers .= "From: \"" . "Aanval Console v5" . "\" <" . "bin@aanval.com" . ">\r\n";
	
	if (function_exists("mail")) @mail("bin@aanval.com", "[$typeText] Aanval 5 | Success", $message, $headers);
    
}

function getVersionText() {

    $version = @file("../../version/version.txt");

    $major = rtrim($version[0]);
    $minor = rtrim($version[1]);
    $name = rtrim($version[2]);
    $build = rtrim($version[3]);

    $out = "$major.$minor ($name) BUILD: $build";

	iuLog("Aanval: $out");

    return $out;
}

?>