<?php

/** Copyright 2010 Tactical FLEX
 *
 * Aanval 5
 *
 * This program is owned and licensed by Tactical FLEX; it may be
 * redistributed only in its original configuration as originally
 * installed and available by Tactical FLEX and / or Aanval.
 *
 * To license and / or include this product in other forms or
 * applications, express prior written authorization must be
 * obtained by contract from authorized Tactical FLEX or Aanval agents.
 *
 * Tactical FLEX and Aanval may not be held liable nor responsible
 * for any and all issues arising from the use of, damages caused by, or 
 * conclusions drawn from the use of this product.
 *
 */

include "initialize.php";

function prv_licenseManagerList() {
	global $idsDB;

	$cnt = 0;

	$xml = "<document>\n";

	$q = $idsDB->query("SELECT id, license, intime FROM idsLicense where active = 1 order by id asc");
	while ($row = mysql_fetch_array($q, MYSQL_ASSOC)) {

		$cnt++;

		$xml .= "\t<node>\n";

		$xml .= "\t\t<type>" . upperCaseString($row["license"]) . "</type>\n";
		$xml .= "\t\t<status>" . upperCaseArray($row["license"]) . "</status>\n";

		$row["intime"] = date("m.d.Y H:i:s", consoleTimeConversion($row["intime"]));
					
		foreach ($row as $key => $val) {

			$xml .= "\t\t\t<$key><![CDATA[$val]]></$key>\n";
						
		}

		$xml .= "\t</node>\n";
		
	}

	$xml .= "\t<total>$cnt</total>\n";
	
	$xml .= "</document>\n";

	return $xml;	
}

function prv_licenseManagerInsert() {
	global $idsDB;

	$license = sanitize("license");

	// Prep
	$license = str_replace("\r", "\n", $license);

	if (strstr($license, ",")) {

		$tmpArray = explode(",", $license);
		foreach ($tmpArray as $lic) {
			$licArray[] = trim($lic);
		}

	} else if (strstr($license, "\n")) {

		$tmpArray = explode("\n", $license);
		foreach ($tmpArray as $lic) {
			
			$licArray[] = trim($lic);
		}

	} else if (strstr($license, "\t")) {

		$tmpArray = explode("\t", $license);
		foreach ($tmpArray as $lic) {
			$licArray[] = trim($lic);
		}
	
	} else if (strstr($license, " ")) {

		$tmpArray = explode(" ", $license);
		foreach ($tmpArray as $lic) {
			$licArray[] = trim($lic);
		}
	
	} else {
	
		$licArray[] = trim($license);
	
	}

	$xml = "<document>\n";
	$xml .= "\t<node>\n";

	foreach ($licArray as $lic) {

		$q = $idsDB->query("SELECT id, license, intime FROM idsLicense where license like '" . substr($lic, 0, -16) . "%'");
		while ($row = mysql_fetch_array($q, MYSQL_ASSOC)) {
			$found = 1;
		}
	
		if ($found) {
		
			$xml .= "\t\t<found>1</found>\n";
		
		} else {
		
			$idsDB->query("insert into idsLicense (license, active, intime) values ('" . $lic . "', '1', '" . time() . "')");
			
		}
		
		unset($found);
	}
	
	$xml .= "\t\t<success>1</success>\n";

	$xml .= "\t</node>\n";
	$xml .= "</document>\n";
	
	return $xml;
}

function prv_licenseManagerDelete() {
	global $idsDB;

	$id = sanitize("id");
	if (!$id) return;

	$idsDB->query("delete from idsLicense where id = '$id'");
	
	$xml = "<success>1</success>\n";

	return $xml;
}

function prv_registrationRequest() {

	$xml = "<document>\n";
	$xml .= "\t<node>\n";

	$xml .= "\t\t<registration>" . ops("site_registration") . "</registration>\n";
	
	$xml .= "\t</node>\n";
	
	$xml .= "</document>\n";

	return $xml;	

}

function prv_registrationUpdate() {
	
	ops("site_registration", sanitize("registration"));
	
	$xml = "<document>\n";
	$xml .= "\t<success>1</success>\n";
	$xml .= "</document>\n";

	return $xml;

}

?>