<?php

/** Copyright 2009 Tactical FLEX
 *
 * Aanval 5
 *
 * This program is owned and licensed by Tactical FLEX; it may be
 * redistributed only in its original configuration as originally
 * installed and available by Tactical FLEX and / or Aanval.
 *
 * To license and / or include this product in other forms or
 * applications, express prior written authorization must be
 * obtained by contract from authorized Tactical FLEX or Aanval agents.
 *
 * Tactical FLEX and Aanval may not be held liable nor responsible
 * for any and all issues arising from the use of, damages caused by, or 
 * conclusions drawn from the use of this product.
 *
 */

include "initialize.php";

function prv_bpuStatusGraph() {

	$xml = "<document>\n";

	$array = array("e", "d", "c", "b", "a");

	foreach ($array as $bpu) {
	
		$tmp = file("../../logs/bpu" . strtoupper($bpu) . ".sts");
		$data1 = explode(",", trim($tmp[0]));
		$data2 = explode(",", trim($tmp[1]));
		
		$diff = $data1[1] - $data1[0];
		if (!$diff || $diff < 0) $diff = 0;

		$last = $data2[1] - $data2[0];
		if (!$last || $last < 0) $last = 0;

		$xml .= "\t<node>\n";
	
		if ($bpu == "a") $name = "Import - BPU A";
		if ($bpu == "b") $name = "Core - BPU B";
		if ($bpu == "c") $name = "Index - BPU C";
		if ($bpu == "d") $name = "Search - BPU D";
		if ($bpu == "e") $name = "Report - BPU E";
	
		$xml .= "\t\t<bpu>$bpu</bpu>\n";
		$xml .= "\t\t<name>$name</name>\n";
		$xml .= "\t\t<diff>$diff</diff>\n";
		$xml .= "\t\t<last>$last</last>\n";
		$xml .= "\t\t<start>" . $data1[0] . "</start>\n";
		$xml .= "\t\t<end>" . $data1[1] . "</end>\n";
		$xml .= "\t\t<longstart>" . date("r", consoleTimeConversion($data1[0])) . "</longstart>\n";
		$xml .= "\t\t<longend>" . date("r", consoleTimeConversion($data1[1])) . "</longend>\n";

		$xml .= "\t</node>\n";
	
	}
	
	$xml .= "</document>\n";

	return $xml;	
}


?>

