<?php

/** Copyright 2010 Tactical FLEX
 *
 * Aanval 5
 *
 * This program is owned and licensed by Tactical FLEX; it may be
 * redistributed only in its original configuration as originally
 * installed and available by Tactical FLEX and / or Aanval.
 *
 * To license and / or include this product in other forms or
 * applications, express prior written authorization must be
 * obtained by contract from authorized Tactical FLEX or Aanval agents.
 *
 * Tactical FLEX and Aanval may not be held liable nor responsible
 * for any and all issues arising from the use of, damages caused by, or 
 * conclusions drawn from the use of this product.
 *
 */

include "initialize.php";

function prv_noteManagerList() {
	global $idsDB;

	$cnt = 0;

	$xml = "<document>\n";

	$q = $idsDB->query("SELECT id, userid, trackid, collectionid, note, read_access, write_access, timestamp FROM idsNotes where enabled = 1 and storeid = '" . login("activeSearchStore") . "' and (userid = '" . login("id") . "' or read_access = 1) order by id asc");
	while ($row = mysql_fetch_array($q, MYSQL_ASSOC)) {

		// Create and prepare short note
		$row["shortnote"] = substr(strip_tags($row["note"]), 0, 45) . "...";
		
		// Create permissions text string
		if ($row["read_access"] == 1) $permissions[] = "Read";
		if ($row["write_access"] == 1) $permissions[] = "Write";
		if ($row["read_access"] == 0 && $row["write_access"] == 0) {
			$row["private_access"] = 1;
			$permissions[] = "Private";
		}
		$row["permissions"] = implode(" and ", $permissions);
	
		// User id to name conversion
		$q2 = $idsDB->query("SELECT username FROM idsUsers where id = " . $row["userid"]);
		while ($row2 = mysql_fetch_array($q2, MYSQL_ASSOC)) {
			$row["username"] = $row2["username"];
		}
	
		// Set read only access trigger
		if (login("id") != $row["userid"]) {
			if ($row["write_access"] != 1) {
				$row["nowrite"] = 1;
			}
		}

		$row["timestamp"] = date("m.d.Y H:i:s", consoleTimeConversion($row["timestamp"]));

		// Generate XML
		$xml .= "\t<node>\n";

		foreach ($row as $key => $val) {

			$xml .= "\t\t<$key><![CDATA[$val]]></$key>\n";

		}

		$xml .= "\t</node>\n";

		// Total counter		
		$cnt++;
		
		// Cleanup
		unset($permissions);
	}

	$xml .= "\t<total>$cnt</total>\n";
	$xml .= "</document>\n";

	return $xml;	
}

function prv_noteManagerUpdate() {
	global $idsDB;

	$id = sanitize("id");
	if (!$id) return;

	$note = addslashes(getVar("note"));

	$trackid = sanitize("trackid");

	$read = sanitize("read");
	$write = sanitize("write");

	if ($write == 1) {
		$read = 1;
	}

	$idsQueryA = $idsDB->query("update idsNotes set note = '$note', trackid = '$trackid', read_access = '$read', write_access = '$write', timestamp = '" . time() . "' where id = '$id' and (userid = '" . login("id") . "' or write_access = 1)");
	
	$xml = "<success>1</success>\n";

	return $xml;
}

function prv_noteManagerDelete() {
	global $idsDB;

	$id = sanitize("id");
	if (!$id) return;

	$idsDB->query("delete from idsNotes where userid = '" . login("id") . "' and id = '$id'");
	
	$xml = "<success>1</success>\n";

	return $xml;
}

function prv_noteCreate() {
	global $idsDB;

	$trackid = sanitize("trackid");

	$note = addslashes(getVar("note"));
	if (!$note || strlen($note) < 1) return;

	$storeid = sanitize("store");
	if (!$storeid || $storeid == 0) $storeid = login("activeSearchStore");

	$read = sanitize("read");
	$write = sanitize("write");

	if ($write == 1) {
		$read = 1;
	}

	$idsQueryA = $idsDB->query("insert into idsNotes (storeid, trackid, note, timestamp, enabled, userid, read_access, write_access) values ('$storeid', '$trackid', '$note', '" . time() . "', '1', '" . login("id") . "', '$read', '$write')");
	
	$xml = "<success>1</success>\n";

	return $xml;
}

?>

