<?php

/** Copyright 2009 Tactical FLEX
 *
 * Aanval 5
 *
 * This program is owned and licensed by Tactical FLEX; it may be
 * redistributed only in its original configuration as originally
 * installed and available by Tactical FLEX and / or Aanval.
 *
 * To license and / or include this product in other forms or
 * applications, express prior written authorization must be
 * obtained by contract from authorized Tactical FLEX or Aanval agents.
 *
 * Tactical FLEX and Aanval may not be held liable nor responsible
 * for any and all issues arising from the use of, damages caused by, or 
 * conclusions drawn from the use of this product.
 *
 */

include "initialize.php";

function prv_reportList() {
	global $idsDB;

	$cnt = 0;

	$xml = "<document>\n";

	$q = $idsDB->query("SELECT id, name, type, status, query, store, mon, tue, wed, thu, fri, sat, sun, runtime, runlast, enabled, intime, email, viewed FROM idsReportSchedule where enabled = 1 and userid = '" . login("id") . "' order by id desc");
	while ($row = mysql_fetch_array($q, MYSQL_ASSOC)) {

		$cnt++;

		$xml .= "\t<node>\n";

		$row["intime"] = date("m.d.Y H:i:s", consoleTimeConversion($row["intime"]));
		if ($row["runlast"] > 0) { $row["runlast"] = date("m.d.Y H:i:s", consoleTimeConversion($row["runlast"])); } else { $row["runlast"] = "Not yet processed"; }

		if ($row["viewed"] == 0) {
        	$row["viewedtext"] = "No";
        } else if ($row["viewed"] >= 1) {
        	$row["viewedtext"] = "Yes";
		}

		if ($row["status"] == 0) {
        	$row["statustext"] = "Queued";
        } else if ($row["status"] == 1) {
        	$row["statustext"] = "Processing";
        } else if ($row["status"] == 2) {
        	$row["statustext"] = "Complete";
        }

		if ($row["type"] == 2) {
			
			if ($row["mon"] == 1) $row["scheduletext"] .= "mon ";
			if ($row["tue"] == 1) $row["scheduletext"] .= "tue ";
			if ($row["wed"] == 1) $row["scheduletext"] .= "wed ";
			if ($row["thu"] == 1) $row["scheduletext"] .= "thu ";
			if ($row["fri"] == 1) $row["scheduletext"] .= "fri ";
			if ($row["sat"] == 1) $row["scheduletext"] .= "sat ";
			if ($row["sun"] == 1) $row["scheduletext"] .= "sun ";
			
			$row["scheduletext"] = trim($row["scheduletext"]) . " @ " . $row["runtime"];
			
		} else {
		
			$row["scheduletext"] = "None";
		}

		foreach ($row as $key => $val) {

			$xml .= "\t\t<$key>$val</$key>\n";

		}
		
		$xml .= "\t</node>\n";
		
	}

	$xml .= "\t<total>$cnt</total>\n";
	$xml .= "</document>\n";

	return $xml;	
}

function prv_reportProcess() {
	global $idsDB;

	$id = sanitize("id");
	if (!$id) return;
	
	$format = sanitize("format");
	if (!$format) $format = 1;

	// Update Viewed Value
	$idsDB->query("update idsReportSchedule set viewed = (viewed + 1) where userid = '" . login("id") . "' and id = '$id'");

	$q = $idsDB->query("SELECT id, data, name, type, status, query, store, mon, tue, wed, thu, fri, sat, sun, runtime, runlast, enabled, intime, email FROM idsReportSchedule where enabled = 1 and userid = '" . login("id") . "' and id = '$id'");
	while ($row = mysql_fetch_array($q, MYSQL_ASSOC)) {

		$id = $row["id"];
		$data = $row["data"];
		$viewed = $row["viewed"];
		
	}
	
	if ($format == 1) {

		// Return XML
		
		return $data;

	} else if ($format == 2) {
	
		// Return HTML

		return processReportXMLToHTML($data);
		
	} else if ($format == 3) {
	
		// Return PDF
	
		if (extension_loaded("gd")) {
	
			$data = processReportXMLToPDF($data);
		
			$data->output();
			
		} else {
		
			dblog("PDF Report Display", "Report not displayed, GD not installed");
		
		}
		
	} else if ($format == 4) {
	
		// Return Text

		return processReportXMLToText($data);
		
	} else {
	
		// Return XML (catch all)
	
		return $data;
	
	}
}

function prv_submitReport() {
	global $idsDB;

	$query = getVar("query");
	if (!$query) return;

	$query = trim(str_replace("report:", "", $query));
	$queryArray = explode(";", $query);

	$runtime = sanitize("runtime");
	if (!$runtime) $runtime = "00:00";

	$type = sanitize("type");
	if (!$type) $type = "1";

	$name = sanitize("name");
	$store = sanitize("store");
	$email = sanitize("email");

	// Defaults
	$mon = 0;	$tue = 0;	$wed = 0;	$thu = 0;	$fri = 0;	$sat = 0;	$sun = 0;

	if (sanitize("mon") == "true") {
		$type = 2;
		$mon = 1;
	}
	if (sanitize("tue") == "true") {
		$type = 2;
		$tue = 1;
	}
	if (sanitize("wed") == "true") {
		$type = 2;
		$wed = 1;
	}
	if (sanitize("thu") == "true") {
		$type = 2;
		$thu = 1;
	}
	if (sanitize("fri") == "true") {
		$type = 2;
		$fri = 1;
	}
	if (sanitize("sat") == "true") {
		$type = 2;
		$sat = 1;
	}
	if (sanitize("sun") == "true") {
		$type = 2;
		$sun = 1;
	}

	foreach ($queryArray as $q) {

		if (!$name) $name = $q;

		if (!$store) {
		
			// Store Check
			if (strstr($q, "store:")) {
	
				preg_match("/(?<=store\:)[0-9]+/", $q, $match);
				$store = $match[0];
				
			} else {
			
				$store = login("activeSearchStore");
				
			}
		
		} 	
	
		$idsDB->query("insert into idsReportSchedule (name, userid, email, query, store, type, status, viewed, mon, tue, wed, thu, fri, sat, sun, runtime, runlast, enabled, intime) 
	    	values (
	    		'$name',
	    		'" . login("id") . "',
	    		'$email',
	    		'$q',
	    		'$store',
	    		'$type',
	    		'0',
	    		'0',
	    		'$mon',
	    		'$tue',
	    		'$wed',
	    		'$thu',
	    		'$fri',
	    		'$sat',
	    		'$sun',
	    		'$runtime',
	    		'0',
	    		'1',
	    		'" . time() . "'    			
	    	)");

		unset($name);
	    	
	}
	
//	if (!$email) $email = login("email");
	
	$xml = "<success>1</success>\n";

	return $xml;

}

function prv_forceReportDelete() {
	global $idsDB;

	$id = sanitize("id");
	if (!$id) return;

	$idsDB->query("DELETE FROM idsReportSchedule WHERE userid = '" . login("id") . "' AND id IN ($id)");
	
	$xml = "<success>1</success>\n";

	return $xml;
}

function prv_reportRename() {
	global $idsDB;

	$id = sanitize("id");
	if (!$id) return;

	$name = sanitize("name");
	if (!$name) return;

	$idsDB->query("UPDATE idsReportSchedule SET name = '$name' WHERE userid = '" . login("id") . "' AND id = '$id'");
	
	$xml = "<success>1</success>\n";

	return $xml;
}


function prv_emailReport() {
	global $idsDB;

	$id = sanitize("id");
	if (!$id) return;

	$type = sanitize("type");
	if (!$type) $type = 0;

	$email = sanitize("email");
	if (!$email) return;

	$subject = sanitize("subject");

    $idsQueryA = $idsDB->query("select data, name from idsReportSchedule where id = '$id' and userid = '" . login("id") . "'");
    while (list($data, $name) = mysql_fetch_row($idsQueryA)) {

		if (!$subject) $subject = "Report: $name";

        $fromEmail = login("email");
        $toEmail = $email;

		if ($type == 1) {

	    	emailPDFReport($data, $fromEmail, $toEmail, $subject);
	    	
	    } else {

	    	emailTextReport($data, $fromEmail, $toEmail, $subject);
	    
	    }
    	
    }

	$xml = "<success>1</success>\n";

	return $xml;
}

?>

