<?php

/** Copyright 2009 Tactical FLEX
 *
 * Aanval 5
 *
 * This program is owned and licensed by Tactical FLEX; it may be
 * redistributed only in its original configuration as originally
 * installed and available by Tactical FLEX and / or Aanval.
 *
 * To license and / or include this product in other forms or
 * applications, express prior written authorization must be
 * obtained by contract from authorized Tactical FLEX or Aanval agents.
 *
 * Tactical FLEX and Aanval may not be held liable nor responsible
 * for any and all issues arising from the use of, damages caused by, or 
 * conclusions drawn from the use of this product.
 *
 */

include "initialize.php";

function prv_scheduleList() {
	global $idsDB;

	$cnt = 0;

	$xml = "<document>\n";

    $q = $idsDB->query("select id, name, host, runonce, status, options, mon, tue, wed, thu, fri, sat, sun, runtime, runlast from idsScannerSchedule where userid = '" . login("id") . "' and enabled = 1 and type = 1");
	while ($row = mysql_fetch_array($q, MYSQL_ASSOC)) {

		$cnt++;

		$xml .= "\t<node>\n";

		if ($row["runlast"]) { $row["runlast"] = date("m.d.Y h:i:s", consoleTimeConversion($row["runlast"])); } else { $row["runlast"] = "null"; };

        if ($row["runonce"] == 0) {
        	$row["runtext"] = "Recurring";
		} else {
        	$row["runtext"] = "Single";
		}

        if ($row["status"] == 0) {
        	$row["statustext"] = "Queued";
        } else if ($row["status"] == 1) {
        	$row["statustext"] = "Processing";
        } else if ($row["status"] == 2) {
        	$row["statustext"] = "Success";
        } else if ($row["status"] == 3) {
        	$row["statustext"] = "Error";
        } else if ($row["status"] == 5) {
        	$row["statustext"] = "Success";
        }

		if ($row["mon"]) $dayArray[] = "Mon";
		if ($row["tue"]) $dayArray[] = "Tue";
		if ($row["wed"]) $dayArray[] = "Wed";
		if ($row["thu"]) $dayArray[] = "Thu";
		if ($row["fri"]) $dayArray[] = "Fri";
		if ($row["sat"]) $dayArray[] = "Sat";
		if ($row["sun"]) $dayArray[] = "Sun";

		$row["scheduletext"] = implode(" ", $dayArray) . " @ " . $row["runtime"];
		unset($dayArray);

		foreach ($row as $key => $val) {

			$xml .= "\t\t<$key>$val</$key>\n";
			
		}

		$xml .= "\t</node>\n";
		
	}

	$xml .= "\t<total>$cnt</total>\n";

	$xml .= "</document>\n";

	return $xml;	
}

function prv_resultsList() {
	global $idsDB;

	$cnt = 0;

	$xml = "<document>\n";

    $q = $idsDB->query("select res.scanid, sch.id, sch.name, sch.host, sch.runonce, sch.status, sch.options, sch.mon, sch.tue, sch.wed, sch.thu, sch.fri, sch.sat, sch.sun, sch.runtime, sch.runlast from idsScannerResults as res LEFT JOIN idsScannerSchedule as sch ON res.scanid = sch.id where sch.type = 1");
	while ($row = mysql_fetch_array($q, MYSQL_ASSOC)) {

		$cnt++;

		$xml .= "\t<node>\n";

		if ($row["intime"]) $row["intime"] = date("m.d.Y h:i:s", consoleTimeConversion($row["intime"]));
		if ($row["runlast"]) $row["runlast"] = date("m.d.Y h:i:s", consoleTimeConversion($row["runlast"]));

        if ($row["runonce"] == 0) {
        	$row["runtext"] = "Recurring";
		} else {
        	$row["runtext"] = "Single";
		}

        if ($row["status"] == 0) {
        	$row["statustext"] = "Queued";
        } else if ($row["status"] == 1) {
        	$row["statustext"] = "Processing";
        } else if ($row["status"] == 2) {
        	$row["statustext"] = "Success";
        } else if ($row["status"] == 3) {
        	$row["statustext"] = "Error";
        } else if ($row["status"] == 5) {
        	$row["statustext"] = "Success";
        }

		if ($row["mon"]) $dayArray[] = "Mon";
		if ($row["tue"]) $dayArray[] = "Tue";
		if ($row["wed"]) $dayArray[] = "Wed";
		if ($row["thu"]) $dayArray[] = "Thu";
		if ($row["fri"]) $dayArray[] = "Fri";
		if ($row["sat"]) $dayArray[] = "Sat";
		if ($row["sun"]) $dayArray[] = "Sun";

		$row["scheduletext"] = implode(" ", $dayArray) . " @ " . $row["runtime"];
		unset($dayArray);

		foreach ($row as $key => $val) {

			$xml .= "\t\t<$key>$val</$key>\n";
			
		}

		$xml .= "\t</node>\n";
		
	}

	$xml .= "\t<total>$cnt</total>\n";

	$xml .= "</document>\n";

	return $xml;	
	
}

function prv_scanResultData() {
	global $idsDB;

	$id = sanitize("id");
	if (!$id) return;
	
	$xml = "<document>\n";

    $q = $idsDB->query("select id, data from idsScannerResults where scanid = '$id'");
	while ($row = mysql_fetch_array($q, MYSQL_ASSOC)) {

		$tmpArray = explode("\n", $row["data"]);
		unset($tmpArray[0], $tmpArray[1], $tmpArray[2]);
		
		$xml .= implode("\n", $tmpArray);

	}

	$xml .= "</document>\n";

	return $xml;	

}

function prv_scanResultDataAsText() {
	global $idsDB;

	$id = sanitize("id");
	if (!$id) return;
	
	$xml = "<document>\n";

    $q = $idsDB->query("select id, data from idsScannerResults where scanid = '$id'");
	while ($row = mysql_fetch_array($q, MYSQL_ASSOC)) {

		$tmpArray = explode("\n", $row["data"]);
		unset($tmpArray[0], $tmpArray[1], $tmpArray[2]);
		
		$nmapXML = implode("\n", $tmpArray);

	}

	$out = getScanResultsAsText($nmapXML);

	$xml .= "\t<data>" . $out . "</data>\n";

	$xml .= "</document>\n";

	return $xml;	

}

function getScanResultsAsText($nmapXML) {

	$data = new SimpleXMLElement($nmapXML);
	
	$out = "Nmap scan completed: " . $data->runstats->finished['timestr'] . "\n";
	$out .= "Elapsed time: " . $data->runstats->finished['elapsed'] . "\n\n";
	
	$out .= "Hosts Up: " . $data->runstats->hosts['up'] . "\n";
	$out .= "Hosts Down: " . $data->runstats->hosts['down'] . "\n";
	$out .= "Hosts Total: " . $data->runstats->hosts['total'] . "\n\n";

	foreach ($data->host as $host) {
	
		$out .= "Host: " . $host->address['addr'] . "\n";
		if ($host->hostnames->hostname['name']) $out .= "Hostname: " . $host->hostnames->hostname['name'] . "\n";
		$out .= "\n";
		
		foreach ($host->ports->port as $port) {
		
			$out .= $port['protocol'] . " " . $port['portid'] . " " . $port->service['name'] . "\n";
		
		}
		
		$out .= "\n";
		
		if ($host->os) {

			$out .= "Operating System: " . $host->os->osmatch['name'] . "\n";
			$out .= "Accuracy: " . $host->os->osmatch['accuracy'] . "%\n\n";
			
			$out .= "OS Family: " . $host->os->osclass['osfamily'] . "\n";
			$out .= "OS Vendor: " . $host->os->osclass['vendor'] . "\n";
			$out .= "OS Type: " . $host->os->osclass['type'] . "\n";
			$out .= "OS Gen: " . $host->os->osclass['osgen'] . "\n";
			$out .= "Accuracy: " . $host->os->osclass['accuracy'] . "%\n";
		
			$out .= "\n";
		}
		
		$out .= "---\n";
		$out .= "\n";
		
	}
	
	return $out;

}

function prv_addNmapScanSchedule() {

	$name = sanitize("name");
	$host = sanitize("host");
	$runtime = sanitize("runtime");
	$email = sanitize("email");
	$type = sanitize("type");

	// Types
	$scanType = "-" . sanitize("scantype");
	$icmpType = "-" . sanitize("icmptype");
	$dnsType = "-" . sanitize("dnstype");
	$portList = "-p " . sanitize("portlist");
	
	// Run once
	if (sanitize("runonce") == "true") $runonce = 1;
	
	// OS
	if (sanitize("ostype") != "") $osType = "-" . sanitize("ostype");

	// Custom ports
	if (strstr($portList, "custom")) $portList = "-p " . sanitize("customportlist");

	// Spoof
	if (sanitize("spooftype") == "custom") $spoofType = "-S " . sanitize("customspoof") . " -e " . sanitize("custominterface");
	
	// ICMP Check (Proto, Ping and List scans cannot be combined with other types)
	if (sanitize("icmptype") == "sL" || sanitize("icmptype") == "sP") {
		unset($scanType, $dnsType, $osType, $portList, $spoofType);
	}
	
	// Schedule
	if (sanitize("mon") == "true") { $mon = 1; $dayGood = 1; }
	if (sanitize("tue") == "true") { $tue = 1; $dayGood = 1; }
	if (sanitize("wed") == "true") { $wed = 1; $dayGood = 1; }
	if (sanitize("thu") == "true") { $thu = 1; $dayGood = 1; }
	if (sanitize("fri") == "true") { $fri = 1; $dayGood = 1; }
	if (sanitize("sat") == "true") { $sat = 1; $dayGood = 1; }
	if (sanitize("sun") == "true") { $sun = 1; $dayGood = 1; }

	if (!$email) $email = login("email");
	if (!$name) $name = $host;
	if (!$type) $type = 1;
	if (!$runtime) $runtime = "00:00";
	
	if (!$host) $fail = 1;
	if (!$runtime) $fail = 1;
	
	$options = "$scanType $icmpType $dnsType $osType $spoofType $portList";

	if (!$dayGood) {
	
		$tmp = strtolower(date("D"));
		$$tmp = 1;
	
	}
	
	if (!$fail) {
		
		$scanner = new vulnScanner();
		$scanner->scanAdd($type, $runonce, $name, $host, $options, $email, $runtime, $mon, $tue, $wed, $thu, $fri, $sat, $sun);
	
		$xml = "<success>1</success>\n";
		
	} else {
	
		// Fail
	
		$xml = "<success>0</success>\n";
	
	}

	return $xml;
}

function prv_getScanOptions() {

	$xml = "<document>\n";
		$xml .= "\t<node>\n";

			$xml .= "\t\t<binary>" . ops("site_nmapBinaryLocation") . "</binary>\n";

		$xml .= "\t</node>\n";
	$xml .= "</document>\n";

	return $xml;
}

function prv_updateScanOptions() {

	$binary = sanitize("binary");
	if (!$binary) return;

	ops("site_nmapBinaryLocation", $binary);

	$xml = "<success>1</success>\n";

	return $xml;
}

function prv_deleteScan() {
	global $idsDB;

	$id = sanitize("id");
	if (!$id) return;

    $q = $idsDB->query("update idsScannerSchedule set enabled = '0' where id = '$id'");

	$xml = "<success>1</success>\n";

	return $xml;
}

function prv_deleteResult() {
	global $idsDB;

	$id = sanitize("id");
	if (!$id) return;

    $q = $idsDB->query("delete from idsScannerResults where scanid = '$id'");

	$xml = "<success>1</success>\n";

	return $xml;
}

function prv_sendScanEmail() {
	global $idsDB;

	$id = sanitize("id");
	if (!$id) return;

	$email = sanitize("email");
	if (!$email) login("email");

	$xml = "<document>\n";

    $q = $idsDB->query("select res.data, sch.name from idsScannerResults as res LEFT JOIN idsScannerSchedule as sch ON res.scanid = sch.id where res.scanid = '$id'");
	while ($row = mysql_fetch_array($q, MYSQL_ASSOC)) {

		$scanName = $row["name"];

		$tmpArray = explode("\n", $row["data"]);
		unset($tmpArray[0], $tmpArray[1], $tmpArray[2]);
		
		$nmapXML = implode("\n", $tmpArray);

	}

	$data = getScanResultsAsText($nmapXML);

	emailScanResults($data, login("email"), $email, "Scan Results [$scanName]");

	$xml = "<success>1</success>\n";

	return $xml;

}

?>