<?php

/** Copyright 2010 Tactical FLEX
 *
 * Aanval 5
 *
 * This program is owned and licensed by Tactical FLEX; it may be
 * redistributed only in its original configuration as originally
 * installed and available by Tactical FLEX and / or Aanval.
 *
 * To license and / or include this product in other forms or
 * applications, express prior written authorization must be
 * obtained by contract from authorized Tactical FLEX or Aanval agents.
 *
 * Tactical FLEX and Aanval may not be held liable nor responsible
 * for any and all issues arising from the use of, damages caused by, or 
 * conclusions drawn from the use of this product.
 *
 */

include "initialize.php";

function prv_searchSubmit() {
	global $idsDB;

	$query = getVar("query");
	if (!$query) return;

	$store = sanitize("store");
	if (!$store) {
	
		// Store Check
		if (strstr($query, "store:")) {

			preg_match("/(?<=store\:)[0-9]+/", $query, $match);
			$store = $match[0];
			
		} else {
		
			$store = login("activeSearchStore");
			
		}
	
	} 

	$transaction = time() . rand(100,999);

	$xml = "<document>\n";

	if (stristr($query, "delete:")) {
	
		$searchObj = new coreSearch();
		$searchObj->setVar("store", $store);
		$searchObj->setVar("query", $query);
	
		$searchObj->searchProcess();

		$xml .= "\t<deletion>1</deletion>\n";
	
	} else {
	
		if ($fp = @fopen("../../tmp/search/search-" . login("id") . "-" . $transaction . ".dat", "w")) {
		
			fwrite($fp, "$transaction\n" . login("id") . "\n$store\n$query");
			fclose($fp);
			
		} else {
		
			errorLog("File: '../../tmp/search/search-" . login("id") . "-$transaction.dat' could not be opened for writing");
		
		}

	}

	// Save in Search History
	$idsDB->query("insert into idsQueries (query, uid, intime) values ('" . sanitize("query") . "', '" . login("id") . "', '" . time() . "')");

	$xml .= "\t<transaction>$transaction</transaction>\n";

	$xml .= "</document>";

	return $xml;
}

function prv_searchPoll() {

	$transaction = sanitize("transaction");
	if (!$transaction) return;

	if (file_exists("../../tmp/search/search-" . login("id") . "-" . $transaction . ".events")) {

		$xml = returnEventXML($transaction);
		
//		@unlink("../../tmp/search/search-" . login("id") . "-" . $transaction . ".results");
	
	}

	return $xml;
}

function prv_searchPageSystem() {

	$transaction = sanitize("transaction");
	if (!$transaction) return;

	$page = sanitize("page");
	if (!$page) unset($page);
	
	if (sanitize("format") == 4) {

		$out = returnEventText($transaction, $page);
	
	} else {
	
		$out = returnEventXML($transaction, $page);
		
	}
	
	return $out;
}

function returnEventXML($transaction, $page) {

	$number = 100;

	if (!$page || $page == "") $page = 1;
	$page--;

	if ($page == 0) {
		$start = 0;
	} else {
		$start = $page * $number;
	}

	$totalInSet = 0;
	$totalIgnores = 0;
	$numCount = 0;

	$data = file("../../tmp/search/search-" . login("id") . "-" . $transaction . ".events");
	
	$store = trim($data[2]);
	
	$totalResults = trim($data[4]);

	$searchObj = new coreSearch();
	
	// Shift items off of array
	$data = array_slice($data, 6);

	$xml = "<document>\n";
	$xml .= "\t<resultsready>1</resultsready>\n";

	$xml .= "\t<store>" . $store . "</store>\n";

	for ($i=$start;$i<count($data);$i++) {

		$totalInSet++;
		$numCount++;

		$eventData = $searchObj->getDetailsByID(trim($data[$i]));

		if (!$eventData["sport"]) $eventData["sport"] = "-";
		if (!$eventData["dport"]) $eventData["dport"] = "-";

		if (strlen($eventData["signatureName"]) > 30) {
			$sigShortName = substr($eventData["signatureName"], 0, 30) . "...";
		} else {
			$sigShortName = $eventData["signatureName"];
		}
		
		$eventAge = time() - sensorTimeConversion($eventData["sensorID"], $eventData["timestamp"]);
		if ($eventAge < 0) $eventAge = 0;

		$xml .= "\t<node>\n";
		
		$xml .= "\t\t<id>" . $eventData["id"] . "</id>\n";
		$xml .= "\t\t<store>" . $store . "</store>\n";
		$xml .= "\t\t<module>" . $eventData["moduleID"] . "</module>\n";
		$xml .= "\t\t<risk>" . $eventData["priority"] . "</risk>\n";
		$xml .= "\t\t<datetime>" . date("m.d.Y H:i:s", sensorTimeConversion($eventData["sensorID"], $eventData["timestamp"])) . "</datetime>\n";
		$xml .= "\t\t<age>" . $eventAge . "</age>\n";
		$xml .= "\t\t<sensorid>" . $eventData["sensorID"] . "</sensorid>\n";
		$xml .= "\t\t<sensorname>" . getSensorNameByID($eventData["sensorID"]) . "</sensorname>\n";
		$xml .= "\t\t<sip>" . longToIP($eventData["sip"]) . "</sip>\n";
		$xml .= "\t\t<dip>" . longToIP($eventData["dip"]) . "</dip>\n";
		$xml .= "\t\t<sport>" . $eventData["sport"] . "</sport>\n";
		$xml .= "\t\t<dport>" . $eventData["dport"] . "</dport>\n";
		$xml .= "\t\t<signame><![CDATA[" .  $eventData["signatureName"] . "]]></signame>\n";
		$xml .= "\t\t<sigid><![CDATA[" . $eventData["signature"] . "]]></sigid>\n";
		$xml .= "\t\t<sigshortname><![CDATA[" .  $sigShortName . "]]></sigshortname>\n";
		$xml .= "\t\t<sigclassname><![CDATA[" . $eventData["className"] . "]]></sigclassname>\n";
		$xml .= "\t\t<sigclassid>" . $eventData["class"] . "</sigclassid>\n";
		$xml .= "\t\t<protocol>" . $eventData["protocol"] . "</protocol>\n";
		$xml .= "\t\t<protocolname><![CDATA[" . protoToName($eventData["protocol"]) . "]]></protocolname>\n";

		if ($eventData["moduleID"] == "1") {

			$xml .= "\t\t<payload><![CDATA[" . PrintAsciiOnly($eventData["payload"], 1) . "]]></payload>\n";
		
		} else {

			$xml .= "\t\t<payload><![CDATA[" . $eventData["payload"] . "]]></payload>\n";
		
		}

		$xml .= "\t</node>\n";
	
		if ($numCount >= $number) break;
	
	}

	if ($totalInSet > $totalResults) $totalResults = $totalInSet;

	if ($totalResults > $number) {
		$totalPages = $totalResults / $number;
		if (strstr($totalPages, ".")) {
			$tmp = explode(".", $totalPages);
			$totalPages = $tmp[0] + 1;
		}
	} else {
		$totalPages = 1;
	}

	// Adjust page for correct display (We alter page for correct 0 starting)
	$page++;

	for ($i=0;$i<$totalPages;$i++) {

		$xml .= "\t<pageNode>\n";
		$xml .= "\t\t<page>" . ($i + 1) . "</page>\n";
		$xml .= "\t</pageNode>\n";
	
	}

	$xml .= "\t<page>$page</page>\n";
	$xml .= "\t<totalignores>$totalIgnores</totalignores>\n";
	$xml .= "\t<totalpages>$totalPages</totalpages>\n";
	$xml .= "\t<totalinset>$totalInSet</totalinset>\n";
	$xml .= "\t<totalresults>$totalResults</totalresults>\n";
	$xml .= "</document>\n";
	
	return $xml;
}

function returnEventText($transaction, $page) {

	$number = 100;

	if (!$page || $page == "") $page = 1;
	$page--;

	if ($page == 0) {
		$start = 0;
	} else {
		$start = $page * $number;
	}

	$totalInSet = 0;
	$totalIgnores = 0;
	$numCount = 0;

	$data = file("../../tmp/search/search-" . login("id") . "-" . $transaction . ".events");
	
	$store = trim($data[2]);
	
	$totalResults = trim($data[4]);

	$searchObj = new coreSearch();

	$out .= "Search query: '" . trim($data[3]) . "' on datastore: $store with $totalResults events returned\n\n";
	
	// Shift items off of array
	$data = array_slice($data, 6);

	for ($i=$start;$i<count($data);$i++) {

		$totalInSet++;
		$numCount++;

		$eventData = $searchObj->getDetailsByID(trim($data[$i]));

		if (!$eventData["sport"]) $eventData["sport"] = "-";
		if (!$eventData["dport"]) $eventData["dport"] = "-";

		if (strlen($eventData["signatureName"]) > 30) {
			$sigShortName = substr($eventData["signatureName"], 0, 30) . "...";
		} else {
			$sigShortName = $eventData["signatureName"];
		}
		
		$eventAge = time() - sensorTimeConversion($eventData["sensorID"], $eventData["timestamp"]);
		if ($eventAge < 0) $eventAge = 0;

		$out .= "Event:\n";
		
		$out .= "\tID: " . $eventData["id"] . "\n";
		$out .= "\tStore: " . $store . "\n";
		$out .= "\tModule: " . $eventData["moduleID"] . "\n";
		$out .= "\tRisk: " . $eventData["priority"] . "\n";
		$out .= "\tDate & Time: " . date("m.d.Y H:i:s", sensorTimeConversion($eventData["sensorID"], $eventData["timestamp"])) . "\n";
		$out .= "\tAge: " . $eventAge . "\n";
		$out .= "\tSensor ID: " . $eventData["sensorID"] . "\n";
		$out .= "\tSensor Name: " . getSensorNameByID($eventData["sensorID"]) . "\n";
		$out .= "\tSource IP: " . longToIP($eventData["sip"]) . "\n";
		$out .= "\tDestination IP: " . longToIP($eventData["dip"]) . "\n";
		$out .= "\tSource Port: " . $eventData["sport"] . "\n";
		$out .= "\tDestination Port: " . $eventData["dport"] . "\n";
		$out .= "\tSignature Name: " .  htmlentities($eventData["signatureName"]) . "\n";
		$out .= "\tSignature ID: " . $eventData["signature"] . "\n";
		$out .= "\tSignature Category Name: " . $eventData["className"] . "\n";
		$out .= "\tSignature Category ID: " . $eventData["class"] . "\n";
		$out .= "\tProtocol: " . $eventData["protocol"] . "\n";
		$out .= "\tProtocol Name: " . protoToName($eventData["protocol"]) . "\n";

		if ($eventData["moduleID"] == "1") {

			$out .= "\tPayload: " . PrintAsciiOnly($eventData["payload"], 1) . "\n";
		
		} else {

			$out .= "\tPayload: " . htmlentities($eventData["payload"]) . "\n";
		
		}

		$out .= "\n";
	
		if ($numCount >= $number) break;
	
	}

	if ($totalInSet > $totalResults) $totalResults = $totalInSet;

	return $out;
}

function prv_liveSearch() {
	global $idsDB;

	$totalResults = 0;
	$totalInSet = 0;
	$totalIgnores = 0;

	$searchObj = new coreSearch();
	$searchObj->setVar("query", getVar("query"));
	$searchObj->setVar("store", ops("site_activeDataStore"));

	if (sanitize("sensor") > 0) {
		$searchObj->setVar("sensor", sanitize("sensor"));
	}

	$xml = "<document>\n";

	$xml .= "\t<store>" . ops("site_activeDataStore") . "</store>\n";

	// Get event id's

	foreach ($searchObj->searchProcess() as $id) {

		$eventArray[] = $id;

	}
	
	// Reverse array for proper sort order (top is most recent for live monitor)
	
	rsort($eventArray);
	
	// Process event id's
	
	foreach ($eventArray as $id) {

		$totalInSet++;

		$eventData = $searchObj->getDetailsByID($id);

		if (!$eventData["sport"]) $eventData["sport"] = "-";
		if (!$eventData["dport"]) $eventData["dport"] = "-";

		if (strlen($eventData["signatureName"]) > 30) {
			$sigShortName = substr($eventData["signatureName"], 0, 30) . "...";
		} else {
			$sigShortName = $eventData["signatureName"];
		}
		
		$eventAge = time() - sensorTimeConversion($eventData["sensorID"], $eventData["timestamp"]);
		if ($eventAge < 0) $eventAge = 0;
		
		$xml .= "\t<node>\n";
		
		$xml .= "\t\t<id>" . $id . "</id>\n";
		$xml .= "\t\t<store>" . $store . "</store>\n";
		$xml .= "\t\t<module>" . $eventData["moduleID"] . "</module>\n";
		$xml .= "\t\t<risk>" . $eventData["priority"] . "</risk>\n";
		$xml .= "\t\t<datetime>" . date("m.d.Y H:i:s", sensorTimeConversion($eventData["sensorID"], $eventData["timestamp"])) . "</datetime>\n";
		$xml .= "\t\t<age>" . $eventAge . "</age>\n";
		$xml .= "\t\t<sensorid>" . $eventData["sensorID"] . "</sensorid>\n";
		$xml .= "\t\t<sensorname><![CDATA[" . getSensorNameByID($eventData["sensorID"]) . "]]></sensorname>\n";
		$xml .= "\t\t<sip>" . longToIP($eventData["sip"]) . "</sip>\n";
		$xml .= "\t\t<dip>" . longToIP($eventData["dip"]) . "</dip>\n";
		$xml .= "\t\t<sport>" . $eventData["sport"] . "</sport>\n";
		$xml .= "\t\t<dport>" . $eventData["dport"] . "</dport>\n";
		$xml .= "\t\t<signame><![CDATA[" .  $eventData["signatureName"] . "]]></signame>\n";
		$xml .= "\t\t<sigshortname><![CDATA[" .  $sigShortName . "]]></sigshortname>\n";
		$xml .= "\t\t<sigclassname><![CDATA[" . $eventData["className"] . "]]></sigclassname>\n";
		$xml .= "\t\t<protocol>" . $eventData["protocol"] . "</protocol>\n";
		$xml .= "\t\t<protocolname><![CDATA[" . protoToName($eventData["protocol"]) . "]]></protocolname>\n";

		if ($eventData["moduleID"] == "1") {

			$xml .= "\t\t<payload><![CDATA[" . PrintAsciiOnly($eventData["payload"], 1) . "]]></payload>\n";
		
		} else {

			$xml .= "\t\t<payload><![CDATA[" . $eventData["payload"] . "]]></payload>\n";
		
		}

		$xml .= "\t</node>\n";
	
	}

	if ($totalInSet > $totalResults) $totalResults = $totalInSet;

	$xml .= "\t<totalignores>$totalIgnores</totalignores>\n";
	$xml .= "\t<totalinset>$totalInSet</totalinset>\n";
	$xml .= "\t<totalresults>$totalResults</totalresults>\n";
	
	$xml .= "</document>\n";

	return $xml;	
}

function pub_iPhoneliveSearch() {
	global $idsDB;

	$totalResults = 0;
	$totalInSet = 0;
	$totalIgnores = 0;

	$query = sanitize("query");
	if (!$query) $query = "recent:25";

	$xml = "<document>\n";

	if (ops("site_iPhoneAccess") != 1) {
	
		$xml .= "\t<node>\n";
		
		$xml .= "\t\t<id>0</id>\n";
		$xml .= "\t\t<store>0</store>\n";
		$xml .= "\t\t<module>0</module>\n";
		$xml .= "\t\t<modulename>null</modulename>\n";
		$xml .= "\t\t<risk>0</risk>\n";
		$xml .= "\t\t<datetime>" . date("m.d.Y H:i:s") . "</datetime>\n";
		$xml .= "\t\t<sensorid>0</sensorid>\n";
		$xml .= "\t\t<sensorname>null</sensorname>\n";
		$xml .= "\t\t<sip>" . longToIP($eventData["sip"]) . "</sip>\n";
		$xml .= "\t\t<dip>" . longToIP($eventData["dip"]) . "</dip>\n";
		$xml .= "\t\t<sport>" . $eventData["sport"] . "</sport>\n";
		$xml .= "\t\t<dport>" . $eventData["dport"] . "</dport>\n";
		$xml .= "\t\t<signame>iPhone Access Disabled</signame>\n";
		$xml .= "\t\t<sigclassname>iPhone Access Disabled</sigclassname>\n";
		$xml .= "\t\t<protocol>0</protocol>\n";
		$xml .= "\t\t<protocolname>null</protocolname>\n";

		$xml .= "\t</node>\n";	
	
		return $xml;
		exit;
	
	}

	$searchObj = new coreSearch();
	$searchObj->setVar("query", $query);
	$searchObj->setVar("store", ops("site_activeDataStore"));

	if (sanitize("sensor") > 0) {
		$searchObj->setVar("sensor", sanitize("sensor"));
	}

	$xml .= "\t<store>" . ops("site_activeDataStore") . "</store>\n";

	// Get event id's

	foreach ($searchObj->searchProcess() as $id) {

		$eventArray[] = $id;

	}
	
	// Reverse array for proper sort order (top is most recent for live monitor)
	
	rsort($eventArray);
	
	// Process event id's
	
	foreach ($eventArray as $id) {

		$totalInSet++;

		$eventData = $searchObj->getDetailsByID($id);

		if (!$eventData["sport"]) $eventData["sport"] = "-";
		if (!$eventData["dport"]) $eventData["dport"] = "-";

		if ($eventData["moduleID"] == 1) {
			$eventData["moduleName"] = "Snort Module";
		} else if ($eventData["moduleID"] == 2) {
			$eventData["moduleName"] = "Syslog Module";
		}

		$xml .= "\t<node>\n";
		
		$xml .= "\t\t<id>" . $id . "</id>\n";
		$xml .= "\t\t<store>" . ops("site_activeDataStore") . "</store>\n";
		$xml .= "\t\t<module>" . $eventData["moduleID"] . "</module>\n";
		$xml .= "\t\t<modulename>" . $eventData["moduleName"] . "</modulename>\n";
		$xml .= "\t\t<risk>" . $eventData["priority"] . "</risk>\n";
		$xml .= "\t\t<datetime>" . date("m.d.Y H:i:s", sensorTimeConversion($eventData["sensorID"], $eventData["timestamp"])) . "</datetime>\n";
		$xml .= "\t\t<sensorid>" . $eventData["sensorID"] . "</sensorid>\n";
		$xml .= "\t\t<sensorname><![CDATA[" . getSensorNameByID($eventData["sensorID"]) . "]]></sensorname>\n";
		$xml .= "\t\t<sip>" . longToIP($eventData["sip"]) . "</sip>\n";
		$xml .= "\t\t<dip>" . longToIP($eventData["dip"]) . "</dip>\n";
		$xml .= "\t\t<sport>" . $eventData["sport"] . "</sport>\n";
		$xml .= "\t\t<dport>" . $eventData["dport"] . "</dport>\n";
		$xml .= "\t\t<signame><![CDATA[" .  $eventData["signatureName"] . "]]></signame>\n";
		$xml .= "\t\t<sigclassname><![CDATA[" . $eventData["className"] . "]]></sigclassname>\n";
		$xml .= "\t\t<protocol>" . $eventData["protocol"] . "</protocol>\n";
		$xml .= "\t\t<protocolname><![CDATA[" . protoToName($eventData["protocol"]) . "]]></protocolname>\n";

		$xml .= "\t</node>\n";
	
	}

	if ($totalInSet > $totalResults) $totalResults = $totalInSet;

	$xml .= "\t<totalignores>$totalIgnores</totalignores>\n";
	$xml .= "\t<totalinset>$totalInSet</totalinset>\n";
	$xml .= "\t<totalresults>$totalResults</totalresults>\n";
	
	$xml .= "</document>\n";

	return $xml;	
}

function prv_eventCollectionBrowse() {
	global $idsDB;

	$totalResults = 0;
	$totalInSet = 0;

	$id = sanitize("id");
	if (!$id) return;

	$store = login("activeSearchStore");

	$xml = "<document>\n";

	$q = $idsDB->query("SELECT event FROM idsCollectionStore WHERE cid = '$id' AND store = '" . $store . "'");
	while ($row = mysql_fetch_array($q, MYSQL_ASSOC)) {
	
		$idArray[] = $row["event"];
		
	}
	
	$searchObj = new coreSearch();
#	$searchObj->setVar("store", $store);

	$xml .= "\t<store>" . $store . "</store>\n";

	foreach ($idArray as $id) {

		$totalInSet++;

		$eventData = $searchObj->getDetailsByID($id);

		if (!$eventData["sport"]) $eventData["sport"] = "-";
		if (!$eventData["dport"]) $eventData["dport"] = "-";

		if (strlen($eventData["signatureName"]) > 30) {
			$sigShortName = substr($eventData["signatureName"], 0, 30) . "...";
		} else {
			$sigShortName = $eventData["signatureName"];
		}
		
		$eventAge = time() - sensorTimeConversion($eventData["sensorID"], $eventData["timestamp"]);
		if ($eventAge < 0) $eventAge = 0;

		$xml .= "\t<node>\n";
		
		$xml .= "\t\t<id>" . $id . "</id>\n";
		$xml .= "\t\t<store>" . $store . "</store>\n";
		$xml .= "\t\t<module>" . $eventData["moduleID"] . "</module>\n";
		$xml .= "\t\t<risk>" . $eventData["priority"] . "</risk>\n";
		$xml .= "\t\t<datetime>" . date("m.d.Y H:i:s", sensorTimeConversion($eventData["sensorID"], $eventData["timestamp"])) . "</datetime>\n";
		$xml .= "\t\t<age>" . $eventAge . "</age>\n";
		$xml .= "\t\t<sensorid>" . $eventData["sensorID"] . "</sensorid>\n";
		$xml .= "\t\t<sensorname><![CDATA[" . getSensorNameByID($eventData["sensorID"]) . "]]></sensorname>\n";
		$xml .= "\t\t<sip>" . longToIP($eventData["sip"]) . "</sip>\n";
		$xml .= "\t\t<dip>" . longToIP($eventData["dip"]) . "</dip>\n";
		$xml .= "\t\t<sport>" . $eventData["sport"] . "</sport>\n";
		$xml .= "\t\t<dport>" . $eventData["dport"] . "</dport>\n";
		$xml .= "\t\t<signame><![CDATA[" .  $eventData["signatureName"] . "]]></signame>\n";
		$xml .= "\t\t<sigshortname><![CDATA[" .  $sigShortName . "]]></sigshortname>\n";
		$xml .= "\t\t<sigclassname><![CDATA[" . $eventData["className"] . "]]></sigclassname>\n";
		$xml .= "\t\t<protocol>" . $eventData["protocol"] . "</protocol>\n";
		$xml .= "\t\t<protocolname><![CDATA[" . protoToName($eventData["protocol"]) . "]]></protocolname>\n";

		if ($eventData["moduleID"] == "1") {

			$xml .= "\t\t<payload><![CDATA[" . PrintAsciiOnly($eventData["payload"], 1) . "]]></payload>\n";
		
		} else {

			$xml .= "\t\t<payload><![CDATA[" . $eventData["payload"] . "]]></payload>\n";
		
		}

		$xml .= "\t</node>\n";

	
	}

	if ($totalInSet > $totalResults) $totalResults = $totalInSet;

	$xml .= "\t<totalinset>$totalInSet</totalinset>\n";
	$xml .= "\t<totalresults>$totalResults</totalresults>\n";
	$xml .= "</document>\n";

	return $xml;	
}

function prv_recentSearchList() {
	global $idsDB;

	$cnt = 0;

	$xml = "<document>\n";

	$q = $idsDB->query("SELECT id, query, intime FROM idsQueries where uid = '" . login("id") . "' order by id desc limit 100");
	while ($row = mysql_fetch_array($q, MYSQL_ASSOC)) {

		$cnt++;

		$xml .= "\t<node>\n";
		$out .= "\t\t<numerical>$cnt</numerical>\n";

		foreach ($row as $key => $val) {

			$xml .= "\t\t<$key><![CDATA[$val]]></$key>\n";
			
		}
		
		$xml .= "\t</node>\n";
		
	}

	$xml .= "\t<total>$cnt</total>\n";
	$xml .= "</document>\n";

	return $xml;	

}

function prv_clearSearchHistory() {
	global $idsDB;
	
	$xml = "<document>\n";
	
	$idsDB->query("delete from idsQueries where uid = '" . login("id") . "'");

	$xml .= "\t<success>1</success>\n";
	
	$xml .= "</document>\n";
	
	return $xml;
}

?>

