<?php

/** Copyright 2009 Tactical FLEX
 *
 * Aanval 5
 *
 * This program is owned and licensed by Tactical FLEX; it may be
 * redistributed only in its original configuration as originally
 * installed and available by Tactical FLEX and / or Aanval.
 *
 * To license and / or include this product in other forms or
 * applications, express prior written authorization must be
 * obtained by contract from authorized Tactical FLEX or Aanval agents.
 *
 * Tactical FLEX and Aanval may not be held liable nor responsible
 * for any and all issues arising from the use of, damages caused by, or 
 * conclusions drawn from the use of this product.
 *
 */

include "initialize.php";

function prv_sensorSelectionList() {
	global $idsDB;

	$cnt = 0;

	$userSensorList = "," . login("sensors") . ",";

	$xml = "<document>\n";

	$q = $idsDB->query("SELECT id, sid, module, name, lastEvent from idsSensor where enabled = 1 order by id asc");
	while ($row = mysql_fetch_array($q, MYSQL_ASSOC)) {

		$cnt++;

		$xml .= "\t<node>\n";

		if (strstr($userSensorList, "," . $row["id"] . ",")) {
			$xml .= "\t\t<status>Yes</status>\n";
		} else {
			$xml .= "\t\t<status>No</status>\n";
		}
		
		if ($row["module"] == 1) {
			$xml .= "\t\t<modulename>Snort</modulename>\n";
		} else if ($row["module"] == 2) {
			$xml .= "\t\t<modulename>Syslog</modulename>\n";
		}

		foreach ($row as $key => $val) {

			$xml .= "\t\t<$key>$val</$key>\n";
			
		}
		
		$xml .= "\t</node>\n";
		
	}

	$xml .= "\t<total>$cnt</total>\n";
	$xml .= "</document>\n";

	return $xml;	
}

function prv_sensorSelectionUpdate() {
	global $idsDB;

	$id = sanitize("id");
	if (!$id) return;

	$sensorList = login("sensors");

	if (substr($sensorList, 0, 1) == ",") $sensorList = substr($sensorList, 1);
	if (substr($sensorList, -1, 1) == ",") $sensorList = substr($sensorList, 0, -1);

	if ($sensorList) {
	
		$sensorList = "," . $sensorList . ",";
	
		if (strstr($sensorList, ",$id,")) {
		
			$sensorList = str_replace(",$id,", ",", $sensorList);
			
		} else {
	
			$sensorList .= $id;
		}
		
	} else {
	
		$sensorList = $id;
	
	}
	
	if (substr($sensorList, 0, 1) == ",") $sensorList = substr($sensorList, 1);
	if (substr($sensorList, -1, 1) == ",") $sensorList = substr($sensorList, 0, -1);

	login("sensors", $sensorList);

	$xml = "<success>1</success>\n";

	return $xml;
}

function prv_availableSensorList() {
	global $idsDB;

	// Returns list of available sensors

	$xml = "<document>\n";

	// Sensor Listing
	
	$userSensorArray = explode(",", login("sensors"));

	$xml .= "\t<sensors>\n";

#	$xml .= "\t\t<sensor>\n";
#		$xml .= "\t\t\t<id>0</id>\n";
#		$xml .= "\t\t\t<name>All Sensors</name>\n";
#	$xml .= "\t\t</sensor>\n";

	foreach ($userSensorArray as $sensor) {

		$xml .= "\t\t<sensor>\n";

		$q = $idsDB->query("SELECT id, name from idsSensor where id = '$sensor' and enabled = 1");
		while ($row = mysql_fetch_array($q, MYSQL_ASSOC)) {
		
			$xml .= "\t\t\t<id>" . $row['id'] . "</id>\n";
			$xml .= "\t\t\t<name>(" . $row['id'] . ") " . $row['name'] . "</name>\n";
		
		}

		$xml .= "\t\t</sensor>\n";
	
	}

	$xml .= "\t</sensors>\n";
		
	$xml .= "</document>\n";
	
	return $xml;

}

?>
