<?php

/** Copyright 2010 Tactical FLEX
 *
 * Aanval 5
 *
 * This program is owned and licensed by Tactical FLEX; it may be
 * redistributed only in its original configuration as originally
 * installed and available by Tactical FLEX and / or Aanval.
 *
 * To license and / or include this product in other forms or
 * applications, express prior written authorization must be
 * obtained by contract from authorized Tactical FLEX or Aanval agents.
 *
 * Tactical FLEX and Aanval may not be held liable nor responsible
 * for any and all issues arising from the use of, damages caused by, or 
 * conclusions drawn from the use of this product.
 *
 */

include "initialize.php";

function pub_validateSession() {
	global $idsDB;
	
	if ($_SESSION["login"] != 1) {
	
		$_SESSION["valid"] = 0;
		
	} else {

		// Authenticate		

		authenticateSessionByUserID($_SESSION["id"]);

	}
	
	$xml .= "<document>\n";

	$xml .= "\t<session>\n";
	
	foreach ($_SESSION as $key => $val) {

		$xml .= "\t\t<$key><![CDATA[$val]]></$key>\n";
			
	}

	$xml .= "\t</session>\n";

	$xml .= "\t<ops>\n";
	
	$query = $idsDB->query("SELECT var, val FROM idsOps ORDER BY var DESC");
	while ($row = mysql_fetch_assoc($query)) {

		$xml .= "\t\t<" . $row["var"] . "><![CDATA[" . $row["val"] . "]]></" . $row["var"] . ">\n";

	}
	
	$xml .= "\t</ops>\n";

	$xml .= "</document>\n";

	return $xml;	
		
}

function pub_userLogin() {
	global $idsDB;

	$username = sanitize("username");
	$password = getVar("password");

	// Clear any existing session
	
	$_SESSION = array();

	// Default login to false
	
	$_SESSION["login"] = 0;

	// Authenticate		

	authenticateSessionByUsernamePassword($username, $password);
	
	// Output
	
	$xml .= "<document>\n";
	
	$xml .= "\t<session>\n";

	foreach ($_SESSION as $key => $val) {

		$xml .= "\t\t<$key><![CDATA[$val]]></$key>\n";
		
	}

	$xml .= "\t</session>\n";
	
	$xml .= "\t<ops>\n";
	
	$query = $idsDB->query("SELECT var, val FROM idsOps ORDER BY var DESC");
	while ($row = mysql_fetch_assoc($query)) {

		$xml .= "\t\t<" . $row["var"] . "><![CDATA[" . $row["val"] . "]]></" . $row["var"] . ">\n";

	}
	
	$xml .= "\t</ops>\n";
		
	$xml .= "</document>\n";

	return $xml;	

}

function pub_userLogout() {

	// Destroy session

	$_SESSION = array();
	
	if (isset($_COOKIE[session_name("aanval")])) {
	    setcookie(session_name("aanval"), '', time()-42000, '/');
	}		
	
	@session_destroy();
	
	$xml = "<document>\n";
	$xml .= "<success>1</success>\n";
	$xml .= "</document>\n";

	return $xml;

}

?>