<?php

/** Copyright 2010 Tactical FLEX
 *
 * Aanval 5
 *
 * This program is owned and licensed by Tactical FLEX; it may be
 * redistributed only in its original configuration as originally
 * installed and available by Tactical FLEX and / or Aanval.
 *
 * To license and / or include this product in other forms or
 * applications, express prior written authorization must be
 * obtained by contract from authorized Tactical FLEX or Aanval agents.
 *
 * Tactical FLEX and Aanval may not be held liable nor responsible
 * for any and all issues arising from the use of, damages caused by, or 
 * conclusions drawn from the use of this product.
 *
 */

include "initialize.php";

function prv_signatureSourceList() {
	global $idsDB;

	$xml = "<document>\n";
	
	$xml .= "\t<options>\n";

	$xml .= "\t\t<enabled><![CDATA[" . ops("site_sigProcessorEnabled") . "]]></enabled>\n";
	$xml .= "\t\t<oinkcode><![CDATA[" . ops("site_sigOinkCode") . "]]></oinkcode>\n";
	$xml .= "\t\t<frequency><![CDATA[" . ops("site_sigProcessorFrequency") . "]]></frequency>\n";

	$xml .= "\t</options>\n";

	$xml .= "\t<sources>\n";

	$q = $idsDB->query("SELECT * FROM idsSignatureSources ORDER BY id");
	while ($row = mysql_fetch_assoc($q)) {

		$xml .= "\t\t<source>\n";

		if ($row["lastDownload"] == 0) {
			$row["lastDownload"] = "never";
		} else {
			$row["lastDownload"] = date("m.d.Y H:i:s", $row["lastDownload"]);
		}

		foreach ($row as $key => $val) {

			$xml .= "\t\t\t<$key><![CDATA[$val]]></$key>\n";
			
		}

		$xml .= "\t\t</source>\n";

	}

	$xml .= "\t</sources>\n";
    
	$xml .= "</document>\n";

	return $xml;
}

function prv_signatureSourceUpdate() {
	global $idsDB;

	$id = sanitize("id");
	if (!$id) return;

	$name = sanitize("name");
	$location = sanitize("location");
	$enabled = sanitize("enabled");

	$idsDB->query("UPDATE idsSignatureSources SET name = '$name', location = '$location', enabled = '$enabled' WHERE id = '$id'");
	
	$xml = "<document>\n";

	$xml .= "<success>1</success>\n";

	$xml .= "</document>\n";

	return $xml;
}

function prv_signatureSourceCreate() {
	global $idsDB;

	$name = sanitize("name");
	$location = sanitize("location");
	$enabled = sanitize("enabled");

	$idsDB->query("INSERT INTO idsSignatureSources (name, location, enabled) VALUES ('$name', '$location', '$enabled')");
	
	$xml = "<document>\n";

	$xml .= "<success>1</success>\n";

	$xml .= "</document>\n";

	return $xml;
}

function prv_signatureSourceDelete() {
	global $idsDB;

	$id = sanitize("id");
	if (!$id) return;

	$idsDB->query("DELETE FROM idsSignatureSources WHERE id = '$id'");
	
	$xml = "<document>\n";

	$xml .= "<success>1</success>\n";

	$xml .= "</document>\n";

	return $xml;
}

function prv_signatureOptionsUpdate() {

    ops("site_sigProcessorEnabled", sanitize("enabled"));
    ops("site_sigOinkCode", sanitize("oinkcode"));

    ops("site_sigProcessorFrequency", "86400");
    
	$xml = "<document>\n";

	$xml .= "<success>1</success>\n";

	$xml .= "</document>\n";

	return $xml;

}

function prv_signatureTriggerDownload() {

	ops("site_sigProcessorNow", 1);
	
	$xml = "<document>\n";

	$xml .= "<success>1</success>\n";

	$xml .= "</document>\n";

}

function prv_snortPolicyList() {
	global $idsDB;

	$xml = "<document>\n";
	
	$xml .= "\t<policies>\n";

	$q = $idsDB->query("SELECT * FROM idsSensorPolicy ORDER BY id DESC");
	while ($row = mysql_fetch_assoc($q)) {

		$row["signatureCount"] = 0;
		$row["sensorCount"] = 0;

		$xml .= "\t\t<policy>\n";

		// Count this policies signatures
		
		$q2 = $idsDB->query("SELECT count(*) as cnt FROM idsSignaturePolicyIndex WHERE pid = '" . $row["id"] . "'");
		while ($row2 = mysql_fetch_assoc($q2)) {

			$row["signatureCount"] = $row2["cnt"];

		}		

		// Count sensors using this policy
		
		$q2 = $idsDB->query("SELECT count(*) as cnt FROM idsSensor WHERE confPolicy = '" . $row["id"] . "'");
		while ($row2 = mysql_fetch_assoc($q2)) {

			$row["sensorCount"] = $row2["cnt"];

		}		
		
		foreach ($row as $key => $val) {

			$xml .= "\t\t\t<$key><![CDATA[$val]]></$key>\n";
			
		}

		$xml .= "\t\t</policy>\n";

	}

	$xml .= "\t</policies>\n";
    
	$xml .= "</document>\n";

	return $xml;

}

function prv_snortPolicyCreate() {
	global $idsDB;

	$name = "New Policy - " . date("r");

	$q = $idsDB->query("INSERT INTO idsSensorPolicy (name) VALUES ('$name')");

	$xml = "<document>\n";
	
	$xml .= "\t<response>1</response>\n";

	$xml .= "</document>\n";

	return $xml;
}

function prv_snortPolicyDuplicate() {
	global $idsDB;

	$id = sanitize("id");
	if (!$id) return;

	$q = $idsDB->query("SELECT * FROM idsSensorPolicy WHERE id = '$id'");
	while ($row = mysql_fetch_assoc($q)) {

		$name = "Copy - " . $row["name"];

	}

	$q = $idsDB->query("INSERT INTO idsSensorPolicy (name) VALUES ('$name')");

	$lastID = mysql_insert_id();
	
	$q = $idsDB->query("SELECT * FROM idsSignaturePolicyIndex WHERE pid = '$id'");
	while ($row = mysql_fetch_assoc($q)) {

		$idsDB->query("INSERT INTO idsSignaturePolicyIndex (pid, sid) VALUES ('$lastID', '" . $row["sid"] . "')");

	}

	$xml = "<document>\n";
	
	$xml .= "\t<response>1</response>\n";

	$xml .= "</document>\n";

	return $xml;
}

function prv_snortPolicyDelete() {
	global $idsDB;

	$id = sanitize("id");
	if (!$id) return;

	$q = $idsDB->query("DELETE FROM idsSensorPolicy WHERE id = '$id'");

	$q = $idsDB->query("DELETE FROM idsSignaturePolicyIndex WHERE pid = '$id'");

	$q = $idsDB->query("UPDATE idsSensor SET confPolicy = '' WHERE confPolicy = '$id'");

	$xml = "<document>\n";
	
	$xml .= "\t<response>1</response>\n";

	$xml .= "</document>\n";

	return $xml;
}

function prv_snortPolicyUpdate() {
	global $idsDB;

	$id = sanitize("id");
	if (!$id) return;

	$name = sanitize("name");

	$q = $idsDB->query("UPDATE idsSensorPolicy SET name = '$name' WHERE id = '$id'");

	$xml = "<document>\n";
	
	$xml .= "\t<response>1</response>\n";

	$xml .= "</document>\n";

	return $xml;
		
} 

function prv_policyCategoryData() {
	global $idsDB;

	$policy = sanitize("policy");
	if (!$policy) return;

	$filter = sanitize("filter");

	if ($filter) {
	
		$filterQuery = "AND (idsSignatures.data LIKE '%$filter%' OR idsSignatures.msg LIKE '%$filter%')";
	
	}

	$xml = "<document>\n";
	
	$q = $idsDB->query("SELECT * FROM idsSensorPolicy WHERE id = '$policy'");
	while ($row = mysql_fetch_assoc($q)) {

		$xml .= "\t<policy>\n";

		foreach ($row as $key => $val) {

			$xml .= "\t\t<$key><![CDATA[$val]]></$key>\n";
			
		}

		$xml .= "\t</policy>\n";

	}
	
	$xml .= "\t<categories>\n";

	$q = $idsDB->query("SELECT file as name, count(id) AS total FROM idsSignatures WHERE id != 0 $filterQuery GROUP BY file ORDER BY file");
	while ($row = mysql_fetch_assoc($q)) {

		$q2 = $idsDB->query("SELECT count(idsSignatures.id) as active FROM idsSignatures JOIN idsSignaturePolicyIndex ON (idsSignatures.id = idsSignaturePolicyIndex.sid) WHERE idsSignaturePolicyIndex.pid = '$policy' $filterQuery AND idsSignatures.file = '" . $row["name"] . "'");
		while ($row2 = mysql_fetch_assoc($q2)) {
		
			$row["active"] = $row2["active"];
		
		}

		$xml .= "\t\t<category>\n";

		foreach ($row as $key => $val) {

			$xml .= "\t\t\t<$key><![CDATA[$val]]></$key>\n";
			
		}

		$xml .= "\t\t</category>\n";

	}

	$xml .= "\t</categories>\n";
    
	$xml .= "</document>\n";

	return $xml;

}

function prv_policySignatureData() {
	global $idsDB;

	$policy = sanitize("policy");
	if (!$policy) return;

	$category = sanitize("category");

	$filter = sanitize("filter");

	$enabledArray = array(99999933);

	if ($filter) {
	
		$filterQuery = "AND (idsSignatures.data LIKE '%$filter%' OR idsSignatures.msg LIKE '%$filter%')";
	
	}

	$xml = "<document>\n";
	
	$xml .= "\t<signatures>\n";

	$xml .= "\t\t<enabled>\n";
	
	$q = $idsDB->query("SELECT idsSignatures.id, idsSignatures.sid, idsSignatures.gid, idsSignatures.rev, idsSignatures.msg FROM idsSignatures JOIN idsSignaturePolicyIndex ON (idsSignatures.id = idsSignaturePolicyIndex.sid) WHERE idsSignaturePolicyIndex.pid = '$policy' $filterQuery AND idsSignatures.file = '$category'");
	while ($row = mysql_fetch_assoc($q)) {

		$enabledArray[] = $row["id"];

		$xml .= "\t\t\t<signature>\n";

		foreach ($row as $key => $val) {

			$xml .= "\t\t\t\t<$key><![CDATA[$val]]></$key>\n";
			
		}

		$xml .= "\t\t\t</signature>\n";

	}
	
	$xml .= "\t\t</enabled>\n";

	$xml .= "\t\t<disabled>\n";

	$q = $idsDB->query("SELECT idsSignatures.id, idsSignatures.sid, idsSignatures.gid, idsSignatures.rev, idsSignatures.msg FROM idsSignatures WHERE idsSignatures.file = '$category' AND idsSignatures.id NOT IN (" . implode(",", $enabledArray) . ") $filterQuery");
	while ($row = mysql_fetch_assoc($q)) {

		$xml .= "\t\t\t<signature>\n";

		foreach ($row as $key => $val) {

			$xml .= "\t\t\t\t<$key><![CDATA[$val]]></$key>\n";
			
		}

		$xml .= "\t\t\t</signature>\n";

	}

	$xml .= "\t\t</disabled>\n";

	$xml .= "\t</signatures>\n";
    
	$xml .= "</document>\n";

	return $xml;

}

function prv_signatureDetails() {
	global $idsDB;

	$id = sanitize("id");
	if (!$id) return;

	$xml = "<document>\n";
	
	$xml .= "\t<signature>\n";

	$q = $idsDB->query("SELECT * FROM idsSignatures WHERE id = '$id'");
	while ($row = mysql_fetch_assoc($q)) {

		$q2 = $idsDB->query("SELECT * FROM idsSignatureSources WHERE id = '" . $row["source"] . "'");
		while ($row2 = mysql_fetch_assoc($q2)) {

			$row["sourceName"] = $row2["name"];
	
		}

		foreach ($row as $key => $val) {

			$xml .= "\t\t<$key><![CDATA[$val]]></$key>\n";
			
		}

	}

	$xml .= "\t</signature>\n";
    
	$xml .= "</document>\n";

	return $xml;

}

function prv_toggleSignatures() {
	global $idsDB;

	$sids = sanitize("sids");
	if (!$sids) return;

	$policy = sanitize("policy");
	if (!$policy) return;

	$category = sanitize("category");

	// Test if any of the signatures are enabled

	$q = $idsDB->query("SELECT id FROM idsSignaturePolicyIndex WHERE sid IN ($sids) AND pid = '$policy'");
	while ($row = mysql_fetch_assoc($q)) {

		$found = true;

	}

	if ($found == true) {
	
		// disable signatures
		
		$idsDB->query("DELETE FROM idsSignaturePolicyIndex WHERE sid IN ($sids) AND pid = '$policy'");
	
	} else {
	
		// enable signatures
	
		$sidsArray = explode(",", $sids);
	
		foreach ($sidsArray as $id) {

			$idsDB->query("INSERT INTO idsSignaturePolicyIndex (pid, sid) VALUES ('$policy', '$id')");
		
		}
	
	}
	
	// Update snort rules files
	
	snortRulesFile_write($policy, $category);

	// Build snort conf files who share this policy
	
	$q = $idsDB->query("SELECT id FROM idsSensor WHERE confPolicy = '$policy'");
	while ($row = mysql_fetch_assoc($q)) {

	    snortConfWrite($row["id"]);

	}

	// Output

	$xml = "<document>\n";
	
	$xml .= "\t<response>1</response>\n";

	$xml .= "</document>\n";

	return $xml;
}

function prv_snortPolicySettings() {

	$xml = "<document>\n";

		$xml .= "\t<node>\n";

		$xml .= "\t\t<status><![CDATA[" . ops("site_sigProcessorEnabled") . "]]></status>\n";
		$xml .= "\t\t<urls><![CDATA[" . ops("site_sigDownloadURL") . "]]></urls>\n";
		$xml .= "\t\t<oinkcode><![CDATA[" . ops("site_sigOinkCode") . "]]></oinkcode>\n";
		$xml .= "\t\t<frequency><![CDATA[" . ops("site_sigProcessorFrequency") . "]]></frequency>\n";

		$xml .= "\t</node>\n";
	
	$xml .= "</document>\n";

	return $xml;

}

?>