<?php

/** Copyright 2010 Tactical FLEX
 *
 * Aanval 5
 *
 * This program is owned and licensed by Tactical FLEX; it may be
 * redistributed only in its original configuration as originally
 * installed and available by Tactical FLEX and / or Aanval.
 *
 * To license and / or include this product in other forms or
 * applications, express prior written authorization must be
 * obtained by contract from authorized Tactical FLEX or Aanval agents.
 *
 * Tactical FLEX and Aanval may not be held liable nor responsible
 * for any and all issues arising from the use of, damages caused by, or 
 * conclusions drawn from the use of this product.
 *
 */

include "initialize.php";

function prv_snortSensorData() {
    global $idsDB;

	$idsQueryA = $idsDB->query("SELECT * FROM idsModules where id = '1'");
	while ($row = mysql_fetch_array($idsQueryA, MYSQL_ASSOC)) {

		foreach ($row as $key => $val) {
	
			$modArray[$key] = $val;
	
		}
	}

	$moduleDB = new moduleDB();
	$moduleDB->load($modArray);
	
	$cnt = 0;

	$xml = "<document>\n";

	// Sensor list

	$q = $moduleDB->query("select sid, hostname, interface as interfaceName, last_cid from sensor order by sid");
	while ($row = mysql_fetch_array($q, MYSQL_ASSOC)) {

		$cnt++;

		$xml .= "\t<node>\n";

		foreach ($row as $key => $val) {

			$xml .= "\t\t<$key><![CDATA[$val]]></$key>\n";
			
		}

		$q2 = $idsDB->query("SELECT id, name, enabled, location, description, os, timezone, lastEvent, smtid, intime, type FROM idsSensor where module = 1 and sid = '" . $row['sid'] . "'");
		while ($rowB = mysql_fetch_assoc($q2)) {
	
			if ($rowB["intime"]) {
				$rowB["intime"] = date("m.d.Y H:i:s", consoleTimeConversion($rowB["intime"]));
			} else {
				$rowB["intime"] = "null";
			}

			foreach ($rowB as $key => $val) {
	
				$xml .= "\t\t<$key><![CDATA[$val]]></$key>\n";
				
			}
	
		}

		$xml .= "\t</node>\n";
		
	}

	$moduleDB->close();

	// Timezone list

	$xml .= "\t<timezone>\n";

    $idsQueryA = $idsDB->query("select id, name, zone from idsTimezones order by name");
    while (list($id, $name, $zone) = mysql_fetch_row($idsQueryA)) {

		$xml .= "\t\t<zonenode>\n";
		$xml .= "\t\t\t<id>$id</id>\n";
		$xml .= "\t\t\t<name><![CDATA[$name]]></name>\n";
		$xml .= "\t\t\t<zone>$zone</zone>\n";
		$xml .= "\t\t</zonenode>\n";

    }

	$xml .= "\t</timezone>\n";

	$xml .= "\t<total>$cnt</total>\n";
	
	$xml .= "</document>\n";

	return $xml;	
}

function prv_snortSensorManageData() {
	global $idsDB;

	$cnt = 0;

	$idsQueryA = $idsDB->query("SELECT * FROM idsModules where id = '1'");
	while ($row = mysql_fetch_array($idsQueryA, MYSQL_ASSOC)) {

		foreach ($row as $key => $val) {
	
			$modArray[$key] = $val;
	
		}
	}

	$moduleDB = new moduleDB();
	$moduleDB->load($modArray);

	$xml = "<document>\n";

	$q = $idsDB->query("SELECT id, sid, name, location, description, os, timezone, lastEvent, smtid, intime, hb, hbcount, status, confFile, confPolicy, countCommFailure, countStatusFailure, lastCommFailure, lastStatusCheck, lastVersionCheck, lastStatusFailure, emailOnStatusFailure, emailOnCommFailure, type FROM idsSensor where module = 1 and enabled = 1 order by id asc");
	while ($row = mysql_fetch_array($q, MYSQL_ASSOC)) {

		$cnt++;

		$xml .= "\t<node>\n";

		if (!$row["hb"]) { $row["hb"] = "null";	} else { $row["hb"] = date("m.d.Y h:i:s", consoleTimeConversion($row["hb"])); }
		if (!$row["hbcount"]) $row["hbcount"] = "0";
		if (!$row["lastCommFailure"]) { $row["lastCommFailure"] = "null";	} else { $row["lastCommFailure"] = date("m.d.Y h:i:s", consoleTimeConversion($row["lastCommFailure"])); }

		if (!$row["lastVersionCheck"]) { $row["lastVersionCheck"] = "null";	} else { $row["lastVersionCheck"] = date("m.d.Y h:i:s", consoleTimeConversion($row["lastVersionCheck"])); }

		if (!$row["status"]) { $row["statusText"] = "null";	} else if ($row["status"] == 1) { $row["statusText"] = "Running"; } else { $row["statusText"] = "Not Running"; }

		if (!$row["lastStatusCheck"]) { $row["lastStatusCheck"] = "null";	} else { $row["lastStatusCheck"] = date("m.d.Y h:i:s", consoleTimeConversion($row["lastStatusCheck"])); }
		if (!$row["lastStatusFailure"]) { $row["lastStatusFailure"] = "null";	} else { $row["lastStatusFailure"] = date("m.d.Y h:i:s", consoleTimeConversion($row["lastStatusFailure"])); }

		$row["confPolicyName"] = translatePolicyToName($row["confPolicy"]);

		if ($row["intime"]) {
			$row["intime"] = date("m.d.Y H:i:s", consoleTimeConversion($row["intime"]));
		} else {
			$row["intime"] = "null";
		}

		foreach ($row as $key => $val) {

			$xml .= "\t\t<$key><![CDATA[$val]]></$key>\n";
			
		}

		$q2 = $moduleDB->query("select hostname, interface, last_cid from sensor where sid = '" . $row["sid"] . "'");
		while ($row2 = mysql_fetch_array($q2, MYSQL_ASSOC)) {
		
			foreach ($row2 as $key => $val) {

				$xml .= "\t\t<$key><![CDATA[$val]]></$key>\n";
			
			}
		
		}

		$xml .= returnTimezoneXML($row["timezone"]);

		$xml .= "\t</node>\n";
		
	}

	$xml .= "\t<total>$cnt</total>\n";

	$xml .= "</document>\n";

	$moduleDB->close();

	return $xml;	
}

function prv_snortUserLists() {
	global $idsDB;

	$sid = sanitize("sid");
	if (!$sid) return;

	$q = $idsDB->query("SELECT id FROM idsUsers where sensors like '%,$sid,%' or sensors like '$sid' or sensors like '%,$sid' or sensors like '$sid,%'");
	while ($row = mysql_fetch_array($q, MYSQL_ASSOC)) {

		foreach ($row as $key => $val) {

			$userArray[] = $val;
			
		}
		
	}

	if (!$userArray) $userArray[] = 10101010;

	$xml = "<document>\n";

	$q = $idsDB->query("SELECT id, username FROM idsUsers where id not in (" . implode(",", $userArray) . ")");
	while ($row = mysql_fetch_array($q, MYSQL_ASSOC)) {

		$xml .= "\t<node1>\n";

		foreach ($row as $key => $val) {

			$xml .= "\t\t<$key><![CDATA[$val]]></$key>\n";
			
		}

		$xml .= "\t</node1>\n";
		
	}

	$q = $idsDB->query("SELECT id, username FROM idsUsers where sensors like '%,$sid,%' or sensors like '$sid' or sensors like '%,$sid' or sensors like '$sid,%'");
	while ($row = mysql_fetch_array($q, MYSQL_ASSOC)) {

		$xml .= "\t<node2>\n";

		foreach ($row as $key => $val) {

			$xml .= "\t\t<$key><![CDATA[$val]]></$key>\n";
			
		}

		$xml .= "\t</node2>\n";
		
	}

	$xml .= "</document>\n";

	return $xml;
}

function prv_snortModuleUpdate() {
	global $idsDB;

	$id = sanitize("id");
	if (!$id) return;

	$name = sanitize("name");
	$description = sanitize("description");
	$location = sanitize("location");
	$os = sanitize("os");
	$smtid = sanitize("smtid");
	$timezone = sanitize("timezone");

	$idsDB->query("update idsSensor set name = '$name', description = '$description', location = '$location', os = '$os', smtid = '$smtid', timezone = '$timezone' where id = '$id'");
	
	$xml = "<success>1</success>\n";

	return $xml;
}

function prv_snortModuleSMTOptionsUpdate() {
	global $idsDB;

	$id = sanitize("id");
	if (!$id) return;

	$snortFailure = sanitize("snortFailure");
	$commFailure = sanitize("commFailure");

	$idsDB->query("update idsSensor set emailOnStatusFailure = '$snortFailure', emailOnCommFailure = '$commFailure' where id = '$id'");
	
	$xml = "<success>1</success>\n";

	return $xml;
}

function prv_snortModuleSettings() {
	global $idsDB;

	// TF

	$xml = "<document>\n";

	$trimLimit = ops("site_snortAutoTrimMax");
	if (!$trimLimit) $trimLimit = 500000;
	
	$q = $idsDB->query("SELECT id, module, auth_db_user, auth_db, auth_db_pass, auth_db_host, enabled FROM idsModules where id = '1'");
	while ($row = mysql_fetch_array($q, MYSQL_ASSOC)) {

		$xml .= "\t<node>\n";

		foreach ($row as $key => $val) {

			$xml .= "\t\t<$key><![CDATA[$val]]></$key>\n";
			
		}

		$xml .= "\t\t<trimthreshold>" . $trimLimit . "</trimthreshold>\n";
		$xml .= "\t\t<trimenabled>" . ops("site_snortAutoTrim") . "</trimenabled>\n";

		$xml .= "\t</node>\n";
		
	}

	$xml .= "</document>\n";

	return $xml;
}

function prv_snortModuleSettingsUpdate() {
	global $idsDB;

	// TF

	$db = sanitize("db");
	$user = sanitize("user");
	$pass = sanitize("pass");
	$host = sanitize("host");
	$status = sanitize("status");
	$threshold = sanitize("threshold");
	$trimming = sanitize("trimming");
	
	if (!$db) $db = "snort";
	if (!$user) $user = "root";
	if (!$pass) $pass = "";
	if (!$host) $host = "localhost";
	if (!$threshold) $threshold = 500000;
	if (!$trimming) $trimming = 0;
	
	$idsDB->query("update idsModules set auth_db = '$db', auth_db_user = '$user', auth_db_pass = '$pass', auth_db_host = '$host', enabled = '$status' where id = '1'");

	ops("site_snortAutoTrimMax", $threshold);
	ops("site_snortAutoTrim", $trimming);
	
	$xml = "<document>\n";
		$xml .= "\t<node>\n";
	
			$xml .= "\t\t<success>1</success>\n";
	
		$xml .= "\t</node>\n";
	$xml .= "</document>\n";

	return $xml;

}

function prv_snortSensorEnable() {
	global $idsDB;

	$sid = sanitize("sid");
	if (!$sid) return;

	$q = $idsDB->query("SELECT count(id) as cnt FROM idsSensor where module = 1 and enabled = 1");
	$row = mysql_fetch_array($q);

	if ((countUpperCaseArray("6")+countUpperCaseArray("7")+countUpperCaseArray("4")+countUpperCaseArray("5")+countUpperCaseArray("1")) == 0) { $useVar = 1; } else if (countUpperCaseArray("6") >= 1) { $useVar = time(); } else { $useVar = countUpperCaseArray("4")+countUpperCaseArray("1"); }
	if (($row["cnt"]+1) > $useVar) { $policy = 0; } else {

		$policy = 1;
	
		// Check if sid exists
		$q = $idsDB->query("SELECT id FROM idsSensor where sid = '$sid' and module = 1");
		if (mysql_num_rows($q) > 0) {
		
			$idsDB->query("update idsSensor set enabled = '1' where sid = '$sid' and module = 1");
		
		} else {

			$idsDB->query("insert into idsSensor (sid, name, enabled, module, smtid, timezone, intime) values ('$sid', 'Not Configured', '1', '1', '" . time() . rand(100,999) . "', '62', '" . time() . "')");
		
		}

	}
	
	$xml = "<document>\n";
	$xml .= "\t<node>\n";
	
	$xml .= "\t\t<success>1</success>\n";
	$xml .= "\t\t<policy>$policy</policy>\n";

	$xml .= "\t</node>\n";
	$xml .= "</document>\n";

	return $xml;
}

function prv_snortSensorDisable() {
	global $idsDB;

	$id = sanitize("id");
	if (!$id) return;

	// Disable sensor
	$idsDB->query("update idsSensor set enabled = '0' where id = '$id' and module = '1'");

	removeSensorFromAllUsers($id);

	// Delete data from idsSensorManage table
	$idsQueryA = $idsDB->query("delete from idsSensorManage where sid = '$id'");
	
	$xml = "<success>1</success>\n";

	return $xml;
}

function prv_snortSensorUserEnable() {
	global $idsDB;

	$ids = sanitize("ids");
	if (!$ids) return;

	$sid = sanitize("sid");
	if (!$sid) return;

	$userArray = explode(",", $ids);
	
	foreach ($userArray as $id) {

		addSensorToUser($sid, $id);

	}
	
	$xml = "<success>1</success>\n";

	return $xml;
}

function prv_snortSensorUserDisable() {
	global $idsDB;

	$ids = sanitize("ids");
	if (!$ids) return;

	$sid = sanitize("sid");
	if (!$sid) return;

	foreach (explode(",", $ids) as $id) {

		removeSensorFromUser($sid, $id);
	}
	
	$xml = "<success>1</success>\n";

	return $xml;
}

function prv_snortSensorMessages() {
	global $idsDB;

	$sid = sanitize("sid");
	if (!$sid) return;

	$xml = "<document>\n";

	$q = $idsDB->query("SELECT id, sid, message, enabled, issued FROM idsSensorManageMessages where enabled = 1 and sid = '$sid' order by id desc limit 100");
	while ($row = mysql_fetch_array($q, MYSQL_ASSOC)) {

		$xml .= "\t<node1>\n";

		$row["issued"] = date("m.d.Y H:i:s", consoleTimeConversion($row["issued"]));

		foreach ($row as $key => $val) {

			$xml .= "\t\t<$key><![CDATA[$val]]></$key>\n";
			
		}

		$xml .= "\t</node1>\n";
		
	}

	$q = $idsDB->query("SELECT id, sid, message, enabled, received FROM idsSensorManageMessages where enabled = 0 and sid = '$sid' order by id desc limit 100");
	while ($row = mysql_fetch_array($q, MYSQL_ASSOC)) {

		$xml .= "\t<node2>\n";

		$row["received"] = date("m.d.Y H:i:s", consoleTimeConversion($row["received"]));
		
		foreach ($row as $key => $val) {

			$xml .= "\t\t<$key><![CDATA[$val]]></$key>\n";
			
		}

		$xml .= "\t</node2>\n";
		
	}

	$xml .= "</document>\n";

	return $xml;
}

function prv_snortSensorMessagePost() {
	global $idsDB;

	$sid = sanitize("sid");
	if (!$sid) return;

	$message = sanitize("message");
	if (!$message) return;

	$idsDB->query("insert into idsSensorManageMessages (sid, message, enabled, issued) values ('$sid', '$message', '1', '" . time() . "')");
	
	$xml = "<success>1</success>\n";

	return $xml;
}

function prv_requestSnortConfig() {
	global $idsDB;

	$sid = sanitize("sid");
	if (!$sid) return;

    $objSensor = new mySensor();
    $objSensor->loadSensor($sid);

	if (!$objSensor->getSensorVar("smtid") || $objSensor->getSensorVar("smtid") == "") return;

	$snortConfFile = "../../smt/sensorData/" . $objSensor->getSensorVar("smtid") . "/" . $objSensor->getSensorVar("confFile");

	$data = @file_get_contents($snortConfFile);

	$xml = "<document>\n";
	
	$xml .= "\t<node>\n";

	$xml .= "\t\t<file><![CDATA[" . $objSensor->getSensorVar("confFile") . "]]></file>\n";
	$xml .= "\t\t<data><![CDATA[" . $data . "]]></data>\n";

	$xml .= "\t</node>\n";
	
	$xml .= "</document>\n";

	return $xml;
}

function prv_updateSnortConfig() {
	global $idsDB;

	$sid = sanitize("sid");
	if (!$sid) return;

	$data = getVar("data");
	if (!$data) return;

    $updateSensor = sanitize("updatesensor");
    $restartSnort = sanitize("restartsnort");

    $objSensor = new mySensor();
    $objSensor->loadSensor($sid);

	if (!$objSensor->getSensorVar("smtid") || $objSensor->getSensorVar("smtid") == "") return;

	if (strlen($data) > 1000) {

		$snortConfFile = "../../smt/sensorData/" . $objSensor->getSensorVar("smtid") . "/" . $objSensor->getSensorVar("confFile");

		if ($fp = @fopen($snortConfFile, "w")) {
		
			fwrite($fp, str_replace("\r", "\n", $data));
			fclose($fp);
			
		} else {
		
			errorLog("File: '$snortConfFile' could not be opened for writing");
		
		}
		
	}

	if ($updateSensor == 1) {
        $idsQueryA = $idsDB->query("insert into idsSensorManageMessages (sid, message, enabled, issued) values ('$sid', 'SNORTCONFSEND', '1', '" . time() . "')");
    }
    
	if ($restartSnort == 1) {
        $idsQueryA = $idsDB->query("insert into idsSensorManageMessages (sid, message, enabled, issued) values ('$sid', 'SNORTRESTART', '1', '" . time() . "')");
    }

	$xml = "<document>\n";
	
	$xml .= "\t<node>\n";

	$xml .= "\t\t<response>1</response>\n";

	$xml .= "\t</node>\n";
	
	$xml .= "</document>\n";

	return $xml;
}

function prv_setPolicyOnSensor() {
	global $idsDB;

    $sensorid = sanitize("sid");
    
	$policy = sanitize("plc");
	if (!$policy) return;
    
    $updateSensor = sanitize("updatesensor");
    $restartSnort = sanitize("restartsnort");
	
    $objSensor = new mySensor();
    $objSensor->loadSensor($sensorid);
    
    $objSensor->setSensorVar("confPolicy", $policy);
	
    snortConfWrite($sensorid);
    
	if ($updateSensor == 1) {
        $idsQueryA = $idsDB->query("insert into idsSensorManageMessages (sid, message, enabled, issued) values ('$sensorid', 'SNORTCONFSEND', '1', '" . time() . "')");
        $idsQueryA = $idsDB->query("insert into idsSensorManageMessages (sid, message, enabled, issued) values ('$sensorid', 'SNORTRULESSEND', '1', '" . time() . "')");
    }
    
	if ($restartSnort == 1) {
        $idsQueryA = $idsDB->query("insert into idsSensorManageMessages (sid, message, enabled, issued) values ('$sensorid', 'SNORTRESTART', '1', '" . time() . "')");
    }

	$xml = "<success>1</success>\n";

	return $xml;

}

?>