<?php

/** Copyright 2010 Tactical FLEX
 *
 * Aanval 5
 *
 * This program is owned and licensed by Tactical FLEX; it may be
 * redistributed only in its original configuration as originally
 * installed and available by Tactical FLEX and / or Aanval.
 *
 * To license and / or include this product in other forms or
 * applications, express prior written authorization must be
 * obtained by contract from authorized Tactical FLEX or Aanval agents.
 *
 * Tactical FLEX and Aanval may not be held liable nor responsible
 * for any and all issues arising from the use of, damages caused by, or 
 * conclusions drawn from the use of this product.
 *
 */

include "initialize.php";

function prv_syslogSensorData() {
    global $idsDB;

	$cnt = 0;

	$xml = "<document>\n";

	// Sensor list

	$q = $idsDB->query("select id as sid, source, type from idsSyslogModule order by sid");
	while ($row = mysql_fetch_array($q, MYSQL_ASSOC)) {

		$cnt++;

		$xml .= "\t<node>\n";

		if ($row["type"] == 2) {

			$row["sourceType"] = "Syslog File";
			
		} else {

			$row["sourceType"] = "idsSyslog.pl";

			$row["source"] = longToIP($row["source"]);
		
		}

		foreach ($row as $key => $val) {

			$xml .= "\t\t<$key><![CDATA[$val]]></$key>\n";
			
		}

		$q2 = $idsDB->query("SELECT id, name, description, location, timezone, os, intime, enabled FROM idsSensor where module = 2 and sid = '" . $row['sid'] . "'");
		while ($rowB = mysql_fetch_array($q2, MYSQL_ASSOC)) {
	
			if ($rowB["intime"]) {
				$rowB["intime"] = date("m.d.Y H:i:s", consoleTimeConversion($rowB["intime"]));
			} else {
				$rowB["intime"] = "null";
			}
	
			foreach ($rowB as $key => $val) {
	
				$xml .= "\t\t<$key><![CDATA[$val]]></$key>\n";
				
			}
	
		}

		$xml .= "\t</node>\n";
		
	}

	// Timezone list

	$xml .= "\t<timezone>\n";

    $idsQueryA = $idsDB->query("select id, name, zone from idsTimezones order by name");
    while (list($id, $name, $zone) = mysql_fetch_row($idsQueryA)) {

		$xml .= "\t\t<zonenode>\n";
		$xml .= "\t\t\t<id>$id</id>\n";
		$xml .= "\t\t\t<name><![CDATA[$name]]></name>\n";
		$xml .= "\t\t\t<zone>$zone</zone>\n";
		$xml .= "\t\t</zonenode>\n";

    }

	$xml .= "\t</timezone>\n";

	$xml .= "\t<total>$cnt</total>\n";
	
	$xml .= "</document>\n";

	return $xml;	
}

function prv_syslogSensorList() {
	global $idsDB;

	$cnt = 0;

	$xml = "<document>\n";

	$q = $idsDB->query("SELECT id, sid, name, description, location, timezone, os, intime FROM idsSensor where module = 2 and enabled = 1 order by id asc");
	while ($row = mysql_fetch_array($q, MYSQL_ASSOC)) {

		$cnt++;

		$xml .= "\t<node>\n";

		$row["intime"] = date("m.d.Y H:i:s", consoleTimeConversion($row["intime"]));

		foreach ($row as $key => $val) {

			$xml .= "\t\t<$key><![CDATA[$val]]></$key>\n";
			
		}

		$xml .= returnTimezoneXML($row["timezone"]);

		$xml .= "\t</node>\n";

	}

	$xml .= "\t<total>$cnt</total>\n";
	
	$xml .= "</document>\n";

	return $xml;	
}

function prv_syslogUserLists() {
	global $idsDB;

	$sid = sanitize("sid");
	if (!$sid) return;

	$q = $idsDB->query("SELECT id FROM idsUsers where sensors like '%,$sid,%' or sensors like '$sid' or sensors like '%,$sid' or sensors like '$sid,%'");
	while ($row = mysql_fetch_array($q, MYSQL_ASSOC)) {

		foreach ($row as $key => $val) {

			$userArray[] = $val;
			
		}
		
	}

	if (!$userArray) $userArray[] = 10101010;

	$xml = "<document>\n";

	$q = $idsDB->query("SELECT id, username FROM idsUsers where id not in (" . implode(",", $userArray) . ")");
	while ($row = mysql_fetch_array($q, MYSQL_ASSOC)) {

		$xml .= "\t<node1>\n";

		foreach ($row as $key => $val) {

			$xml .= "\t\t<$key><![CDATA[$val]]></$key>\n";
			
		}

		$xml .= "\t</node1>\n";
		
	}

	$q = $idsDB->query("SELECT id, username FROM idsUsers where sensors like '%,$sid,%' or sensors like '$sid' or sensors like '%,$sid' or sensors like '$sid,%'");
	while ($row = mysql_fetch_array($q, MYSQL_ASSOC)) {

		$xml .= "\t<node2>\n";

		foreach ($row as $key => $val) {

			$xml .= "\t\t<$key><![CDATA[$val]]></$key>\n";
			
		}

		$xml .= "\t</node2>\n";
		
	}

	$xml .= "</document>\n";

	return $xml;
}

function prv_syslogModuleUpdate() {
	global $idsDB;

	$id = sanitize("id");
	if (!$id) return;

	$name = sanitize("name");
	$description = sanitize("description");
	$location = sanitize("location");
	$os = sanitize("os");
	$timezone = sanitize("timezone");

	$idsDB->query("update idsSensor set name = '$name', description = '$description', location = '$location', os = '$os', timezone = '$timezone' where id = '$id'");
	
	$xml = "<success>1</success>\n";

	return $xml;
}

function prv_syslogModuleSettings() {
	global $idsDB;

	$xml = "<document>\n";

	$q = $idsDB->query("SELECT id, module, enabled FROM idsModules where id = '2'");
	while ($row = mysql_fetch_array($q, MYSQL_ASSOC)) {

		$xml .= "\t<node>\n";

		foreach ($row as $key => $val) {

			$xml .= "\t\t<$key><![CDATA[$val]]></$key>\n";
			
		}

		$xml .= "\t</node>\n";
		
	}

	$xml .= "</document>\n";

	return $xml;
}

function prv_syslogSensorCreate() {
	global $idsDB;

	$source = sanitize("source");
	if (!$source) return;
	
	$idsDB->query("insert into idsSyslogModule (source, type) values ('$source', '2')");

	$xml = "<success>1</success>\n";

	return $xml;

}

function prv_syslogSensorDelete() {
	global $idsDB;

	$sid = sanitize("sid");
	if (!$sid) return;
	
	$idsDB->query("DELETE FROM idsSensor WHERE sid = '$sid' AND module = '2'");
	$idsDB->query("DELETE FROM idsSyslogModule WHERE id = '$sid'");

	$xml = "<success>1</success>\n";

	return $xml;

}


function prv_syslogModuleSettingsUpdate() {
	global $idsDB;

	$module = sanitize("module");
	
	$idsDB->query("update idsModules set enabled = '$module' where id = '2'");

	$xml = "<success>1</success>\n";

	return $xml;

}

function prv_syslogSensorEnable() {
	global $idsDB;

	$sid = sanitize("sid");
	if (!$sid) return;

	$q = $idsDB->query("SELECT count(id) as cnt FROM idsSensor where module = 2 and enabled = 1");
	$row = mysql_fetch_array($q);

	if ((countUpperCaseArray("6")+countUpperCaseArray("7")+countUpperCaseArray("4")+countUpperCaseArray("5")+countUpperCaseArray("1")) == 0) { $useVar = 1; } else if (countUpperCaseArray("7") >= 1) { $useVar = time(); } else { $useVar = countUpperCaseArray("5")+countUpperCaseArray("1"); }
	if (($row["cnt"]+1) > $useVar) { $policy = 0; } else {

		$policy = 1;
	
		// Check if sid exists
		$q = $idsDB->query("SELECT id FROM idsSensor where sid = '$sid' and module = 2");
		if (mysql_num_rows($q) > 0) {
		
			$idsDB->query("update idsSensor set enabled = '1' where sid = '$sid' and module = 2");
		
		} else {
		
			$idsQueryA = $idsDB->query("select source from idsSyslogModule where id = '$sid' and type = 2");
			while (list($d_source) = mysql_fetch_row($idsQueryA)) {
				$source = $d_source;
			}

			$idsDB->query("insert into idsSensor (sid, name, enabled, module, path, timezone, intime) values ('$sid', 'Not Configured', '1', '2', '$source', '62', '" . time() . "')");
		
		}

	}
	
	$xml = "<document>\n";
	$xml .= "\t<node>\n";
	
	$xml .= "\t\t<success>1</success>\n";
	$xml .= "\t\t<policy>$policy</policy>\n";

	$xml .= "\t</node>\n";
	$xml .= "</document>\n";

	return $xml;
}

function prv_syslogSensorDisable() {
	global $idsDB;

	$id = sanitize("id");
	if (!$id) return;

	// Disable sensor
	$idsDB->query("update idsSensor set enabled = '0' where id = '$id' and module = '2'");

	removeSensorFromAllUsers($id);

	$xml = "<success>1</success>\n";

	return $xml;
}

function prv_syslogSensorUserEnable() {
	global $idsDB;

	$ids = sanitize("ids");
	if (!$ids) return;

	$sid = sanitize("sid");
	if (!$sid) return;

	$userArray = explode(",", $ids);
	
	foreach ($userArray as $id) {

		addSensorToUser($sid, $id);

	}
	
	$xml = "<success>1</success>\n";

	return $xml;
}

function prv_syslogSensorUserDisable() {
	global $idsDB;

	$ids = sanitize("ids");
	if (!$ids) return;

	$sid = sanitize("sid");
	if (!$sid) return;

	foreach (explode(",", $ids) as $id) {

		removeSensorFromUser($sid, $id);
	}
	
	$xml = "<success>1</success>\n";

	return $xml;
}

function prv_syslogFilterList() {
	global $idsDB;

	$cnt = 0;

	$xml = "<document>\n";

	$q = $idsDB->query("SELECT id, enabled, name, description, filter, sample FROM idsImportFilters where enabled = 1 order by id");
	while ($row = mysql_fetch_array($q, MYSQL_ASSOC)) {

		$cnt++;

		$xml .= "\t<node>\n";

		foreach ($row as $key => $val) {

			$xml .= "\t\t<$key><![CDATA[$val]]></$key>\n";
			
		}

		$xml .= "\t</node>\n";
		
	}

	$xml .= "\t<total>$cnt</total>\n";
	
	$xml .= "</document>\n";

	return $xml;	
}

function prv_syslogFiltersBySensor() {
	global $idsDB;

	$id = sanitize("id");
	if (!$id) return;

	$xml = "<document>\n";

	$q = $idsDB->query("SELECT * FROM idsSyslogModule where id = '$id'");
	while ($row = mysql_fetch_array($q, MYSQL_ASSOC)) {

		$xml .= "\t<node>\n";

		foreach ($row as $key => $val) {

			if (strstr($key, "f_")) {

				$xml .= "\t\t<$key>\n";
				
					$tmp = explode(",", $val);
					foreach ($tmp as $fil) {
					
						$xml .= "\t\t\t<filter>\n";
						
							$xml .= "\t\t\t\t<fid>$fil</fid>\n";
							$xml .= "\t\t\t\t<fname><![CDATA[$key]]></fname>\n";
							$xml .= "\t\t\t\t<name><![CDATA[" . syslogFilterNameByID($fil) . "]]></name>\n";
						
						$xml .= "\t\t\t</filter>\n";
					
					}
				
				$xml .= "\t\t</$key>\n";
			
			} else {
			
				$xml .= "\t\t<$key><![CDATA[$val]]></$key>\n";
				
			}
			
		}

		$xml .= "\t</node>\n";
		
	}

	$xml .= "</document>\n";

	return $xml;	
}

function prv_syslogFilterCreate() {
	global $idsDB;

	$name = sanitize("name");
	if (!$name) $name = "New Syslog Filter";

	$description = sanitize("description");
	if (!$description) $description = "No Description";

	$regex = addslashes(getVar("regex"));
	if (!$regex) $regex = "";

	$idsDB->query("insert into idsImportFilters (enabled, name, description, filter) values ('1', '$name', '$description', '$regex')");

	$xml = "<success>1</success>\n";

	return $xml;

}

function prv_syslogFilterUpdate() {
	global $idsDB;

	$id = sanitize("id");
	if (!$id) return;

	$name = sanitize("name");
	if (!$name) $name = "New Syslog Filter";

	$description = sanitize("description");
	if (!$description) $description = "No Description";

	$regex = addslashes(getVar("regex"));
	if (!$regex) $regex = "";

	$idsDB->query("update idsImportFilters set name = '$name', description = '$description', filter = '$regex' where id = '$id'");

	$xml = "<success>1</success>\n";

	return $xml;

}

function prv_syslogFilterDelete() {
	global $idsDB;

	$id = sanitize("id");
	if (!$id) return;

	$idsDB->query("delete from idsImportFilters where id = '$id'");

	$xml = "<success>1</success>\n";

	return $xml;

}

function prv_syslogFilterTest() {
	global $idsDB;

	$regex = getVar("regex");
	if (!$regex) return;

	$data = getVar("data");
	if (!$data) return;

	$result = filterGetResult($data, $regex);

	$xml = "<document>\n";

	$xml .= "<result><![CDATA[$result]]></result>\n";

	$xml .= "</document>\n";

	return $xml;

}

function prv_syslogAddFilter() {
	global $idsDB;
	
	$fid = sanitize("fid");
	$sid = sanitize("sensor");
	$type = sanitize("filter");
	
	$idsQueryA = $idsDB->query("select $type from idsSyslogModule where id = '$sid'");
	while (list($tbl_type) = mysql_fetch_row($idsQueryA)) {
		$filterList = $tbl_type;
	}
	
	$tmp = explode(",", $filterList);
	foreach ($tmp as $fil) {
		if ($fil == $fid) $exists = 1;
	}
	
	if (!$exists) {
	
		// Remove leading and trailing ,
		if (substr($filterList, 0, 1) == ",") $filterList = substr($filterList, 1);
		if (substr($filterList, -1, 1) == ",") $filterList = substr($filterList, 0, -1);
		
		$filterList = "$filterList,$fid";
		
		// Remove leading and trailing ,
		if (substr($filterList, 0, 1) == ",") $filterList = substr($filterList, 1);
		if (substr($filterList, -1, 1) == ",") $filterList = substr($filterList, 0, -1);

		$idsQueryA = $idsDB->query("update idsSyslogModule set $type = '$filterList' where id = '$sid'");
	}
	
	$xml = "<success>1</success>\n";

	return $xml;

}

function prv_syslogRemoveFilter() {
	global $idsDB;
	
	$fid = sanitize("fid");
	$sid = sanitize("sensor");
	$type = sanitize("filter");
	
	$idsQueryA = $idsDB->query("select $type from idsSyslogModule where id = '$sid'");
	while (list($tbl_type) = mysql_fetch_row($idsQueryA)) {
		$filterList = $tbl_type;
	}
	
	$tmp = explode(",", $filterList);
	foreach ($tmp as $fil) {
		if ($fil != $fid) {
		
			$newArray[] = $fil;
		
		}
	}

	$filterList = implode(",", $newArray);
	
	$idsQueryA = $idsDB->query("update idsSyslogModule set $type = '$filterList' where id = '$sid'");
	
	$xml = "<success>1</success>\n";

	return $xml;

}

?>

