<?php

/** Copyright 2009 Tactical FLEX
 *
 * Aanval 5
 *
 * This program is owned and licensed by Tactical FLEX; it may be
 * redistributed only in its original configuration as originally
 * installed and available by Tactical FLEX and / or Aanval.
 *
 * To license and / or include this product in other forms or
 * applications, express prior written authorization must be
 * obtained by contract from authorized Tactical FLEX or Aanval agents.
 *
 * Tactical FLEX and Aanval may not be held liable nor responsible
 * for any and all issues arising from the use of, damages caused by, or 
 * conclusions drawn from the use of this product.
 *
 */

include "initialize.php";

function prv_loadConsolePreferences() {
	global $idsDB;
	
	$xml = "<document>\n";
	$xml .= "\t<node>\n";

	$q = $idsDB->query("select var, val from idsOps");
	while ($row = mysql_fetch_assoc($q)) {

		$xml .= "\t\t\t<" . $row["var"] . "><![CDATA[" . $row["val"] . "]]></" . $row["var"] . ">\n";
		
		if ($row["var"] == "site_timezone") {
			$tz = $row["val"];
		}
	}

	$xml .= returnTimezoneXML($tz);

	$xml .= "\t</node>\n";
	$xml .= "</document>\n";
	
	return $xml;
}

function prv_updateConsolePreferences() {
	global $idsDB;

	ops("site_timezone", sanitize("consoletimezone"));

	ops("site_versionChecking", sanitize("versionchecking"));
	ops("site_proxyEnabled", sanitize("useproxy"));
	ops("site_sendmailEnabled", sanitize("usesendmail"));
	ops("site_permChecking", sanitize("permchecking"));
	ops("site_emailFloodProtection", sanitize("floodprotection"));

	ops("site_hostnameLookups", sanitize("hostnamelookups"));
	ops("site_hostnameRunLimit", sanitize("hostrun"));

	ops("site_wget_path", sanitize("wgetpath"));
	ops("site_proxyHost", sanitize("proxyhost"));
	ops("site_proxyPort", sanitize("proxyport"));
	ops("site_proxyUsername", sanitize("proxyusername"));
	ops("site_proxyPassword", sanitize("proxypassword"));
	
	ops("site_sendmailLocal", sanitize("sendmailbinary"));
	ops("site_emailFloodLimit", sanitize("floodthreshold"));

	ops("site_reportDisplayRows", sanitize("reportrows"));

	ops("site_processorEventRun", sanitize("eventrun"));
	ops("site_processorIndexRun", sanitize("indexrun"));

	ops("site_bpuIndexStart", sanitize("indexhourstart"));
	ops("site_bpuIndexEnd", sanitize("indexhourend"));

	ops("site_bpuIterationA", sanitize("aiterations"));
	ops("site_bpuIterationB", sanitize("biterations"));
	ops("site_bpuIterationC", sanitize("citerations"));
	ops("site_bpuIterationD", sanitize("diterations"));
	ops("site_bpuIterationE", sanitize("eiterations"));

	ops("site_bpusleepA", sanitize("asleep"));
	ops("site_bpusleepB", sanitize("bsleep"));
	ops("site_bpusleepC", sanitize("csleep"));
	ops("site_bpusleepD", sanitize("dsleep"));
	ops("site_bpusleepE", sanitize("esleep"));

	$xml = "<document>\n";
	$xml .= "\t<success>1</success>\n";
	$xml .= "</document>\n";
	
	return $xml;

}

function prv_brandOptions() {
	global $idsDB;

	$optionsArray = Array("'site_brandLicense'", "'site_consoleName'", "'site_consoleDescription'", "'site_mainURL'", "'site_poweredBy'", "'site_loginLegalText'", "'site_loginMainImage'", "'site_reportLogoA'");

	$xml = "<document>\n";
	
	$xml .= "\t<options>\n";

	$q = $idsDB->query("SELECT var, val FROM idsOps WHERE var IN (" . implode(",", $optionsArray) . ")");
	while ($row = mysql_fetch_assoc($q)) {

		$xml .= "\t\t<option>\n";

		$xml .= "\t\t\t<name><![CDATA[" . $row["var"] . "]]></name>\n";
		$xml .= "\t\t\t<value><![CDATA[" . $row["val"] . "]]></value>\n";

		$xml .= "\t\t</option>\n";
		
	}

	$xml .= "\t</options>\n";

	$xml .= "</document>\n";

	return $xml;
}

function prv_brandOptionsUpdate() {
	global $idsDB;

	$name = sanitize("name");
	if (!$name) return;

	$value = sanitize("value");

	$idsDB->query("UPDATE idsOps SET val = '$value' WHERE var = '$name'");
	
	$xml = "<document>\n";

	$xml .= "<success>1</success>\n";

	$xml .= "</document>\n";

	return $xml;
}

?>

