<?php

/** Copyright 2009 Tactical FLEX
 *
 * Aanval 5
 *
 * This program is owned and licensed by Tactical FLEX; it may be
 * redistributed only in its original configuration as originally
 * installed and available by Tactical FLEX and / or Aanval.
 *
 * To license and / or include this product in other forms or
 * applications, express prior written authorization must be
 * obtained by contract from authorized Tactical FLEX or Aanval agents.
 *
 * Tactical FLEX and Aanval may not be held liable nor responsible
 * for any and all issues arising from the use of, damages caused by, or 
 * conclusions drawn from the use of this product.
 *
 */

include "initialize.php";

function prv_checkVersionMessage() {
	global $idsDB;
	
	$version = @file("../../version/version.txt");
	$currentMajor = trim($version[0]);
	$currentMinor = trim($version[1]);
	$currentName = trim($version[2]);
	$currentBuild = trim($version[3]);

	$version = @file("../../version/ver");
	$newMajor = trim($version[0]);
	$newMinor = trim($version[1]);
	$newName = trim($version[2]);
	$newBuild = trim($version[3]);

	$xml = "<document>\n";
	$xml .= "\t<node>\n";
	
	if ($newBuild > $currentBuild) {
	
		$xml .= "\t\t<version>1</version>\n";
		$xml .= "\t\t<message>New Version Available</message>\n";
		$xml .= "\t\t<details>v$newMajor.$newMinor ($newBuild) - $newName</details>\n";
	
	
	} else {

		$xml .= "\t\t<version>0</version>\n";
	
	}

	$xml .= "\t</node>\n";
	$xml .= "</document>\n";

	return $xml;
	
}

function prv_forceUpdateNow() {

	ops("site_versionUpdateNow", "1");

	$xml = "<document>\n";
	$xml .= "\t<success>1</success>\n";
	$xml .= "</document>\n";

	return $xml;
}

function prv_upgradeReadyCheck() {

	$xml = "<document>\n";
	
	$xml .= "\t<upgrading>" . 	ops("site_versionUpdateNow") . "</upgrading>\n";
	
	if (file_exists("../../installation/upgrade")) {

		$xml .= "\t<ready>1</ready>\n";

	} else {

		$xml .= "\t<ready>0</ready>\n";
	
	}
	
	$xml .= "</document>\n";

	return $xml;
}

function prv_versionData() {

	$version = @file("../../version/version.txt");
	
	$major = trim($version[0]);
	$minor = trim($version[1]);
	$name = trim($version[2]);
	$build = trim($version[3]);
	
	$xml = "<document>\n";
	$xml .= "\t<node>\n";

	$xml .= "\t\t<major>$major</major>\n";
	$xml .= "\t\t<minor>$minor</minor>\n";
	$xml .= "\t\t<name>$name</name>\n";
	$xml .= "\t\t<build>$build</build>\n";

	$version = @file("../../version/ver");
	$newMajor = trim($version[0]);
	$newMinor = trim($version[1]);
	$newName = trim($version[2]);
	$newBuild = trim($version[3]);

	if ($newBuild > $build) {

		$xml .= "\t\t<newVersion>1</newVersion>\n";
		$xml .= "\t\t<newMajor>$newMajor</newMajor>\n";
		$xml .= "\t\t<newMinor>$newMinor</newMinor>\n";
		$xml .= "\t\t<newName>$newName</newName>\n";
		$xml .= "\t\t<newBuild>$newBuild</newBuild>\n";
	
	} else {

		$xml .= "\t\t<newVersion>0</newVersion>\n";
		$xml .= "\t\t<newMajor>$major</newMajor>\n";
		$xml .= "\t\t<newMinor>$minor</newMinor>\n";
		$xml .= "\t\t<newName>$name</newName>\n";
		$xml .= "\t\t<newBuild>$build</newBuild>\n";

	}
	
	$xml .= "\t\t<generalText>Thank you for using " . ops("site_consoleName") . "!\n\nCopyright 2010, All Rights Reserved</generalText>\n";
	
	$xml .= "\t</node>\n";
	
	$xml .= "</document>\n";

	return $xml;	
}

?>
