<?php

/** Copyright 2009 Tactical FLEX
 *
 * Aanval 5
 *
 * This program is owned and licensed by Tactical FLEX; it may be
 * redistributed only in its original configuration as originally
 * installed and available by Tactical FLEX and / or Aanval.
 *
 * To license and / or include this product in other forms or
 * applications, express prior written authorization must be
 * obtained by contract from authorized Tactical FLEX or Aanval agents.
 *
 * Tactical FLEX and Aanval may not be held liable nor responsible
 * for any and all issues arising from the use of, damages caused by, or 
 * conclusions drawn from the use of this product.
 *
 */
 
// Set to HTML format prior to initializing (prevents XML heading from returning)
$_GET["format"] = 2; 
 
include "initialize.php";

function pub_checkMessages() {
	global $idsDB;

	// Returns the next waiting message in order

    $id = sanitize("id");

    if (!$id) {

    	$out = "Sensor management identification was not received. Exiting.";
    	
    } else {
    
    	if (verifySMTID($id) != 1) {
    	
	    	$out = "Sensor management identification failure. Exiting.";
    	
    	} else {
    	
    		// Function content
    		
			commonOperations($id);
    		
    		heartbeatUpdate($id);
    		
    		$out = sensorMessage($id);
    		
    	}
    	
    }

	if (!$out) $out = 1;

	return $out;
	
}

function pub_snortStatus() {
	global $idsDB;

	// Updates status of snort process from smt

    $id = sanitize("id");
    $data = sanitize("data");

    if (!$id) {
    
    	$out = "Sensor management identification was not received. Exiting.";
    	
    } else {
    
    	if (verifySMTID($id) != 1) {
    	
	    	$out = "Sensor management identification failure. Exiting.";
    	
    	} else {
    	
    		// Function content
    		
			commonOperations($id);
    		
    		heartbeatUpdate($id);
    	
			if ($data == 1) {
			
				$idsDB->query("update idsSensor set status = '1', lastStatusCheck = '" . time() . "', countStatusFailure = '0' where smtid = '$id'");
				
			} else {
			
				$idsDB->query("update idsSensor set status = '0', lastStatusCheck = '" . time() . "', countStatusFailure = (countStatusFailure + 1) where smtid = '$id'");
				
			}

    	}
    
    }

	if (!$out) $out = 1;

	return $out;
	
}

function pub_sensorUptime() {
	global $idsDB;

	// Receives uptime from smt

    $id = sanitize("id");
    $data = sanitize("data");

    if (!$id) {

    	$out = "Sensor management identification was not received. Exiting.";
    	
    } else {
    
    	if (verifySMTID($id) != 1) {
    	
	    	$out = "Sensor management identification failure. Exiting.";
    	
    	} else {
    	
    		// Function content
    		
    		heartbeatUpdate($id);
    		
    	}
    	
    }

	if (!$out) $out = 1;

	return $out;

}

function pub_sendConf() {
	global $idsDB;

	// Receives and saves snort conf from smt

    $id = sanitize("id");
    $file = sanitize("file");
    $data = getVar("data");

    if (!$id) {

    	$out = "Sensor management identification was not received. Exiting.";
    	
    } else {
    
    	if (verifySMTID($id) != 1) {
    	
	    	$out = "Sensor management identification failure. Exiting.";
    	
    	} else {
    	
    		// Function content
    		
    		heartbeatUpdate($id);
    		
	        if ($fp = @fopen("../../smt/sensorData/$id/$file", "w")) {
	
	        	fputs ($fp, urlBase64_decode($data));
	
	            fclose($fp);
	
				$idsDB->query("update idsSensor set confFile = '$file' where smtid = '$id'");
				
	        } else {
	        
				errorLog("File: '../../smt/sensorData/$id/$file' could not be opened for writing");
	        
	        }
    		
    	}
    	
    }

	if (!$out) $out = 1;

	return $out;
	
}

function pub_getConf() {
	global $idsDB;

	// Sends snort conf to smt

    $id = sanitize("id");

    if (!$id) {

    	$out = "Sensor management identification was not received. Exiting.";
    	
    } else {
    
    	if (verifySMTID($id) != 1) {
    	
	    	$out = "Sensor management identification failure. Exiting.";
    	
    	} else {
    	
    		// Function content
    		
    		heartbeatUpdate($id);
    		
	        $idsQueryA = $idsDB->query("select confFile from idsSensor where smtid = '$id'");
			for ($i = 0; $row = mysql_fetch_row($idsQueryA); $i++) {
				$confFile = $row[0];
			}
	    	
	        $data = @file_get_contents("../../smt/sensorData/$id/$confFile");
	        
	        if ($data) {
	        
		        $out = urlBase64_encode($data);
		        
	        } else {
	        
	        	$out = 0;
	        	
	        }
    		
    	}
    	
    }

	if (!$out) $out = 1;

	return $out;

}

function pub_sendRule() {
	global $idsDB;

	// Receives and saves snort rule from smt

    $id = sanitize("id");
    $file = sanitize("file");
    $data = getVar("data");

    if (!$id) {

    	$out = "Sensor management identification was not received. Exiting.";
    	
    } else {
    
    	if (verifySMTID($id) != 1) {
    	
	    	$out = "Sensor management identification failure. Exiting.";
    	
    	} else {
    	
    		// Function content
    		
    		heartbeatUpdate($id);
    		
			if (!file_exists("../../smt/snortRules/smt-$id")) {
				@mkdir("../../smt/snortRules/smt-$id");
				@mkdir("../../smt/snortRules/smt-$id/rules");
			}
	
			// Write snort rules to package directory
	        if ($fp = @fopen("../../smt/snortRules/smt-$id/rules/$file", "w")) {
	
	        	fputs ($fp, urlBase64_decode($data));
	
	        	// Close file handle
	            fclose($fp);
	            
	        } else {
	        
				errorLog("File: '../../smt/snortRules/smt-$id/rules/$file' could not be opened for writing");
	        
	        }
	
			// Create and store policy file
			
			$ruleFile = @file("../../smt/snortRules/smt-$id/rules/$file");
			
			foreach ($ruleFile as $line) {
	
				if (strstr($line, "alert") && strstr($line, "sid:")) {
				
					preg_match("/sid:[ ]*[0-9]+/", $line, $match);
					$sid = trim(str_replace("sid:", "", $match[0]));
	
					if (strstr(substr($line, 0, 5), "#")) continue;				
			
					$array[] = $sid;		
				}
			}
			
			if ($array) {
	
				storeRuleData("smt-$id", $id, $file, $array);
	
			}
		    		
    	}
    	
    }

	if (!$out) $out = 1;

	return $out;

}

function pub_getRules() {
	global $idsDB;

	// Sends list of rule files to smt

    $id = sanitize("id");

    if (!$id) {

    	$out = "Sensor management identification was not received. Exiting.";
    	
    } else {
    
    	if (verifySMTID($id) != 1) {
    	
	    	$out = "Sensor management identification failure. Exiting.";
    	
    	} else {
    	
    		// Function content
    		
    		heartbeatUpdate($id);
    		
	        $q = $idsDB->query("SELECT confFile, confPolicy FROM idsSensor WHERE smtid = '$id'");
			while ($row = mysql_fetch_assoc($q)) {
			
				$confFile = $row["confFile"];
				$policy = $row["confPolicy"];
				
			}    	
	    	
	        if ($rulesDir = @dir("../../smt/policyData/$policy/")) {

		        while ($file = $rulesDir->read()) {
		            if ($file != "." && $file != ".." && $file != "$confFile") {
		            
		                $out .= "$file\n";
		                
		            }
		        }

	        } else {
	        
	        	$out = 0;
	        
	        }
	        
    	}
    	
    }

	if (!$out) $out = 1;

	return $out;

}

function pub_getRule() {
	global $idsDB;

	// Sends rule file to smt

    $id = sanitize("id");
    $rule = sanitize("rule");

    if (!$id) {

    	$out = "Sensor management identification was not received. Exiting.";
    	
    } else {
    
    	if (verifySMTID($id) != 1) {
    	
	    	$out = "Sensor management identification failure. Exiting.";
    	
    	} else {
    	
    		// Function content
    		
    		heartbeatUpdate($id);
    		
    		$policy = getPolicyBySMTID($id);
    		
	        $data = file_get_contents("../../smt/policyData/$policy/$rule");
	        
	        $out = urlBase64_encode($data);
    		
    	}
    	
    }

	if (!$out) $out = 1;

	return $out;
	
}

function pub_SMTUpdate() {
	global $idsDB;

	// Sends smt.php to smt

    $id = sanitize("id");
    $rule = sanitize("rule");

    if (!$id) {

    	$out = "Sensor management identification was not received. Exiting.";
    	
    } else {
    
    	if (verifySMTID($id) != 1) {
    	
	    	$out = "Sensor management identification failure. Exiting.";
    	
    	} else {
    	
    		// Function content
    		
    		heartbeatUpdate($id);
    		
	        $data = file_get_contents("../../contrib/smt/smt.php");
	        
	        $out = urlBase64_encode($data);
    		
    	}
    	
    }

	if (!$out) $out = 1;

	return $out;

}

function verifySMTID($id) {
	global $idsDB;

	$q = $idsDB->query("SELECT id FROM idsSensor WHERE smtid = '$id'");
	while ($row = mysql_fetch_assoc($q)) {
	
		return 1;
		
	}
	
	return 0;
	
}

function getPolicyBySMTID($id) {
	global $idsDB;

	$q = $idsDB->query("SELECT confPolicy FROM idsSensor WHERE smtid = '$id'");
	while ($row = mysql_fetch_assoc($q)) {
		
		$policy = $row["confPolicy"];
		
	}
	
	if (!$policy) {
	
		return 0;
	
	} else {

		return $policy;
	
	}
	
	
}

function commonOperations($id) {

	// If the direction we are looking for is actually a file then unlink it
	if (@is_file("../../smt/sensorData/$id")) @unlink("../../smt/sensorData/$id");
	
	// Create SMT ID directory
    @mkdir("../../smt/sensorData/$id");

}

function heartbeatUpdate($id) {
	global $idsDB;

	$idsDB->query("UPDATE idsSensor SET hb = '" . time() . "', hbcount = (hbcount + 1) WHERE smtid = '$id'");

}

function sensorMessage($smtid) {
    global $idsDB;

    $idsQueryA = $idsDB->query("SELECT id FROM idsSensor WHERE smtid = '$smtid' AND enabled = 1 AND module = 1");
    while (list($d_sid) = mysql_fetch_row($idsQueryA)) {
        $sid = $d_sid;
    }

    if (!$sid) return;

    $idsQueryA = $idsDB->query("SELECT id, message FROM idsSensorManageMessages WHERE sid = '$sid' AND enabled = 1 ORDER BY issued LIMIT 1");
    while (list($d_id, $d_message) = mysql_fetch_row($idsQueryA)) {
        $id = $d_id;
        $message = $d_message;
    }

    if ($message) {
        $idsQueryA = $idsDB->query("UPDATE idsSensorManageMessages SET enabled = 0, received = '" . time() . "' WHERE id = '$id'");
    } else {
        $message = "SNORTSTATUS";
    }

    return "MSG::" . $message;
}

function urlBase64_decode($string) {
 
	$string = str_replace('-', '+', $string);
	$string = str_replace('_', '/', $string);
	$string = str_replace('.', '=', $string);

	return base64_decode($string);
}

function urlBase64_encode($string) {

	$string = base64_encode($string);
	$string = str_replace('+', '-', $string);
	$string = str_replace('/', '_', $string);
	$string = str_replace('=', '.', $string);

	return $string;
}

?>