<?php

/** Copyright 2010 Tactical FLEX
 *
 * Aanval 5
 *
 * This program is owned and licensed by Tactical FLEX; it may be
 * redistributed only in its original configuration as originally
 * installed and available by Tactical FLEX and / or Aanval.
 *
 * To license and / or include this product in other forms or
 * applications, express prior written authorization must be
 * obtained by contract from authorized Tactical FLEX or Aanval agents.
 *
 * Tactical FLEX and Aanval may not be held liable nor responsible
 * for any and all issues arising from the use of, damages caused by, or 
 * conclusions drawn from the use of this product.
 *
 */

$version = "5.0";
$globalError = 0;

// Sets
error_reporting(E_ALL ^ E_NOTICE);
ini_set("memory_limit", -1);
ini_set("display_errors", 1);
set_time_limit(2000);

if (!include("conf.php")) {
	echo "ERROR - Could not access conf.php. Ensure it is in the local directory and / or 'open_basedir' is disabled in your php.ini\n\n";
}

mainApp();

function mainApp() {
	global $version, $protocol, $consoleHost, $consoleHostPath, $id, $logging, $logfile, $globalError;

    echo "Aanval - Sensor Management Tools - v.$version\n---\n";
	smtLog("<----- SMT run started [v.$version] ----->");

    if (strtoupper($protocol) == "HTTPS") {
	    echo "* Using HTTPS > If you experience problems, please try http\n";
    }
    
    if ($logging == 0) {
    	echo "* Logging disabled\n";
    } else {
    	echo "* Logging Enabled: $logfile\n";
    }
    
    echo "* Connection URL: $protocol://$consoleHost$consoleHostPath/console/ws/smt_sensor.php?op=pub_checkMessages&id=$id\n* Sensor Management ID: $id (must match sensor settings in console)\n---\n\n";
	smtLog("Connection URL: $protocol://$consoleHost$consoleHostPath/console/ws/smt_sensor.php?op=pub_checkMessages&id=$id");

    if (errorChecking() == 0) $globalError = 1;
    
    if ($globalError == 0) {
    
		$res = file_get_contents("$protocol://$consoleHost$consoleHostPath/console/ws/smt_sensor.php?op=pub_checkMessages&id=$id");
	
		if ($res) {
		
			processMessage($res);
			
		} else {
		
			echo "ERROR - Connection to console failed. Check host and host path settings within your conf.php\n";
			smtLog("ERROR - Connection to console failed. Check host and host path settings within your conf.php");
			smtLog("ERROR - Additional help: Paste the \"Connection URL\" into browser and check for errors (in php logs too)");
			$globalError = 1;
			
		}
    }

    if ($globalError == 1) {
		echo "\n---\nFail => Error detected. See messages above.\n\n";
		smtLog("SMT run ended with errors");
    } else {
		echo "\n---\nSuccess => SMT's appear to be functioning properly.\n\n";
		smtLog("SMT run ended successfully");
    }
}

function processMessage($res) {
	
	$resArray = explode("::", trim($res));
	$res = $resArray[1];
	
	if ($res == "") {
	
		$rmsg = "(ERROR: nothing returned. Check settings, php and webserver logs)";
		
		smtLog("ERROR - Unable to retrieve sensor messages from console");
		smtLog("ERROR - Additional help: Make sure the SMT ID in conf.php matches sensor configuration in console");
		smtLog("ERROR - Additional help: Paste the \"Connection URL\" into browser and check for errors (in php logs too)");
		
		$globalError = 1;

		echo "SMT: Message from console: [$res] $rmsg\n";
		
	} else {
	
		echo "SMT: Message from console: [$res] (0 is okay)\n";
		
	}

	smtLog("Message from console: $res");
	
	executeMessage($res);
}

function executeMessage($res) {
	global $protocol, $consoleHost, $consoleHostPath, $id, $confSnort, $rulesSnort, $sensorDataPath, $cmdSnortStatus, $cmdSnortStart, $cmdSnortStop, $cmdSnortReload, $cmdUptime, $logging;
	
	if ($res == "SNORTRESTART") {
		
		$tmp = exec("$cmdSnortStop > /dev/null 2>&1 &", $data);
		smtLog("Snort Stop Command Executed: $cmdSnortStop");
		sleep(5);
        $tmp = exec("$cmdSnortStart > /dev/null 2>&1 &", $data);
		smtLog("Snort Start Command Executed: $cmdSnortStart");
		
	} else if ($res == "SNORTSTOP") {
        
		$tmp = exec("$cmdSnortStop > /dev/null 2>&1 &", $data);
		smtLog("Snort Stop Command Executed: $cmdSnortStop");
		
	} else if ($res == "SNORTSTART") {
        
		$tmp = exec("$cmdSnortStart > /dev/null 2>&1 &", $data);
		smtLog("Snort Start Command Executed: $cmdSnortStart");

	} else if ($res == "SNORTRELOAD") {
        
		$tmp = exec("$cmdSnortReload > /dev/null 2>&1 &", $data);
		smtLog("Snort Reload Command Executed: $cmdSnortReload");
		
    } else if ($res == "UPTIME") {

    	$tmp = exec($cmdUptime, $return);
		$data = urlBase64_encode($return[0]);
		$tmp = file_get_contents("$protocol://$consoleHost$consoleHostPath/console/ws/smt_sensor.php?op=pub_sensorUptime&id=$id&data=$data");
        
    } else if ($res == "SNORTCONFGET") {

    	$confData = file_get_contents($confSnort);
    	$postData = "op=pub_sendConf&id=$id&file=" . basename($confSnort) . "&data=" . urlBase64_encode($confData);
		sendToHost($consoleHost, "$consoleHostPath/console/ws/smt_sensor.php", $postData, 0);		
		
    } else if ($res == "SNORTCONFSEND") {
        
		$tmp = file_get_contents("$protocol://$consoleHost$consoleHostPath/console/ws/smt_sensor.php?op=pub_getConf&id=$id");
		if (!empty($tmp)) {
	        // Open File For Write
	        if ($fp = @fopen($confSnort, "w")) {
	        	fputs ($fp, urlBase64_decode($tmp));
	            fclose($fp);
	        }  
		}
		
    } else if ($res == "SNORTRULESGET") {

        if (!$rules = @dir("$rulesSnort")) {
            echo "ERROR - Could not locate rules (Check to ensure directories are correct in conf.php)";
            exit;
        }
        
        while ($fileTmp = $rules->read()) {
            if ($fileTmp != "." && $fileTmp != ".." && $fileTmp != basename($confSnort)) {
                $files[] = $fileTmp;
            }
        }
        		
		foreach($files as $file) {
	    	$ruleData = file_get_contents("$rulesSnort/$file");
	    	$postData = "op=pub_sendRule&id=$id&file=$file&data=" . urlBase64_encode($ruleData);
			sendToHost($consoleHost, "$consoleHostPath/console/ws/smt_sensor.php", $postData, 0);			

// Not sure!?
//			$tmp = file_get_contents("$protocol://$consoleHost$consoleHostPath/console/ws/smt_sensor.php?id=$id");

			unset($tmp);
		}
                		
    } else if ($res == "SNORTRULESSEND") {

		$tmp = file_get_contents("$protocol://$consoleHost$consoleHostPath/console/ws/smt_sensor.php?op=pub_getRules&id=$id");

        if ($tmp) {
    		$ruleList = explode("\n", $tmp);
		}

		foreach($ruleList as $rule) {
			$tmp = file_get_contents("$protocol://$consoleHost$consoleHostPath/console/ws/smt_sensor.php?op=pub_getRule&id=$id&rule=$rule");
			if (!empty($tmp)) {
		        // Open File For Write
		        if ($fp = @fopen("$rulesSnort/$rule", "w")) {
		        	fputs ($fp, urlBase64_decode($tmp));
		            fclose($fp);
		        }  
			}	
			
// Not sure!?
//			$tmp = file_get_contents("$protocol://$consoleHost$consoleHostPath/console/ws/smt_sensor.php?id=$id");
			unset($tmp);
		}
        
    } else if ($res == "SENSORUPDATE") {
    	
		$tmp = file_get_contents("$protocol://$consoleHost$consoleHostPath/console/ws/smt_sensor.php?op=pub_SMTUpdate&id=$id");
        if ($tmp) {
	        if ($fp = @fopen("$sensorDataPath/smt.php.NEW", "w")) {
	        	fputs ($fp, urlBase64_decode($tmp));
	            fclose($fp);
	        } 
        }
        
    } else if ($res == "SNORTSTATUS") {
    	
		$tmp = exec("$cmdSnortStatus", $data);
		
		if ($data) {
		
			echo "SMT: Snort Process Found\n";
			smtLog("Status Results: Snort Process Found");			
			$status = 1;
			
		} else {
		
			echo "SMT: Snort Process NOT Found\n";
			smtLog("Status Results: Snort Process NOT Found");
			smtLog("Status Command Executed: $cmdSnortStatus");
			$status = 0;
		}
		
		$tmp = file_get_contents("$protocol://$consoleHost$consoleHostPath/console/ws/smt_sensor.php?op=pub_snortStatus&id=$id&data=$status");
		
    }
	
}

function errorChecking() {
	global $version, $protocol, $consoleHost, $consoleHostPath, $id, $logging;

    if (!$protocol) {
    	$msg = "ERROR - Protocol variable in configuration file is not set";
    	echo "$msg";
		smtLog("$msg");
    	return 0;
    }
    if (!$consoleHost) {
    	$msg = "ERROR - Console Host variable in configuration file is not set";
    	echo "$msg";
		smtLog("$msg");
    	return 0;
    }
    if (!$consoleHostPath) {
    	$msg = "ERROR - Console Host Path variable in configuration file is not set";
    	echo "$msg";
		smtLog("$msg");
    	return 0;
    }
    if (!$id) {
    	$msg = "ERROR - SMT ID variable in configuration file is not set";
    	echo "$msg";
		smtLog("$msg");
    	return 0;
    }	

    return 1;
}

function sendToHost($host, $path, $data, $useragent = 0) {
	global $protocol, $logging;
	
	$method = "POST";
	
	if ($protocol == "HTTPS" || $protocol == "https") {
		$port = 443;
		$ssl = "ssl://";
	} else {
		$port = 80;
	}
	
	if (strstr($host, "@")) {

		$tmpa = explode("@", $host);
		$tmpb = explode(":", $tmpa[0]);
		$host = $tmpa[1];
		$user = $tmpb[0];
		$pass = $tmpb[1];
	
		$authString = "Authorization: Basic " . base64_encode("$user:$pass") . "\r\n";

	}

    $fp = fsockopen($ssl . $host, $port, $errno, $errstr, 30);

    fputs($fp, "$method $path HTTP/1.1\r\n");
    fputs($fp, "Host: $host\r\n");

    if ($authString) fputs($fp, "$authString");
	
    fputs($fp,"Content-type: application/x-www-form-urlencoded\r\n");
    fputs($fp, "Content-length: " . strlen($data) . "\r\n");
    if ($useragent) {
       @fputs($fp, "User-Agent: MSIE\r\n");
    }
    fputs($fp, "Connection: close\r\n\r\n");
    if ($method == 'POST') {
       @fputs($fp, $data);
    }

    while (!feof($fp)) {
        $buf .= @fgets($fp,128);
    }
    fclose($fp);
    
    return $buf;
}

function smtLog($data) {
	global $logging, $logfile, $id;
	
	if ($logging == 0) return;

	$timestamp = date("d-m-Y H:i:s");
	
	$fh = fopen("$logfile", "a");
	fputs($fh, "$timestamp $id $data\n");
    fclose($fh);
}

function urlBase64_decode($string) {
  
	$string = str_replace( '-', '+', $string );
	$string = str_replace( '_', '/', $string );
	$string = str_replace( '.', '=', $string );
	
	return base64_decode($string);
}

function urlBase64_encode($string) {

	$string = base64_encode($string);
	$string = str_replace( '+', '-', $string );
	$string = str_replace( '/', '_', $string );
	$string = str_replace( '=', '.', $string );
	
	return $string;
}

?>