<?php

/** Copyright 2010 Tactical FLEX
 *
 * Aanval 5
 *
 * This program is owned and licensed by Tactical FLEX; it may be
 * redistributed only in its original configuration as originally
 * installed and available by Tactical FLEX and / or Aanval.
 *
 * To license and / or include this product in other forms or
 * applications, express prior written authorization must be
 * obtained by contract from authorized Tactical FLEX or Aanval agents.
 *
 * Tactical FLEX and Aanval may not be held liable nor responsible
 * for any and all issues arising from the use of, damages caused by, or 
 * conclusions drawn from the use of this product.
 *
 */

#####

// PHP Module test

foreach (array("session", "mysql", "pcre") as $module) {

	if (!extension_loaded($module)) {
	
		$fail = true;
		$noMod[] = $module;
	
	}

}

// PHP Safe Mode test

if ((bool) ini_get('safe_mode') == true) {

	$fail = true;
	$safeMode = true;

}

// PHP GD Module test

if (!extension_loaded("gd")) {

	$fail = true;
	$noGD = true;

}

// GPC Magic Quotes test

if ((bool) ini_get('magic_quotes_gpc') == true) {

	$fail = true;
	$magicGPC = true;

}

// Runtime Magic Quotes test

if ((bool) ini_get('magic_quotes_runtime') == true) {

	$fail = true;
	$magicRuntime = true;

}

// PHP Memory Limit test

$mem = ini_get('memory_limit');

if ($mem != "-1") {

	$unit = strtolower(substr($mem, strlen($mem / 1), 1));

	$val = (int) $mem;

	if ($unit == "m") {

		if ($val < 64) {
		
			$fail = true;
			$memoryLimit = $mem;
			
		}
	
	}

}

#####

if (!$fail) {

	if ($install) {

		// Install
	
#		header('Location: installation/install/install.html');
	
	} else if ($upgrade) {
	
		// Upgrade
	
#		header('Location: installation/upgrade/upgrade.html');
	
	} else {

		// Run

		header('Location: console/index.html');
	
	}

} else {

	// Fail
	$out .= "<html><body bgcolor=\"#EDECE8\">";
	$out .= "<b>Aanval Snort & Syslog Intrusion Detection and Correlation Console</b><br>";
	$out .= "<a href=\"http://www.aanval.com\">www.aanval.com</a><br>";
	$out .= "<hr size=\"1\" width=\"100%\">";
	$out .= "<br>";
	
	$out .= "Unfortunately, one or more errors have been detected in your current environment that may interfere with operation or prevent the console from functioning properly.";
	$out .= "<p>";
	$out .= "Please review the information provided below and take the appropriate steps for resolution.<br>";
	$out .= "<br>";
	$out .= "<hr size=\"1\" width=\"100%\">";
	$out .= "<br>";
	$out .= "[ <a href=\"\">Check Again</a> ]";
	$out .= "<p>";

	if (count($noMod) > 0) {
	
		$out .= "<div style=\"background-color:#D1C6B3; width:100%; border:1px solid #D1C6B3;\">";
		$out .= "<b>ERROR: One or more required PHP modules were not found</b>";
		$out .= "</div>";
		$out .= "<div style=\"background-color:#DEDEDE; width:100%; border:1px solid #D1C6B3;\">";
		$out .= "<br>";
		$out .= "The following PHP modules / extensions are required:<p>";
		$out .= "" . implode("<br>", $noMod) . "";
		$out .= "<p>";
		$out .= "Please install the listed module(s) and restart your web server to continue.<p>";
		$out .= "</div>";
		
		$out .= "<p>";
	
	}

	if (count($noGD) > 0) {
	
		$out .= "<div style=\"background-color:#D1C6B3; width:100%; border:1px solid #D1C6B3;\">";
		$out .= "<b>ERROR: The PHP module 'GD' was not found</b>";
		$out .= "</div>";
		$out .= "<div style=\"background-color:#DEDEDE; width:100%; border:1px solid #D1C6B3;\">";
		$out .= "<br>";
		$out .= "The PHP module / extension 'GD' is required if you will be using the PDF and imaging features of the console.";
		$out .= "<p>";
		$out .= "Please install the 'GD' module and restart your web server to disable this warning.<p>";
		$out .= "</div>";
		
		$out .= "<p>";
	
	}

	if ($safeMode == true) {
	
		$out .= "<div style=\"background-color:#D1C6B3; width:100%; border:1px solid #D1C6B3;\">";
		$out .= "<b>ERROR: PHP Safe Mode is enabled</b>";
		$out .= "</div>";
		$out .= "<div style=\"background-color:#DEDEDE; width:100%; border:1px solid #D1C6B3;\">";
		$out .= "<br>";
		$out .= "PHP Safe Mode is not supported, please disable this PHP configuration option.<p>";
		$out .= "Please update your php.ini and restart your web server to continue.<p>";
		$out .= "</div>";
		
		$out .= "<p>";
	
	}

	if ($magicGPC == true) {
	
		$out .= "<div style=\"background-color:#D1C6B3; width:100%; border:1px solid #D1C6B3;\">";
		$out .= "<b>ERROR: Magic quotes for get, post and cookie data is enabled</b>";
		$out .= "</div>";
		$out .= "<div style=\"background-color:#DEDEDE; width:100%; border:1px solid #D1C6B3;\">";
		$out .= "<br>";
		$out .= "All PHP magic quote options are not supported, please disable the magic_quotes_gpc PHP configuration option.<p>";
		$out .= "Please update your php.ini and restart your web server to continue.<p>";
		$out .= "</div>";
		
		$out .= "<p>";
	
	}

	if ($magicRuntime == true) {
	
		$out .= "<div style=\"background-color:#D1C6B3; width:100%; border:1px solid #D1C6B3;\">";
		$out .= "<b>ERROR: Magic quotes for runtime data is enabled</b>";
		$out .= "</div>";
		$out .= "<div style=\"background-color:#DEDEDE; width:100%; border:1px solid #D1C6B3;\">";
		$out .= "<br>";
		$out .= "All PHP magic quote options are not supported, please disable the magic_quotes_runtime PHP configuration option.<p>";
		$out .= "Please update your php.ini and restart your web server to continue.<p>";
		$out .= "</div>";
		
		$out .= "<p>";
	
	}

	if ($memoryLimit) {
	
		$out .= "<div style=\"background-color:#D1C6B3; width:100%; border:1px solid #D1C6B3;\">";
		$out .= "<b>ERROR: Available PHP memory is not sufficient</b>";
		$out .= "</div>";
		$out .= "<div style=\"background-color:#DEDEDE; width:100%; border:1px solid #D1C6B3;\">";
		$out .= "<br>";
		$out .= "The memory_limit option within php.ini must be configured to be greater than or equal to 64M, please update this PHP configuration option.<p>";
		$out .= "Current php.ini setting: $memoryLimit<p>";
		$out .= "64M is the required minimum memory_limit configuration, however 128M or more is recommended.<p>";
		$out .= "Please update your php.ini and restart your web server to continue.<p>";
		$out .= "</div>";
		
		$out .= "<p>";
	
	}

	$out .= "<p>";
	$out .= "[ <a href=\"\">Check Again</a> ]";
	$out .= "<br>";

	$out .= "<br>";
	$out .= "<hr size=\"1\" width=\"100%\">";
	$out .= "<br>";

	$out .= "<a href=\"console/index.html\">Temporarily bypass this error page and continue to console</a> (you may experience strange results, and should really try and resolve any issues listed)";
	$out .= "<p>";

	$out .= "&copy; 2009 Tactical FLEX; All Rights Reserved - " . date("r");

	$out .= "</body></html>";

	echo $out;

}

?>

