<?php

// Get command line options

$_ENV['options'] = getopt("", array("params:"));

// Prepare environment

chdir("../../");

include "console/core/bootstrap.php";

// Initialize

initialize();

// Execute

main();

// Finalize

finalize();

function main() {

	// If importer or core requested by option i, else process queue messages

	if (!$_ENV['options']['params']) $_ENV['options'] = array("params" => "Default:1");

	if ($_ENV['options']['params'] == "importer") {
	
		importMain();
		
	} else if ($_ENV['options']['params'] == "core") {
	
		coreMain();
	
	} else {
	
		messageMain();
	
	}

}

function messageMain() {

	$runCount = 0;

	// Open queue
	
	$_ENV['messageQueue'] = new messageQueue();

    // Register for queue types based on passed parameters
    
    $tmp = explode(":", $_ENV['options']['params']);
	$registerArray = explode(",", trim($tmp[1]));

    $_ENV['messageQueue']->registerTypes($registerArray);

	$_SESSION['user']['id'] = "0";
	$_SESSION['user']['username'] = "BPU " . $_ENV['options']['params'];

	while ($runCount < 60) {
	
		// Write last run file
		if ($fp = fopen("tmp/bpuMessage.last", "w")) {
		
			fwrite($fp, time());
			fclose($fp);
		
		} else {
		
			$_ENV['appLog']->log('ERROR', "Tracking file /tmp/bpuMessage.last could not be opened for writing");
		
		}
	
		// Exit if stop command found

		if (file_exists("apps/bpu/pid/allStop")) {
			
			unlink("tmp/bpuMessage.last");
			
			$_ENV['appLog']->log('CONSOLE', "BPU Message was issued the stop command.");
			
			echo "Exiting...\nThis BPU has been issued a stop command. Please use idsBackground.pl to issue the start command\n\n";
			exit;
			
		}

		// Process Messages
		
		if ($_ENV['messageQueue']->processQueue(1)) {
		
			// Sleep (if message, sleep short)
		
			usleep(10);
		
		} else {
		
			// Sleep (if no message, sleep long)
			
			sleep(1);
		
		}
	
		$runCount++;
	
	}
	
	exit;

}

function importMain() {

	$_SESSION['user']['id'] = "0";
	$_SESSION['user']['username'] = "BPU Importer";

	$runCount = 0;

	while ($runCount < 60) {
	
		// Write last run file
		if ($fp = fopen("tmp/bpuImport.last", "w")) {
		
			fwrite($fp, time());		
			fclose($fp);
		
		} else {
		
			$_ENV['appLog']->log('ERROR', "Tracking file /tmp/bpuImport.last could not be opened for writing");
		
		}
	
		// Exit if stop command found

		if (file_exists("apps/bpu/pid/allStop")) {
			
			unlink("tmp/bpuImport.last");
			
			$_ENV['appLog']->log('CONSOLE', "BPU Importer was issued the stop command.");
			
			echo "Exiting...\nThis BPU has been issued a stop command. Please use idsBackground.pl to issue the start command\n\n";
			exit;
			
		}
		
		// MySQL Snort Processing Function

		idsSnort();
		
		// Syslog Processing Function

		idsSyslog();
		
		// Sleep

		sleep(1);
		
		$runCount++;
	
	}
	
	exit;

}

function coreMain() {

	$_SESSION['user']['id'] = "0";
	$_SESSION['user']['username'] = "BPU Core";

	$runCount = 0;

	while ($runCount < 5) {
	
		// Write last run file
		if ($fp = fopen("tmp/bpuCore.last", "w")) {
		
			fwrite($fp, time());		
			fclose($fp);
		
		} else {
		
			$_ENV['appLog']->log('ERROR', "Tracking file tmp/bpuCore.last could not be opened for writing");
		
		}
	
		// Exit if stop command found

		if (file_exists("apps/bpu/pid/allStop")) {
			
			unlink("tmp/bpuCore.last");
			
			$_ENV['appLog']->log('CONSOLE', "BPU Core was issued the stop command.");
			
			echo "Exiting...\nThis BPU has been issued a stop command. Please use idsBackground.pl to issue the start command\n\n";
			exit;
			
		}
		
		// Version checking

		versionCheck();
		
		// Mail processing
		
		processMail();
		
		// Download & import geo location data
		
		downloadGeoLocation();
		
		importGeoLocation();
		
		// Datastore deletion check
		
		deleteDataStoreCheck();
		
		// Delete events check
		
		deleteDataProcessor();
		
		// Snort trim check
		
		autoSnortTrimmer();
		
		// Signature processor
		
		sigProcessor();
		
		// Report processor
		
		processReportSchedule();
		
		// Sleep

		sleep(5);
		
		$runCount++;
	
	}
	
	exit;

}

?>