#!/usr/bin/perl -w

# USE
use English;
use Getopt::Long;
use POSIX;

# DEFINES
my $start;
my $stop;
my $launch;
my $params;
my $help;
my %children;

$vMajor = 7;
$vMinor = 0;
$vBuild = 700;

# OPTIONS
GetOptions (
		'start' => \$start,
		'stop' => \$stop,
		'launch' => \$launch,
		'params=s' => \$params,
		'help' => \$help
		);
		
# Launch

if ($launch) {

	processorLaunch();

} else {

	bpuWrapper();
	
}
		
sub bpuWrapper {

	my $run = 1;

	print "\n---------------------------------------------------\nAanval by Tactical FLEX, Inc.\nCopyright 2003-2012\n\nhttp://www.tacticalflex.com/\n\nBackground Processing Unit (BPU) Initializer\nVersion: $vMajor.$vMinor.$vBuild\n---------------------------------------------------\n\n";

	# PERL TEST
	$command = "perl";
	for $dir (split /:/, $ENV{PATH}) { 
	   last if ($existsP = (-x "$dir/$command")); 
	} 
	die "Fatal Error -> '$command' command not found. Ensure this command is in your path before continuing.\n" unless ($existsP); 	
	
	# PHP TEST
	$command = "php";
	for $dir (split /:/, $ENV{PATH}) { 
	   last if ($existsP = (-x "$dir/$command")); 
	} 
	die "Fatal Error -> '$command' command not found. Ensure this command is in your path before continuing.\n" unless ($existsP); 		
	
	if ($stop) {
		system("touch ./bpu/pid/allStop");
		print "BPU STOP Requested\n";
		print "BPU STOP command issued to all running BPU's\n\nPlease wait ...\n";
		sleep(5);
		print "\nFinished.\n(working BPU's may take a few moments to exit)\n\n";
		exit;
	}
	
	# Exit immediately if this launch isn't going anywhere
	if (!$start && !$help) { displayHelp(); $run = 0; }
	
	# Display Help
	if ($help) { displayHelp(); $run = 0; }

	if ($run == 1) {
		
		# Remove allStop semaphore if exists
		if (-e "./bpu/pid/allStop") {
			system("rm -f ./bpu/pid/allStop");
		}

		# Launch the importer (separate from queue processors)
		
        system("perl ./idsBackground.pl -launch -params=importer");

		# Launch the core (separate from queue processors)
		
        system("perl ./idsBackground.pl -launch -params=core");

		# Loop over bpu.conf

		open(F, "./bpu/bpu.conf");

		my @lines = <F>;
		for my $line (@lines) {

	        system("perl ./idsBackground.pl -launch -params=$line");

		}
        
	}

	exit;
}

sub processorLaunch {

	daemonRun();
	
	mainLoop();

	exit;
}

sub mainLoop {

	chdir("./bpu");

	$0 = "Aanval BPU ($params)";
	
	while(1) {
	
		if (-e "pid/allStop") { exit; }
	
		system("php processor.php --params $params > /dev/null");
		
		sleep 1;
		
	}
}

sub daemonRun {

	my $pid = fork;
	
	defined ($pid) or die "Cannot start Aanval as daemon: $!";
	
	if ($pid) {
		print "Aanval BPU ($params) launched in daemon mode [PID: $pid].\n";
	}
	
	exit if $pid; # Return control to the user
	
	POSIX::setsid(); # Become a session mojo-master
	
	close (STDOUT); # Close file handles to detach from any terminals if necessary
	close (STDIN);
	close (STDERR);
	
	# Any death trigger will kill everything
	
	$SIG{HUP} = $SIG{INT} = $SIG{TERM} = sub {
		my $sig = shift;
		$SIG{$sig} = 'IGNORE';
		kill 'INT' => keys %children;
		die "killed by $sig\n";
		exit;
	};      
	
}

sub displayHelp {

	print "Usage: perl idsBackground.pl [options]\n\n";
	
	print "-start       Start all Aanval Background Processors\n";
	print "-stop        Stop all Aanval Background Processors\n";
	print "-help        This Help Information\n";
	print "\n";
	print "Example: perl idsBackground.pl -start\n";
	print "\n";

}
