<?php

error_reporting(E_ALL);
ini_set("memory_limit", -1);
ini_set("display_errors", 1);
ini_set("display_startup_errors", 1);
set_time_limit(0);

importUnifiedSnort();

function importUnifiedSnort() {

	$runMax = 10;

	$counter = 0;
	
    // Load sid-msg.map
    $sidArray = loadSidMsgMap(1);
    
    // Instantiate Class
	$unified = new unifiedSnort();

	// Initialize Unified System
	$returnCode = $unified->initialize("/var/log/snort/merged.log");

	// Set Start Byte Location
	$unified->setVar("startByte", 0);

	$unified->seekTo();
	
	// Loop
	for ($i=0;$i<$runMax;$i++) {

		$record = $unified->record();
		if (!$record) break;

		if ($unified->getVar("type") == "alert") {
#				$fields = array('gid', 'sid', 'rev', 'classtype', 'priority', 'event_id', 'reference', 'tv_sec', 'tv_usec', 'tv_sec2', 'tv_usec2', 'source_ip', 'destination_ip', 'source_port', 'destination_port', 'protocol', 'flags');	
			$fields = array('sig_gid', 'sig_sid', 'sig_rev', 'sig_class', 'sig_priority', 'sig_cid', 'sig_reference', 'tv_sec', 'tv_usec', 'tv_sec2', 'tv_usec2', 'src', 'dst', 'sport', 'dport', 'ip_proto', 'flags');	
		} else {
		 	$fields = array('gid', 'sid', 'rev', 'classtype', 'priority', 'event_id', 'reference', 'tv_sec', 'tv_usec', 'flags', 'pkt_sec', 'pkt_usec', 'caplen', 'pktlen');
		}

		$result = array_combine($fields, $record);
		
		$lastTimestamp = $result["timestamp"];
	    $flashWriteCount++;
	    $counter++;

	    // Set Default Risk Level
		if (!$result["sig_priority"]) $result["sig_priority"] = 5;
	    
	    // Set Results
		$result["datastore"] = "1.1";
		$result["unified_version"] = $unified->getVar("versionHeader");
		$result["timestamp"] = $result["tv_sec"];
		$result["intime"] = date("U");
		$result["module"] = 1;
		$result["enabled"] = 1;
		$result["sensorid"] = $sensorID;

		// Custom Sig Sid Data
		$tmpData = explode(" || ", $sidArray[$result["sig_sid"]]);
		
			$tmpChunk = explode(" ", $tmpData[1]);
			$sigClassName = $tmpChunk[0];
			$sigName = $tmpData[1];
			
			$result["sig_name"] = $sigName;
			$result["sig_class_name"] = $sigClassName;
		
		$result["misc1"] = "";
		$result["misc2"] = "";
		$result["misc3"] = "";
		$result["misc4"] = "";
		$result["misc5"] = "";
		$result["xcol1"] = "";
		$result["xcol2"] = "";
		$result["xcol3"] = "";
		$result["xcol4"] = "";
		$result["xcol5"] = "";

		$cid = $result["sig_cid"];
		
		unset($record, $result, $sigClassName, $sigName, $tmpChunk, $tmpData);
		
	}
    
    // Protect integrity of processor if no events were processed this run (prevents cycling of existing events)
    $data[] = $lastTimestamp;
	$data[] = $counter;
	$data[] = $cid;
	
    return $data;
    
}

function getNextUnifiedFile($current, $sensorID) {
	
	$array = getUnifiedFileArray($sensorID);
	
	foreach ($array as $file) {

		if ($next == 1) {
			$nextFile = $file;
			break;
		}
		
		if ($current == $file) {
			$next = 1;
		}
		
	}
	
	if (!$nextFile) $nextFile = $current;
	
	return $nextFile;
}

function loadSidMsgMap($sensorID) {
	global $root_path;
	
	$tmpData = @file("../conf/unified/default.sid-msg.map");
	
	foreach ($tmpData as $line) {

		$tmp = explode(" || ", $line);
		
		$sidOut[$tmp[0]] = $line;
		
	}
	
	return $sidOut;
	
}

class unifiedSnort {
	
 	var $logFields = array('gid', 'sid', 'rev', 'classtype', 'priority', 'event_id', 'reference', 'tv_sec', 'tv_usec', 'flags', 'pkt_sec', 'pkt_usec', 'caplen', 'pktlen', 'pkt');
 	var $alertFields = array('gid', 'sid', 'rev', 'classtype', 'priority', 'event_id', 'reference', 'tv_sec', 'tv_usec', 'tv_sec2', 'tv_usec2', 'source_ip', 'destination_ip', 'source_port', 'destination_port', 'protocol', 'flags');

	var $fp;
	var $type;
	var $endian;

	var $record_size;
	var $pack_record;
	var $pack_header;
	var $fields;
	
	var $versionHeader;
	
	var $u2_idsEvent = array(
		'sensor_id',
        'event_id',
        'tv_sec',
        'tv_usec',
        'sig_id',
        'sig_gen',
        'sig_rev',
        'class',
        'pri',
        'sip',
        'dip',
        'sp',
        'dp',
        'protocol',
        'pkt_action'
    );
    
    var $u2_alert = array(
    	'sig_gen',
        'sig_id',
        'sig_rev',
        'class',
        'pri',
        'event_id',
        'reference',
        'tv_sec',
        'tv_usec',
        'tv_sec2',
        'tv_usec2',
        'sip',
        'dip',
        'sp',
        'dp',
        'protocol',
        'flags'
    );
    
    var $u2_packet = array(
    	'sensor_id',
        'event_id',
        'tv_sec',
        'pkt_sec',
        'pkt_usec',
        'linktype',
        'pkt_len',
        'pkt'
    );
    
    var $u2_log = array(
    	'sig_gen',
        'sig_id',
        'sig_rev',
        'class',
        'pri',
        'event_id',
        'reference',
        'tv_sec',
        'tv_usec',
        'flags',
        'pkt_sec',
        'pkt_usec',
        'caplen',
        'pktlen',
        'pkt'
    );
    
    var $u2_VLANEvent = array(
	    'sensor_id',
	    'event_id',
	    'event_second',
	    'event_microsecond',
	    'signature_id',
	    'generator_id',
	    'signature_revision',
	    'classification_id',
	    'priority_id',
	    'ip_source',
	    'ip_destination',
	    'sport_itype',
	    'dport_icode',
	    'protocol',
	    'impact_flag',
	    'impact',
	    'blocked',
	    'mpls_label',
	    'vlanId',
	    'policyID'
    );
	
	function setVar($key, $value) {
		$this->s_vars[$key] = $value;
	}

	function getVar($key) {
		return $this->s_vars[$key];
	}	
	
	function initialize($filename) {
		global $fp, $logFields, $alertFields, $type, $endian, $fields, $record_size, $pack_header, $pack_record;
		
		$fp = fopen($filename, "r");
		
		if ($fp) echo "file opened\n";
 		
 		$run = 0;
 		
 		while (!feof($fp)) {
 		
 			echo "W: " . ftell($fp) . "\n";
 		
 			$run++;
 		
	 		$header = fread($fp, 8);
 		
 			$tmp = unpack("N1Type/N1Length", $header);
 		
 			print_r($tmp);
 			
	 		$data = fread($fp, $tmp['Length']);

			if ($tmp['Type'] == 1) {
	 		
		 		$upack = unpack("N11A/n2B/c2C", $data);
	
				$event = array_combine($this->u2_idsEvent, $upack);
	
	 			print_r($event);

			} else if ($tmp['Type'] == 2) {
	 		
		 		$upack = unpack("N8A", $data);
	
				$event = array_combine($this->u2_packet, $upack);
	
	 			print_r($event);

			} else if ($tmp['Type'] == 7) {
	 		
		 		$upack = unpack("N11A/n2B/c2", $data);
	
				$event = array_combine($this->u2_idsEvent, $upack);
	
	 			print_r($event);
	 			
	 		} else if ($tmp['Type'] == 104) {
	 		
		 		$upack = unpack("N11A/n2B/c4C/ND/n2E", $data);
	
				$event = array_combine($this->u2_VLANEvent, $upack);
	
	 			print_r($event);
	 		
	 		}
 			
 			echo "\n";
 			
 			if ($run > 2) exit;

		}
		
		fclose($fp);

/*
		switch ($this->getVar("type")) {
			case "log":
				
                $this->setVar("record_size", (14 * 4));
                $this->setVar("pack_record", 'V14');
                $this->setVar("pack_header", 'vMajor/vMinor/V4');
                $this->setVar("fields", $logFields);
                
				break;
	
			case "alert":
	
                $this->setVar("record_size", (15 * 4) + (2 * 2));
                $this->setVar("pack_record", 'V13Alpha/v2Bravo/V2Charlie');
                $this->setVar("pack_header", 'VMajor/VMinor/VTimezone');
                $this->setVar("fields", $alertFields);
				
                break;
                
			default:
	
				echo "Wrong Type; Error!\n";
				
				break;
		}			
		
*/
		
		echo "Type: " . $this->getVar("type") . " Endian: " . $this->getVar("endian");
				
		$this->header();
	}
	
	function header() {
		global $fp;
		
		switch ($this->getVar("type")) {
			case "log":
				
				$tmp = fread($fp, 20);
				$tmp = unpack($this->getVar("pack_header"), $tmp);
				$this->setVar("versionHeader", $tmp["Major"] . "." . $tmp["Minor"]);
				
				break;
	
			case "alert":
	
				$tmp = fread($fp, 12);
				$tmp = unpack($this->getVar("pack_header"), $tmp);
				$this->setVar("versionHeader", $tmp["Major"] . "." . $tmp["Minor"]);
				
                break;
                
			default:
	
				echo "Invalid Header; Error!\n";
				
				break;
		}				
		
		echo $tmp["Major"] . "." . $tmp["Minor"];
		
	}
	
	function seekTo() {
		global $fp;
		
		if ($this->getVar("startByte")) {
			
			fseek($fp, $this->getVar("startByte"));
			
			if (feof($fp)) {
//		        procWrite("A", " . EOF Detected: $filename");
				return 3;
			}
			
//	        procWrite("A", " . Seeking: " . $this->getVar("startByte"));
		}
		
	}
	
	function record() {
		global $fp;
		
		if ($this->getVar("type") == "alert") {
		
			$data = fread($fp, $this->getVar("record_size"));
			$tmp = unpack($this->getVar("pack_record"), $data);
			
		} else if ($this->getVar("type") == "log") {

			$data = fread($fp, $this->getVar("record_size"));
			
			if ($data) {
			
				$tmp = unpack($this->getVar("pack_record"), $data);
				
				$data1 = fread($fp, $tmp[13]);
#				$tmp1 = unpack("V", $data1);
#				$tmp[15] = $tmp1[1];
			}
			
		}

		$this->setVar("lastByte", ftell($fp));
		
		return $tmp;
		
	}
}

?>