<?php

function initialize() {

	// Order of init is important
	
	$_ENV['contentTitle'] = "Console";
	
	// Install / upgrade check
	
	if (installUpgradeTest() != false) {
	
		include_once('conf/defaults-debug.php');

		installUpgrade();
		exit;
		
	}

	// Defaults

	include_once('conf/defaults.php');
	if (@file_exists('conf/custom.php')) include_once('conf/custom.php');
	
	// Load configuration

	include_once('conf/conf.php');

	// Cleanup / Maintenance
	
	bootstrapMaintenance();

	// Version data

	loadVersionData();

	// init core

	coreLoader();
	
	// init modules
	
	moduleLoader();

	// init log

	$_ENV['appLog'] = new appLog();

	// init db

	$_ENV['appDB'] = new appDB();

	// init ops

	opsLoader();

	// init datastore

	$_ENV['dataStore'] = new dataStore();

	// init session (only if not CLI)

	if (!isCli()) {

		session_name("aanvalWeb");
		@session_start();
		
	}
	
	// logout (catchall)
	
	if (sanitize("op") == "pub_logout") destroySession();
	
}

function finalize() {

	$_ENV['appDB']->close();

}

function loadVersionData() {

	$v = file('version/version.txt');

	define(VERSION, trim($v[0]) . "." . trim($v[1]));
	define(BUILD, trim($v[2]));

}

function coreLoader() {

        if ($thisDir = @dir("console/core/")) {

                while ($file = $thisDir->read()) {

                        if ($file != "." && $file != "..") {

                                if (substr($file, 0, 5) == "core_") {

                                        include_once "console/core/$file";

                                }

                        }

                }

    }

}

function moduleLoader() {

        if ($thisDir = @dir("console/modules/")) {

                while ($file = $thisDir->read()) {

                        if ($file != "." && $file != "..") {

                                if (substr($file, 0, 7) == "module_") {

                                        include_once "console/modules/$file";

                                }

                        }

                }

    }

}

function installUpgradeTest() {

	if (file_exists("installation/install.cert")) {
	
		// Console has been installed
		
		if (file_exists("installation/upgrade")) {
		
			// Installed console is ready for upgrade
			
			return true;
		
		} else {
		
			// Installed console with nothing to do
			
			return false;
		
		}
	
	} else {
	
		// Console has not yet been installed
				
		return true;
	
	}

}

function installUpgrade() {

	if (file_exists("installation/install.cert")) {
	
		// Upgrade
		
		include_once('console/core/installUpgrade.php');
	
	} else {
	
		// Install

		include_once('console/core/installUpgrade.php');
	
	}

}

function bootstrapMaintenance() {

	// Cleanup ._files

	if (file_exists('._index.php')) {

		`find . -iname '._*' -exec rm -rf {} \;`;
		
	}

}

function isCli() {

	if(strtolower(php_sapi_name()) == 'cli') {

		return true;

	} else {

    	return false;
    	
	}
	
}

?>