<?php

function idsSnort() {

    // Check if snort module is enabled
    
    if (moduleStatus(1) == 1) {

        // Instantiate new snortPort object
        $sp = new snortPort();
        
        // Create Sensor Object
        $objSensor = new mySensor();
        
        // Retrieve array of sensor id's
        $id = $objSensor->getSensorIDs(1);
        
        // Loop through each activated sensor
        for ($i=0;$i<count($id);$i++) {

        	$count = 0;

            // Load sensor information
            $objSensor->loadSensor($id[$i]);
            
            // Get id of last event insert
            $eStart = $objSensor->getSensorVar("lastEvent");
            if (!$eStart) $eStart = 0;
            
            // Set timers
            $timerStart = microtime(true);
        
            // Perform import of snort to Aanval based on greater than stored timestamp and sensor id
            $data = $sp->processSnortRange($objSensor->getSensorVar("sid"), $id[$i], $eStart, ops("site_processorEventRun"), ops("site_snortTruncate"), 0);
        
            $lastProcessed = $data[0];
            $count = $data[1];
            $cid = $data[2];
            
            if ($cid) {

                // Perform import of snort to Aanval based on equal to stored timestamp and sensor id (This is a clean up operation to ensure all events for this timestamp have been converted)
                $data = $sp->processSnortRange($objSensor->getSensorVar("sid"), $id[$i], $lastProcessed, ops("site_processorEventRun"), ops("site_snortTruncate"), 1, $cid);			
        
                $lastProcessed = $data[0];
                $count = $data[1] + $count;
                
            }

            if ($count > 0) {

	            // Update sensor lastEvent processed

    	        $objSensor->setSensorVar("lastEvent", $lastProcessed);

	            // Dispatch timescale message
        
		        $mObject = arrayToObject(array("type" => 10, "data" => "timescaleWrite", "options" => $id[$i] . "|$count", "priority" => 2));
	    	    $mQueue = new messageQueue();
	        	$mQueue->add($mObject);
	        	
	        }
            
            // Calculate timers
            $timerDiff = microtime(true) - $timerStart;
            
            echo "$count processed in $timerDiff seconds\n";
            
        }
		
	} else {

	}
	
}

function idsSyslog() {
	
	$idsQueryA = $_ENV['appDB']->query("SELECT * FROM idsModules where id = '2'");
	while ($row = mysql_fetch_array($idsQueryA, MYSQL_ASSOC)) {

		foreach ($row as $key => $val) {
	
			$modArray[$key] = $val;
	
		}
	}
		
	$moduleDB = new moduleDB();
	$moduleDB->load($modArray);
	
    // Check if syslog unified module is enabled
    if ($modArray["enabled"] == 1) {

		/* Syslog Daemon Processing */
		
		// Instantiate new processor object
	    $processor = new syslogProcessor();
	
	    // Retrieve List of syslog sensor files from /syslog/ directory
	    $syslogFiles = $processor->getSyslogFiles();
	    
	    // Check for new syslog sensors (create new sensor if necessary)
	    $processor->newSyslogSensorCheck($syslogFiles);
	    
	    // Process syslog sensors (single or multiple)
	    $processor->processSyslogSensors();

	    /* Syslog Source File Processing */

		// Set variables
	    $start = date("U");
		
		// Set array of sources
		$queryA = $_ENV['appDB']->query("select id, path from idsSensor where enabled = 1 AND module = 2");
		while (list($q_id, $q_path) = mysql_fetch_row($queryA)) {
			if (strstr($q_path, "/")) $enabledSourceArray[] = $q_id;
		}
		
		if (count($enabledSourceArray) == 0) return;
		
		// Loop through sources
		foreach ($enabledSourceArray as $sid) {
	
			// Load sensor data
			$objSensor = new mySensor();
			$objSensor->loadSensor($sid);
			
			// Error checking
			if (!@file_exists($objSensor->getSensorVar("path"))) {

				continue;
			} else if (!@is_file($objSensor->getSensorVar("path"))) {

				continue;
			}
			
			// Open file handle
			$handle = @fopen($objSensor->getSensorVar("path"), "r");
			
			// Check filesize against tracker for rotated or cleared logs
			$fileInfo = fstat($handle);
			if ($objSensor->getSensorVar("tracker1") > $fileInfo[7]) {
				$objSensor->setSensorVar("tracker1", 0);
			}
			
			// Reset tracker if null
			
			if (!$objSensor->getSensorVar("tracker1") || $objSensor->getSensorVar("tracker1") == "") {
				$objSensor->setSensorVar("tracker1", 0);
			}
			
			// Seek to last position
			fseek($handle, $objSensor->getSensorVar("tracker1"));
			
			// Begin processing
			$line = 0;
			if ($handle) {
				
				// Loop through source line by line
				while (!feof($handle)) {
					$buffer = rtrim(fgets($handle, 4096));
					$tracker1 = ftell($handle);
	
					// If line not blank
					if ($buffer) {
						$line++;
						$dataArray[] = "$buffer";
						$tracker2 = $buffer;
						
						// Exit if processing more than X lines
						if ($line >= ops("site_processorEventRun")) break;
					}
				}
				
				// Close file handle
				fclose($handle);
				
				// Store data
				if ($dataArray) $processor->processSyslogSourceFile($sid, $objSensor->getSensorVar("sid"), $dataArray);
			}
	
            // Write to new timescale table (03/03/09)
            
	        $mObject = arrayToObject(array("type" => 10, "data" => "timescaleWrite", "options" => $sid . "|" . $line));
    	    $mQueue = new messageQueue();
        	$mQueue->add($mObject);
            
			// Get trackers in case no data processed
			if (!$tracker1) $tracker1 = $objSensor->getSensorVar("tracker1");
			if (!$tracker2) $tracker2 = $objSensor->getSensorVar("tracker2");
	
			// Calculate byte diff
			$byteDiff = $tracker1 - $objSensor->getSensorVar("tracker1");
			
			// Set trackers
			$objSensor->setSensorVar("tracker1", $tracker1);
			$objSensor->setSensorVar("tracker2", addslashes($tracker2));
			
			// Unset used variables
			unset($dataArray, $buffer, $tracker1, $tracker2, $byteDiff);	
		}
	
		// Time calculations
	    $diff = date("U") - $start;
	
		return $out;
	
	} else {

	}
	
}

function timescaleWrite($sid, $total) {

	// Only write on 5 minute intervals

	if (substr(date("i"), 1) < 5) {
	
		// Alter to 0
	
		$mod = substr(date("i"), 0, 1) . "0";
	
	
	} else {
	
		// Alter to 5

		$mod = substr(date("i"), 0, 1) . "5";
	
	}

	$currentTimestamp = strtotime(date("y-m-d H") . ":$mod");

	$idsQueryA = $_ENV['appDB']->query("INSERT IGNORE INTO idsDataStore_" . ops("site_activeDataStore") . "_Timescale (timestamp, sensor, total) VALUES ('$currentTimestamp', '$sid', '$total') ON DUPLICATE KEY UPDATE total = (total + $total)");

}

function deleteDataStoreCheck() {
	
    // Check if deletion of a data store has been forced
    if (strlen(ops("storeDeletion")) >= 4) {

		$delArray = explode(",", ops("storeDeletion"));

		foreach ($delArray as $store) {

			$cnt = 0;

			if (strlen($store) < 4) continue;

			$idsQueryA = $_ENV['appDB']->query("DELETE FROM idsDataStore WHERE store = '$store'");

			$q = $_ENV['appDB']->query("SHOW TABLES LIKE 'idsDataStore_$store%'");
			while ($row = mysql_fetch_array($q)) {
	
				$q1 = $_ENV['appDB']->query("DROP TABLE " . $row[0]);

				$cnt++;
			
			}

		    // Update ops variable to reset manual reprocessing variable
	        ops("storeDeletion", str_replace(",$store,", ",", "," . ops("storeDeletion") . ","));
	        
	        // Remove first element
	        array_shift($delArray);
	        
	        // Break out to run on next iteration
			break;
		}

		ops("storeDeletion", implode(",", $delArray));
	    	
    }		
}

function processReportSchedule() {

    $todayDate = date("y-m-d");
    $todayDateName = substr(date("l"), 0, 3);
    $todayEpoch = strtotime($todayDate);
    $tomorrowEpoch = strtotime($todayDate) + 86400;

    $dayQuery = strtolower("$todayDateName = 1");

    $idsQueryA = $_ENV['appDB']->query("select id, type, status, userid, name, store, email, query, runtime, runlast from idsReportSchedule where $dayQuery and enabled = 1 and type = 2 and runlast not between $todayEpoch and $tomorrowEpoch order by id desc");
    while (list($id, $type, $status, $userid, $name, $store, $email, $query, $runtime, $runlast) = mysql_fetch_row($idsQueryA)) {

		// Scheduled report
		
		$tmpEpoch = strtotime($todayDate . " $runtime");
		if ($tmpEpoch < time()) {

			// Set user for processing		
			authenticateSessionByUserID($userid);
			
			$searchObj = new coreSearch();
			$searchObj->setVar("store", ops("site_activeDataStore"));
			$searchObj->setVar("query", "rqueue: $query");
			
			$reportData = $searchObj->searchProcess();
            
			// Set status of report
		    $idsQueryB = $_ENV['appDB']->query("update idsReportSchedule set data = '" . addslashes($reportData) . "', status = 2, runlast = '" . time() . "' where id = $id");
			
			insertUserMessage($userid, 3, "Report emailed: $query");

			if ($email) {

				if (extension_loaded("gd")) {
	
		    		emailPDFReport($reportData, $email, $email, "Report: \"$name\"");
		    		
		    	} else {
	
		    		emailTextReport($reportData, $email, $email, "Report: \"$name\"");
		    	
		    	}
		    	
		    }
		    
    	}
    	
    }

    if (!$report && !$reportData) {

        // Nothing to do
        
    }

}

function autoSnortTrimmer() {
	
	$idsQueryA = $_ENV['appDB']->query("SELECT * FROM idsModules where id = '1'");
	while ($row = mysql_fetch_array($idsQueryA, MYSQL_ASSOC)) {

		foreach ($row as $key => $val) {
	
			$modArray[$key] = $val;
	
		}
	}
		
	$moduleDB = new moduleDB();
	$moduleDB->load($modArray);

	// Return if snort module is not enabled
    if ($modArray["enabled"] == 0) {
		return;
    }
    
    // Return if snort auto trimming is disabled
	if (ops("site_snortAutoTrim") == 0) {
		return;
	}

	$Q = $moduleDB->query("SELECT count(*) AS cnt FROM event");
	if(mysql_num_rows($Q) > 0) {
		$row = mysql_fetch_array($Q);
		$eventTotal = $row["cnt"];
	}
	
	if (ops("site_snortAutoTrimMax") > $eventTotal) {

		// Nothing to be done

	} else {
	
		$diff = $eventTotal - ops("site_snortAutoTrimMax");
		
		if ($diff > 5000) {
			$diff = 5000;
		}
		
		if ($diff > 0) {	
	
			$Q = $moduleDB->query("SELECT sid, cid FROM event ORDER BY timestamp LIMIT $diff");
			if(mysql_num_rows($Q) > 0) {
				while ($row = mysql_fetch_array($Q)) {
					$cnt++;
					$Q2 = $moduleDB->query("DELETE FROM event WHERE sid = '" . $row["sid"] . "' and cid = '" . $row["cid"] . "'");
					$Q2 = $moduleDB->query("DELETE FROM data WHERE sid = '" . $row["sid"] . "' and cid = '" . $row["cid"] . "'");
					$Q2 = $moduleDB->query("DELETE FROM tcphdr WHERE sid = '" . $row["sid"] . "' and cid = '" . $row["cid"] . "'");
					$Q2 = $moduleDB->query("DELETE FROM udphdr WHERE sid = '" . $row["sid"] . "' and cid = '" . $row["cid"] . "'");
					$Q2 = $moduleDB->query("DELETE FROM iphdr WHERE sid = '" . $row["sid"] . "' and cid = '" . $row["cid"] . "'");
					$Q2 = $moduleDB->query("DELETE FROM icmphdr WHERE sid = '" . $row["sid"] . "' and cid = '" . $row["cid"] . "'");
					$Q2 = $moduleDB->query("DELETE FROM opt WHERE sid = '" . $row["sid"] . "' and cid = '" . $row["cid"] . "'");
				}
				
			}		
	
		} else {
			
		}
	}
	
	$moduleDB->close();	
	
}

function deleteDataProcessor() {

	$filename = "tmp/eventDeletion.dat";

	if (file_exists($filename)) {
	
		$data = @file($filename);
		
		foreach ($data as $line) {
		
			$tmp = explode(":", $line);
	
			$_ENV['appDB']->query("DELETE FROM idsDataStore_" . $tmp[0] . "_Master where id in (" . $tmp[1] . ")");
			$_ENV['appDB']->query("DELETE FROM idsDataStore_" . $tmp[0] . "_Events where id in (" . $tmp[1] . ")");
			$_ENV['appDB']->query("DELETE FROM idsDataStore_" . $tmp[0] . "_Text where loc in (" . $tmp[1] . ")");
			$_ENV['appDB']->query("DELETE FROM idsDataStore_" . $tmp[0] . "_Tag where eventID in (" . $tmp[1] . ")");
			$_ENV['appDB']->query("DELETE FROM idsDataStore_" . $tmp[0] . "_Review where eventID in (" . $tmp[1] . ")");
			
		}
		
		unlink($filename);
			
	} else {

	}

}

function versionCheck() {

    /* Checks the Aanval.com version website for new available builds */
    
    $aanvalPackage = "aanval-7-latest-stable.tar.gz";
    
    // Start version checking at least once upon each install / upgrade
    if (@file_exists("version/version.one")) {
		ops("site_versionChecking", "1");    	
		@unlink("version/version.one");
    }

    // Check if version checking is enabled
    if (ops("site_versionChecking") == 1) {

    	// Retrieve unix epoch
        $epoch = time();
        
        // Read in current version /version/verstion.txt file if available
        if ($tmp = @file("version/version.txt")) {

        	// Create various variables from array
        	$major = trim($tmp[0]);
        	$minor = trim($tmp[1]);
        	$name = trim($tmp[2]);
        	$build = trim($tmp[3]);
        	
        	// Read in available version /version/ver file if available
	        if ($tmp = @file("version/ver")) {
	        	
	        	// Create $time variable from array
	        	$time = trim($tmp[4]);
	
		        // Check $time variable to see if 4 hours have passed and it is time to recheck for new versions
	        	if (($epoch - 3600) > $time) {

					// Reset ver file (in case we cannot get results, we don't want constant version checking)

					$fp = @fopen("version/ver", "w");
					fwrite($fp, "0" . "\n" . "0" . "\n" . "0" . "\n" . "0" . "\n$epoch");
					fclose($fp);
	
					$_ENV['appLog']->log('CONSOLE', "Checking update.aanval.com for updates");
	
	        		// Make outbound web connection to aanval server
		        	$versionData = exConnect("http://update.aanval.com/aanval7.php?major=$major&minor=$minor&build=$build&registration=alpha&ver=7");

					$returnData = explode("\n", $versionData);

		            // Disable Version Checking if $versionData is empty
		            if (!$versionData || $versionData == "") {
		            
						$_ENV['appLog']->log('ERROR', "Version checking result data is empty");
		            
		            } else {

						if ($fp = @fopen("version/ver", "w")) {
					
							fwrite($fp, $returnData[0] . "\n" . $returnData[1] . "\n" . $returnData[2] . "\n" . $returnData[3] . "\n$epoch");
							fclose($fp);

							$vData = versionData();
							
							if ($vData->newBuild > $vData->build) {
							
								$_ENV['appLog']->log('CONSOLE', "A new build of the console is available: " . $vData->newBuild);

								insertUserMessage(0, 3, "A new build of the console is available! v" . $vData->newMajor ."." . $vData->newMinor . " Build: " . $vData->newBuild, arrayToObject(array("url" => "prv_versionManagement")));
							
							}
							
						} else {
						
							$_ENV['appLog']->log('ERROR', "Could not open version/ver for writing");
						
						}

					}

	        	} else {
	        		
		        	// Calculate seconds until we make version check
		        	$until = $time - ($epoch - 12000);
		        	
	        	}
	        	
	        } else {

	        	// Create /version/ver file handle (fill with emptyness)
	            if ($fp = @fopen("version/ver", "w")) {
	            	
            		// Write web retrieved version data to /version/ver
                    fputs ($fp, "0\n0\n0\n0\n" . time());
                    
                    // Close file handle
                    fclose($fp);
                    
	            } else {
	            
					$_ENV['appLog']->log('ERROR', "Could not open version/ver for writing");
	            
	            } 	
	        }
	        
        } else {
        	
			$_ENV['appLog']->log('ERROR', "Could not open version/version.txt for reading");
        	
        }

    }

    /* Download Performed Here */
    
	// Check if the UpdateNow variable == 1
    if (ops("site_versionUpdateNow") == 1) {

		$_ENV['appLog']->log('CONSOLE', "Console update requested");

        // External execute: rm -f to remove previously downloaded file if exists
        @unlink("$aanvalPackage");

    	// Download the .tar.gz file from Aanval - if returns 0 do not continue
        if (updateDownload("http://download.aanval.com/$aanvalPackage", "$aanvalPackage") == 0) {

			$_ENV['appLog']->log('ERROR', "Console update download failed, 0 returned from download function");
        
        } else {

			$_ENV['appLog']->log('NOTICE', "Decompressing download package & installing");

            // External execute: gunzip .tar.gz
	        exec("tar -zxvf $aanvalPackage");

			// Test if installation/upgrade exists... if so, decompress was successful

            if (!file_exists("installation/upgrade")) {
            
				$_ENV['appLog']->log('ERROR', "Decompress failed, trying secondary method");

	            // External execute: gunzip .tar.gz
	            exec("gunzip -c $aanvalPackage | tar -xvf - -C ");
	            
	            if (!file_exists("installation/upgrade")) {

					$_ENV['appLog']->log('NOTICE', "Decompress not successful, manual intervention required");
					$_ENV['appLog']->log('NOTICE', "Remove all contents of the console/ dir, and decompress $aanvalPackage over the top of this install to upgrade");
	
				} else {
				
	            	// Upgrade successful (clear core, modules, templates, assets and renderers dir, then do it again)
	            	
	            	`rm -rf console/core`;
	            	`rm -rf console/modules`;
	            	`rm -rf console/templates`;
	            	`rm -rf console/renderers`;
	            	`rm -rf console/assets`;
	            
		            // External execute: gunzip .tar.gz
		            exec("gunzip -c $aanvalPackage | tar -xvf - -C ");
				
				}
            
            } else {
            
            	// Upgrade successful (clear core, modules, templates, assets and renderers dir, then do it again)
            	
            	`rm -rf console/core`;
            	`rm -rf console/modules`;
            	`rm -rf console/templates`;
            	`rm -rf console/renderers`;
            	`rm -rf console/assets`;
            
	            // External execute: gunzip .tar.gz
		        exec("tar -zxvf $aanvalPackage");
            
            }
            
            // External execute: rm -f to remove downloaded file
	        @unlink("$aanvalPackage");
	     
			$_ENV['appLog']->log('NOTICE', "Removing download package");
	     
	     	insertUserMessage(1, 3, "New Console Update Processed");
   
        }

        // Disable UpdateNow
        ops("site_versionUpdateNow", "0");
        
    }

}

function updateDownload($url, $file) {

    // Default status = 0
    $status = 0;

    // Make outbound web connection to Aanval server
    $downloadData = exConnect("$url");

    // Disable Version Checking if $downloadData is empty
    if ($downloadData == "") {
    
    	ops("site_versionChecking", "0");
    	
    } else {
	    
		$_ENV['appLog']->log('NOTICE', "Downloading console update");
	    
    	// Create file handle
	    if ($handle = @fopen("$file","w")) {
	    	
	    	// Dump data into new file handle
	    	fputs($handle, $downloadData);
	    	
	    	// Close file handle
	    	fclose($handle);

			$_ENV['appLog']->log('NOTICE', "Saving download package to disk");
	    	
	    } else {

			$_ENV['appLog']->log('ERROR', "Could not write download package to disk (root directory of console)");

	    	// File could not be opened for writing
	    	ops("site_versionChecking", "0");
	    	
	    }
	    
	    // Check if newly created file exists
	    if (@file_exists("$file")) $status = 1;
    }

    return $status;
}

function downloadGeoLocation() {

    if ((ops("site_downloadGeoDatabaseNow") != 1)) return;
    
	$_ENV['appLog']->log('CONSOLE', "GeoLocation Database Download Requested");
    
    // Initialize
    
	$url = ops("site_geoLocationDatabaseURL");

	// Warnings
	
	if (!$url || $url == "") {
		return;
	}

	// Download
    $data = exConnect($url);
			
    // Write
    if ($handle = fopen("tmp/geo/geo-latest.zip", "w")) {
    
		$_ENV['appLog']->log('CONSOLE', "Writing GeoLocation Database Data");
    
    	fputs($handle, $data);
    	fclose($handle);
    	
    } else {
    
		$_ENV['appLog']->log('ERROR', "Unable to write tmp/geo/geo-latest.zip");
    
    }
			
	// Clear flag
	
	$_ENV['appLog']->log('CONSOLE', "Disabling GeoLocation Database Download");
	
	ops("site_downloadGeoDatabaseNow", "0");
	
	insertUserMessage(0, 3, "The GeoLocation database has been downloaded and importing has begun");

}

function importGeoLocation() {

	if (file_exists("tmp/geo")) {

		if ($thisDir = @dir("tmp/geo/")) { 
			while ($file = $thisDir->read()) {
				if ($file != "." && $file != "..") {
				
					if (substr($file, -4) == ".zip") {

						@exec("unzip -o -qq -j tmp/geo/$file -d tmp/geo/");
						@unlink("tmp/geo/$file");

						$_ENV['appLog']->log('CONSOLE', "GeoLocation Database Download File Found");
						
						$found = true;
						
						break;
					}
				}
			}
	    }
	    
	    if ($found) {
	    
			$_ENV['appLog']->log('CONSOLE', "Clearing GeoLocation Database Content");
	    
		    $_ENV['appDB']->query("DELETE FROM idsGeoData");
		    $_ENV['appDB']->query("ALTER TABLE idsGeoData AUTO_INCREMENT = 1");

		    $_ENV['appDB']->query("DELETE FROM idsGeoLocation");

			// Block

		    $data = @file("tmp/geo/GeoLiteCity-Blocks.csv");
		
			$_ENV['appLog']->log('CONSOLE', "Importing GeoLocation Network Block Data");
		
			foreach ($data as $line) {
			
				// CREATE MULTI-LINE QUERY
			
				if (!strstr($line, "\"")) continue;
			
				$line = str_replace("\"", "", $line);
			
				$array = explode(",", trim($line));

				$multiQuery[] = "('" . $array[2] . "', '" . $array[0] . "', '" . $array[1] . "')";
	
				if (count($multiQuery) > 25) {
				
					// MYSQL INSERT

				   	$_ENV['appDB']->query("INSERT INTO idsGeoData (locationID, ipStart, ipEnd) VALUES " . implode(", ", $multiQuery) . "");

					unset($multiQuery);
				
				}

			}

			unset($data);
			
			unlink("tmp/geo/GeoLiteCity-Blocks.csv");

			// Location
			
		    $data = @file("tmp/geo/$fileBase/GeoLiteCity-Location.csv");
		
			$_ENV['appLog']->log('CONSOLE', "Importing GeoLocation Location Data");
		
			foreach ($data as $line) {
			
				if (!strstr($line, "\"")) continue;
			
				$line = str_replace("\"", "", $line);
			
				$array = explode(",", trim($line));
			
				$multiQuery[] = "('" . addslashes($array[0]) . "', '" . addslashes($array[1]) . "', '" . addslashes($array[2]) . "', '" . addslashes($array[3]) . "', '" . addslashes($array[4]) . "', '" . addslashes($array[5]) . "', '" . addslashes($array[6]) . "', '" . addslashes($array[7]) . "', '" . addslashes($array[8]) . "')";
			
				if (count($multiQuery) > 25) {
				
					// MYSQL INSERT

				   	$_ENV['appDB']->query("INSERT INTO idsGeoLocation (locationID, country, region, city, postalCode, latitude, longitude, metroCode, areaCode) VALUES " . implode(", ", $multiQuery) . "");

					unset($multiQuery);
				
				}
			
			}
			
			unset($data);
			
			@unlink("tmp/geo/GeoLiteCity-Location.csv");

			$_ENV['appLog']->log('CONSOLE', "GeoLocation Data Cleanup");

			insertUserMessage(0, 3, "GeoLocation Database Imported Successfully");

		} else {
		
		}
	
	} else {
	
		@mkdir("tmp/geo");
	
	}

}

function processMail() {

	// Retrieve current unix epoch for query
	$epoch = date("U");
	
    // Set limit to default or use Flood Limit if Protection enabled
    if (ops("site_emailFloodProtection") == 1) {
    	$limit = ops("site_emailFloodLimit");
	} else {
		$limit = 100;
	}
    
    // Query email table within the aanval database for all emails which have a delivery time less than the current epoch (retrieved above)
    $idsQueryA = $_ENV['appDB']->query("select id, type, fromName, fromEmail, toName, toEmail, subject, message, deliver from idsEmail where sent = 0 and deliver < '$epoch' order by deliver limit $limit");
    while (list($id, $type, $fromName, $fromEmail, $toName, $toEmail, $subject, $message, $deliver) = mysql_fetch_row($idsQueryA)) {

		// Type [1 = text, 2 = HTML, 3 = Attachments]

		$mime_boundary = "==Multipart_Boundary_x" . md5(time()) . "x";

    	// Check if Flood Protection is needed (in combination with LIMIT in query above, this should help prevent flooding)
    	if (ops("site_emailFloodProtection") == 1) {
	    	if ($headers) {
	    		
	    		// Check for previous toEmail equaling current toEmail (if true, then we increase the sleep period)
	    		if ($tmpTo == $toEmail) {
	    			sleep(3);
	    		} else {
	    			sleep(1);
	    		}
	
	    		// Set $tmpTo variable for checking next loop
	    		$tmpTo = $toEmail;
	    	}
    	}
    	
    	// Generate new unix timestamp for the send date/time
    	$sentDate = date("U");
    	
    	// Header definitions
    	
    	if ($type == 1) {
    	
	    	// PLAIN
    	    $headers = "From: \"" . $fromName . "\" <" . $fromEmail . ">\n\n";
    	    
    	} else if ($type == 2) {
    	
    		// HTML
    	
    	} else if ($type == 3) {
    	
    		// ATTACHMENTS
    		
	        $message = chunk_split( base64_encode( $message ) );
    		
    	    $headers = "From: \"" . $fromName . "\" <" . $fromEmail . ">\n";
    		
    		$headers .= "MIME-Version: 1.0\n";
			$headers .= "Content-Type: multipart/mixed; boundary=\"$mime_boundary\"\n\n";
    	    	
			$msg = "This is a multi-part message in MIME format.\n\n"; 
			$msg .= "--$mime_boundary\n";
			$msg .= "Content-Type: text/plain; charset=\"iso-8859-1\"\n";
			$msg .= "Content-Transfer-Encoding: 7bit\n\n";
			$msg .= "\n\n";

			$msg .= "--$mime_boundary\n";
 			$msg .= "Content-Type: application/pdf; name=\"attachment_$epoch.pdf\"\n";
			$msg .= "Content-Disposition: inline; filename=\"attachment_$epoch.pdf\"\n";
			$msg .= "Content-Transfer-Encoding: base64\n\n";
			$msg .= $message;
			$msg .= "\n\n";
			$msg .= "--$mime_boundary--\n";
    	
    		$message = $msg;
    	
    	}
    	
        // Check to see if system is using sendmail or built-in php mail() function
        if (ops("site_sendmailEnabled") == 1) {
        	
        	// Check to ensure variable is not empty
        	if (ops("site_sendmailLocal") != "") {
        	
				// Check to ensure the sendmail binary file handle is opened correctly
				if ($fd = popen(ops("site_sendmailLocal"), 'w')) {
					
					// Write details to binary handle
					fputs($fd, "To: $toEmail\n"); 
					fputs($fd, "Subject: $subject\n"); 
					fputs($fd, "X-Mailer: PHP4\n"); 
					
					// Check to see if headers are empty and write if available
					if ($headers != "") {
						fputs($fd, "$headers\n"); 
					} 
					
					// Write body / message to binary handle
					fputs($fd, "\n"); 
					fputs($fd, $message); 
					
					// Close binary handle
					pclose($fd);
					
				} else {
					
					// Handle could not be opened
					
					// Set notSent variable
					$notSent = 1;
				}
        	}
			
        } else {     
        	
			// Attempt to send mail - appropriate message regardless
			if (mail($toEmail, $subject, $message, $headers)) {

			} else {

				// Set notSent variable
				$notSent = 1;
			}
			
        }

        // Check to see if message was not sent
        if (!$notSent) {

        	// Update database; set sent variable = 1 if message sent successfuly
        	$idsQueryB = $_ENV['appDB']->query("update idsEmail set sent = 1, senttime = '$sentDate' where id = $id");
        	
        } else {

        }
        
        unset($notSent);
       
    }
        
}

function nmapScanProcessor() {
	
	/* NMAP SCAN PROCESSOR */
	
	if (@file_exists("tmp/demo.txt")) return;
	
	// Set initial variables for scheduling
    $todayDate = date("y-m-d");
    $todayDateName = substr(date("l"), 0, 3);
    $todayEpoch = strtotime($todayDate);
    $tomorrowEpoch = strtotime($todayDate) + 86400;

    $dayQuery = strtolower("$todayDateName = 1");	
	
    // Query to select the id of the next scan to process
    $idsQueryA = $_ENV['appDB']->query("select id, userid, runtime, runonce from idsScannerSchedule where $dayQuery and enabled = 1 and type = 1 and status != 5 and (runlast not between $todayEpoch and $tomorrowEpoch) order by id desc limit 1");
    while (list($id, $userid, $runtime, $runonce) = mysql_fetch_row($idsQueryA)) {

		if ($runonce == 1) {
			$runonceString = ", enabled = 0";
		}
    	
		$tmpEpoch = strtotime($todayDate . " $runtime");
		
		if ($tmpEpoch < time()) {
    	
		    $idsQueryB = $_ENV['appDB']->query("update idsScannerSchedule set status = 1 where id = '$id'");
	    	
	    	$returnData = performNmapScan($id);
	    	
	    	if ($returnData) {
	    		
			    $idsQueryC = $_ENV['appDB']->query("update idsScannerSchedule set status = '2', runlast = '" . date("U") . "' $runonceString where id = '$id'");
			    $idsQueryC = $_ENV['appDB']->query("insert into idsScannerResults (scanid, userid, data, intime) values ('$id', '$userid', '" . addslashes($returnData) . "', '" . date("U") . "')");
			    
	    	} else {
	    		
			    $idsQueryC = $_ENV['appDB']->query("update idsScannerSchedule set status = '3', runlast = '" . date("U") . "' $runonceString where id = '$id'");
				
	    	}
	    	
	    	unset($returnData);
		}
    }
}

function performNmapScan($id) {
	
	// Initialize scanner
	$scannner = new vulnScanner();

	// Load scan data
	$scannner->loadScan($id);

	$nmapBinary = ops("site_nmapBinaryLocation");
	
	if (!@file_exists(ops("site_nmapBinaryLocation"))) {
	
		return 0;
		
	}
	
	$optionsString = $scannner->getVar("options");
	$targetString = $scannner->getVar("host");
	
	$filename = "tmp/nmapResults-G-$id-" . date("U") . ".dat";
	
	$fileOutString = "-oX " . $filename;
	
	$timeMaxString = "--host-timeout 60s";
	
    $tmpExec = `$nmapBinary $optionsString $timeMaxString $fileOutString $targetString 2>&1`;		     
	
	if (@file_exists($filename)) {
		
		$return = @file_get_contents($filename);
		@unlink($filename);

		return $return;
		
	} else {
	
		return 0;
		
	}
}

function actionTextReplace($data, $action, $id, $module, $proto, $sip, $dip, $sport, $dport, $etypeid, $etypename, $enameid, $ename, $level, $payload, $sensorid, $timestamp) {

	/* Replaces text for emails which use keywords for replacing text */
	
	// Perform string replace on all keywords
	$data = str_replace("ACTIONID", $action, $data);
	$data = str_replace("AANVALID", $id, $data);
	$data = str_replace("PROTOCOL", $proto, $data);
	$data = str_replace("MODULE", $module, $data);
	$data = str_replace("SOURCE_IP", long2ip($sip), $data);
	$data = str_replace("DESTINATION_IP", long2ip($dip), $data);
	$data = str_replace("SOURCE_PORT", $sport, $data);
	$data = str_replace("DESTINATION_PORT", $dport, $data);
	$data = str_replace("SIG_NAME_ID", $enameid, $data);
	$data = str_replace("SIG_CLASS_ID", $etypeid, $data);
	$data = str_replace("SIG_NAME", $ename, $data);
	$data = str_replace("SIG_CLASS", $etypename, $data);
	$data = str_replace("RISK_LEVEL", $level, $data);
	$data = str_replace("PAYLOAD", $payload, $data);
	$data = str_replace("SENSOR", $sensorid, $data);
	$data = str_replace("TIMESTAMP", timeDisplay($timestamp, 1), $data);
	
	// Return data
	return $data;
}

function sendSignatureUpdateEmail($insert_array, $rev_array, $insert_count, $revision_count, $skip_count, $update_count, $delete_count) {

	if (strlen(ops("site_signatureUpdateEmail")) < 5) return;

	$sig_body .= "Signature Processing Report (limited to most recent 250 signatures):\n\n";

	$sig_body .= "Processing Count - New: $insert_count\n";
	$sig_body .= "Processing Count - Revisions: $revision_count\n";
	$sig_body .= "Processing Count - Skipped: $skip_count\n";
	$sig_body .= "Processing Count - Deleted: $delete_count\n";
	$sig_body .= "Processing Count - Policies Updated: $update_count\n";
	
	$sig_body .= "\n--------------------------\n";
	$sig_body .= "New Signatures\n";
	$sig_body .= "--------------------------\n";

	$idsQueryA = $_ENV['appDB']->query("SELECT * from idsSignatures WHERE id IN (" . implode(",", $insert_array) . ") ORDER BY id DESC LIMIT 125");
	while ($row = mysql_fetch_assoc($idsQueryA)) {

		$sig_body .= $row["class"] . " : " . $row["msg"] . "\n";
	
	}

	$sig_body .= "\n--------------------------\n";
	$sig_body .= "Updated Signatures\n";
	$sig_body .= "--------------------------\n";

	$idsQueryA = $_ENV['appDB']->query("SELECT * from idsSignatures WHERE id IN (" . implode(",", $rev_array) . ") ORDER BY id DESC LIMIT 125");
	while ($row = mysql_fetch_assoc($idsQueryA)) {

		$sig_body .= $row["class"] . " : " . $row["msg"] . "\n";
	
	}

    $to = trim(ops("site_signatureUpdateEmail"));
    $subject = ops("site_signatureUpdateEmailSubject");
    
    sendmail($to, "" . ops("site_consoleName") . " - Signature Processing", $to, $to, $subject, $sig_body);
    
}

function execCommand($cmd, $trackid) {

	$searchObj = new coreSearch();
	
	$eventData = $searchObj->getDetailsByID($trackid);

	$module = $eventData["moduleID"];
	$proto = $eventData["protocol"];
	$sip = $eventData["sip"];
	$dip = $eventData["dip"];
	$sport = $eventData["sport"];
	$dport = $eventData["dport"];
	$etypeid = $eventData["class"];
	$etypename = $eventData["className"];
	$enameid = $eventData["signature"];
	$ename = $eventData["signatureName"];
	$level = $eventData["priority"];
	$payload = $eventData["payload"];
	$sensorid = $eventData["sensorID"];
	$timestamp = $eventData["timestamp"];

	$cmd = actionTextReplace($cmd, $actionid, $trackid, $module, $proto, $sip, $dip, $sport, $dport, $etypeid, $etypename, $enameid, $ename, $level, $payload, $sensorid, $timestamp);
    
	$_ENV['appLog']->log('CONSOLE', "Command Executed: $cmd");

    $fp = popen($cmd, 'r');
    
    while(!feof($fp)) {
    
        $read .= fread($fp,1024);
        
    }
    
    pclose($fp);

}

function sigProcessor() {

    if ((ops("site_sigProcessorEnabled") != 1)) return;
    
    // Initialize
    
	$omc = ops("site_sigOinkCode");

	// Prepare download locations
	
    @mkdir("smt/snortRules/data");
    @chmod("smt/snortRules/data", 0777);
	
	// Warnings
	
	if (!$omc || $omc == "") {

	}
	
	// Test for semaphore
	
    if (ops("site_sigFileCustom") != "") {
	    $file = ops("site_sigFileCustom");
	    if(file_exists("smt/snortRules/$file")) $fileFound = 1;
    }    
	
	// Query available signature sources
	
	$q = $_ENV['appDB']->query("SELECT * FROM idsSignatureSources WHERE enabled = 1 ORDER BY id");
	while ($row = mysql_fetch_assoc($q)) {
	
		if (($row["lastDownload"] + ops("site_sigProcessorFrequency")) < time()) ops("site_sigProcessorNow", 1);
		
		if (ops("site_sigProcessorNow") == 1) {

			// Clean up

			$runOnce = true;

			rmdir("smt/snortRules/ptmp");
		    @mkdir("smt/snortRules/ptmp");

			// Process this source

			$tmp_pfile = rand(1000,9999) . ".tar.gz";
			
			if (strtolower(substr($row["location"], 0, 4)) == "http") {
			
				// Replace OMC with code
				$row["location"] = str_replace("OMC", $omc, $row["location"]);
	
				// Download
			    $data = exConnect($row["location"]);
			    
			    // Write
			    if ($handle = fopen("smt/snortRules/ptmp/$tmp_pfile", "w")) {
			    
			    	fputs($handle, $data);
			    	fclose($handle);
			    	
			    } else {
			    
			    }
			
			} else {
	
				// Copy
				
				@copy($row["location"], "smt/snortRules/ptmp/$tmp_pfile");
				
			}
			
		    if (@file_exists("smt/snortRules/ptmp/$tmp_pfile")) {
		    
				$_ENV['appDB']->query("UPDATE idsSignatureSources SET lastFilesize = '" . filesize("smt/snortRules/ptmp/$tmp_pfile") . "' WHERE id = '" . $row["id"] . "'");
		    
				// Import signatures
				sigImporter($tmp_pfile, $row["id"]);

			} else {
			
			}
			
			$_ENV['appDB']->query("UPDATE idsSignatureSources SET lastDownload = '" . time() . "' WHERE id = '" . $row["id"] . "'");
		
		}

	}

	// Clear forced signature processing flag

	ops("site_sigProcessorNow", "0");
	
	ops("site_sigLastDownload", time());

	if ($runOnce) insertUserMessage(1, 3, "Signature Importing Complete");

}

function sigImporter($pkg, $source) {
	
	$path = "smt/snortRules/ptmp/";

	$insert_count = 0;
	$revision_count = 0;
	$skip_count = 0;
	$update_count = 0;
	$delete_count = 0;
	
	$ruleDirectoryArray = array("rules", "so_rules", "preproc_rules");
	
	// Uncompress and remove files	
	@exec("gunzip -c $path/$pkg | tar -xvf - -C $path");
	@unlink($path . $pkg);

	foreach ($ruleDirectoryArray as $ruleDir) {

		unset($rules_array);
	
		// rules	
		if ($thisDir = @dir($path . "/$ruleDir/")) { 
			while ($file = $thisDir->read()) {
				if ($file != "." && $file != "..") {
					if (substr($file, -6) == ".rules") {
					
						if (!in_array($file, array("deleted.rules", "xyz.rules"))) {
							
							$rules_array[] = $file;
							
						}
					
					}
				}
			}
	    }
	    
		foreach ($rules_array as $file) {
	    
			if ($content = @file("$path/$ruleDir/$file")) {
			
				foreach ($content as $line) {
				
					unset($array, $sid, $gid, $rev, $foundSignature, $newSignatureID);
				
					if (strstr($line, "alert") && strstr($line, "sid:")) {
	
						# Signature line
	
						$line = trim($line);
						if (strstr(substr($line, 0, 1), "#")) $line = substr($line, 1);
						$line = trim($line);
			
						preg_match("/sid:\s*[0-9]+/", $line, $match);
						$sid = trim(str_replace("sid:", "", $match[0]));
			
						preg_match("/gid:\s*[0-9]+/", $line, $match);
						$gid = trim(str_replace("gid:", "", $match[0]));
						if (!$gid) $gid = 1;
	
						preg_match("/rev:\s*[0-9]+/", $line, $match);
						$rev = trim(str_replace("rev:", "", $match[0]));
						if (!$rev) $rev = 1;
	
						preg_match("/classtype:\s?([^;]*);/", $line, $match);
						$class = trim(str_replace("classtype:", "", $match[0]));
						$class = str_replace(";", "", $class);
						$class = addslashes($class);
					
						preg_match("/msg:\s?\"([^\"]*)\"/", $line, $match);
						$msg = trim(str_replace("msg:", "", $match[0]));
						$msg = str_replace("\"", "", $msg);
						$msg = addslashes($msg);
						
						$data = addslashes($line);
					
		   	 			$idsQueryA = $_ENV['appDB']->query("SELECT * from idsSignatures WHERE sid = '$sid' AND gid = '$gid' ORDER BY rev DESC LIMIT 1");
						while ($row = mysql_fetch_assoc($idsQueryA)) {
			
							# Found existing signature
							
							$foundSignature = true;
							
							// If revision is greater, we'll insert into db and update policies if applicable						
							
							if ($rev > $row["rev"]) {
							
								// New revision of signature available

								// Insert
																
				   	 			$idsQueryA = $_ENV['appDB']->query("INSERT INTO idsSignatures (sid, gid, rev, msg, class, file, source, data, intime) VALUES ('$sid', '$gid', '$rev', '$msg', '$class', '$file', '$source', '$data', '" . time() . "')");

								$newSignatureID = mysql_insert_id();
								
								// Update any matching id's in the policy index

								if (ops("site_policyRevisionUpdate") == 1) {

					   	 			$_ENV['appDB']->query("UPDATE idsSignaturePolicyIndex SET sid = '$newSignatureID' WHERE sid = '" . $row["id"] . "'");
					   	 			
					   	 			$update_count++;
					   	 			
					   	 		}

								// Delete existing signature
								
								if (ops("site_signatureRevisionReplace") == 1) {

					   	 			$_ENV['appDB']->query("DELETE FROM idsSignatures WHERE id = '" . $row["id"] . "'");

					   	 			$delete_count++;

								}								

#								echo "INSERT REVISION: $file - SID:$sid GID:$gid REV:$rev CLASS:$class\n";
								
								$revision_count++;
								
				   	 			$rev_array[] = $newSignatureID;
								
							} else {
	
#								echo "SKIPPING: $file - SID:$sid GID:$gid REV:$rev CLASS:$class\n";
							
								$skip_count++;
								
							}

						}
						
						if (!$foundSignature) {
						
							// Signature not found in database
							
			   	 			$_ENV['appDB']->query("INSERT INTO idsSignatures (sid, gid, rev, msg, class, file, source, data, intime) VALUES ('$sid', '$gid', '$rev', '$msg', '$class', '$file', '$source', '$data', '" . time() . "')");
							
							$newSignatureID = mysql_insert_id();
							
#							echo "INSERT: $file - SID:$sid GID:$gid REV:$rev CLASS:$class\n";
							
							$insert_count++;
							
			   	 			$insert_array[] = $newSignatureID;
							
						}						
				
					} else {
					
						# Not a signature line
					
					}
	
				}
			
			}
	
		}
		
	}
	
	if (($insert_count + $revision_count + $skip_count + $update_count + $delete_count) > 0) {
	
	    // Trigger Sensors to retreive new signatures
	    
	    $idsQueryA = $_ENV['appDB']->query("SELECT id, name FROM idsSensor WHERE confPolicy > 0 AND module = 1");
		while ($row = mysql_fetch_assoc($idsQueryA)) {
	    
	        $idsQueryB = $_ENV['appDB']->query("INSERT INTO idsSensorManageMessages (sid, message, enabled, issued) VALUES ('" . $row["id"] . "', 'SNORTRULESSEND', '1', '" . time() . "')");
	        
	        $idsQueryB = $_ENV['appDB']->query("INSERT INTO idsSensorManageMessages (sid, message, enabled, issued) VALUES ('" . $row["id"] . "', 'SNORTRESTART', '1', '" . time() . "')");
	        
	    }
	
		sendSignatureUpdateEmail($insert_array, $rev_array, $insert_count, $revision_count, $skip_count, $update_count, $delete_count);
		
	}
	
}

function analysisProcessor() {

    $objSensor = new mySensor();
    $sensorArray = $objSensor->getSensorIDs(1);
    
    if (count($sensorArray) == 0) return;
    
    foreach ($sensorArray as $sensor) {

	    $epoch = date("U");
    	$objSensor->loadSensor($sensor);
    	
	    ### Sensor Status ###
	    
    	if ($objSensor->getSensorVar("countStatusFailure") >= 5 && $objSensor->getSensorVar("countStatusFailure") <= 10) {

    		// Update status count to bypass this section
    		$objSensor->setSensorVar("lastStatusFailure", $epoch);
    		
    		// Email
    		if ($objSensor->getSensorVar("emailOnStatusFailure") != "") {
				$to = trim($objSensor->getSensorVar("emailOnStatusFailure"));
				$subject = "Snort Restart Attempted: " . $objSensor->getSensorVar("id") . " [" . $objSensor->getSensorVar("name") . "]";
				$message = "Problem:\n";
				$message .= "Snort appears to have stopped on sensor '" . $objSensor->getSensorVar("name") . "'.\n\n";
				$message .= "Solution:\n";
                $message .= "The console attempted to restart snort and if successful, you will not receive any further emails. ";
                $message .= "However, if this snort restart fails you will receive additional updates via email and ";
                $message .= "should investigate the problem as soon as possible.\n\n";
                $message .= "---\nStatus Failure Count: " . $objSensor->getSensorVar("countStatusFailure") . "\n---\n";
				sendmail("intrusion@console.com", "Intrusion Detection Console", $to, $to, $subject, $message);
    		}
    		
    		// Update status count to bypass this section
    		$objSensor->setSensorVar("countStatusFailure", 11);

    		// Issue snort restart
    		sensorMessagePost("SNORTRESTART", $sensor);
    		
    	} else if ($objSensor->getSensorVar("countStatusFailure") >= 30 && $objSensor->getSensorVar("countStatusFailure") <= 40) {

    		// Email
    		if ($objSensor->getSensorVar("emailOnStatusFailure") != "") {
				$to = trim($objSensor->getSensorVar("emailOnStatusFailure"));
				$subject = "Snort Status Failure: " . $objSensor->getSensorVar("id") . " [" . $objSensor->getSensorVar("name") . "]";
				$message = "Priority 1 of 4:\n---\n\nProblem:\n";
				$message .= "A problem with snort sensor '" . $objSensor->getSensorVar("name") . "' has been detected. ";
                $message .= "This usually indicates the snort process is no longer running on the mentioned sensor.\n\n";
                $message .= "The console has already attempted an automatic restart of snort, however it appears to have failed.\n\n";
				$message .= "Solution:\n";
                $message .= "The console will attempt to restart snort again momentarily, if this fails you will ";
                $message .= "receive an additional warning by email and should begin resolving the problem as quickly as possible.\n\n";
                $message .= "---\nStatus Failure Count: " . $objSensor->getSensorVar("countStatusFailure") . "\n---\n";
				sendmail("intrusion@console.com", "Intrusion Detection Console", $to, $to, $subject, $message);
    		}
    		
    		// Issue snort restart
    		sensorMessagePost("SNORTRESTART", $sensor);
    		
    		// Update status count to bypass this section
    		$objSensor->setSensorVar("countStatusFailure", 41);    		
    		
    	} else if ($objSensor->getSensorVar("countStatusFailure") >= 100 && $objSensor->getSensorVar("countStatusFailure") <= 110) {

    		// Email
    		if ($objSensor->getSensorVar("emailOnStatusFailure") != "") {
				$to = trim($objSensor->getSensorVar("emailOnStatusFailure"));
				$subject = "Snort Status Failure: " . $objSensor->getSensorVar("id") . " [" . $objSensor->getSensorVar("name") . "]";
				$message = "Priority 2 of 4:\n---\n\nProblem:\n";
				$message .= "The problem with snort sensor '" . $objSensor->getSensorVar("name") . "' has not been resolved. ";
                $message .= "The snort process appears to no longer be running or the console can no longer detect its presence.\n\n";
                $message .= "The console has already attempted an automatic restart of snort twice, however both attempts appear to have ";
                $message .= "failed and this situation requires human intervention to be resolved.\n\n";
				$message .= "Solution:\n";
                $message .= "The console will continue to monitor snort and wait for the situation to be resolved. If this problem is not ";
                $message .= "resolved within the next 15 - 20 minutes, additional warning emails will be sent as a reminder.\n\n";
                $message .= "---\nStatus Failure Count: " . $objSensor->getSensorVar("countStatusFailure") . "\n---\n";
				sendmail("intrusion@console.com", "Intrusion Detection Console", $to, $to, $subject, $message);
    		}
    		
    		// Update status count to bypass this section
    		$objSensor->setSensorVar("countStatusFailure", 111); 
    		    		
    	} else if ($objSensor->getSensorVar("countStatusFailure") >= 460 && $objSensor->getSensorVar("countStatusFailure") <= 470) {

    		// Email
    		if ($objSensor->getSensorVar("emailOnStatusFailure") != "") {
				$to = trim($objSensor->getSensorVar("emailOnStatusFailure"));
				$subject = "Snort Status Failure: " . $objSensor->getSensorVar("id") . " [" . $objSensor->getSensorVar("name") . "]";
				$message = "Priority 3 of 4:\n---\n\nProblem:\n";
				$message .= "The problem with snort sensor '" . $objSensor->getSensorVar("name") . "' remains to be unresolved. ";
                $message .= "The snort process appears to no longer be running or the console can no longer detect its presence.\n\n";
                $message .= "This is a reminder by email that this issue requires human intervention.\n\n";
				$message .= "Solution:\n";
                $message .= "The console will attempt to restart snort one last time, to assist with this problem. However, the console ";
                $message .= "will continue to monitor snort and wait for the situation to be resolved. If this problem is not ";
                $message .= "resolved within the next 15 - 20 minutes, one last email warning will be sent as a reminder.\n\n";
                $message .= "---\nStatus Failure Count: " . $objSensor->getSensorVar("countStatusFailure") . "\n---\n";
				sendmail("intrusion@console.com", "Intrusion Detection Console", $to, $to, $subject, $message);
    		}
    		
    		// Issue snort restart
    		sensorMessagePost("SNORTRESTART", $sensor);
    		
    		// Update status count to bypass this section
    		$objSensor->setSensorVar("countStatusFailure", 471);     		
    		
    	} else if ($objSensor->getSensorVar("countStatusFailure") >= 820 && $objSensor->getSensorVar("countStatusFailure") <= 830) {

    		// Email
    		if ($objSensor->getSensorVar("emailOnStatusFailure") != "") {
				$to = trim($objSensor->getSensorVar("emailOnStatusFailure"));
				$subject = "Snort Status Failure: " . $objSensor->getSensorVar("id") . " [" . $objSensor->getSensorVar("name") . "]";
				$message = "Priority 4 of 4:\n---\n\nProblem:\n";
				$message .= "This is your last reminder / warning email.\n\n";
				$message .= "The problem with snort sensor '" . $objSensor->getSensorVar("name") . "' remains to be unresolved. ";
                $message .= "The snort process appears to no longer be running or the console can no longer detect its presence. The process ";
				$message .= "has not been running for quite some time now and needs to be resolved immediately. ";
                $message .= "This is a reminder by email that this issue requires human intervention.\n\n";
				$message .= "Solution:\n";
                $message .= "The console has attempted to restart snort several times and appears to have failed. Human intervention is ";
                $message .= "required at this point in time. This is your last email concerning this sensor status issue at this time.\n\n";
                $message .= "---\nStatus Failure Count: " . $objSensor->getSensorVar("countStatusFailure") . "\n---\n";
				sendmail("intrusion@console.com", "Intrusion Detection Console", $to, $to, $subject, $message);
    		}
    		
    		// Update status count to bypass this section
    		$objSensor->setSensorVar("countStatusFailure", 831);
    	}
    	
    	### Comm ###

		if (($epoch - 30) > $objSensor->getSensorVar("hb") && $objSensor->getSensorVar("hbcount") > 0) {
    		$objSensor->setSensorVar("lastCommFailure", $epoch);
    		$objSensor->setSensorVar("countCommFailure", $objSensor->getSensorVar("countCommFailure") + 1);
		} else {
    		$objSensor->setSensorVar("countCommFailure", 0);
		}
    	
		if ($objSensor->getSensorVar("countCommFailure") >= 10 && $objSensor->getSensorVar("countCommFailure") <= 20) {
    		$objSensor->setSensorVar("lastCommFailure", $epoch);

    		// Email
    		if ($objSensor->getSensorVar("emailOnCommFailure") != "") {
				$to = trim($objSensor->getSensorVar("emailOnCommFailure"));
				$subject = "SMT Communication Failure: " . $objSensor->getSensorVar("id") . " [" . $objSensor->getSensorVar("name") . "]";
				$message = "Priority 1 of 4:\n---\n\nProblem:\n";
				$message .= "A communication issue with sensor '" . $objSensor->getSensorVar("name") . "' and the console has been detected. ";
                $message .= "This usually indicates a network connectivity related issue has occurred or the sensor management tools ";
                $message .= "have stopped.\n\n";
				$message .= "Solution:\n";
                $message .= "The console will continue to monitor the progress of this issue, however this should be reviewed as soon as ";
                $message .= "possible in the event there is a serious network or system problem.\n\n";
                $message .= "Additional email warnings will be sent shortly if this problem is not resolved.\n\n";
                $message .= "---\nCommunication Failure Count: " . $objSensor->getSensorVar("countCommFailure") . "\n---\n";
				sendmail("intrusion@console.com", "Intrusion Detection Console", $to, $to, $subject, $message);
    		}    		
    		
    		// Update status count to bypass this section
    		$objSensor->setSensorVar("countCommFailure", 21);
    		
		} else if ($objSensor->getSensorVar("countCommFailure") >= 100 && $objSensor->getSensorVar("countCommFailure") <= 110) {
    		$objSensor->setSensorVar("lastCommFailure", $epoch);

    		// Email
    		if ($objSensor->getSensorVar("emailOnCommFailure") != "") {
				$to = trim($objSensor->getSensorVar("emailOnCommFailure"));
				$subject = "SMT Communication Failure: " . $objSensor->getSensorVar("id") . " [" . $objSensor->getSensorVar("name") . "]";
				$message = "Priority 2 of 4:\n---\n\nProblem:\n";
				$message .= "A communication issue with sensor '" . $objSensor->getSensorVar("name") . "' remains to be resolved. ";
                $message .= "This usually indicates it is less a network connectivity related issue and a higher chance of it being ";
                $message .= "a server or sensor management tool related issue.\n\n";
				$message .= "Solution:\n";
                $message .= "The console will continue to monitor the progress of this issue, however this should be reviewed as soon as ";
                $message .= "possible in the event there is a serious or critical network or system related issue.\n\n";
                $message .= "Additional email warnings will be sent shortly if this problem is not resolved.\n\n";
                $message .= "---\nCommunication Failure Count: " . $objSensor->getSensorVar("countCommFailure") . "\n---\n";
				sendmail("intrusion@console.com", "Intrusion Detection Console", $to, $to, $subject, $message);
    		}    		
    		
    		// Update status count to bypass this section
    		$objSensor->setSensorVar("countCommFailure", 111);

		} else if ($objSensor->getSensorVar("countCommFailure") >= 400 && $objSensor->getSensorVar("countCommFailure") <= 410) {
    		$objSensor->setSensorVar("lastCommFailure", $epoch);
    		
    		// Email
    		if ($objSensor->getSensorVar("emailOnCommFailure") != "") {
				$to = trim($objSensor->getSensorVar("emailOnCommFailure"));
				$subject = "SMT Communication Failure: " . $objSensor->getSensorVar("id") . " [" . $objSensor->getSensorVar("name") . "]";
				$message = "Priority 3 of 4:\n---\n\nProblem:\n";
				$message .= "A communication issue with sensor '" . $objSensor->getSensorVar("name") . "' has yet to be remedied. ";
                $message .= "This prolonged communication outage usually indicates the server is unavailable or the sensor management tools ";
                $message .= "have stopped or failed.\n\n";
				$message .= "Solution:\n";
                $message .= "The console will continue to monitor the progress of this issue, however this should be reviewed as soon as ";
                $message .= "possible in the event there is a critical system related issue going on unnoticed.\n\n";
                $message .= "One more email warning will be sent as a reminder to get this problem resolved.\n\n";
                $message .= "---\nCommunication Failure Count: " . $objSensor->getSensorVar("countCommFailure") . "\n---\n";
				sendmail("intrusion@console.com", "Intrusion Detection Console", $to, $to, $subject, $message);
    		}      		
    		
    		// Update status count to bypass this section
    		$objSensor->setSensorVar("countCommFailure", 411);

		} else if ($objSensor->getSensorVar("countCommFailure") >= 800 && $objSensor->getSensorVar("countCommFailure") <= 810) {
    		$objSensor->setSensorVar("lastCommFailure", $epoch);
    		
    		// Email
    		if ($objSensor->getSensorVar("emailOnCommFailure") != "") {
				$to = trim($objSensor->getSensorVar("emailOnCommFailure"));
				$subject = "SMT Communication Failure: " . $objSensor->getSensorVar("id") . " [" . $objSensor->getSensorVar("name") . "]";
				$message = "Priority 4 of 4:\n---\n\nProblem:\n";
				$message .= "This is your last reminder / warning email.\n\n";
				$message .= "The communication issue with sensor '" . $objSensor->getSensorVar("name") . "' continues to be a problem. ";
                $message .= "This prolonged communication outage will affect sensor management functionality if not resolved soon.\n\n";
				$message .= "Solution:\n";
                $message .= "Human intervention is required to identify the specific cause of this communication outage and to resolve it ";
                $message .= "promptly. This is your last email concerning this sensor communication related issue at this time.\n\n";
                $message .= "---\nCommunication Failure Count: " . $objSensor->getSensorVar("countCommFailure") . "\n---\n";
				sendmail("intrusion@console.com", "Intrusion Detection Console", $to, $to, $subject, $message);
    		}      		
    		
    		// Update status count to bypass this section
    		$objSensor->setSensorVar("countCommFailure", 811);
		}    		
    }
	
}

function actionEmail($actionid, $trackid, $toEmail) {

    // Build action object and load master details
    $objAction = new myAction();
	$objAction->actionMasterLoad($actionid);
	
	// Set userid variable for query
    $uid = $objAction->getActionMasterVar("userid");

    // Query user details for defaults
    $idsQueryA = $_ENV['appDB']->query("select email, fname, lname from idsUsers where id = '$uid'");
    while (list($d_email, $d_fname, $d_lname) = mysql_fetch_row($idsQueryA)) {
        $email = $d_email;
        $fname = $d_fname;
        $lname = $d_lname;
    }

	$searchObj = new coreSearch();
	$eventData = $searchObj->getDetailsByID($trackid);
    
	$module = $eventData["moduleID"];
	$proto = $eventData["protocol"];
	$sip = $eventData["sip"];
	$dip = $eventData["dip"];
	$sport = $eventData["sport"];
	$dport = $eventData["dport"];
	$etypeid = $eventData["class"];
	$etypename = $eventData["className"];
	$enameid = $eventData["signature"];
	$ename = $eventData["signatureName"];
	$level = $eventData["priority"];
	$payload = $eventData["payload"];
	$sensorid = $eventData["sensorID"];
	$timestamp = $eventData["timestamp"];
	
    // Set sensor name for sensorid variable
    $objSensor = new mySensor;
    $sensorid = $objSensor->getSensorName($sensorid);
	
    // Retrieve proto name by number
    if ($proto == 1) $proto = "ICMP";
    if ($proto == 6) $proto = "TCP";
    if ($proto == 17) $proto = "UDP";

    // Check if snort and decode payload
    if ($module == 1) { 
    	$payload = packetPayload($payload, 3, 1);
    }        

	// Set sender name
    if ($objAction->getActionMasterVar("senderName") == "") {
    	$fromName = "$fname $lname";
    } else {
    	$fromName = $objAction->getActionMasterVar("senderName");
    }        
    
	// Set sender email
    if ($objAction->getActionMasterVar("senderEmail") == "") {
    	$fromEmail = "$email";
    } else {
    	$fromEmail = $objAction->getActionMasterVar("senderEmail");
    }           
    
    // Set subject
    if ($objAction->getActionMasterVar("senderSubject") == "") {
    	$subject = "! " . ops("site_consoleName") . " Alert ($ename)";
    } else {

    	// Set subject and run through text replace
    	$subject = actionTextReplace($objAction->getActionMasterVar("senderSubject"), $actionid, $trackid, $module, $proto, $sip, $dip, $sport, $dport, $etypeid, $etypename, $enameid, $ename, $level, $payload, $sensorid, $timestamp);
    }        
    
    // Set body
    if ($objAction->getActionMasterVar("senderBody") == "") {
    
    	$body = "The following alert was generated by the " . ops("site_consoleName") . " Intrusion Detection Console.\n---\n\n";
    	$body .= "Timestamp: TIMESTAMP\n\n";
    	$body .= "Risk Level: RISK_LEVEL\n\n";
	    $body .= "Source IP: SOURCE_IP : SOURCE_PORT\n";
	    $body .= "Destination IP: DESTINATION_IP : DESTINATION_PORT\n";
	    $body .= "Sensor: SENSOR\n\n";
	    $body .= "Detected Event: SIG_NAME (SIG_NAME_ID)\n\n";
	    $body .= "Detected Event Category: SIG_CLASS (SIG_CLASS_ID)\n\n";
	    $body .= "" . ops("site_consoleName") . " ID: AANVALID\n";
	    $body .= "Action ID: ACTIONID\n";
		$body .= "---\n";
	    $body .= "Payload:\n";
	    $body .= "PAYLOAD\n";
    
    	$body = actionTextReplace($body, $actionid, $trackid, $module, $proto, $sip, $dip, $sport, $dport, $etypeid, $etypename, $enameid, $ename, $level, $payload, $sensorid, $timestamp);
    } else {
    	
    	// Set body and run through text replace
    	$body = actionTextReplace($objAction->getActionMasterVar("senderBody"), $actionid, $trackid, $module, $proto, $sip, $dip, $sport, $dport, $etypeid, $etypename, $enameid, $ename, $level, $payload, $sensorid, $timestamp);
    }
    
    // Send email
    sendmail($fromEmail, $fromName, $toEmail, $toEmail, $subject, $body);
}

?>