<?php

class myAction {

	var $ignoreArray = array();

	function setActionMasterVar($key, $value) {
		$this->s_vars[$key] = $value;
	}

	function getActionMasterVar($key) {
		$this->s_vars[$key] = stripslashes($this->s_vars[$key]);
		return $this->s_vars[$key]; 
	} 
	
	function setActionStoreVar($key, $value) {
		$this->s_vars[$key] = $value;
	}

	function getActionStoreVar($key) {
		$this->s_vars[$key] = stripslashes($this->s_vars[$key]);
		return $this->s_vars[$key]; 
	} 	

    function actionMasterLoad($id) {
    	
		if ($id == "") $id = 9999999;

		$idsQueryA = $_ENV['appDB']->query("SELECT id, userid, name, description, threshold, thresholdcount, thresholdtime, thresholdeventtime, count, matchtype, onetime, enabled, deleted, 
			intime, senderName, senderEmail, senderSubject, senderBody FROM idsActionMaster where id = $id");
        for ($i = 0; $row = mysql_fetch_row($idsQueryA); $i++) {
            $this->setActionMasterVar("id", "$row[0]");
            $this->setActionMasterVar("userid", "$row[1]");
            $this->setActionMasterVar("name", "$row[2]");
            $this->setActionMasterVar("description", "$row[3]");
            $this->setActionMasterVar("threshold", "$row[4]");
            $this->setActionMasterVar("thresholdcount", "$row[5]");
            $this->setActionMasterVar("thresholdtime", "$row[6]");
            $this->setActionMasterVar("thresholdeventtime", "$row[7]");
            $this->setActionMasterVar("count", "$row[8]");
            $this->setActionMasterVar("matchtype", "$row[9]");
            $this->setActionMasterVar("onetime", "$row[10]");
            $this->setActionMasterVar("enabled", "$row[11]");
            $this->setActionMasterVar("deleted", "$row[12]");
            $this->setActionMasterVar("intime", "$row[13]");
            $this->setActionMasterVar("senderName", "$row[14]");
            $this->setActionMasterVar("senderEmail", "$row[15]");
            $this->setActionMasterVar("senderSubject", "$row[16]");
            $this->setActionMasterVar("senderBody", "$row[17]");
        }
    }

    function actionStoreLoad($id) {
    	global $idsDB;
    	
		if ($id == "") $id = 9999999;

		$idsQueryA = $_ENV['appDB']->query("SELECT id, masterid, class, type, data, intime FROM idsActionStore where id = $id");
        for ($i = 0; $row = mysql_fetch_row($idsQueryA); $i++) {
            $this->setActionStoreVar("id", "$row[0]");
            $this->setActionStoreVar("masterid", "$row[1]");
            $this->setActionStoreVar("class", "$row[2]");
            $this->setActionStoreVar("type", "$row[3]");
            $this->setActionStoreVar("data", "$row[4]");
            $this->setActionStoreVar("intime", "$row[5]");
        }
    }    
    
	function getActionMasterIDs() {
    	global $idsDB;
		
		/* Returns an array of enabled action id's */
		
		// Query for enabled id's
		$idsQueryA = $_ENV['appDB']->query("SELECT id from idsActionMaster where enabled = 1 and deleted = 0 order by weight asc");
		for ($i = 0; $row = mysql_fetch_row($idsQueryA); $i++) {
			$array[] = $row[0];
		}
		
		// Returns array of id's
		return $array;
	}

	function getActionStoreIDs($id, $type) {
    	global $idsDB;
	
		/* Returns an array of enabled action store id's */
		
		// Query for enabled id's
		$idsQueryA = $_ENV['appDB']->query("SELECT id from idsActionStore where masterid = $id and class = $type order by id");
		for ($i = 0; $row = mysql_fetch_row($idsQueryA); $i++) {
			$array[] = $row[0];
		}
		
		// Returns array of id's
		return $array;		
	}
	
	function actionSetWeight($id, $weight) {
    	global $idsDB;
		
		// Set Weight
		$idsQueryA = $_ENV['appDB']->query("update idsActionMaster set weight = $weight where id = $id");
	
	}
	
	function setThresholdEventTime() {
		// Stores the epoch temporarily for comparison of time for thresholdtime matching
		// This is reset in incrementThreshold()
		
		if ($this->getActionMasterVar("thresholdeventtime") == 0) {
			$this->setActionMasterVar("thresholdeventtime", date("U"));
			$this->actionMasterSave();
		}
	}

	function incrementThreshold() {
		if ($this->getActionMasterVar("threshold") > 0) {
			$epoch = date("U");
			
			// TIME SENSITIVE THRESHOLDS CHECK
			if ($this->getActionMasterVar("thresholdtime") > 0) {
				if (($epoch - $this->getActionMasterVar("thresholdtime")) < $this->getActionMasterVar("thresholdeventtime")) {
					$current = $this->getActionMasterVar("thresholdcount");
					$this->setActionMasterVar("thresholdcount", ($current+1));
					$this->actionMasterSave();
				} else {
					$this->setActionMasterVar("thresholdcount", 0);
					$this->setActionMasterVar("thresholdeventtime", 0);
					$this->actionMasterSave();
				}
			} else {
				$current = $this->getActionMasterVar("thresholdcount");
				$this->setActionMasterVar("thresholdcount", ($current+1));
				$this->actionMasterSave();
			}
		}
	}

	function incrementCount() {
		
		/* Increment action match count */
		
		// Set current count variable
		$current = $this->getActionMasterVar("count");
		
		// Increment current + 1
		$this->setActionMasterVar("count", ($current+1));
		
		// Save changes
		$this->actionMasterSave();
		
	}

    function oneTimeCheck() {
    	
    	/* Check if this is a match one time only action */
    	
    	// If match one time only => disable
    	if ($this->getActionMasterVar("onetime") == 1) {
    		
    		// Disable via toggle function (which will save changes after toggle)
    		$this->actionMasterToggle();
    	}
    	
    }

	function actionMasterDelete($id) {
        global $idsDB;

        /* Delete action permanently from database */

		// Delete query using action id and user id
		$_ENV['appDB']->query("delete from idsActionMaster where id = '$id' and userid = '" . login("id") . "'");
		$_ENV['appDB']->query("delete from idsActionStore where masterid = '$id'");
		
	}

	function actionStoreDelete($id) {
        global $idsDB;

        /* Delete action store permanently from database */

		// Delete query using action id and user id
		$_ENV['appDB']->query("delete from idsActionStore where id = '$id'");
		
	}	
	
    function actionMasterToggle() {
    	
    	/* Enable / disable action toggle function */
    	
    	// If disabled => enable
        if ($this->getActionMasterVar("enabled") == 0) {
                $this->setActionMasterVar("enabled", 1);
                
        // If enabled => disable
        } else if ($this->getActionMasterVar("enabled") == 1) {
                $this->setActionMasterVar("enabled", 0);
        }

        // Save toggle change
        $this->actionMasterSave();
    }

    function actionCountReset($id) {
    	
    	/* Reset master count (to 0) */
    	
    	$this->actionMasterLoad($id);
        $this->setActionMasterVar("count", 0);
                
        // Save changes
        $this->actionMasterSave();
    }    
    
    function actionMasterSave() {
    	global $idsDB;

    	/* Saves changes to database for current instantiated action master object */
    	
		// Update Query
		$idsQueryA = $_ENV['appDB']->query("update idsActionMaster set
            name = '" . $this->getActionMasterVar("name") . "',
            description = '" . $this->getActionMasterVar("description") . "',
            threshold = '" . $this->getActionMasterVar("threshold") . "',
            thresholdcount = '" . $this->getActionMasterVar("thresholdcount") . "',
            thresholdtime = '" . $this->getActionMasterVar("thresholdtime") . "',
            thresholdeventtime = '" . $this->getActionMasterVar("thresholdeventtime") . "',
            count = '" . $this->getActionMasterVar("count") . "',
            matchtype = '" . $this->getActionMasterVar("matchtype") . "',
            deleted = '" . $this->getActionMasterVar("deleted") . "',
            enabled = '" . $this->getActionMasterVar("enabled") . "',
            senderName = '" . $this->getActionMasterVar("senderName") . "',
            senderEmail = '" . $this->getActionMasterVar("senderEmail") . "',
            senderSubject = '" . $this->getActionMasterVar("senderSubject") . "',
            senderBody = '" . $this->getActionMasterVar("senderBody") . "',
            onetime = '" . $this->getActionMasterVar("onetime") . "'
        where id = '" . $this->getActionMasterVar("id") . "'");
    }
    
    function actionStoreSave() {

    	/* Saves changes to database for current instantiated action store object */
    	
		// Update Query
		$idsQueryA = $_ENV['appDB']->query("update idsActionStore set
            type = '" . $this->getActionStoreVar("type") . "',
            data = '" . $this->getActionStoreVar("data") . "'
        where id = '" . $this->getActionStoreVar("id") . "'");
    }    
    
    function newActionMatcher($eventData) {

    	// Retrieve array of master id's
		$masterIDs = $this->getActionMasterIDs();

		if ($eventData->actionated != 1) {

			// Convert payload only if snort / hex
			if ($eventData->moduleID == 1) $eventData->payload = packetPayload($eventData->payload, 3, 1);

			$totalMatch = $this->actionMatchCheck($masterIDs, $eventData->id, $eventData->moduleID, $eventData->signature, $eventData->class, $eventData->sensorID, $eventData->sip, $eventData->dip, $eventData->sport, $eventData->dport, $eventData->protocol, $eventData->priority, $eventData->payload, $eventData->signatureName, $eventData->className);
			
			// Update event

			$_ENV['appDB']->query("update idsDataStore_" . ops("site_activeDataStore") . "_Master set actionated = 1 where id = '" . $eventData->id . "'");

		}
		
    }    
    
    function actionMatchCheck($masterIDs, $trackid, $module, $enameid, $etypeid, $sensorid, $sip, $dip, $sport, $dport, $proto, $level, $payload, $ename, $etypename) {

		if (in_array($trackid, $this->ignoreArray)) return 0;

		// Iterate through each master id to grab and process criteria
		for ($i=0;$i<count($masterIDs);$i++) {
	
			$positive = 0;
			$negative = 0;
			
			// Load master id
			$this->actionMasterLoad($masterIDs[$i]);
			
			// Set match type
			$matchType = $this->getActionMasterVar("matchtype");
					
			// Retrieve array of store id's (type 1)
			$storeIDs = $this->getActionStoreIDs($masterIDs[$i], 1);
			
			// Instantiate new action object
			$objAction = new myAction();
			
			// Iterate through each store
			for ($j=0;$j<count($storeIDs);$j++) {

				// Load store
				$objAction->actionStoreLoad($storeIDs[$j]);
			
				// ##### Here we run through the actual matching process #####
			
				switch ($objAction->getActionStoreVar("type")) {				
					
					case 1:
						// Source IP
						
						if (strstr($objAction->getActionStoreVar("data"), "/")) {
							$tmp = cidrconv($objAction->getActionStoreVar("data"));
							$ip = explode("-", $tmp);
							$low = ip2long($ip[0]);
							$high = ip2long($ip[1]);
							if ($sip >= $low && $sip <= $high) {
								$positive++;
							} else {
								$negative++;
								continue;
							}
						} else {
							if (ip2long($objAction->getActionStoreVar("data")) == $sip) {
								$positive++;
							} else {
								$negative++;
								continue;
							}
						}						
				        
						break;
					case 2:
						// Destination IP
						
						if (strstr($objAction->getActionStoreVar("data"), "/")) {
							$tmp = cidrconv($objAction->getActionStoreVar("data"));
							$ip = explode("-", $tmp);
							$low = ip2long($ip[0]);
							$high = ip2long($ip[1]);
							if ($dip >= $low && $dip <= $high) {
								$positive++;
							} else {
								$negative++;
								continue;
							}
						} else {
							if (ip2long($objAction->getActionStoreVar("data")) == $dip) {
								$positive++;
							} else {
								$negative++;
								continue;
							}
						}					
				        
						break;
					case 3:
						// Source Port
						
						// Build array from criteria data whether or not it is in multiples (separated by comma)
						if (strstr($objAction->getActionStoreVar("data"), ",")) {
							$tmp = str_replace(" ", "", $objAction->getActionStoreVar("data"));
							$tmp = explode(",", $tmp);
						} else {
							$tmp = array($objAction->getActionStoreVar("data"));
						}

						// Check array for matches
						foreach ($tmp as $match) {
					        if ($match == $sport) {
					                $positive++;
					                break;
					        } else {
					                $negative++;
					                continue;
					        }					
						}					
				        
						break;
					case 4:
						// Destination Port
						
						// Build array from criteria data whether or not it is in multiples (separated by comma)
						if (strstr($objAction->getActionStoreVar("data"), ",")) {
							$tmp = str_replace(" ", "", $objAction->getActionStoreVar("data"));
							$tmp = explode(",", $tmp);
						} else {
							$tmp = array($objAction->getActionStoreVar("data"));
						}

						// Check array for matches
						foreach ($tmp as $match) {
					        if ($match == $dport) {
					                $positive++;
					                break;
					        } else {
					                $negative++;
					                continue;
					        }					
						}				
				        						
						break;
					case 5:
						// Protocol
						
						// Build array from criteria data whether or not it is in multiples (separated by comma)
						if (strstr($objAction->getActionStoreVar("data"), ",")) {
							$tmp = str_replace(" ", "", $objAction->getActionStoreVar("data"));
							$tmp = explode(",", $tmp);
						} else {
							$tmp = array($objAction->getActionStoreVar("data"));
						}

						// Check array for matches
						foreach ($tmp as $match) {
					        if ($match == $proto) {
					                $positive++;
					                break;
					        } else {
					                $negative++;
					                continue;
					        }					
						}						
						
						break;
					case 6:
						// Risk
					
						// Build array from criteria data whether or not it is in multiples (separated by comma)
						if (strstr($objAction->getActionStoreVar("data"), ",")) {
							$tmp = str_replace(" ", "", $objAction->getActionStoreVar("data"));
							$tmp = explode(",", $tmp);
						} else {
							$tmp = array($objAction->getActionStoreVar("data"));
						}

						// Check array for matches
						foreach ($tmp as $match) {
					        if ($match == $level) {
					                $positive++;
					                break;
					        } else {
					                $negative++;
					                continue;
					        }					
						}
				        
				        break;
					case 7:
						// Sensor
						
						// Build array from criteria data whether or not it is in multiples (separated by comma)
						if (strstr($objAction->getActionStoreVar("data"), ",")) {
							$tmp = str_replace(" ", "", $objAction->getActionStoreVar("data"));
							$tmp = explode(",", $tmp);
						} else {
							$tmp = array($objAction->getActionStoreVar("data"));
						}

						// Check array for matches
						foreach ($tmp as $match) {
					        if ($match == $sensorid) {
					                $positive++;
					                break;
					        } else {
					                $negative++;
					                continue;
					        }					
						}					
				        
						break;
					case 8:
						// Module
						
						// Build array from criteria data whether or not it is in multiples (separated by comma)
						if (strstr($objAction->getActionStoreVar("data"), ",")) {
							$tmp = str_replace(" ", "", $objAction->getActionStoreVar("data"));
							$tmp = explode(",", $tmp);
						} else {
							$tmp = array($objAction->getActionStoreVar("data"));
						}

						// Check array for matches
						foreach ($tmp as $match) {
					        if ($match == $module) {
					                $positive++;
					                break;
					        } else {
					                $negative++;
					                continue;
					        }					
						}					
				        					
						break;
					case 9:
						// Signature ID
						
						// Build array from criteria data whether or not it is in multiples (separated by comma)
						if (strstr($objAction->getActionStoreVar("data"), ",")) {
							$tmp = str_replace(" ", "", $objAction->getActionStoreVar("data"));
							$tmp = explode(",", $tmp);
						} else {
							$tmp = array($objAction->getActionStoreVar("data"));
						}

						// Check array for matches
						foreach ($tmp as $match) {
					        if ($match == $enameid) {
					                $positive++;
					                break;
					        } else {
					                $negative++;
					                continue;
					        }					
						}				
				        						
						break;
					case 10:
						// Category ID
						
						// Build array from criteria data whether or not it is in multiples (separated by comma)
						if (strstr($objAction->getActionStoreVar("data"), ",")) {
							$tmp = str_replace(" ", "", $objAction->getActionStoreVar("data"));
							$tmp = explode(",", $tmp);
						} else {
							$tmp = array($objAction->getActionStoreVar("data"));
						}

						// Check array for matches
						foreach ($tmp as $match) {
					        if ($match == $etypeid) {
					                $positive++;
					                break;
					        } else {
					                $negative++;
					                continue;
					        }					
						}
				        						
						break;
					case 11:
						// Text Search
						
						// Build array from criteria data whether or not it is in multiples (separated by comma)
						if (strstr($objAction->getActionStoreVar("data"), ",")) {
							$tmp = str_replace(" ", "", $objAction->getActionStoreVar("data"));
							$tmp = explode(",", $tmp);
						} else {
							$tmp = array($objAction->getActionStoreVar("data"));
						}

						// Check array for matches
						foreach ($tmp as $match) {
					        if (stristr($payload, $match) || stristr($ename, $match) || stristr($etypename, $match)) {
					                $positive++;
					                break;
					        } else {
					                $negative++;
					                continue;
					        }					
						}
				        						
						break;						
				}
				
			}
			
			// Determine whether or not a match was made with this particular action
			if ($matchType == 0 || $matchType == 1) {
				
				// ANY
				
				// If positive > 0 then at least 1 match was made; trigger
				if ($positive != 0) {

					$dataStoreObj = new dataStore();
					
					// Increment match count
					$this->incrementCount();
					
					// Trigger	
					$breakPriority = $this->actionRun($dataStoreObj, $masterIDs[$i], $trackid);
					
					$totalMatch++;
				}
					
			} else if ($matchType == 2) {
				
				// ALL
				
				// If negative == 0 then all matches were positive; trigger
				if ($negative == 0) {

					$dataStoreObj = new dataStore();
					
					// Increment match count
					$this->incrementCount();

					// Trigger				
					$breakPriority = $this->actionRun($dataStoreObj, $masterIDs[$i], $trackid);
					
					$totalMatch++;
					
				}
				
			}
			
			// Break out of match system if an ignore or delete have been previously triggered
			# This gives ignore and delete a higher priority over other actions
			if ($breakPriority == 1) break;
			
		}

		return $totalMatch;
		
    }
    
    function actionRun($dataStoreObj, $masterID, $trackid) {
    	global $idsDB;
    
		// Load master
    	$this->actionMasterLoad($masterID);    	
    	
		// Threshold function operations
		$this->setThresholdEventTime();
		$this->incrementThreshold();	    	

		// Check if thresholds will allow us to proceed onto performing individual actions
		if ($this->getActionMasterVar("thresholdcount") > $this->getActionMasterVar("threshold") || $this->getActionMasterVar("threshold") == 0) {
	    	
	    	// One time action check
	    	$this->oneTimeCheck();
	    	
			// Retrieve array of store id's (type 1)
			$storeIDs = $this->getActionStoreIDs($masterID, 2);
			
			// Instantiate new action object
			$objAction = new myAction();
	    	
			// Iterate through each store
			for ($j=0;$j<count($storeIDs);$j++) {
	
				// Load store
				$objAction->actionStoreLoad($storeIDs[$j]);
			
				// ##### Here we run through the actual response processing #####
				
				switch ($objAction->getActionStoreVar("type")) {
					
					case 1:
						// Do Nothing
						
						// As you can see, we do absolutely nothing here
						
						break;
					case 2:
						// Ignore
						
						// Update event data to reflect ignored xcol1 = 1
//						$dataStoreObj->alterDataStore($trackid, "xcol1", "1");
						
//						$this->ignoreArray[] = $trackid;
						
						// Set return value
						$returnValue = 1;
											
						break;						
						
					case 3:
						// Send Email
					
						actionEmail($masterID, $trackid, $objAction->getActionStoreVar("data"));
	
						$_ENV['appLog']->log('CONSOLE', "EMAIL: (Action: $masterID ID: $trackid) => " . $objAction->getActionStoreVar("data"));

						break;
					case 4:
						// Audio
					
						// Update event data to reflect audio xcol1 = 2
//						$dataStoreObj->alterDataStore($trackid, "xcol1", "2");
						
						break;			
					case 5:
						// Collection
					
						// Add event to collection group with event id and store id
						$this->collectionListingAdd($objAction->getActionStoreVar("data"), ops("site_activeDataStore"), $trackid);
	
						break;
					case 6:
						// Execute
						
						// !! Break if demo feature exists !!
						if (file_exists("tmp/demo")) break;
						
						// Execute external system call
						execCommand($objAction->getActionStoreVar("data"), $trackid);
					
						break;
					case 7:
						// Delete
					
						writeEventDeleteFile(ops("site_activeDataStore"), array($trackid));

						// Set return value
						$returnValue = 1;
						
						break;										
					case 8:
						// Tag
					
						// Add tag to event
						$this->tagAdd($objAction->getActionStoreVar("data"), $trackid);
	
						break;
						
				}
				
			}
			
			// Reset threshold counts and time to prevent spamming when count is exceeded before time expires
			$this->setActionMasterVar("thresholdcount", 0);
			$this->setActionMasterVar("thresholdeventtime", 0);
			$this->actionMasterSave();			
		}
		
		// Return
		return $returnValue;
			
    }
    
    function collectionListingAdd($collection, $store, $event) {

		if ($collection) {
	
			$_ENV['appDB']->query("INSERT into idsCollectionStore (cid, store, event) VALUES ('$collection', '$store', '$event')");
	
		}                               
	}

    function tagAdd($tags, $event) {

		if ($tags) {
		
			$tagArray = explode(",", $tags);
			
			foreach ($tagArray as $tag) {
			
				$tag = trim($tag);
				
				$q = $_ENV['appDB']->query("SELECT * FROM idsTags WHERE id = '$tag' || name = '$tag' ORDER BY id DESC LIMIT 1");
				
				if (mysql_num_rows($q) > 0) {
				
					$result = mysql_fetch_assoc($q);
					
					$_ENV['appDB']->query("INSERT into idsDataStore_" . ops("site_activeDataStore") . "_Tag_Index (tagID, eventID) VALUES ('" . $result['id'] . "', '$event')");
					
				} else {

					// No tag found				
				
				}
			
			}
	
		}                               
	}

}

?>
