<?php

/** Copyright 2012 Tactical FLEX, Inc.
 *
 * Aanval 7
 *
 * This program is owned and licensed by Tactical FLEX, Inc.; it may be
 * redistributed only in its original configuration as originally
 * installed and available by Tactical FLEX, Inc. and / or Aanval.
 *
 * To license and / or include this product in other forms or
 * applications, express prior written authorization must be
 * obtained by contract from authorized Tactical FLEX, Inc. or Aanval
 * agents.
 *
 * Tactical FLEX, Inc. and Aanval may not be held liable nor responsible
 * for any and all issues arising from the use of, damages caused by, or 
 * conclusions drawn from the use of this product.
 *
 */
 
class dataStore {
	
	function dataStore() {
		
		// Check for auto increment by event count (data store settings)
		if (ops("site_dataStoreRotationType") == 2) {
			
			if ($this->getCurrentEventID() >= ops("site_dataStoreRotationEvents")) {
				
				// Turn on dataswitch ops variable
				ops("site_dataSwitch", "1");
			
			}
		}
		
		// Check for auto increment by day (data store settings)
		if (ops("site_dataStoreRotationType") == 1) {
			
			$q = $_ENV['appDB']->query("SELECT UNIX_TIMESTAMP(created) FROM idsDataStore_" . ops("site_activeDataStore") . "_Master ORDER BY id ASC LIMIT 1");
	    	while ($row = mysql_fetch_assoc($q)) {
	    	
				$comp = time() - (ops("site_dataStoreRotationDays") * 86400);
				
				if ($row['created'] <= $comp) {
				
					// Turn on dataswitch ops variable
					ops("site_dataSwitch", "1");
					
				}

			}
			
		}
		
		// Test for datastore switching
		if (ops("site_dataSwitch") == 1) {
			
			$oldStore = ops("site_activeDataStore");
			$newStore = ops("site_activeDataStore") + 1;
			
			// Create new dataStore table structures
			$_ENV['appDB']->query("CREATE TABLE idsDataStore_" . $newStore . "_Master LIKE idsDataStore_TEMPLATE_Master");
			$_ENV['appDB']->query("CREATE TABLE idsDataStore_" . $newStore . "_Events LIKE idsDataStore_TEMPLATE_Events");
			$_ENV['appDB']->query("CREATE TABLE idsDataStore_" . $newStore . "_Text LIKE idsDataStore_TEMPLATE_Text");
			$_ENV['appDB']->query("CREATE TABLE idsDataStore_" . $newStore . "_Text_Index LIKE idsDataStore_TEMPLATE_Text_Index");
			$_ENV['appDB']->query("CREATE TABLE idsDataStore_" . $newStore . "_Timescale LIKE idsDataStore_TEMPLATE_Timescale");
			$_ENV['appDB']->query("CREATE TABLE idsDataStore_" . $newStore . "_Review_Index LIKE idsDataStore_TEMPLATE_Review_Index");
			$_ENV['appDB']->query("CREATE TABLE idsDataStore_" . $newStore . "_Tag_Index LIKE idsDataStore_TEMPLATE_Tag_Index");

			$q = $_ENV['appDB']->query("SELECT id FROM idsDataStore WHERE store = '" . $newStore . "'");
	    	if (mysql_num_rows($q) < 1) {

				$_ENV['appDB']->query("INSERT INTO idsDataStore (store, name) values ('" . $newStore . "', 'Unnamed Datastore')");
				
			}

			// Increment datastore by 1
			ops("site_activeDataStore", $newStore);
			
			// Turn off dataswitch ops variable
			ops("site_dataSwitch", "0");
			
			$_ENV['appLog']->log('CONSOLE', "A datastore rotation has been detected and changed to: $newStore");
	
			insertUserMessage(0, 3, "A datastore rotation has been detected and changed to: $newStore");
			
			// Update all users to new store
			$_ENV['appDB']->query("update idsUsers set activeSearchStore = '$newStore'");
			
		}
		
	}
	
	function getActiveDataStore() {
	
		return ops("site_activeDataStore");
	
	}

	function getActiveSearchStore() {
	
		return $_SESSION['user']['activeSearchStore'];
	
	}
	
    function getCurrentEventID() {

		$eventid = 0;

		$q = $_ENV['appDB']->query("SELECT id from idsDataStore_" . ops("site_activeDataStore") . "_Master order by id desc limit 1");
    	while ($row = mysql_fetch_assoc($q)) {
    	
    		$eventid = $row['id'];
    		
		}

		return $eventid;
		
	}		
	
	function getLastEventIDFromStore($store) {

		$store = trim($store);	

		$eventid = 0;

		$q = $_ENV['appDB']->query("SELECT id from idsDataStore_" . $store . "_Master order by id desc limit 1");
    	while ($row = mysql_fetch_assoc($q)) {
    	
    		$eventid = $row['id'];
    		
		}

		return $eventid;
		
	}	
	
	function writeEventRecord($object) {
	
		foreach ($object as $field => $value) {

			if ($field == "moduleID" || $field == "sensorID") continue;
		
			$fieldArray[] = $field;
			$valueArray[] = "'" . addslashes($value) . "'";

		}
		
		$fieldString = implode(", ", $fieldArray);
		$valueString = implode(", ", $valueArray);
		
		$idsQueryA = $_ENV['appDB']->query("INSERT INTO idsDataStore_" . ops("site_activeDataStore") . "_Events ($fieldString) VALUES ($valueString)");
	
	}
	
	function writeMasterRecord($object) {
	
		$idsQueryA = $_ENV['appDB']->query("INSERT INTO idsDataStore_" . ops("site_activeDataStore") . "_Master (moduleID, sensorID) VALUES ('" . $object->moduleID . "', '" . $object->sensorID . "')");
	
		return mysql_insert_id($_ENV['appDB']->link);
	
	}	
	
}

?>