<?php

class messageQueue {

	var $_registeredTypes = array(1);

    function add($data) {

		if (!$data->uid) $data->uid = $_SESSION['user']['id'];

		if (!$data->data) $data->data = "";
		if (!$data->options) $data->options = "";

		if (!$data->status) $data->status = 1;
		if (!$data->enabled) $data->enabled = 1;
		if (!$data->created) $data->created = time();
		if (!$data->priority) $data->priority = 3;

        $q = $_ENV['appDB']->query("INSERT INTO idsMessageQueue (uid, type, options, data, status, priority, enabled, created) VALUES ('" . $data->uid . "', '" . $data->type . "', '" . addslashes($data->options) . "', '" . addslashes($data->data) . "', '" . $data->status . "', '" . $data->priority . "', '" . $data->enabled . "', '" . $data->created . "')");

		$_ENV['appLog']->log('DEBUG', "Message type: " . $data->type . " added to queue");

    }
 
	function queueCount() {
	
        $q = $_ENV['appDB']->query("SELECT COUNT(id) AS cnt FROM idsMessageQueue WERE enabled = 1");
		$result = mysql_fetch_assoc($q);
		
		return $result['cnt'];
	
	}
 
	function registerTypes($typeArray) {
	
		$this->_registeredTypes = $typeArray;
	
	}
 
	function processQueue($num = 1) {
	
		for ($i=0; $i<$num; $i++) {
		
			if ($item = $this->_getNextItem()) {

				$timerStart = microtime(true);
			
				$this->_doItem($item);

	            // Calculate timers
    	        $timerDiff = number_format(microtime(true) - $timerStart, 5);
            
				$_ENV['appLog']->log('DEBUG', "Message type: " . $item->type . " processed in $timerDiff seconds");
        	    
        	    return true;
	
			}
		
		}
		
		return false;
	
	}

	function _getNextItem() {

        $q = $_ENV['appDB']->query("SELECT * FROM idsMessageQueue WHERE enabled = 1 AND status = 1 AND type IN (" . implode(",", $this->_registeredTypes) . ") ORDER BY priority, id ASC LIMIT 1");
		
		if ($result = mysql_fetch_object($q)) {

			$_ENV['appLog']->log('DEBUG', "Message type: " . $result->type . " selected for processing");

			return $result;
		
		} else {
		
			return false;
		
		}

	}

	function _updateItem($data) {

        $_ENV['appDB']->query("UPDATE idsMessageQueue SET
			uid = '" . $data->uid . "',
			type = '" . $data->type . "',
			options = '" . addslashes($data->options) . "',
			data = '" . addslashes($data->data) . "',
			status = '" . $data->status . "',
			enabled = '" . $data->enabled . "',
			priority = '" . $data->priority . "',
			created = '" . $data->created . "',
			finished = '" . $data->finished . "'
			
			WHERE id = '" . $data->id . "'
        ");
        
	}
	
	function _deleteItem($data) {

        $_ENV['appDB']->query("DELETE FROM idsMessageQueue WHERE id = '" . $data->id . "'");
        
	}
	
	function _doItem($item) {
	
		$item->status = 2;
	
		$this->_updateItem($item);
	
		switch ($item->type) {
	
			case 1:
			
				// Search
			
				$this->_searchProcessor($item);
			
				$item->status = 5;
				$item->enabled = 0;
				$item->finished = time();
			
				break;

			case 2:
			
				// Report
			
				$this->_reportProcessor($item);
			
				$item->status = 5;
				$item->enabled = 0;
				$item->finished = time();
			
				break;
				
			case 10:
			
				// Miscellaneous function execution
			
				$this->_funcExec($item);
			
				$item->status = 5;
				$item->enabled = 0;
				$item->finished = time();
			
				$item->delete = true;
			
				break;
				
			case 100:
			
				// Snort import
			
				$this->_snortImport($item);
			
				$item->status = 5;
				$item->enabled = 0;
				$item->finished = time();
			
				$item->delete = true;
			
				break;
				
			case 105:
			
				// Event indexer
			
				$this->_eventIndexer($item);
			
				$item->status = 5;
				$item->enabled = 0;
				$item->finished = time();
			
				$item->delete = true;
			
				break;				
				
			default:

				$item->status = 4;
				$item->enabled = 0;
				$item->finished = time();
			
				break;
				
		}

		if (!$item->delete) {

			$this->_updateItem($item);
			
		} else {
		
			$this->_deleteItem($item);
		
		}
		
	}

	function _searchProcessor($item) {

		$totalResults = 0;
	
		// explode options by pipe
		
		$tmp = explode("|", $item->options);
	
		$transaction = $tmp[0];
		$store = $tmp[1];
		
		// Set user for processing		
		authenticateSessionByUserID($item->uid);
	
		$searchObj = new coreSearch();
		$searchObj->setVar("query", "returnid: " . $item->data);
		$searchObj->setVar("store", "$store");
	
		foreach ($searchObj->searchProcess() as $data) {
	
			$set .= "$data\n";
			$totalResults++;
	
		}
	
		// Write search results to tmp/search directory
	
		$fp = fopen("tmp/search/search-" . $item->uid . "-" . $transaction . ".events", "w");
		fwrite($fp, "$transaction\n" . $item->uid . "\n$store\n" . $item->data . "\n$totalResults\n---\n" . trim($set));
		fclose($fp);
		
		// Save search to query history
		
		$_ENV['appDB']->query("INSERT INTO idsQueries (query, uid, intime) VALUES ('" . $item->data . "', '" . $item->uid . "', '" . $transaction . "')");
		
	}
	
	function _reportProcessor($item) {

		$totalResults = 0;
	
		// explode options by pipe

		$transaction = $item->data;

	    $_ENV['appDB']->query("UPDATE idsReportSchedule SET status = 1 WHERE intime = '$transaction'");
		
		$q = $_ENV['appDB']->query("SELECT * FROM idsReportSchedule WHERE intime = '$transaction'");
		$result = mysql_fetch_assoc($q);
		
		// Set user for processing		
		
		authenticateSessionByUserID($result['userid']);
	
		$searchObj = new coreSearch();
		$searchObj->setVar("query", "returnid: " . $result['query']);
		$searchObj->setVar("store", $result['store']);
	
		foreach ($searchObj->searchProcess() as $data) {
	
			$set[] = $data;
			$totalResults++;
	
		}	
	
		$reportObj = new coreReport();
		$reportObj->setVar("store", $result['store']);
		
		$xml = $reportObj->reportProcess($set, $result['query']);
	
		// Write search results to tmp/search directory
	
		$fp = fopen("tmp/search/search-" . $result['userid'] . "-" . $transaction . ".report", "w");
		fwrite($fp, "$transaction\n" . $result['userid'] . "\n" . $result['store'] . "\n" . $result['query'] . "\n$totalResults\n---\n" . "$xml");
		fclose($fp);
		
		// Update status
		
	    $_ENV['appDB']->query("UPDATE idsReportSchedule SET data = '" . addslashes($xml) . "', status = 2, runlast = '" . time() . "' WHERE intime = '$transaction'");
		
	}	

	function _funcExec($item) {

		$tmp = explode("|", $item->options);
	
		call_user_func_array($item->data, $tmp);
	
	}
	
	function _snortImport($item) {

		$datastore = new dataStore();
		
		$objectArray = unserialize($item->data);

		foreach ($objectArray as $event) {

			// Write master event record
			
			$event->id = $datastore->writeMasterRecord($event);

			// Write event record
		
			$datastore->writeEventRecord($event);
			
			// Create new object array to pass to indexer
			
			$newObjectArray[] = $event;
			
		}

		// Dispatch index message
		
        $mObject = arrayToObject(array("type" => 105, "data" => serialize($newObjectArray), "priority" => 3));
       	$this->add($mObject);
	
	}
	
	function _eventIndexer($item) {

		$objectArray = unserialize($item->data);

		// Index array of events

		$indexer = new indexer();

		$indexer->indexMultipleEvents($objectArray, ops("site_activeDataStore"));
	
	}
	
}

?>