<?php

class coreReport {
	
	function setVar($key, $value) {
		$this->s_vars[$key] = $value;
	}

	function getVar($key) {
		$this->s_vars[$key] = stripslashes($this->s_vars[$key]);
		return $this->s_vars[$key];
	}
		
	function coreReport() {
		
		if (login("login") == true) {
			$this->setVar("store", login("activeSearchStore"));
		} else {
			$this->setVar("store", ops("site_activeIndexStore"));
		}
		
	}
		
	function reportProcess(&$data, $search) {

		$totalReportEvents = 0;
		
		$this->setVar("maxRows", ops("site_reportDisplayRows"));
		
		$totalReportEvents = count($data);

		// pre load bucket var's if necessary
		
		$bucket["risk"]["1"] = 0;
		$bucket["risk"]["2"] = 0;
		$bucket["risk"]["3"] = 0;
		$bucket["risk"]["4"] = 0;
		$bucket["risk"]["5"] = 0;

		$bucket["reviewed"]["0"] = 0;
		$bucket["reviewed"]["1"] = 0;

		$searchObj = new coreSearch();

		foreach ($data as $item) {

			$tmp = explode(":", $item);
			
			$store = $tmp[0];
			$eventID = $tmp[1];
	
			$searchObj->setVar("store", $store);
	
			$eventData = $searchObj->getDetailsByID(trim($eventID));

			$bucket["sip"][$eventData["sip"]]++;
			$bucket["dip"][$eventData["dip"]]++;
			
			$bucket["sport"][$eventData["sport"]]++;
			$bucket["dport"][$eventData["dport"]]++;

			$bucket["store"][$store]++;
			
			$bucket["module"][$eventData["moduleID"]]++;
			$bucket["risk"][$eventData["priority"]]++;
			$bucket["protocol"][$eventData["protocol"]]++;

			$bucket["sensor"][$eventData["sensorID"]]++;

			$bucket["signature"]["[" . $eventData["signature"] . "] " . $eventData["signatureName"]]++;
			$bucket["class"]["[" . $eventData["class"] . "] " . $eventData["className"]]++;
			
			$bucket["reviewed"][$reviewed]++;
			
		}
		
		$xml = "<document>\n";
		$xml .= "\t<data>\n";

    	$tmpGenerated = timeDisplay(consoleTimeConversion(time()), 1);
    	
    	$tmpTextA .= "This document contains sensitive and / or confidential information, do not distribute, email, fax or transfer via any ";
    	$tmpTextA .= "electronic mechanism without proper authorization. Information contained within this document should be handled with appropriate ";
    	$tmpTextA .= "caution. While reasonable attempts have been made to confirm the accuracy of the data contained herein, ";
    	$tmpTextA .= "this console applications creators assume no liability for the completeness, use of, or conclusions drawn from this data.";
		
    	$tmpTextB .= "The objective of this report is to provide an accurate and comprehensive summary of search results using the criteria provided. ";
    	$tmpTextB .= "The following report should be reviewed to identify possible patterns in suspicious and anomalous activity presented in the following technical details. ";
    	$tmpTextB .= "This report was generated using the most accurate information available to the console at the time of generation.";

		$xml .= "\t\t<generatedText><![CDATA[" . $tmpGenerated . "]]></generatedText>\n";
		$xml .= "\t\t<confidentialText><![CDATA[" . $tmpTextA . "]]></confidentialText>\n";
		$xml .= "\t\t<objectiveText><![CDATA[" . $tmpTextB . "]]></objectiveText>\n";

		$xml .= "\t\t<searchText><![CDATA[" . $search . "]]></searchText>\n";
		$xml .= "\t\t<searchTextTrimmed><![CDATA[" . $searchTrimmed . "]]></searchTextTrimmed>\n";

		$xml .= "\t\t<reportStatistics>\n";
		$xml .= "\t\t\t<item>\n";
		$xml .= "\t\t\t\t<name>Total Events (in this report)</name>\n";
		$xml .= "\t\t\t\t<total>" . $totalReportEvents . "</total>\n";
		$xml .= "\t\t\t</item>\n";
		$xml .= "\t\t</reportStatistics>\n";

		########################################################################
		// Sensor

		// Resets for each summary		
		$summaryTotal = 0;
		$rows = 0;

		$xml .= "\t\t<sensorSummary>\n";

		arsort($bucket["sensor"]);

		foreach ($bucket["sensor"] as $item => $count) {
		
			$summaryTotal += $count;
			$rows++;

			if (!ops("site_custom_snortGroup")) {

				$xml .= "\t\t\t<item>\n";
				$xml .= "\t\t\t\t<name><![CDATA[" . getSensorNameByID($item) . "]]></name>\n";
				$xml .= "\t\t\t\t<total>" . $count . "</total>\n";
				$xml .= "\t\t\t</item>\n";
				
			} else {

				// custom grouping

				$xml .= "\t\t\t<item>\n";
				$xml .= "\t\t\t\t<name><![CDATA[" . $item . "]]></name>\n";
				$xml .= "\t\t\t\t<total>" . $count . "</total>\n";
				$xml .= "\t\t\t</item>\n";
			
			}
			
			if ($rows >= $this->getVar("maxRows")) break;
			
		}
		
		$xml .= "\t\t\t<total>" . $summaryTotal . "</total>\n";
					
		$xml .= "\t\t</sensorSummary>\n";
		
		########################################################################
		// Priority

		// Resets for each summary		
		$summaryTotal = 0;
		$rows = 0;

		$xml .= "\t\t<prioritySummary>\n";
		
		arsort($bucket["risk"]);
		
		foreach ($bucket["risk"] as $item => $count) {
		
			$summaryTotal += $count;
			$rows++;
		
			$xml .= "\t\t\t<item>\n";
			$xml .= "\t\t\t\t<name><![CDATA[" . $item . "]]></name>\n";
			$xml .= "\t\t\t\t<total>" . $count . "</total>\n";
			$xml .= "\t\t\t</item>\n";

			if ($rows >= $this->getVar("maxRows")) break;

		}

		$xml .= "\t\t\t<total>" . $summaryTotal . "</total>\n";
		
		$xml .= "\t\t</prioritySummary>\n";

		########################################################################
		// Module

		// Resets for each summary		
		$summaryTotal = 0;
		$rows = 0;

		$xml .= "\t\t<moduleSummary>\n";
		
		arsort($bucket["module"]);
		
		foreach ($bucket["module"] as $item => $count) {
		
			$summaryTotal += $count;
			$rows++;
			
			$xml .= "\t\t\t<item>\n";
			$xml .= "\t\t\t\t<name><![CDATA[" . getModuleNameByType($item) . "]]></name>\n";
			$xml .= "\t\t\t\t<total>" . $count . "</total>\n";
			$xml .= "\t\t\t</item>\n";

			if ($rows >= $this->getVar("maxRows")) break;

		}

		$xml .= "\t\t\t<total>" . $summaryTotal . "</total>\n";
		
		$xml .= "\t\t</moduleSummary>\n";

		########################################################################
		// Stores

		// Resets for each summary		
		$summaryTotal = 0;
		$rows = 0;

		$xml .= "\t\t<datastoreSummary>\n";
		
		arsort($bucket["store"]);
		
		foreach ($bucket["store"] as $item => $count) {
		
			$summaryTotal += $count;
			$rows++;
		
			$xml .= "\t\t\t<item>\n";
			$xml .= "\t\t\t\t<name><![CDATA[" . $item . "]]></name>\n";
			$xml .= "\t\t\t\t<total>" . $count . "</total>\n";
			$xml .= "\t\t\t</item>\n";

			if ($rows >= $this->getVar("maxRows")) break;

		}
			
		$xml .= "\t\t\t<total>" . $summaryTotal . "</total>\n";
		
		$xml .= "\t\t</datastoreSummary>\n";
		
		########################################################################
		// Reviewed

		// Resets for each summary		
		$summaryTotal = 0;
		$rows = 0;

		$xml .= "\t\t<reviewedSummary>\n";
		
		arsort($bucket["reviewed"]);
		
		foreach ($bucket["reviewed"] as $item => $count) {
		
			$summaryTotal += $count;
			$rows++;
		
			if ($item == 1) {
				
				$itemText = "Reviewed";
				
			} else {

				$itemText = "Not Reviewed";
			
			}
		
			$xml .= "\t\t\t<item>\n";
			$xml .= "\t\t\t\t<name><![CDATA[" . $itemText . "]]></name>\n";
			$xml .= "\t\t\t\t<total>" . $count . "</total>\n";
			$xml .= "\t\t\t</item>\n";

			if ($rows >= $this->getVar("maxRows")) break;

		}
			
		$xml .= "\t\t\t<total>" . $summaryTotal . "</total>\n";
		
		$xml .= "\t\t</reviewedSummary>\n";		
		
		########################################################################
		// Signature

		// Resets for each summary		
		$summaryTotal = 0;
		$rows = 0;

		$xml .= "\t\t<signatureSummary>\n";
		
		arsort($bucket["signature"]);
		
		foreach ($bucket["signature"] as $item => $count) {
		
			$summaryTotal += $count;
			$rows++;
		
			$xml .= "\t\t\t<item>\n";
			$xml .= "\t\t\t\t<name><![CDATA[" . $item . "]]></name>\n";
			$xml .= "\t\t\t\t<total>" . $count . "</total>\n";
			$xml .= "\t\t\t</item>\n";

			if ($rows >= $this->getVar("maxRows")) break;

		}
			
		$xml .= "\t\t\t<total>" . $summaryTotal . "</total>\n";
		
		$xml .= "\t\t</signatureSummary>\n";		
		
		########################################################################
		// Class

		// Resets for each summary		
		$summaryTotal = 0;
		$rows = 0;

		$xml .= "\t\t<classSummary>\n";
		
		arsort($bucket["class"]);
		
		foreach ($bucket["class"] as $item => $count) {
		
			$summaryTotal += $count;
			$rows++;
		
			$xml .= "\t\t\t<item>\n";
			$xml .= "\t\t\t\t<name><![CDATA[" . $item . "]]></name>\n";
			$xml .= "\t\t\t\t<total>" . $count . "</total>\n";
			$xml .= "\t\t\t</item>\n";

			if ($rows >= $this->getVar("maxRows")) break;

		}
			
		$xml .= "\t\t\t<total>" . $summaryTotal . "</total>\n";
		
		$xml .= "\t\t</classSummary>\n";
		
		########################################################################
		// Protocol

		// Resets for each summary		
		$summaryTotal = 0;
		$rows = 0;

		$xml .= "\t\t<protocolSummary>\n";
		
		arsort($bucket["protocol"]);
		
		foreach ($bucket["protocol"] as $item => $count) {
		
			$summaryTotal += $count;
			$rows++;

			$xml .= "\t\t\t<item>\n";
			$xml .= "\t\t\t\t<name><![CDATA[" . protoToName($item) . "]]></name>\n";
			$xml .= "\t\t\t\t<total>" . $count . "</total>\n";
			$xml .= "\t\t\t</item>\n";
			
			if ($rows >= $this->getVar("maxRows")) break;

		}

		$xml .= "\t\t\t<total>" . $summaryTotal . "</total>\n";
		
		$xml .= "\t\t</protocolSummary>\n";
		
		########################################################################
		// Source Port

		// Resets for each summary		
		$summaryTotal = 0;
		$rows = 0;

		$xml .= "\t\t<sportSummary>\n";
		
		arsort($bucket["sport"]);
		
		foreach ($bucket["sport"] as $item => $count) {
		
			$summaryTotal += $count;
			$rows++;
		
			$xml .= "\t\t\t<item>\n";
			$xml .= "\t\t\t\t<name><![CDATA[" . $item . "]]></name>\n";
			$xml .= "\t\t\t\t<total>" . $count . "</total>\n";
			$xml .= "\t\t\t</item>\n";

			if ($rows >= $this->getVar("maxRows")) break;

		}
			
		$xml .= "\t\t\t<total>" . $summaryTotal . "</total>\n";
		
		$xml .= "\t\t</sportSummary>\n";	
		
		########################################################################
		// Destination Port

		// Resets for each summary
		$summaryTotal = 0;
		$rows = 0;

		$xml .= "\t\t<dportSummary>\n";
		
		arsort($bucket["dport"]);
		
		foreach ($bucket["dport"] as $item => $count) {
		
			$summaryTotal += $count;
			$rows++;

			$xml .= "\t\t\t<item>\n";
			$xml .= "\t\t\t\t<name><![CDATA[" . $item . "]]></name>\n";
			$xml .= "\t\t\t\t<total>" . $count . "</total>\n";
			$xml .= "\t\t\t</item>\n";

			if ($rows >= $this->getVar("maxRows")) break;

		}
			
		$xml .= "\t\t\t<total>" . $summaryTotal . "</total>\n";
		
		$xml .= "\t\t</dportSummary>\n";
		
		########################################################################
		// Source IP

		// Resets for each summary		
		$summaryTotal = 0;
		$rows = 0;

		$xml .= "\t\t<sipSummary>\n";
		
		arsort($bucket["sip"]);
		
		foreach ($bucket["sip"] as $item => $count) {
		
			$summaryTotal += $count;
			$rows++;
		
			$xml .= "\t\t\t<item>\n";
			$xml .= "\t\t\t\t<name><![CDATA[" . long2ip($item) . "]]></name>\n";
			$xml .= "\t\t\t\t<total>" . $count . "</total>\n";
			$xml .= "\t\t\t</item>\n";

			if ($rows >= $this->getVar("maxRows")) break;

		}
			
		$xml .= "\t\t\t<total>" . $summaryTotal . "</total>\n";
		
		$xml .= "\t\t</sipSummary>\n";	
		
		########################################################################
		// Destination IP

		// Resets for each summary
		$summaryTotal = 0;
		$rows = 0;

		$xml .= "\t\t<dipSummary>\n";
		
		arsort($bucket["dip"]);
		
		foreach ($bucket["dip"] as $item => $count) {
		
			$summaryTotal += $count;
			$rows++;

			$xml .= "\t\t\t<item>\n";
			$xml .= "\t\t\t\t<name><![CDATA[" . long2ip($item) . "]]></name>\n";
			$xml .= "\t\t\t\t<total>" . $count . "</total>\n";
			$xml .= "\t\t\t</item>\n";
		
			if ($rows >= $this->getVar("maxRows")) break;
		
		}
			
		$xml .= "\t\t\t<total>" . $summaryTotal . "</total>\n";
		
		$xml .= "\t\t</dipSummary>\n";				

		$xml .= "\t</data>\n";
		$xml .= "</document>\n";

		return $xml;
	}
	
}

?>