<?php

class syslogProcessor {
	
	// Returns complete list of available syslog sensor data files from /syslog/ directory
	function getSyslogFiles() {
		
		$syslogPath = ops("site_dir_syslog");
		
		// Check to ensure ops variable is not empty
		if ($syslogPath != "") {
	
			// Open syslog directory and check for error
			if (!$this_dir = @dir("$syslogPath")) {

			} else {
				
		    	// Loop through files
		        while ($file = $this_dir->read()) {
		        	// Only check files which are NOT . and ..
		        	
			        if ($file != "." && $file != "..") {
		    	        if (substr($file, -4, 4) == ".sys") {
		                    $filesArray[] = $file;
		                }
		            }
			    }
			}
			
		}
		// Return array of files found in /syslog/ directory
		return $filesArray;		
	}
	
	// Identifies if new syslog sensor files exist, and writes newly found sensors to syslog module database (checks getSyslogFiles() against syslog module sensor database)
	function newSyslogSensorCheck($syslogFiles) {
		
		// Loops through $sensorFiles and checks syslog module database for existing sensors
		for ($i=0;$i<count($syslogFiles);$i++) {
			
			// Retrieves 2 forms of IP address (dotted and numeric)
			$sourceIP = str_replace("indata_", "", (str_replace(".sys", "", $syslogFiles[$i])));
			if (!strstr($sourceIP, ".")) $sourceIP = long2ip($sourceIP);
	
	        // Check to see if sensor exists
        	$idsQueryA = $_ENV['appDB']->query("SELECT id FROM idsSyslogModule WHERE source = '$sourceIP' OR source = '" . ip2long($sourceIP) . "'");
			if (mysql_num_rows($idsQueryA) < 1) {

		        // If nothing found then we write new sensor to syslog module sensor table

	            $_ENV['appDB']->query("INSERT INTO idsSyslogModule (source, type) VALUES ('$sourceIP', '1')");

	            $q = $_ENV['appDB']->query("SELECT max(id) AS id FROM idsSyslogModule");
				$result = mysql_fetch_assoc($q);
				
				$_ENV['appDB']->query("INSERT INTO idsSensor (sid, name, enabled, module, path, timezone, intime) VALUES ('" . $result['id'] . "', 'Not Configured', '0', '2', '" . $sourceIP . "', '62', '" . time() . "')");
	            
				$_ENV['appLog']->log('CONSOLE', "New syslog sensor found: " . $sourceIP);
	            
			}
			
		}		
	}

	// Primary syslog sensor processor logic
	function processSyslogSensors() {

		// Instantiate new sensor object
	    $objSensor = new mySensor();

	    // Retrieve list of current sensor id's from syslog module
	    $sensorArray = $objSensor->getSensorIDs(2);

	    // Loop through listed sensors
    	for ($i=0;$i<count($sensorArray);$i++) {
       	
        	// Load specific sensor from module
        	$objSensor->loadSensor($sensorArray[$i]);
        	
        	// Define variable(s) from module
        	$sensorSID = $objSensor->getSensorVar("sid");
        	$sensorID = $objSensor->getSensorVar("id");
        	$sensorName = $objSensor->getSensorVar("name");

        	// Import sensor data into syslog database
        	$this->importSyslogData($sensorID, $sensorSID);
    	}
	}
	
	// Specifically imports syslog data from /syslog/indata_$sensorIP.sys to syslog database
	function importSyslogData($sensorID, $sensorSID) {

		$processCount = 0;

		$importArray = noImportLoad();

		$dataStoreObj = new dataStore();
		
		$indexerObj = new indexer();
		
		// Load specific sensor from module
	    $objSensor = new mySensor();
        $objSensor->loadSensor($sensorID);
       	$sensorName = $objSensor->getSensorVar("name");
        			
		// Query syslog database for sensor filters and source information
        $idsQueryA = $_ENV['appDB']->query("select
            source,
            f_date,
            f_time,
            f_sip,
            f_dip,
            f_sport,
            f_dport,
            f_protocol,
            f_level,
            f_ename,
            f_etypename,
            f_misc1,
            f_misc2,
            f_misc3,
            f_misc4,
            f_misc5,
            f_payload
			from idsSyslogModule where id = $sensorSID");
		while (list($sensorSource, $f_date, $f_time, $f_sip, $f_dip, $f_sport, $f_dport, $f_protocol, $f_level, $f_ename, $f_etypename, $f_misc1, $f_misc2, $f_misc3, $f_misc4, $f_misc5, $f_payload) = mysql_fetch_row($idsQueryA)) {

			if (!strstr($sensorSource, ".")) $sensorSource = long2ip($sensorSource);
           
            // Rename .sys file to .processing to separate incoming data from those already in processing
			if (file_exists("syslog/indata_$sensorSource.sys")) {
				
				if (!rename("syslog/indata_$sensorSource.sys", "syslog/indata_$sensorSource.processing")) {

				} else {

				}
				
			}

			// Check to ensure that renaming of the file was successful - if exists we continue to import
            if (file_exists("syslog/indata_$sensorSource.processing")) {
            	
            	// Open file for reading
				if ($handle = @fopen("syslog/indata_$sensorSource.processing", "r")) {

					// Report import status
					
					// Loop through each line of the .processing syslog data file
					while (!feof($handle)) {
                        $timestamp = date("U");
						$buffer = fgets($handle, 4096);

						// Check to ensure the buffer (line) is not empty and continue
						if ($buffer != "") {
							
							// Replace TAB with a single space character
							$buffer = str_replace("\t", " ", $buffer);
							
							// Test function
							$time = filterProcess($f_time, $buffer);
							if (!$time || $time == "") $time = date("H:i:s");
							
							// Test function
							$date = filterProcess($f_date, $buffer);
							if (!$date || $date == "") $date = date("j F Y");
							
					        // Source IP Filter
							$sip = filterProcess($f_sip, $buffer);
					        if (!$sip || $sip == "") {
								$sip = ip2long($sensorSource);
					        } else {
					        	$sip = ip2long($sip);
					        }
					        
					        // Destination IP Filter
							$dip = filterProcess($f_dip, $buffer);
					        if (!$dip || $dip == "") {
		
					        } else {
					        	$dip = ip2long($dip);
					        }
					
					        // Source Port Filter
							$sport = filterProcess($f_sport, $buffer);
					        
							if (is_string($sport)) {
								$sport = nameToPort($sport);
							}
					
					        // Destination Port Filter
							$dport = filterProcess($f_dport, $buffer);
					
							if (is_string($dport)) {
								$dport = nameToPort($dport);
							}							
						
				        	// Protocol Filter
							$protocol = filterProcess($f_protocol, $buffer);
					        $protocol = nameToProto($protocol);
					
					        // Level Filter
							$level = filterProcess($f_level, $buffer);
		                    if ($level == "") $level = ops("site_riskRankBottom");
				
					        // Event Name (signature) Filter
							$ename = filterProcess($f_ename, $buffer);
		#			        $moduleQueryInternal = $_ENV['appDB']->query("insert into signature (signature) values ('$ename')", 0);
		#			        $moduleQueryInternal = $_ENV['appDB']->query("select id from signature where signature = '$ename'", 0);
		#			        while (list($sigid) = mysql_fetch_row($moduleQueryInternal)) {
		#			            $sig_id = $sigid;
		#			        }
					
					        // Event Category Filter
							$etypename = filterProcess($f_etypename, $buffer);
					        if ($etypename == "") $etypename = "General Syslog";
		#			        $moduleQueryInternal = $_ENV['appDB']->query("insert into category (category) values ('$etypename')", 0);
		#			        $moduleQueryInternal = $_ENV['appDB']->query("select id from category where category = '$etypename'", 0);
		#			        while (list($typeid) = mysql_fetch_row($moduleQueryInternal)) {
		#			            $type_id = $typeid;
		#			        }
				
		                    // Misc Filters
							$misc1 = filterProcess($f_misc1, $buffer);
							$misc2 = filterProcess($f_misc2, $buffer);
							$misc3 = filterProcess($f_misc3, $buffer);
							$misc4 = filterProcess($f_misc4, $buffer);
							$misc5 = filterProcess($f_misc5, $buffer);
												        
					        // Payload Filter
							$payload = filterProcess($f_payload, $buffer);
				
					        // If Date filter does not contain the year - alter the results to contain the year
							if (!strstr($date, date("Y"))) $date = $date . " " . date("Y");
				
							// Combine the date and time into $intime for database update
							$intime = strtotime("$date $time");			

							$level = $this->postProcessor("level", $level, $sensorID);
							$protocol = $this->postProcessor("proto", $protocol, $sensorID);
							$sip = $this->postProcessor("sip", $sip, $sensorID);
							$dip = $this->postProcessor("dip", $dip, $sensorID);
							$sport = $this->postProcessor("sport", $sport, $sensorID);
							$dport = $this->postProcessor("dport", $dport, $sensorID);
							$ename = $this->postProcessor("ename", $ename, $sensorID);
							$etypename = $this->postProcessor("etypename", $etypename, $sensorID);
							
							$payload = $this->postProcessor("payload", $payload, $sensorID);
							if (strlen($payload) > 10) $payload = gzcompress($payload, 9);

					        // Signature to risk table lookup
//					        $tmpA = signatureRiskLookup($riskArray, $sig_id, $ename);
//							if ($tmpA != 0) $level = $tmpA;
							
							$import = noImportLookup($importArray, $payload);

							if ($import == 1) {
								
								$masterDataArray = array(
									"moduleID" => "2",
									"sensorID" => "$sensorID",
									"enabled" => "1"
								);
								
								$masterRecord = $this->writeMasterRecord($masterDataArray);
								
								$snortDataArray = array(
									"id" => "$masterRecord",
									"sport" => "$sport", 
									"dport" => "$dport",
									"sip" => "$sip",
									"dip" => "$dip",
									"signature" => "$sig_id",
									"signatureName" => "$ename",
									"class" => "$type_id",
									"className" => "$etypename",
									"priority" => "$level",
									"protocol" => "$protocol",
									"sensor" => "$sensorSID",
									"payload" => "$payload",
									"timestamp" => "$timestamp"									
								);	  									

								$this->writeEventRecord($snortDataArray);

								$assocEventDataArray[] = array_merge($masterDataArray, $snortDataArray);
							
							}
						}
					}

					// Close file handle
					fclose($handle);

				} else {
						
					// Could not open file

				}
				
				// Delete .processing file
				if (!unlink("syslog/indata_$sensorSource.processing")) {

				} else {

				}
			}
			
			
		}
		
		if ($assocEventDataArray) {
		
	        $indexerObj->indexMultipleEvents($assocEventDataArray, ops("site_activeDataStore"));
	        
	    }
		
	}

	function processSyslogSourceFile($sensorID, $sensorSID, $bufferArray) {

		$processCount = 0;
		
		$dataStoreObj = new dataStore();
		
		$indexerObj = new indexer();
		
		$riskArray = signatureRiskLoad();
		$importArray = noImportLoad();
		
		// Query syslog database for sensor filters and source information
        $idsQueryA = $_ENV['appDB']->query("select
            source,
            f_date,
            f_time,
            f_sip,
            f_dip,
            f_sport,
            f_dport,
            f_protocol,
            f_level,
            f_ename,
            f_etypename,
            f_misc1,
            f_misc2,
            f_misc3,
            f_misc4,
            f_misc5,
            f_payload
			from idsSyslogModule where id = '$sensorSID'");
        
		while (list($source, $f_date, $f_time, $f_sip, $f_dip, $f_sport, $f_dport, $f_protocol, $f_level, $f_ename, $f_etypename, $f_misc1, $f_misc2, $f_misc3, $f_misc4, $f_misc5, $f_payload) = mysql_fetch_row($idsQueryA)) {

			foreach ($bufferArray as $buffer) {
			    $timestamp = date("U");

				// Check to ensure the buffer (line) is not empty and continue
				if ($buffer != "") {

					// Replace TAB with a single space character
					$buffer = str_replace("\t", " ", $buffer);
					
					// Test function
					$time = filterProcess($f_time, $buffer);
					if (!$time || $time == "") $time = date("H:i:s");
					
					// Test function
					$date = filterProcess($f_date, $buffer);
					if (!$date || $date == "") $date = date("j F Y");
					
			        // Source IP Filter
					$sip = filterProcess($f_sip, $buffer);
			        if (!$sip || $sip == "") {

			        } else {
			        	$sip = ip2long($sip);
			        }
			        
			        // Destination IP Filter
					$dip = filterProcess($f_dip, $buffer);
			        if (!$dip || $dip == "") {

			        } else {
			        	$dip = ip2long($dip);
			        }
			
			        // Source Port Filter
					$sport = filterProcess($f_sport, $buffer);
					
					if (is_string($sport)) {
						if (strtolower($sport) == "smtp") {
							$sport = 25;
						} else if (strtolower($sport) == "pop" || strtolower($sport) == "pop3") {
							$sport = 110;
						} else if (strtolower($sport) == "http") {
							$sport = 80;
						} else if (strtolower($sport) == "https") {
							$sport = 443;
						} else if (strtolower($sport) == "telnet") {
							$sport = 23;
						} else if (strtolower($sport) == "ssh") {
							$sport = 22;
						} else if (strtolower($sport) == "ftp") {
							$sport = 21;
						}
					}
			
			        // Destination Port Filter
					$dport = filterProcess($f_dport, $buffer);
			
					if (is_string($dport)) {
						if (strtolower($dport) == "smtp") {
							$dport = 25;
						} else if (strtolower($dport) == "pop" || strtolower($dport) == "pop3") {
							$dport = 110;
						} else if (strtolower($dport) == "http") {
							$dport = 80;
						} else if (strtolower($dport) == "https") {
							$dport = 443;
						} else if (strtolower($dport) == "telnet") {
							$dport = 23;
						} else if (strtolower($dport) == "ssh") {
							$dport = 22;
						} else if (strtolower($dport) == "ftp") {
							$dport = 21;
						}
					}							
					
			        // Protocol Filter
					$protocol = filterProcess($f_protocol, $buffer);
			        $protocol = nameToProto($protocol);
			
			        // Level Filter
					$level = filterProcess($f_level, $buffer);
                    if ($level == "") $level = ops("site_riskRankBottom");
			
			        // Event Name (signature) Filter
					$ename = filterProcess($f_ename, $buffer);
#			        $moduleQueryInternal = $_ENV['appDB']->query("insert into signature (signature) values ('$ename')", 0);
#			        $moduleQueryInternal = $_ENV['appDB']->query("select id from signature where signature = '$ename'", 0);
#			        while (list($sigid) = mysql_fetch_row($moduleQueryInternal)) {
#			            $sig_id = $sigid;
#			        }
			
			        // Event Category Filter
					$etypename = filterProcess($f_etypename, $buffer);
			        if ($etypename == "") $etypename = "General Syslog";
#			        $moduleQueryInternal = $_ENV['appDB']->query("insert into category (category) values ('$etypename')", 0);
#			        $moduleQueryInternal = $_ENV['appDB']->query("select id from category where category = '$etypename'", 0);
#			        while (list($typeid) = mysql_fetch_row($moduleQueryInternal)) {
#			            $type_id = $typeid;
#			        }
			
                    // Misc Filters
					$misc1 = filterProcess($f_misc1, $buffer);
					$misc2 = filterProcess($f_misc2, $buffer);
					$misc3 = filterProcess($f_misc3, $buffer);
					$misc4 = filterProcess($f_misc4, $buffer);
					$misc5 = filterProcess($f_misc5, $buffer);
										        
			        // Payload Filter
					$payload = filterProcess($f_payload, $buffer);
			
			        // If Date filter does not contain the year - alter the results to contain the year
					if (!strstr($date, date("Y"))) $date = $date . " " . date("Y");
			
					// Combine the date and time into $intime for database update
					$intime = strtotime("$date $time");
			
					$level = $this->postProcessor("level", $level, $sensorID);
					$protocol = $this->postProcessor("proto", $protocol, $sensorID);
					$sip = $this->postProcessor("sip", $sip, $sensorID);
					$dip = $this->postProcessor("dip", $dip, $sensorID);
					$sport = $this->postProcessor("sport", $sport, $sensorID);
					$dport = $this->postProcessor("dport", $dport, $sensorID);
					$ename = $this->postProcessor("ename", $ename, $sensorID);
					$etypename = $this->postProcessor("etypename", $etypename, $sensorID);

					$payload = $this->postProcessor("payload", $payload, $sensorID);
					if (strlen($payload) > 10) $payload = gzcompress($payload, 9);
						
			        // Signature to risk table lookup
			        $tmpA = signatureRiskLookup($riskArray, $sig_id, $ename);
					if ($tmpA != 0) $level = $tmpA;
					
					$import = noImportLookup($importArray, $payload);

					if ($import == 1) {
						
						$masterDataArray = array(
							"moduleID" => "2",
							"sensorID" => "$sensorID",
							"enabled" => "1"
						);
						
						$masterRecord = $this->writeMasterRecord($masterDataArray);
						
						$snortDataArray = array(
							"id" => "$masterRecord",
							"sport" => "$sport", 
							"dport" => "$dport",
							"sip" => "$sip",
							"dip" => "$dip",
							"signature" => "$sig_id",
							"signatureName" => "$ename",
							"class" => "$type_id",
							"className" => "$etypename",
							"priority" => "$level",
							"protocol" => "$protocol",
							"sensor" => "$sensorSID",
							"payload" => "$payload",
							"timestamp" => "$timestamp"									
						);

						$this->writeEventRecord($snortDataArray);

						$assocEventDataArray[] = array_merge($masterDataArray, $snortDataArray);
					
					}
				}
			}
		}

		if ($assocEventDataArray) {
		
	        $indexerObj->indexMultipleEvents($assocEventDataArray, ops("site_activeDataStore"));
	        
	    }
		
	}	
	
	function postProcessor($post, $value, $sensorid) {
		
		$file = "conf/post/$post.postFilter.$sensorid.conf";
		
		if (@file_exists($file)) {
			
			$data = @file($file);
			
			foreach ($data as $line) {
				
				if (!strstr($line, "~")) continue;
				if (substr($line, 0, 1) == "#") continue;
				
				$tmp = explode("~", $line);

				$value = trim($value);
				$type = trim($tmp[0]);
				$match = trim($tmp[1]);
				$replace = trim($tmp[2]);
				
				switch ($type) {
					case "S":
						
						if (stristr($value, $match)) {
							// Matched -> Return new value
							return $replace;
						} else {
							// Nothing to do
						}						
						
						break;	
					
					case "E":
						
						if ($match == $value) {
							// Matched -> Return new value
							return $replace;
						} else {
							// Nothing to do 
						}						
						
						break;
				
					case "D":
						
						if ($post == "sip" || $post == "dip") $replace = ip2long($replace);
						
						return $replace;
						
						break;						
						
					default:
						break;
				}
				
			}
			
			return $value;
			
		} else {
			// Nothing to do -> Return original value
			return $value;
		}
	}
	
	function writeEventRecord($dataArray) {
		global $idsDB;
	
		foreach ($dataArray as $field => $value) {
		
			$fieldArray[] = $field;
			$valueArray[] = "'" . addslashes($value) . "'";
	
		}
		
		$fieldString = implode(", ", $fieldArray);
		$valueString = implode(", ", $valueArray);
		
		$idsQueryA = $_ENV['appDB']->query("INSERT INTO idsDataStore_" . ops("site_activeDataStore") . "_Events ($fieldString) VALUES ($valueString)");
	
	}
	
	function writeMasterRecord($dataArray) {
		global $idsDB;
	
		foreach ($dataArray as $field => $value) {
		
			$fieldArray[] = $field;
			$valueArray[] = "'" . addslashes($value) . "'";

		}
		
		$fieldString = implode(", ", $fieldArray);
		$valueString = implode(", ", $valueArray);
		
		$idsQueryA = $_ENV['appDB']->query("INSERT INTO idsDataStore_" . ops("site_activeDataStore") . "_Master ($fieldString) VALUES ($valueString)");
	
		return mysql_insert_id($_ENV['appDB']->link);	
	
	}	
	
}

?>