<?php

function navIcons() {
	
	$icons = array(
	
		"Home" => array(
			"image" => "main_icon.png",
			"url" => "?op=prv_main"
		),

		"My Account" => array(
			"image" => "user_icon.png",
			"url" => "?op=prv_myAccount"
		),

		"My Options" => array(
			"image" => "options_icon.png",
			"url" => "?op=prv_myOptions"
		),

		"Browse & Search Events" => array(
			"image" => "search_icon.png",
			"url" => "?op=prv_eventBrowser"
		),

		"Charts & Graphs" => array(
			"image" => "charts_icon.png",
			"url" => "?op=prv_chartsGraphs"
		),

		"Situational Awareness" => array(
			"image" => "situationalAwareness_icon.png",
			"url" => "?op=prv_situationalAwareness"
		),

		"Live Monitor" => array(
			"image" => "live_icon.png",
			"url" => "?op=prv_liveMonitor"
		),

		"Live Correlation" => array(
			"image" => "liveCorrelation_icon.png",
			"url" => "?op=prv_liveEventCorrelation"
		),

		"Live GeoLocation" => array(
			"image" => "geo_icon.png",
			"url" => "?op=prv_liveGeoLocation"
		),

		"My Reports" => array(
			"image" => "reports_icon.png",
			"url" => "?op=prv_myReports"
		)
		
	);
	
	return $icons;

}

function navIconsBottom() {
	
	$icons = array(
		
		"Console Status" => array(
			"image" => "status_icon.png",
			"url" => "?op=prv_status"
		),
			
		"Console Configuration" => array(
			"image" => "configuration_icon.png",
			"url" => "?op=prv_configuration"
		)
	
	);
	
	return $icons;

}

function navMenu() {

	$navMenu = array(
	
		"My Menu" => array(
			"Home" => "?",
			"Account" => "?op=prv_account",
			"Search History" => "?op=prv_searchHistory",
			"Activity Logs" => "?op=prv_activityLogs",
			"About" => "?op=prv_about",
			"Logout" => "?op=pub_logout"
		),
		
		"Event" => array(
			"Live Monitor" => "?op=prv_liveMonitor", 
			"Live GeoLocation" => "?", 
			"Event Browser" => "?op=prv_eventBrowser",
			"Event Correlation" => "?",
			"Event Indexes" => "?op=prv_indexes",
			"Frequent Offenders" => "?op=prv_frequentOffenders",
			"Frequent Targets" => "?op=prv_frequentTargets",
			"Frequent Events" => "?op=prv_frequentEvents",
			"Frequent Ports" => "?op=prv_frequentPorts"
		),
		
		"Modules" => array(
			"Accounts" => "?op=prv_accountManagement", 
			"Reports" => "?", 
			"Actions" => "?", 
			"Event Browser" => "?",
			"Notes" => "?",
			"Collections" => "?",
			"Host Visualizer" => "?"
		),
	
		"Snort" => array(
			"Settings" => "?op=prv_snortModuleSettings", 
			"Configuration" => "?op=prv_snortConfiguration", 
			"Management" => "?", 
			"Policies" => "?", 
			"Signature Management" => "?", 
			"Signature Sources" => "?"
		),
		
		"Syslog" => array(
			"Settings" => "?op=prv_syslogModuleSettings", 
			"Configuration" => "?", 
			"Manage Filters" => "?", 
			"Assign Filters" => "?"
		)		
	
	);
	
	foreach ($navMenu as $title => $items) {
	
		$out.= "<div style=\"font-size: 15px; margin-top: 7px; margin-bottom: 1px; vertical-align: middle;\"><img src=\"console/assets/images/icons/arrow_down_gray.png\" style=\"position: relative; padding-top: 5px;\"> $title</div>";
		
		foreach ($items as $item => $op) {
	
			$out .="<div style=\"font-size: 13px; margin-left: 33px; padding: 2px;\"><a href=\"$op\">" . $item . "</a></div>";
	
		}
		
	}
	
	return $out;
	
}

?>