<?php

/** Copyright 2012 Tactical FLEX, Inc.
 *
 * Aanval 7
 *
 * This program is owned and licensed by Tactical FLEX, Inc.; it may be
 * redistributed only in its original configuration as originally
 * installed and available by Tactical FLEX, Inc. and / or Aanval.
 *
 * To license and / or include this product in other forms or
 * applications, express prior written authorization must be
 * obtained by contract from authorized Tactical FLEX, Inc. or Aanval
 * agents.
 *
 * Tactical FLEX, Inc. and Aanval may not be held liable nor responsible
 * for any and all issues arising from the use of, damages caused by, or 
 * conclusions drawn from the use of this product.
 *
 */

function getIP() {
	return $_SERVER['REMOTE_ADDR'];
}

function cidrconv($net) {

    $start = strtok($net, "/");
    $n = 3 - substr_count($net, ".");

    if ($n > 0) {
    
        for ($i = $n; $i > 0; $i--) {
            $start .= ".0";
        }
        
    }

    $bits1 = str_pad(decbin(ip2long($start)), 32, "0", STR_PAD_LEFT);
    $net = pow(2, (32 - substr(strstr($net, "/"), 1)))-1;
    $bits2 = str_pad(decbin($net), 32, "0", STR_PAD_LEFT);

    for ($i = 0; $i < 32; $i++) {
    
		if ($bits1[$i] == $bits2[$i]) $final .= $bits1[$i];
		if ($bits1[$i] == 1 and $bits2[$i] == 0) $final .= $bits1[$i];
		if ($bits1[$i] == 0 and $bits2[$i] == 1) $final .= $bits2[$i];
		
    }

    return $start . "-" . long2ip(bindec($final));
}

function protoToName($in) {

	/* Convert numerical protocol into text protocol */	
	
	$file = @file("conf/maps/proto.map");
	
	foreach ($file as $line) {
		
		// Trim lines
		$line = trim($line);
		
		// Remove whitespace
		$line = str_replace(" ", "", $line);
		
		// Skip commented lines
		if (strstr($line, "#")) continue;
		
		// Skip if not complete
		if (!strstr($line, "=")) continue;
		
		// Break on =
		$data = explode("=", $line);
		
		// Pad list with commas
		$numList = "," . $data[1] . ",";
		
		// Match
		if (strstr($numList, ",$in,")) {

			// Set protocol w/ UPPER CASE
			$protocol = strtoupper($data[0]);

			break;
		}
	}
	
	if (!$protocol) $protocol = $in;
	
	// Returns textual representation of protocol
	return $protocol;
}

function nameToProto($in) {

	/* Convert text protocol into numerical protocol */	
	
	$file = @file("conf/maps/proto.map");
	
	foreach ($file as $line) {
		
		// Trim lines
		$line = trim($line);
		
		// Remove whitespace
		$line = str_replace(" ", "", $line);
		
		// Skip commented lines
		if (strstr($line, "#")) continue;
		
		// Skip if not complete
		if (!strstr($line, "=")) continue;
		
		// Break on =
		$data = explode("=", $line);
		
		// Match		
		if (strtoupper($in) == $data[0]) {

			// Set protocol
			$tmp = explode(",", $data[1]);
			$protocol = $tmp[0];

			break;
		}
	}
	
	if (!$protocol) $protocol = $in;
	
	// Returns numerical representation of protocol
	return $protocol;
}

function portToName($in) {

	/* Convert numerical port into text port name */	
	
	$file = @file("conf/maps/port.map");
	
	foreach ($file as $line) {
		
		// Trim lines
		$line = trim($line);
		
		// Remove whitespace
		$line = str_replace(" ", "", $line);
		
		// Skip commented lines
		if (strstr($line, "#")) continue;
		
		// Skip if not complete
		if (!strstr($line, "=")) continue;
		
		// Break on =
		$data = explode("=", $line);
		
		// Pad list with commas
		$numList = "," . $data[1] . ",";
		
		// Match
		if (strstr($numList, ",$in,")) {

			// Set port w/ UPPER CASE
			$protocol = strtoupper($data[0]);

			break;
		}
	}
	
	if (!$protocol) $protocol = $in;
	
	// Returns textual representation of port
	return $protocol;
}

function nameToPort($in) {

	/* Convert text port name into numerical port */	
	
	$file = @file("conf/maps/port.map");
	
	foreach ($file as $line) {
		
		// Trim lines
		$line = trim($line);
		
		// Remove whitespace
		$line = str_replace(" ", "", $line);
		
		// Skip commented lines
		if (strstr($line, "#")) continue;
		
		// Skip if not complete
		if (!strstr($line, "=")) continue;
		
		// Break on =
		$data = explode("=", $line);
		
		// Match		
		if (strtoupper($in) == $data[0]) {

			// Set port
			$tmp = explode(",", $data[1]);
			$protocol = $tmp[0];

			break;
		}
	}
	
	if (!$protocol) $protocol = $in;
	
	// Returns numerical representation of port
	return $protocol;
}

function doHostnameLookup($ip, $override = null) {
	
	if ($override !== null) {

		if ($override == true) {

			return readWriteDBHostname($ip);
		
		}

	} else {

		if (ops("site_hostnameLookups") == 1) {
	
			return readWriteDBHostname($ip);
			
		}

	}
	
	return $ip;
	
}

function readWriteDBHostname($ip) {

	$q = $_ENV['appDB']->query("SELECT hostname FROM idsHostnames WHERE ip = INET_ATON('$ip')");
	while ($row = mysql_fetch_assoc($q)) {

		return $row['hostname'];

	}

	$hostname = gethostbyaddr($ip);
	
	$q = $_ENV['appDB']->query("INSERT INTO idsHostnames (ip, hostname, timestamp) VALUES (INET_ATON('$ip'), '" . addslashes($hostname) . "', '" . time() . "')");
	
	return $hostname;

}

function packetPayload($data, $encode_type, $output_type) {

	if ( $encode_type == "1" ) {
		$payload = PrintBase64PacketPayload($data, $output_type);
	} else if ($encode_type == "2" ) {
	    $payload = PrintAsciiPacketPayload($data, $output_type);
	} else if ($encode_type == "3" ) {
		$payload = PrintAsciiOnly($data, $output_type);
	} else if ($encode_type == "0" ) {
		$payload = PrintHexPacketPayload($data, $output_type);
	}

	return $payload;
}

function PrintPayloadChar($char, $output_type ) {

	if ( $char >= 32 && $char <= 127 ) {
		if ( $output_type == 2 ) {
        	return chr($char);
		} else {
        	return htmlspecialchars(chr($char));
		}
	} else {
		return '.';
	}
}

function PrintAsciiPacketPayload ( $encoded_payload, $output_type )
{
   return wordwrap($encoded_payload, 70);
}

function PrintHexPacketPayload ( $encoded_payload, $output_type )
{
     /* strip out the <CR> at the end of each block */
     $encoded_payload = str_replace("\n", "", $encoded_payload);
     $payload = $encoded_payload;

     $len = strlen($payload);
#     $s = " length = ".(strlen($payload)/2)."\n";

     $s = "Payload Length: " . (strlen($payload)/2)."<br>";

     for ($i = 0; $i < strlen($payload); $i += 2 )
     {
          if ( $i % 32 == 0 )
          {
             /* dump the ASCII characters */
             if ( $i != 0 )
             {
                $s = $s.'  ';
                for ($j = $i-32; $j < $i; $j+=2 )
                {
                    $t = hexdec($payload[$j].$payload[$j+1]);
                    $s = $s.PrintPayloadChar($t, $output_type);
                }
             }
             $s = $s.sprintf("<br>%03x : ", $i/2);
          }
          $s = $s.sprintf("%s%s ", $payload[$i], $payload[$i+1] );
     }

     /* space through to align end of hex dump */
     if ( $i % 32 )
        for ( $j = 0; $j < 32 - ($i % 32); $j+=2)
           $s = $s.'   ';

     $s = $s.'  ';

     /* print the ASCII decode */
     if ( $i % 32 )
        $start = $len - ($i % 32);
     else
        $start = $len - 32;

     for ( $j = $start; $j < $i; $j+=2 )
     {
        $t = hexdec($payload[$j].$payload[$j+1]);
        $s = $s.PrintPayloadChar($t, $output_type);
     }

     return addslashes($s);
}

function PrintAsciiOnly($encoded_payload, $output_type) {

    /* strip out the <CR> at the end of each block */
     $encoded_payload = str_replace("\n", "", $encoded_payload);
     $payload = $encoded_payload;

     $len = strlen($payload);

     for ($i = 0; $i < $len; $i += 2 ) {
         if ( $i % 32 == 0 ) {
            if ( $i != 0 ) {
                for ($j = $i-32; $j < $i; $j+=2 ) {
                    $t = hexdec($payload[$j].$payload[$j+1]);
                    $s = $s.PrintPayloadChar($t, $output_type);
                }
            }
         }
     }

	/* print the ASCII decode */
    if ( $i % 32 ) {
        $start = $len - ($i % 32);
    } else {
		$start = $len - 32;
    }
	
	for ( $j = $start; $j < $i; $j+=2 ) {
		$t = hexdec($payload[$j].$payload[$j+1]);
		$s = $s.PrintPayloadChar($t, $output_type);
	} 

    return $s;
}

function PrintBase64PacketPayload ( $encoded_payload, $output_type )
{
     /* strip out the <CR> at the end of each block */
     $encoded_payload = str_replace("\n", "", $encoded_payload);
     //printf(" len = %d\n", strlen($encoded_payload));
     //printf("%s \n", $encoded_payload);

     $payload = base64_decode($encoded_payload);
     $len = strlen($payload);
     $s = " length = ".strlen($payload)."<br>";

     for ($i = 0; $i < strlen($payload); $i++ )
     {
          if ( $i % 16 == 0 )
          {
             /* dump the ASCII characters */
             if ( $i != 0 )
             {
                $s = $s.'  ';
                for ($j = $i-16; $j < $i; $j++ )
                   $s = $s.PrintPayloadChar($payload[$j], $output_type);
             }
             $s = $s.sprintf("\n%03x : ", $i);
          }

          $s = $s.sprintf("%s ", bin2hex($payload[$i]) );
     }

     /* print the remained of any ASCII chars */
     if ( ($i % 16) != 0 )
     {
        for ( $j = 0; $j < 16 - ($i % 16); $j++)
            $s = $s.'   ';

        $s = $s.'  ';

        for ( $j = $len - ($i % 16); $j < $len; $j++ )
           $s = $s.PrintPayloadChar($payload[$j], $output_type);
     }

     return addslashes($s);
}

function exConnect($url) {

    /* Proxy option uses wget */
    
    // Check if proxy settings are required and enabled
    if (ops("site_proxyEnabled") == 1) {

    	// Check if proxy username is not empty
        if (ops("site_proxyUsername") != "") {
        	
        	// Set proxy username options
            $proxyAuth .= " --proxy-user=" . ops("site_proxyUsername") . " ";
        }
        
        // Check if proxy password is not empty
        if (ops("site_proxyPassword") != "") {
        	
        	// Set proxy password options
            $proxyAuth .= " --proxy-passwd=" . ops("site_proxyPassword") . " ";
        }

        // Retrieve proxy variables from ops
        $proxy_host = ops("site_proxyHost");
        $proxy_port = ops("site_proxyPort");
        
        // Set needed environment variable for wget
        putenv("http_proxy=$proxy_host:$proxy_port");
        
        // Execute shell command
        $data = shell_exec(ops("site_wget_path") . " $proxyAuth -q -O - \"$url\"");
        
    } else {

    	// Create file handle and make outbound connection
        if ($handle = @fopen("$url", "r")) {
        	
        	// Loop through file contents
            while (!feof($handle)) {
            	
            	// Concatentate incoming data
                $data .= fread($handle, 4096);
            }
            
            // Close file handle
            fclose($handle);
            
        } else {
			
        }
    }

    // Return results
    return $data;
}

function flagToText($bit) {
	
	$array[] = "NULL Packet";
	$array[] = "NULL Packet (reserved bit 1 active)";
	$array[] = "NULL Packet (reserved bit 2 active)";
	$array[] = "NULL Packet (reserved bit 1 & 2 active)";
	$array[] = "URG: Standard/Invalid ";
	$array[] = "URG: Standard/Invalid (reserved bit 1 active) ";
	$array[] = "URG: Standard/Invalid (reserved bit 2 active) ";
	$array[] = "URG: Standard/Invalid (reserved bit 1 & 2 active) ";
	$array[] = "ACK: Acknowlege packet";
	$array[] = "ACK: Acknowlege packeStandard/Invalid (reserved bit 1 active) ";
	$array[] = "ACK: Acknowlege packeStandard/Invalid (reserved bit 2 active) ";
	$array[] = "ACK: Acknowlege packeStandard/Invalid (reserved bit 1 & 2 active) ";
	$array[] = "URG | ACK: Urgent field active with acknowlegement of packet";
	$array[] = "URG | ACK: Urgent field active with acknowlegement of packet (reserved bit 1 active)";
	$array[] = "URG | ACK: Urgent field active with acknowlegement of packet (reserved bit 2 active)";
	$array[] = "URG | ACK: Urgent field active with acknowlegement of packet (reserved bit 1 & 2 active)";
	$array[] = "PSH: Standard/Invalid ";
	$array[] = "PSH: Standard/Invalid (reserved bit 1 active) ";
	$array[] = "PSH: Standard/Invalid (reserved bit 2 active) ";
	$array[] = "PSH: Standard/Invalid (reserved bit 1 & 2 active) ";
	$array[] = "URG | PSH: Urgent field active and push data";
	$array[] = "URG | PSH: Urgent field active and push data (reserved bit 1 active)";
	$array[] = "URG | PSH: Urgent field active and push data (reserved bit 2 active)";
	$array[] = "URG | PSH: Urgent field active and push data (reserved bit 1 & 2 active)";
	$array[] = "ACK | PSH: Acknowlegement with a push on packet ";
	$array[] = "ACK | PSH: Acknowlegement with a push on packet (reserved bit 1 active) ";
	$array[] = "ACK | PSH: Acknowlegement with a push on packet (reserved bit 2 active) ";
	$array[] = "ACK | PSH: Acknowlegement with a push on packet (reserved bit 1 & 2 active) ";
	$array[] = "URG | ACK | PSH: Urgent field active, acknowlegement of packet, and priority data ";
	$array[] = "URG | ACK | PSH: Urgent field active, acknowlegement of packet, and priority data (reserved bit 1 active) ";
	$array[] = "URG | ACK | PSH: Urgent field active, acknowlegement of packet, and priority data (reserved bit 2 active) ";
	$array[] = "URG | ACK | PSH: Urgent field active, acknowlegement of packet, and priority data (reserved bit 1 & 2 active) ";
	$array[] = "RST: Reset/Terminate connection immediately";
	$array[] = "RST: Reset/Terminate connection immediately (reserved bit 1 active)";
	$array[] = "RST: Reset/Terminate connection immediately (reserved bit 2 active)";
	$array[] = "RST: Reset/Terminate connection immediately (reserved bit 1 & 2 active)";
	$array[] = "URG | RST: Standard/Invalid ";
	$array[] = "URG | RST: Standard/Invalid (reserved bit 1 active) ";
	$array[] = "URG | RST: Standard/Invalid (reserved bit 2 active) ";
	$array[] = "URG | RST: Standard/Invalid (reserved bit 1 & 2 active) ";
	$array[] = "ACK | RST: Acknowlegement with connection reset ";
	$array[] = "ACK | RST: Acknowlegement with connection reset (reserved bit 1 active) ";
	$array[] = "ACK | RST: Acknowlegement with connection reset (reserved bit 2 active) ";
	$array[] = "ACK | RST: Acknowlegement with connection reset (reserved bit 1 & 2 active) ";
	$array[] = "URG | ACK | RST: Standard/Invalid ";
	$array[] = "URG | ACK | RST: Standard/Invalid (reserved bit 1 active) ";
	$array[] = "URG | ACK | RST: Standard/Invalid (reserved bit 2 active) ";
	$array[] = "URG | ACK | RST: Standard/Invalid (reserved bit 1 & 2 active) ";
	$array[] = "PSH | RST: Standard/Invalid ";
	$array[] = "PSH | RST: Standard/Invalid (reserved bit 1 active) ";
	$array[] = "PSH | RST: Standard/Invalid (reserved bit 2 active) ";
	$array[] = "PSH | RST: Standard/Invalid (reserved bit 1 & 2 active) ";
	$array[] = "URG | PSH | RST: Standard/Invalid ";
	$array[] = "URG | PSH | RST: Standard/Invalid (reserved bit 1 active) ";
	$array[] = "URG | PSH | RST: Standard/Invalid (reserved bit 2 active) ";
	$array[] = "URG | PSH | RST: Standard/Invalid (reserved bit 1 & 2 active) ";
	$array[] = "ACK | PSH | RST: Found through numberous false alters, but is legitimate traffic";
	$array[] = "ACK | PSH | RST: Found through numberous false alters, but is legitimate traffic (reserved bit 1 active)";
	$array[] = "ACK | PSH | RST: Found through numberous false alters, but is legitimate traffic (reserved bit 2 active)";
	$array[] = "ACK | PSH | RST: Found through numberous false alters, but is legitimate traffic (reserved bit 1 & 2 active)";
	$array[] = "Standard/Invalid";
	$array[] = "Standard/Invalid";
	$array[] = "Standard/Invalid";
	$array[] = "Standard/Invalid";
	$array[] = "SYN: Setup/Initiate Connection";
	$array[] = "SYN: Setup/Initiate Connection (reserved bit 1 active)";
	$array[] = "SYN: Setup/Initiate Connection (reserved bit 2 active)";
	$array[] = "SYN: Setup/Initiate Connection (reserved bit 1 & 2 active)";
	$array[] = "Standard/Invalid";
	$array[] = "Standard/Invalid";
	$array[] = "Standard/Invalid";
	$array[] = "Standard/Invalid";
	$array[] = "ACK | SYN: Acknowlege a SYN packet";
	$array[] = "ACK | SYN: Acknowlege a SYN packet (reserved bit 1 active)";
	$array[] = "ACK | SYN: Acknowlege a SYN packet (reserved bit 2 active)";
	$array[] = "ACK | SYN: Acknowlege a SYN packet (reserved bit 1 & 2 active)";
	$array[] = "Standard/Invalid";
	$array[] = "Standard/Invalid";
	$array[] = "Standard/Invalid";
	$array[] = "Standard/Invalid";
	$array[] = "Standard/Invalid";
	$array[] = "Standard/Invalid";
	$array[] = "Standard/Invalid";
	$array[] = "Standard/Invalid";
	$array[] = "Standard/Invalid";
	$array[] = "Standard/Invalid";
	$array[] = "Standard/Invalid";
	$array[] = "Standard/Invalid";
	$array[] = "Standard/Invalid";
	$array[] = "Standard/Invalid";
	$array[] = "Standard/Invalid";
	$array[] = "Standard/Invalid";
	$array[] = "URG | ACK | PSH | SYN";
	$array[] = "URG | ACK | PSH | SYN (reserved bit 1 active)";
	$array[] = "URG | ACK | PSH | SYN (reserved bit 2 active)";
	$array[] = "URG | ACK | PSH | SYN (reserved bit 1 & 2 active)";
	$array[] = "Standard/Invalid";
	$array[] = "Standard/Invalid";
	$array[] = "Standard/Invalid";
	$array[] = "Standard/Invalid";
	$array[] = "Standard/Invalid";
	$array[] = "Standard/Invalid";
	$array[] = "Standard/Invalid";
	$array[] = "Standard/Invalid";
	$array[] = "Standard/Invalid";
	$array[] = "Standard/Invalid";
	$array[] = "Standard/Invalid";
	$array[] = "Standard/Invalid";
	$array[] = "Standard/Invalid";
	$array[] = "Standard/Invalid";
	$array[] = "Standard/Invalid";
	$array[] = "Standard/Invalid";
	$array[] = "Standard/Invalid";
	$array[] = "Standard/Invalid";
	$array[] = "Standard/Invalid";
	$array[] = "Standard/Invalid";
	$array[] = "Standard/Invalid";
	$array[] = "Standard/Invalid";
	$array[] = "Standard/Invalid";
	$array[] = "Standard/Invalid";
	$array[] = "Standard/Invalid";
	$array[] = "Standard/Invalid";
	$array[] = "Standard/Invalid";
	$array[] = "Standard/Invalid";
	$array[] = "Standard/Invalid";
	$array[] = "Standard/Invalid";
	$array[] = "Standard/Invalid";
	$array[] = "Standard/Invalid";
	$array[] = "FIN: Finished sending data through 1/2 connection ";
	$array[] = "FIN: Finished sending data through 1/2 connection (reserved bit 1 active) ";
	$array[] = "FIN: Finished sending data through 1/2 connection (reserved bit 2 active) ";
	$array[] = "FIN: Finished sending data through 1/2 connection (reserved bit 1 & 2 active) ";
	$array[] = "URG | RST: Urgent field active and reset connection ";
	$array[] = "URG | RST: Urgent field active and reset connection (reserved bit 1 active) ";
	$array[] = "URG | RST: Urgent field active and reset connection (reserved bit 2 active) ";
	$array[] = "URG | RST: Urgent field active and reset connection (reserved bit 1 & 2 active) ";
	$array[] = "SYN | FIN: Finished with connection with acknowlegement of packet";
	$array[] = "SYN | FIN: Finished with connection with acknowlegement of packet (reserved bit 1 active)";
	$array[] = "SYN | FIN: Finished with connection with acknowlegement of packet (reserved bit 2 active)";
	$array[] = "SYN | FIN: Finished with connection with acknowlegement of packet (reserved bit 1 & 2 active)";
	$array[] = "URG | ACK | FIN: Urgent field active, acknowlege packet, and finished sending data";
	$array[] = "URG | ACK | FIN: Urgent field active, acknowlege packet, and finished sending data (reserved bit 1 active)";
	$array[] = "URG | ACK | FIN: Urgent field active, acknowlege packet, and finished sending data (reserved bit 2 active)";
	$array[] = "URG | ACK | FIN: Urgent field active, acknowlege packet, and finished sending data (reserved bit 1 & 2 active)";
	$array[] = "PSH | RST: Push data and reset connection";
	$array[] = "PSH | RST: Push data and reset connection (reserved bit 1 active)";
	$array[] = "PSH | RST: Push data and reset connection (reserved bit 2 active)";
	$array[] = "PSH | RST: Push data and reset connection (reserved bit 1 & 2 active)";
	$array[] = "URG | PSH | FIN: X-mas tree";
	$array[] = "URG | PSH | FIN: X-mas tree (reserved bit 1 active)";
	$array[] = "URG | PSH | FIN: X-mas tree (reserved bit 2 active)";
	$array[] = "URG | PSH | FIN: X-mas tree (reserved bit 1 & 2 active)";
	$array[] = "ACK | PSH | FIN: Acknowlege packet, push data, and finished with connection";
	$array[] = "ACK | PSH | FIN: Acknowlege packet, push data, and finished with connection (reserved bit 1 active)";
	$array[] = "ACK | PSH | FIN: Acknowlege packet, push data, and finished with connection (reserved bit 2 active)";
	$array[] = "ACK | PSH | FIN: Acknowlege packet, push data, and finished with connection (reserved bit 1 & 2 active)";
	$array[] = "URG | ACK | PSH | FIN: Urgent field active, acknowlege packet, push data, and finished sending data ";
	$array[] = "URG | ACK | PSH | FIN: Urgent field active, acknowlege packet, push data, and finished sending data (reserved bit 1 active) ";
	$array[] = "URG | ACK | PSH | FIN: Urgent field active, acknowlege packet, push data, and finished sending data (reserved bit 2 active) ";
	$array[] = "URG | ACK | PSH | FIN: Urgent field active, acknowlege packet, push data, and finished sending data (reserved bit 1 & 2 active) ";
	$array[] = "Standard/Invalid";
	$array[] = "Standard/Invalid";
	$array[] = "Standard/Invalid";
	$array[] = "Standard/Invalid";
	$array[] = "Standard/Invalid";
	$array[] = "Standard/Invalid";
	$array[] = "Standard/Invalid";
	$array[] = "Standard/Invalid";
	$array[] = "Standard/Invalid";
	$array[] = "Standard/Invalid";
	$array[] = "Standard/Invalid";
	$array[] = "Standard/Invalid";
	$array[] = "Standard/Invalid";
	$array[] = "Standard/Invalid";
	$array[] = "Standard/Invalid";
	$array[] = "Standard/Invalid";
	$array[] = "Standard/Invalid";
	$array[] = "Standard/Invalid";
	$array[] = "Standard/Invalid";
	$array[] = "Standard/Invalid";
	$array[] = "URG | PSH | RST | FIN: Kamakaze packet if it has one byte of data";
	$array[] = "URG | PSH | RST | FIN: Kamakaze packet if it has one byte of data (reserved bit 1 active)";
	$array[] = "URG | PSH | RST | FIN: Kamakaze packet if it has one byte of data (reserved bit 2 active)";
	$array[] = "URG | PSH | RST | FIN: Kamakaze packet if it has one byte of data (reserved bit 1 & 2 active)";
	$array[] = "Standard/Invalid";
	$array[] = "Standard/Invalid";
	$array[] = "Standard/Invalid";
	$array[] = "Standard/Invalid";
	$array[] = "Standard/Invalid";
	$array[] = "Standard/Invalid";
	$array[] = "Standard/Invalid";
	$array[] = "Standard/Invalid";
	$array[] = "SYN | FIN: \"SYN | FIN scan\" generates a reply if port is open (reply-> ) or closed (reply-> RST | SCK)";
	$array[] = "SYN | FIN: \"SYN | FIN scan\" generates a reply if port is open (reply-> ) or closed (reply-> RST | SCK) (reserved bit 1 active)";
	$array[] = "SYN | FIN: \"SYN | FIN scan\" generates a reply if port is open (reply-> ) or closed (reply-> RST | SCK) (reserved bit 2 active)";
	$array[] = "SYN | FIN: \"SYN | FIN scan\" generates a reply if port is open (reply-> ) or closed (reply-> RST | SCK) (reserved bit 1 & 2 active)  | ";
	$array[] = "Standard/Invalid";
	$array[] = "Standard/Invalid";
	$array[] = "Standard/Invalid";
	$array[] = "Standard/Invalid";
	$array[] = "Standard/Invalid";
	$array[] = "Standard/Invalid";
	$array[] = "Standard/Invalid";
	$array[] = "Standard/Invalid";
	$array[] = "Standard/Invalid";
	$array[] = "Standard/Invalid";
	$array[] = "Standard/Invalid";
	$array[] = "Standard/Invalid";
	$array[] = "Standard/Invalid";
	$array[] = "Standard/Invalid";
	$array[] = "Standard/Invalid";
	$array[] = "Standard/Invalid";
	$array[] = "URG | PSH | SYN | FIN: NMAPID";
	$array[] = "URG | PSH | SYN | FIN: NMAPID (reserved bit 1 active)";
	$array[] = "URG | PSH | SYN | FIN: NMAPID (reserved bit 2 active)";
	$array[] = "URG | PSH | SYN | FIN: NMAPID (reserved bit 1 & 2 active)";
	$array[] = "Standard/Invalid";
	$array[] = "Standard/Invalid";
	$array[] = "Standard/Invalid";
	$array[] = "Standard/Invalid";
	$array[] = "Standard/Invalid";
	$array[] = "Standard/Invalid";
	$array[] = "Standard/Invalid";
	$array[] = "Standard/Invalid";
	$array[] = "Standard/Invalid";
	$array[] = "Standard/Invalid";
	$array[] = "Standard/Invalid";
	$array[] = "Standard/Invalid";
	$array[] = "Standard/Invalid";
	$array[] = "Standard/Invalid";
	$array[] = "Standard/Invalid";
	$array[] = "Standard/Invalid";
	$array[] = "Standard/Invalid";
	$array[] = "Standard/Invalid";
	$array[] = "Standard/Invalid";
	$array[] = "Standard/Invalid";
	$array[] = "Standard/Invalid";
	$array[] = "Standard/Invalid";
	$array[] = "Standard/Invalid";
	$array[] = "Standard/Invalid";
	$array[] = "Standard/Invalid";
	$array[] = "Standard/Invalid";
	$array[] = "Standard/Invalid";
	$array[] = "Standard/Invalid";
	$array[] = "Standard/Invalid";
	$array[] = "Standard/Invalid";
	$array[] = "Standard/Invalid";
	$array[] = "Standard/Invalid";
	$array[] = "Standard/Invalid";
	$array[] = "Standard/Invalid";
	$array[] = "Standard/Invalid";
	$array[] = "Standard/Invalid";
	$array[] = "URG | ACK | PSH | RST | SYN | FIN: FULL X-mas tree";
	$array[] = "URG | ACK | PSH | RST | SYN | FIN: FULL X-mas tree (reserved bit 1 active)";
	$array[] = "URG | ACK | PSH | RST | SYN | FIN: FULL X-mas tree (reserved bit 2 active)";
	$array[] = "URG | ACK | PSH | RST | SYN | FIN: FULL X-mas tree (reserved bit 1 & 2 active)";	
	
	return $array[$bit];
}

?>
