<?php

function ruleWordNormalize($in) {

	$in = str_replace(".rules", "", $in);
	
	$tmp = explode("-", $in);
	
	foreach ($tmp as $word) {

		if (in_array($word, array("smtp", "iis", "voip", "nntp", "ftp", "tftp", "sql", "mysql", "snmp", "cgi", "pop3", "pop2", "php", "p2p", "imap", "dos", "ddos", "icmp", "dns", "ids", "rpc"))) {
		
			$out .= strtoupper($word) . " ";
		
		} else {

			$out .= strtoupper(substr($word, 0, 1)) . strtolower(substr($word, 1)) . " ";
			
		}
	
	}

	$out = trim($out);

	return $out;
}

function snortConfWrite($sid) {

    $objSensor = new mySensor();
    $objSensor->loadSensor($sid);

	if (!$objSensor->getSensorVar("smtid") || $objSensor->getSensorVar("smtid") == "") return;

	$snortConfFile = "smt/sensorData/" . $objSensor->getSensorVar("smtid") . "/" . $objSensor->getSensorVar("confFile");
	$snortRuleDirectory = "smt/policyData/" . $objSensor->getSensorVar("confPolicy") . "/";
	
	if (!@file_exists($snortRuleDirectory)) {
	
		if (!@mkdir($snortRuleDirectory, 0777, true)) {
		
//			errorLog("Directory: '$snortRuleDirectory' could not be created");
		
		}
		
	}
	
	// Make Rule File Array	
	
	if ($this_dir = @dir($snortRuleDirectory)) {
		while ($file = $this_dir->read()) {
			if ($file != "." && $file != "..") {
				if (substr($file, -6) == ".rules") {

					$fileArray[] = $file;
					$ruleArray[] = "include \$RULE_PATH/$file";

				}
			}
		}
	}
	
	// Main Loop (creates conf array, removes rule lines and sets insert marker)
	
	foreach (@file($snortConfFile) as $line) {
	
		$line = trim($line);
		
		if (stristr($line, "include") && stristr($line, ".rules")) {

		} else if (stristr($line, "site specific rules")) {
		
			$lineArray[] = "# site specific rules";
			$lineArray[] = "AANVAL RULE MARKER";
		
		} else {
		
			$lineArray[] = $line;
			
		}
	
	}

	// Rebuild conf from array and insert rule lines at marker

	$newConf = implode("\n", $lineArray);
	
	if (strstr($newConf, "AANVAL RULE MARKER")) {
	
		$newConf = str_replace("AANVAL RULE MARKER", implode("\n", $ruleArray) . "\n", $newConf);
	
	} else {
	
		$newConf .= "\n\n";
		$newConf .= "# site specific rules";
		$newConf .= "\n" . implode("\n", $ruleArray);
	
	}

	// Write new conf
	
	if ($fp = @fopen($snortConfFile, "w")) {
	
		$data = str_replace("\n\n\n", "\n", $newConf);
		
		fwrite($fp, $data);
		
		fclose($fp);
		
	} else {
	
//		errorLog("File: '$snortConfFile' could not be opened for writing");
	
	}

}

function snortRulesFile_write($policy, $file) {
	
	$writeDirectory = "smt/policyData/" . $policy . "/";
	
	if (!@file_exists($writeDirectory)) {
	
		if (!@mkdir($writeDirectory, 0777, true)) {
		
//			errorLog("Directory: '$writeDirectory' could not be created");
		
		}
		
	}

	$lineArray[] = " ";
	$lineArray[] = "# ----------------------------";
	$lineArray[] = "# " . ruleWordNormalize($file) . " Rules";
	$lineArray[] = "# ----------------------------";
	$lineArray[] = " ";

	$q = $_ENV['appDB']->query("SELECT idsSignatures.* FROM idsSignatures JOIN idsSignaturePolicyIndex ON (idsSignatures.id = idsSignaturePolicyIndex.sid) WHERE idsSignatures.file = '$file' AND idsSignaturePolicyIndex.pid = '$policy'");
	while ($row = mysql_fetch_assoc($q)) {

		$lineArray[] = $row["data"];

	}
	
	if ($fp = @fopen($writeDirectory . "/$file", "w")) {
	
		fwrite($fp, ruleFileHeading());
		fwrite($fp, implode("\n", $lineArray));
		fclose($fp);
		
	} else {
	
//		errorLog("File: '$writeDirectory/$file' could not be opened for writing");
	
	}
	
	unset($lineArray);
	unset($fileHeadFlag);
	
}

function ruleFileHeading() {

	$out .= "# Copyright 2001-2005 Sourcefire, Inc. All Rights Reserved\n";
	$out .= "#\n";
	$out .= "# This file may contain proprietary rules that were created, tested and\n";
	$out .= "# certified by Sourcefire, Inc. (the \"VRT Certified Rules\") as well as\n";
	$out .= "# rules that were created by Sourcefire and other third parties and\n";
	$out .= "# distributed under the GNU General Public License (the \"GPL Rules\").  The\n";
	$out .= "# VRT Certified Rules contained in this file are the property of\n";
	$out .= "# Sourcefire, Inc. Copyright 2005 Sourcefire, Inc. All Rights Reserved.\n";
	$out .= "# The GPL Rules created by Sourcefire, Inc. are the property of\n";
	$out .= "# Sourcefire, Inc. Copyright 2002-2005 Sourcefire, Inc. All Rights\n";
	$out .= "# Reserved.  All other GPL Rules are owned and copyrighted by their\n";
	$out .= "# respective owners (please see www.snort.org/contributors for a list of\n";
	$out .= "# owners and their respective copyrights).  In order to determine what\n";
	$out .= "# rules are VRT Certified Rules or GPL Rules, please refer to the VRT\n";
	$out .= "# Certified Rules License Agreement.\n";
	$out .= "\n";
	$out .= "#\n";
	$out .= "# <><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><>\n";
	$out .= "#\n";
	$out .= "\n";
	$out .= "#\n";
	$out .= "# This rules file compiled and created by Aanval's snortRules Packaging System\n";
	$out .= "#\n";
	$out .= "# Generated by snortRules System on " . date("r") . "\n";
	$out .= "#";

	return $out;
}

function translatePolicyToName($policy) {
	
	$q = $_ENV['appDB']->query("SELECT * FROM idsSensorPolicy WHERE id = '$policy'");
	while ($row = mysql_fetch_assoc($q)) {

		$name = $row["name"];

	}

	if (!$name) $name = "null";
	
	return $name;

}

?>