<?php

#
# Aanval Intrusion Detection and Correlation Console
# Install / Upgrade
#
# Copyright (c) 2012 - Tactical FLEX, Inc. - All Rights Reserved
#

// Globals

$_ENV["appDB"] = "";

// System

$out = installUpgradeHeader();
$out .= installUpgradeBody();
$out .= installUpgradeFooter();

echo $out;

// Main Functions

function installSystem() {

	$op = sanitize("op");
	if (!$op) $op = 1;
	
	switch ($op) {
	
		case 1:
		
			$out .= EULADisplay();
		
			break;

		case 2:

			$out .= compatibilityTest();
		
			break;

		case 3:

			$out .= configurationForm();
		
			break;

		case 4:

			$out .= configurationConfirm();
		
			break;
			
		case 5:
		
			$out .= install();
			
			break;

		case 6:
		
			$out .= installComplete();

			break;
			
		default:
		
			$out .= EULADisplay();
		
			break;
	
	}
	
	return $out;

}

function EULADisplay() {

	$eula = @file_get_contents("installation/EULA.txt");

	$out .= "<p>EULA - End User License Agreement</p>";
	$out .= "<hr>";
	$out .= "<br>";

	$out .= "<span style=\"text-align: justify; font-size: 0.9em;\">" . nl2br($eula) . "</span>";

	$out .= "<br>";

	$out .= "<a href=\"?op=2\">I Agree. Continue.</a>";
	
	$out .= "<br>&nbsp;<br>";

	return $out;
}

function configurationForm() {

	$out .= "<p>Configuration</p>";
	$out .= "<hr>";
	$out .= "<br>";

	$out .= "<form method=\"POST\" action=\"?op=4\">";

	$out .= "<span style=\"font-size: 1.1em; line-height: 25px;\">Database Server</span>";
	$out .= "<br>";
	$out .= "<input type=\"text\" name=\"dbhost\" value=\"127.0.0.1\" style=\"width: 200px; margin-left: 20px;\">";
	$out .= "<br>";
	$out .= "<span style=\"font-size: 0.9em; line-height: 20px; color: #999999; margin-left: 20px;\">Address or hostname of database server (local databases; use 127.0.0.1 or localhost)</span>";

	$out .= "<br>";
	$out .= "<br>";

	$out .= "<span style=\"font-size: 1.1em; line-height: 25px;\">Database Name</span>";
	$out .= "<br>";
	$out .= "<input type=\"text\" name=\"dbname\" value=\"aanvaldb\" style=\"width: 200px; margin-left: 20px;\">";
	$out .= "<br>";
	$out .= "<span style=\"font-size: 0.9em; line-height: 20px; color: #999999; margin-left: 20px;\">Name of new console database to create or pre-existing if necessary</span>";

	$out .= "<br>";
	$out .= "<br>";

	$out .= "<span style=\"font-size: 1.1em; line-height: 25px;\">Database Username</span>";
	$out .= "<br>";
	$out .= "<input type=\"text\" name=\"dbusername\" style=\"width: 200px; margin-left: 20px;\">";
	$out .= "<br>";
	$out .= "<span style=\"font-size: 0.9em; line-height: 20px; color: #999999; margin-left: 20px;\">Name of database user with proper privileges (CREATE, ALTER, DROP, SELECT, INSERT, UPDATE, DELETE)</span>";

	$out .= "<br>";
	$out .= "<br>";

	$out .= "<span style=\"font-size: 1.1em; line-height: 25px;\">Database Password</span>";
	$out .= "<br>";
	$out .= "<input type=\"password\" name=\"dbpassword\" style=\"width: 200px; margin-left: 20px;\">";
	$out .= "<br>";
	$out .= "<span style=\"font-size: 0.9em; line-height: 20px; color: #999999; margin-left: 20px;\">Password of database user (empty is okay, if necessary)</span>";

	$out .= "<br>";
	$out .= "<br>";
		
	$out .= "<input type=\"submit\" value=\"Submit\" style=\"margin-left: 20px;\">";
	
	$out .= "</form>";

	return $out;
}

function configurationConfirm() {

	$pass = true;

	$out .= "<p>Configuration Confirmation</p>";
	$out .= "<hr>";

	$createTest = dbCreateTest();
	
	if ($createTest && is_bool($createTest)) {
	
		// Success

		writeConfigFile();

		$out .= "<p style=\"\">Success!</p>";

		$out .= "Configuration Confirmed - <a href=\"?op=5\">Continue</a>";
	
	} else {
	
		// Failure
		
		$out .= "<p style=\"color: #CC0000;\">Failure!</p>";
		
		$out .= $createTest;
		$out .= "<br>";
		$out .= "<br>";

		$out .= "Invalid Configuration - <a href=\"?op=3\">back to configuration</a>";
	
	}
	
	return $out;

}

function install() {

	$out .= "<p>Installation</p>";
	$out .= "<hr>";
	$out .= "<br>";

	// Load new configuration file

	include_once("conf/conf.php");
	
	// DB connect

	$_ENV["appDB"] = mysql_connect(DBHOST, DBUSER, DBPASS);
	mysql_select_db(DBNAME);

	// Perform installation
	
	$out .= "Creating all tables";
	$out .= "<br>";
	
	createAllTables();

	$out .= "Loading table data";
	$out .= "<br>";

	loadAllTableData();

	// DB close
	
	mysql_close($_ENV["appDB"]);
	
	$out .= "<br>";
	$out .= "Installation Complete - <a href=\"?op=6\">Continue</a>";
	
	return $out;

}

function installComplete() {

	$out .= "<p>Installation Complete!</p>";
	$out .= "<hr>";

	// Complete
	
	@unlink("installation/upgrade");
	@touch("installation/install.cert");

	$out .= "<p style=\"color: #990000\">IMPORTANT! > Start the Aanval BPU's</p>";

	$out .= "<p>From your Aanval installations /apps/ directory, run the following command: <span style=\"color: #009900;\">perl ./idsBackground.pl -start</span></p>";

	$out .= "<hr>";

	$out .= "<p>Default username: <span style=\"color: #009900;\">root</span></p>";
	
	$out .= "<p>Default password: <span style=\"color: #009900;\">specter</span></p>";	

	$out .= "<hr>";
	
	$out .= "<p>Thank you for choosing Aanval, we sincerely appreciate your interest and support!</p>";
	
	$out .= "<form method=\"POST\" action=\"?\"><input type=\"submit\" value=\"Login Now\"></form>";

	// Notification
	
	installEmail("INSTALL");
	
	return $out;
	
}

function upgrade() {

	$out .= "<p>Upgrade</p>";
	$out .= "<hr>";
	$out .= "<br>";

	// Load new configuration file

	include_once("conf/conf.php");
	
	// DB connect

	$_ENV["appDB"] = mysql_connect(DBHOST, DBUSER, DBPASS);
	mysql_select_db(DBNAME);

	// Perform upgrade
	
	$out .= "Creating new tables";
	$out .= "<br>";
	
	createAllTables();

	$out .= "Loading table data";
	$out .= "<br>";

	loadAllTableData();

	// Post release modifications

	# 02-01-12
	`rm -rf console/assets/jquery/development-bundle`;

	# 02-06-12
	alterTable("idsUserMessages", "ALTER TABLE idsUserMessages ADD data text");

	# 02-07-12
	updateTableData("idsOps", "UPDATE idsOps SET val = 'Tactical FLEX, Inc.' WHERE var = 'site_companyName'");
	updateTableData("idsOps", "UPDATE idsOps SET val = 'Snort and Syslog Intrusion Detection, Correlation and Threat Managment SIEM' WHERE var = 'site_consoleDescription'");

	// DB close
	
	mysql_close($_ENV["appDB"]);
	
	$out .= "<br>";
	$out .= "Upgrade Complete - <a href=\"?op=4\">Continue</a>";
		
	return $out;

}

function upgradeComplete() {

	$out .= "<p>Upgrade Complete</p>";
	$out .= "<hr>";
	$out .= "<br>";

	// Complete
	
	@unlink("installation/upgrade");

	$out .= "<form method=\"POST\" action=\"?\"><input type=\"submit\" value=\"Login\"></form>";

	// Notification
	
	installEmail("UPGRADE");

	return $out;
	
}

function createAllTables() {

	// Create tables
	
	$out .= createTable("idsUsers", "CREATE TABLE idsUsers (id int(11) NOT NULL auto_increment, username varchar(50) default NULL, fname varchar(20) default NULL, lname varchar(20) default NULL, organization varchar(40) default NULL, email varchar(50) default NULL, phone varchar(30) default NULL, secword varchar(50) default NULL, password varchar(100) default NULL, enabled int(3) default NULL, loginip varchar(20) default NULL, logintime varchar(50) default NULL, type int(10) default NULL, pgp text, country varchar(50) default NULL, state varchar(50) default NULL, city varchar(50) default NULL, sensors varchar(200) default NULL, timezone int(10) default NULL, activeSearchStore int(10) default NULL, intime timestamp NOT NULL default CURRENT_TIMESTAMP, PRIMARY KEY (id))");
	$out .= createTable("idsUserMessages", "CREATE TABLE idsUserMessages (id int(11) NOT NULL auto_increment, uid int(11) default NULL,priority int(11) default '3', message text, data text, enabled int(11) default '1', timestamp timestamp NOT NULL default CURRENT_TIMESTAMP, PRIMARY KEY  (id), KEY msgTimestamp (timestamp))");
	
	$out .= createTable("idsSensor", "CREATE TABLE idsSensor ( id int(10) NOT NULL auto_increment, sid varchar(20) default NULL,  name varchar(200) default NULL,  location varchar(200) default NULL,  description text,  os varchar(100) default NULL,  module smallint(3) default NULL,  timezone varchar(100) default NULL,  enabled int(10) default NULL,  lastEvent varchar(100) default NULL,  intime varchar(100) default NULL,  smtid varchar(20) default NULL,  emailOnStatusFailure varchar(250) default NULL,  emailOnCommFailure varchar(250) default NULL,  path varchar(100) default NULL,  tracker1 varchar(100) default NULL,  tracker2 longblob,  hb varchar(20) default NULL,  hbcount int(10) default '0',  status int(10) default NULL,  confFile varchar(100) default NULL,  confPolicy varchar(100) default NULL,  countCommFailure int(10) default '0',  countStatusFailure int(10) default '0',  lastCommFailure varchar(20) default NULL,  lastStatusCheck varchar(20) default NULL,  lastVersionCheck varchar(20) default NULL,  lastStatusFailure varchar(20) default NULL,  type int(10) default NULL,  PRIMARY KEY  (id))");
	$out .= createTable("idsSensorManage", "CREATE TABLE idsSensorManage (sid int(10) NOT NULL,  status int(10),  hb int(10), hbcount int(10) default '0', snortconf text)");
	$out .= createTable("idsSensorManageMessages", "CREATE TABLE idsSensorManageMessages (id int(10) NOT NULL auto_increment,  sid int(10), message varchar(200), enabled int(10), issued int(10), received int(10), PRIMARY KEY  (id))");
	$out .= createTable("idsSensorPolicy", "CREATE TABLE idsSensorPolicy (id int(10) not null auto_increment, name varchar(100), PRIMARY KEY  (id))");

	$out .= createTable("idsDevices", "CREATE TABLE idsDevices (id int(10) not null auto_increment, name varchar(100), description varchar(200), type int(10), PRIMARY KEY  (id))");
	$out .= createTable("idsDeviceTypes", "CREATE TABLE idsDeviceTypes (id int(10) not null auto_increment, name varchar(100), priority int(10), PRIMARY KEY  (id))");
	$out .= createTable("idsDeviceAddresses", "CREATE TABLE idsDeviceAddresses (id int(10) not null auto_increment, deviceID int(10), name varchar(100), ip bigint(11), PRIMARY KEY (id))");
	$out .= createTable("idsDeviceServices", "CREATE TABLE idsDeviceServices (id int(10) not null auto_increment, deviceID int(10), name varchar(100), port int(10), protocol int(10), PRIMARY KEY (id))");

	$out .= createTable("idsNetworks", "CREATE TABLE idsNetworks (id int(10) not null auto_increment, name varchar(100), description varchar(200), network varchar(100), PRIMARY KEY (id))");

	$out .= createTable("idsSyslogModule", "CREATE TABLE idsSyslogModule (id int(10) NOT NULL auto_increment, source varchar(250) default NULL, type varchar(250) default NULL, f_date varchar(250) default NULL, f_time varchar(250) default NULL, f_sip varchar(250) default NULL, f_dip varchar(250) default NULL, f_sport varchar(250) default NULL, f_dport varchar(250) default NULL, f_protocol varchar(250) default NULL, f_level varchar(250) default NULL, f_ename varchar(250) default NULL, f_etypename varchar(250) default NULL, f_payload varchar(250) default NULL, f_misc1 varchar(250) default NULL, f_misc2 varchar(250) default NULL, f_misc3 varchar(250) default NULL, f_misc4 varchar(250) default NULL, f_misc5 varchar(250) default NULL, PRIMARY KEY  (id))");
	$out .= createTable("idsImportFilters", "CREATE TABLE idsImportFilters (id int(10) not null auto_increment, enabled int(5), name varchar(100), description varchar(200), filter text, sample text, PRIMARY KEY (id))");

	$out .= createTable("idsCollection", "CREATE TABLE idsCollection (id int(10) NOT NULL auto_increment,  userid int(10) default NULL,  name varchar(100) default NULL,  description varchar(200) default NULL, enabled int(10) default NULL,  access int(5), timestamp varchar(100) default NULL,  PRIMARY KEY  (id))");
	$out .= createTable("idsCollectionStore", "CREATE TABLE idsCollectionStore (cid int(10) NOT NULL, store int(10) NOT NULL, event int(10) NOT NULL, KEY cid_store (cid,store))");

	$out .= createTable("idsScannerSchedule", "CREATE TABLE idsScannerSchedule (id int(10) not null auto_increment, name varchar(100), runonce int(5), type int(5), host longblob, status int(5), options longblob, mon int(2), tue int(2), wed int(2), thu int(2), fri int(2), sat int(2), sun int(2), runtime varchar(100), runlast int(3), enabled int(3), intime int(10), userid int(10), email varchar(200), viewed varchar(100), PRIMARY KEY  (id))");
	$out .= createTable("idsScannerResults", "CREATE TABLE idsScannerResults (id int(10) not null auto_increment, userid int(10), scanid int(10), data longblob, intime varchar(100), PRIMARY KEY (id))");

	$out .= createTable("idsSignatures", "CREATE TABLE idsSignatures (id int(10) not null auto_increment, sid int(10), gid int(10), rev int(10), class varchar(100), msg varchar(200), file varchar(100), source varchar(100), data text, intime varchar(100),  PRIMARY KEY  (id), KEY rev_index (rev), KEY sid_gid_index (sid,gid))");
	$out .= createTable("idsSignaturePolicyIndex", "CREATE TABLE idsSignaturePolicyIndex (id int(10) not null auto_increment, pid int(10), sid int(10), PRIMARY KEY  (id))");
	$out .= createTable("idsSignatureSources", "CREATE TABLE idsSignatureSources (id int(10) not null auto_increment, name varchar(100), location varchar(200), lastDownload varchar(20) default '0', lastFilesize varchar(20) default '0', enabled int(10) default '0', PRIMARY KEY  (id))");

	$out .= createTable("idsOps", "CREATE TABLE idsOps ( var varchar(100) NOT NULL default '', val text, type int(5) default NULL, cat int(5) default NULL, mod_date timestamp NOT NULL default CURRENT_TIMESTAMP, intime timestamp NOT NULL default '0000-00-00 00:00:00', PRIMARY KEY (var))");
	$out .= createTable("idsModules", "CREATE TABLE idsModules (id int(10) NOT NULL auto_increment,  module varchar(20) default NULL,  enabled int(10) default NULL,  auth_db_user varchar(50) default NULL,  auth_db varchar(50) default NULL,  auth_db_pass varchar(50) default NULL,  auth_db_host varchar(50) default NULL,  PRIMARY KEY  (id))");
	$out .= createTable("idsQueries", "CREATE TABLE idsQueries (id int(10) not null auto_increment, uid int(10), query text, intime varchar(100), PRIMARY KEY (id))");
	$out .= createTable("idsEmail", "CREATE TABLE idsEmail (id int(10) not null auto_increment, uid int(10), type int(2), fromName varchar(200), fromEmail varchar(200), toName varchar(200), toEmail varchar(200), subject varchar(200), message text, sent int(10), senttime varchar(100), deliver varchar(100), intime varchar(100), PRIMARY KEY  (id))");
	$out .= createTable("idsHostnames", "CREATE TABLE idsHostnames (ip int(10) unsigned NOT NULL default '0',  hostname varchar(200) default NULL, timestamp varchar(100) default NULL,  PRIMARY KEY  (ip))");
	$out .= createTable("idsNotes", "CREATE TABLE idsNotes (id int(10) NOT NULL auto_increment,  storeid int(10) default NULL, trackid int(10) default NULL, collectionid int(10) default NULL,  note text,  timestamp varchar(100) default NULL,  enabled int(10) default NULL,  userid int(10) default NULL,  read_access int(10) default NULL,  write_access int(10) default NULL,  PRIMARY KEY  (id))");

	$out .= createTable("idsActionMaster", "CREATE TABLE idsActionMaster (id int(10) NOT NULL auto_increment,  userid smallint(5) default NULL, name varchar(200) default NULL, enabled int(10) default NULL,  intime varchar(100) default NULL,  matchtype int(3) default NULL, threshold int(10) default NULL,  thresholdcount int(10) default '0',  count int(10) default '0',  description varchar(250) default NULL,  onetime tinyint(3) default NULL, thresholdtime int(10) default NULL, deleted int(3), thresholdeventtime int(10) unsigned default NULL, senderName varchar(200), senderEmail varchar(200), senderSubject varchar(200), senderBody blob, weight int(10), PRIMARY KEY (id))");
	$out .= createTable("idsActionStore", "CREATE TABLE idsActionStore (id int(10) NOT NULL auto_increment, masterid int(10), class int(3), type int(3), data varchar(220), intime varchar(100), primary key (id))"); 

	$out .= createTable("idsReportSchedule", "CREATE TABLE idsReportSchedule (id int(10) not null auto_increment, name varchar(100), type int(5), status int(5), query text, store varchar(100), mon int(2), tue int(2), wed int(2), thu int(2), fri int(2), sat int(2), sun int(2), runtime varchar(100), runlast int(3), enabled int(3), intime int(10), userid int(10), email varchar(200), data longblob, viewed varchar(100),PRIMARY KEY  (id))");

	$out .= createTable("idsDataStore", "CREATE TABLE idsDataStore (id int(11) unsigned NOT NULL auto_increment, name varchar(200) default NULL, store smallint(11) unsigned default NULL, `index` int(11) unsigned default NULL, PRIMARY KEY  (id))");

	$out .= createTable("idsDataStore_TEMPLATE_Master", "CREATE TABLE idsDataStore_TEMPLATE_Master (id int(11) unsigned NOT NULL auto_increment, moduleID tinyint(11) unsigned default '0',  sensorID smallint(11) unsigned default '0',  created timestamp NOT NULL default CURRENT_TIMESTAMP, enabled tinyint(11) unsigned default '1', actionated tinyint(11) unsigned default '0', PRIMARY KEY  (id), KEY masterMODULEID (moduleID), KEY masterCREATED (created), KEY masterSENSORID (sensorID))");
	$out .= createTable("idsDataStore_TEMPLATE_Events", "CREATE TABLE idsDataStore_TEMPLATE_Events (id int(11) unsigned NOT NULL, eventID int(11) unsigned default NULL, signature mediumint(11) unsigned default NULL, signatureName varchar(255) default NULL, class mediumint(11) unsigned default NULL, className varchar(255) default NULL, gid mediumint(11) unsigned default NULL, sensor smallint(11) unsigned default NULL, sip bigint(11) unsigned default NULL, sip_ipv6 bigint(11) unsigned default NULL, dip bigint(11) unsigned default NULL, dip_ipv6 bigint(11) unsigned default NULL, sport smallint(11) unsigned default NULL, dport smallint(11) unsigned default NULL, priority tinyint(11) unsigned default NULL, protocol tinyint(11) unsigned default NULL, payload text, hdr_seq int(11) unsigned default NULL, hdr_ack int(11) unsigned default NULL, hdr_off tinyint(11) unsigned default NULL, hdr_res tinyint(11) unsigned default NULL, hdr_flags tinyint(11) unsigned default NULL, hdr_win smallint(11) unsigned default NULL, hdr_csum smallint(11) unsigned default NULL, hdr_urp smallint(11) unsigned default NULL, hdr_len smallint(11) unsigned default NULL, hdr_id smallint(11) unsigned default NULL, hdr_code tinyint(11) unsigned default NULL, hdr_type tinyint(11) unsigned default NULL, ip_ver tinyint(11) unsigned default NULL, ip_hlen tinyint(11) unsigned default NULL, ip_tos tinyint(11) unsigned default NULL, ip_len smallint(11) unsigned default NULL, ip_id smallint(11) unsigned default NULL, ip_off smallint(11) unsigned default NULL, ip_flags tinyint(11) unsigned default NULL, ip_ttl tinyint(11) unsigned default NULL, ip_csum smallint(11) unsigned default NULL, opt_proto tinyint(11) unsigned default NULL, opt_code tinyint(11) unsigned default NULL, opt_len smallint(11) default NULL, opt_data text, customGrouping text, timestamp int(11) default NULL, PRIMARY KEY  (id), KEY event_id (eventID), KEY eventSIP (sip), KEY eventDIP (dip), KEY eventSIGNAME (signatureName), KEY eventCLASSNAME (className), KEY eventDPORT (dport), KEY eventSPORT (sport), KEY eventSIG (signature), KEY eventCLASS (class), KEY eventTIMESTAMP (timestamp))");
	$out .= createTable("idsDataStore_TEMPLATE_Text", "CREATE TABLE idsDataStore_TEMPLATE_Text (id int(10) NOT NULL auto_increment, text varchar(64) NOT NULL default '', PRIMARY KEY  (id), UNIQUE KEY keyword (text))");
	$out .= createTable("idsDataStore_TEMPLATE_Text_Index", "CREATE TABLE idsDataStore_TEMPLATE_Text_Index (id int(11) unsigned default NULL, loc int(11) unsigned default NULL, rel smallint(11) unsigned default '0', KEY indexID (id),	KEY indexLOC (loc))");
 	$out .= createTable("idsDataStore_TEMPLATE_Timescale", "CREATE TABLE idsDataStore_TEMPLATE_Timescale (timestamp int(11) unsigned NOT NULL default '0', sensor int(5) unsigned NOT NULL default '0', total int(11) unsigned default '0', PRIMARY KEY  (timestamp,sensor))");
 	$out .= createTable("idsDataStore_TEMPLATE_Review_Index", "CREATE TABLE idsDataStore_TEMPLATE_Review_Index (id int(11) NOT NULL AUTO_INCREMENT, uid int(11) unsigned DEFAULT NULL, eventID int(11) unsigned DEFAULT NULL, timestamp int(11) unsigned DEFAULT NULL, PRIMARY KEY (id), KEY uid_eventid (uid, eventID))");
 	$out .= createTable("idsDataStore_TEMPLATE_Tag_Index", "CREATE TABLE idsDataStore_TEMPLATE_Tag_Index (tagID int(11) unsigned DEFAULT NULL, eventID int(11) unsigned DEFAULT NULL)");

	$out .= createTable("idsDataStore_1000_Master", "CREATE TABLE idsDataStore_1000_Master (id int(11) unsigned NOT NULL auto_increment, moduleID tinyint(11) unsigned default '0',  sensorID smallint(11) unsigned default '0',  created timestamp NOT NULL default CURRENT_TIMESTAMP, enabled tinyint(11) unsigned default '1', actionated tinyint(11) unsigned default '0', PRIMARY KEY  (id), KEY masterMODULEID (moduleID), KEY masterCREATED (created), KEY masterSENSORID (sensorID))");
	$out .= createTable("idsDataStore_1000_Events", "CREATE TABLE idsDataStore_1000_Events (id int(11) unsigned NOT NULL, eventID int(11) unsigned default NULL, signature mediumint(11) unsigned default NULL, signatureName varchar(255) default NULL, class mediumint(11) unsigned default NULL, className varchar(255) default NULL, gid mediumint(11) unsigned default NULL, sensor smallint(11) unsigned default NULL, sip bigint(11) unsigned default NULL, sip_ipv6 bigint(11) unsigned default NULL, dip bigint(11) unsigned default NULL, dip_ipv6 bigint(11) unsigned default NULL, sport smallint(11) unsigned default NULL, dport smallint(11) unsigned default NULL, priority tinyint(11) unsigned default NULL, protocol tinyint(11) unsigned default NULL, payload text, hdr_seq int(11) unsigned default NULL, hdr_ack int(11) unsigned default NULL, hdr_off tinyint(11) unsigned default NULL, hdr_res tinyint(11) unsigned default NULL, hdr_flags tinyint(11) unsigned default NULL, hdr_win smallint(11) unsigned default NULL, hdr_csum smallint(11) unsigned default NULL, hdr_urp smallint(11) unsigned default NULL, hdr_len smallint(11) unsigned default NULL, hdr_id smallint(11) unsigned default NULL, hdr_code tinyint(11) unsigned default NULL, hdr_type tinyint(11) unsigned default NULL, ip_ver tinyint(11) unsigned default NULL, ip_hlen tinyint(11) unsigned default NULL, ip_tos tinyint(11) unsigned default NULL, ip_len smallint(11) unsigned default NULL, ip_id smallint(11) unsigned default NULL, ip_off smallint(11) unsigned default NULL, ip_flags tinyint(11) unsigned default NULL, ip_ttl tinyint(11) unsigned default NULL, ip_csum smallint(11) unsigned default NULL, opt_proto tinyint(11) unsigned default NULL, opt_code tinyint(11) unsigned default NULL, opt_len smallint(11) default NULL, opt_data text, customGrouping text, timestamp int(11) default NULL, PRIMARY KEY  (id), KEY event_id (eventID), KEY eventSIP (sip), KEY eventDIP (dip), KEY eventSIGNAME (signatureName), KEY eventCLASSNAME (className), KEY eventDPORT (dport), KEY eventSPORT (sport), KEY eventSIG (signature), KEY eventCLASS (class), KEY eventTIMESTAMP (timestamp))");
	$out .= createTable("idsDataStore_1000_Text", "CREATE TABLE idsDataStore_1000_Text (id int(10) NOT NULL auto_increment, text varchar(64) NOT NULL default '', PRIMARY KEY  (id), UNIQUE KEY keyword (text))");
	$out .= createTable("idsDataStore_1000_Text_Index", "CREATE TABLE idsDataStore_1000_Text_Index (id int(11) unsigned default NULL, loc int(11) unsigned default NULL, rel smallint(11) unsigned default '0', KEY indexID (id),	KEY indexLOC (loc))");
 	$out .= createTable("idsDataStore_1000_Timescale", "CREATE TABLE idsDataStore_1000_Timescale (timestamp int(11) unsigned NOT NULL default '0', sensor int(5) unsigned NOT NULL default '0', total int(11) unsigned default '0', PRIMARY KEY  (timestamp,sensor))");
 	$out .= createTable("idsDataStore_1000_Review_Index", "CREATE TABLE idsDataStore_1000_Review_Index (id int(11) NOT NULL AUTO_INCREMENT, uid int(11) unsigned DEFAULT NULL, eventID int(11) unsigned DEFAULT NULL, timestamp int(11) unsigned DEFAULT NULL, PRIMARY KEY (id), KEY uid_eventid (uid, eventID))");
 	$out .= createTable("idsDataStore_1000_Tag_Index", "CREATE TABLE idsDataStore_1000_Tag_Index (tagID int(11) unsigned DEFAULT NULL, eventID int(11) unsigned DEFAULT NULL)");

	$out .= createTable("idsLicense", "CREATE TABLE idsLicense (id int(10) not null auto_increment, license varchar(200), licensekey int(10), active int(10), intime varchar(100), PRIMARY KEY  (id))");
	
	$out .= createTable("idsGeoData", "CREATE TABLE idsGeoData (id int(10) unsigned NOT NULL AUTO_INCREMENT, locationID int(10) unsigned NOT NULL, ipStart int(10) unsigned NOT NULL, ipEnd int(10) unsigned NOT NULL, PRIMARY KEY (id), KEY startEnd (ipStart,ipEnd))");
	$out .= createTable("idsGeoLocation", "CREATE TABLE idsGeoLocation (locationID int(10) unsigned NOT NULL, country varchar(10) DEFAULT NULL, region varchar(10) DEFAULT NULL, city varchar(100) DEFAULT NULL, postalCode varchar(100) DEFAULT NULL, latitude varchar(100) DEFAULT NULL, longitude varchar(100) DEFAULT NULL, metroCode varchar(100) DEFAULT NULL, areaCode varchar(100) DEFAULT NULL, KEY idx_location (locationID))");
	$out .= createTable("idsGeoCache", "CREATE TABLE idsGeoCache (ip int(11) unsigned NOT NULL DEFAULT '0', locationID int(11) DEFAULT NULL, timestamp varchar(100) DEFAULT NULL, PRIMARY KEY (ip))");

	$out .= createTable("idsTimezones", "CREATE TABLE idsTimezones (id int(10) NOT NULL auto_increment,  name varchar(100) default NULL,  zone int(10) default NULL,  PRIMARY KEY (id))");

	$out .= createTable("idsMessageQueue", "CREATE TABLE `idsMessageQueue` (
		`id` int(11) unsigned NOT NULL AUTO_INCREMENT,
		`uid` int(11) unsigned DEFAULT NULL,
		`type` int(11) unsigned DEFAULT NULL,
		`data` mediumtext,
		`options` mediumtext,
		`status` int(11) unsigned DEFAULT NULL,
		`priority` int(11) unsigned DEFAULT '3',
		`enabled` int(11) unsigned DEFAULT NULL,
		`created` int(11) unsigned DEFAULT NULL,
		`finished` int(11) unsigned DEFAULT NULL,
		PRIMARY KEY (`id`)
	)");
	
	$out .= createTable("idsTags", "CREATE TABLE `idsTags` (
		`id` int(11) unsigned NOT NULL AUTO_INCREMENT,
		`userID` int(11) unsigned DEFAULT NULL,
		`name` varchar(100) DEFAULT NULL,
		`permissions` int(11) unsigned DEFAULT NULL,
		PRIMARY KEY (`id`)
	)");

	return $out;

}

function loadAllTableData() {

    # idsDataStore
    insertTableData("idsDataStore", "INSERT INTO idsDataStore VALUES (1, 'Primary Datastore', '1000', '')");

    # idsModules
    insertTableData("idsModules", "INSERT INTO idsModules VALUES (1,'snort',0,'default_username','db_name','password','localhost')");
    insertTableData("idsModules", "INSERT INTO idsModules VALUES (2,'syslog',0,'default_username','db_name','password','localhost')");

    # idsUsers
    insertTableData("idsUsers", "INSERT INTO idsUsers 
    	(
    	id, 
    	username, 
    	fname, 
    	lname, 
    	organization, 
    	email, 
    	phone, 
    	secword, 
    	password, 
    	enabled, 
    	type, 
    	country, 
    	state, 
    	city, 
    	timezone, 
    	activeSearchStore
    	)
    	
    	VALUES
    	
    	(
    	'1',
    	'root',
    	'Admin',
    	'Account',
    	'Aanval by Tactical FLEX',
    	'default@email.com',
    	'800.921.2584',
    	'Secret Passphrase',
    	'b7c087f49d2394c3e93835605ff147b8',
    	'1',
    	'10',
    	'US',
    	'IL',
    	'Chicago',
    	'62',
    	'1000'
    	)");    
    
	// OPS Load Here
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('site_timezone','62',1,1,20040616202338,20040616195044)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('site_timeDateFormat','m-d-Y H:i:s',1,1,20040616202338,20040616195044)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('site_dir_syslog','syslog/',1,1,20040618075729,20040618075729)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('hostnameReprocess','0',1,1,20040629012801,20040520011130)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('siteLicenseMonitor','0',1,1,20040618081055,20040618081055)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('site_dataStoreRotationDays','30',1,1,20040629012801,20040520011130)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('site_dataStoreRotationEvents','1000000',1,1,20040629012801,20040520011130)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('site_dataStoreRotationType','2',1,1,20040629012801,20040520011130)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('site_sigProcessorEnabled','0',1,1,20040629012801,20040520011130)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('site_sigProcessorFrequency','86400',1,1,20040629012801,20040520011130)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('site_sigProcessorSiteA','signature01.aanval.com',1,1,20040629012801,20040520011130)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('site_sigProcessorSiteB','signature02.aanval.com',1,1,20040629012801,20040520011130)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('site_proxyEnabled','0',1,1,20040629012801,20040520011130)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('site_proxyHost','127.0.0.1',1,1,20040629012801,20040520011130)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('site_proxyPort','8080',1,1,20040629012801,20040520011130)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('site_proxyUsername','',1,1,20040629012801,20040520011130)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('site_proxyPassword','',1,1,20040629012801,20040520011130)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('site_versionChecking','1',1,1,20040629012801,20040520011130)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('site_registration','',1,1,20040629012801,20040520011130)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('site_sigProcessorNow','0',1,1,20040629012801,20040520011130)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('site_sigProcessorSite','A',1,1,20040629012801,20040520011130)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('site_hostnameLookups','1',1,1,20040629012801,20040520011130)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('site_versionUpdateNow','0',1,1,20040629012801,20040520011130)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('loadOpsContinue','0',1,1,20040629012801,20040520011130)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('loadProcessor','1',1,1,20040629012801,20040520011130)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('indexReprocess','0',1,1,20040629012801,20040520011130)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('site_brandLicense','',1,1,20040629012801,20040520011130)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('site_snortTruncate','0',1,1,20040618081150,20040618081150)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('site_processorEventRun','500',1,1,20040629012801,20040520011130)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('site_processorIndexRun','500',1,1,20040629012801,20040520011130)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('site_dailyStatsReportEmail','',1,1,20040629012801,20040520011130)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('site_dailyStatsReportTime','08:00',1,1,20040629012801,20040520011130)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('site_dailyStatsReportLast','',1,1,20040629012801,20040520011130)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('site_dailyStatsReportFrom','email@aanvalconsole.com',1,1,20040629012801,20040520011130)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('site_dailyStatsReportSubject','Daily Statistics Report',1,1,20040629012801,20040520011130)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('site_smtpEnabled','',1,1,20040629012801,20040520011130)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('site_smtpServer','smtp.server.com',1,1,20040629012801,20040520011130)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('site_smtpUsername','',1,1,20040629012801,20040520011130)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('site_smtpPassword','',1,1,20040629012801,20040520011130)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('site_sendmailLocal','/usr/sbin/sendmail -t',1,1,20040629012801,20040520011130)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('site_sendmailEnabled','',1,1,20040629012801,20040520011130)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('site_sigFileCustom','',1,1,20040629012801,20040520011130)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('site_emailFloodProtection','1',1,1,20040629012801,20040520011130)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('site_emailFloodLimit','10',1,1,20040629012801,20040520011130)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('site_wget_path','/usr/bin/wget',1,1,20040629012801,20040520011130)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('site_permChecking','1',1,1,20040629012801,20040520011130)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('site_snortAutoTrim','0',1,1,20040629012801,20040520011130)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('site_snortAutoTrimMax','500000',1,1,20040629012801,20040520011130)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('site_snortStats','0',1,1,20040629012801,20040520011130)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('site_corEngineLevelA','1',1,1,20040629012801,20040520011130)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('site_consoleName','Aanval',1,1,20040629012801,20040520011130)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('site_consoleDescription','Snort and Syslog Intrusion Detection and Correlation Console',1,1,20040629012801,20040520011130)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('site_companyName','Tactical FLEX',1,1,20040629012801,20040520011130)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('site_loginMainImage','images/mat_d3.jpg',1,1,20040629012801,20040520011130)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('site_mainURL','http://www.aanval.com/',1,1,20040629012801,20040520011130)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('site_reportLogoA','images/mat_d3.jpg',1,1,20040629012801,20040520011130)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('site_loginLegalText','Unauthorized Access Prohibited',1,1,20040629012801,20040520011130)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('site_riskRankBottom','1',1,1,20040629012801,20040520011130)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('site_riskRankTop','5',1,1,20040629012801,20040520011130)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('site_bpuIndexStart','0',1,1,20040629012801,20040520011130)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('site_bpuIndexEnd','23',1,1,20040629012801,20040520011130)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('site_activeDataStore','1000',1,1,20040629012801,20040520011130)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('site_activeIndexStore','1000',1,1,20040629012801,20040520011130)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('site_dataSwitch','0',1,1,20040629012801,20040520011130)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('site_actionRunLimit','500',1,1,20040629012801,20040520011130)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('site_signatureUpdateEmail','',1,1,20040629012801,20040520011130)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('site_signatureUpdateEmailSubject','Signature Processing Report',1,1,20040629012801,20040520011130)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('site_custom_snortGroup','0',1,1,20040629012801,20040520011130)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('site_hostnameRunLimit','100',1,1,20040629012801,20040520011130)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('site_corEngineLimitA','300',1,1,20040629012801,20040520011130)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('site_bpuSleepA','5',1,1,20040629012801,20040520011130)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('site_bpuSleepB','5',1,1,20040629012801,20040520011130)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('site_bpuSleepC','5',1,1,20040629012801,20040520011130)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('site_bpuSleepD','5',1,1,20040629012801,20040520011130)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('site_bpuSleepE','5',1,1,20040629012801,20040520011130)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('site_bpuIterationA','5',1,1,20040629012801,20040520011130)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('site_bpuIterationB','5',1,1,20040629012801,20040520011130)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('site_bpuIterationC','5',1,1,20040629012801,20040520011130)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('site_bpuIterationD','25',1,1,20040629012801,20040520011130)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('site_bpuIterationE','25',1,1,20040629012801,20040520011130)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('site_permDelete','1',1,1,20040629012801,20040520011130)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('indexDeletion','0',1,1,20040629012801,20040520011130)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('storeDeletion','0',1,1,20040629012801,20040520011130)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('site_nmapBinaryLocation','/usr/bin/nmap',1,1,20040629012801,20040520011130)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('site_sigLastDownload','',1,1,20040629012801,20040520011130)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('site_iPhoneAccess','1',1,1,20040629012801,20040520011130)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('site_reportDisplayRows','25',1,1,20040629012801,20040520011130)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('site_sigOinkCode','',1,1,20040629012801,20040520011130)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('site_googleMapsAPIKey','',1,1,20040629012801,20040520011130)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('site_geoLocationDatabaseURL','http://download.aanval.com/geo/geo-latest.zip',1,1,20040629012801,20040520011130)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('site_downloadGeoDatabaseNow','0',1,1,20040629012801,20040520011130)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('site_signatureRevisionReplace','1',1,1,20040629012801,20040520011130)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('site_policyRevisionUpdate','1',1,1,20040629012801,20040520011130)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('site_v6','0',1,1,20040629012801,20040520011130)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('site_forceUpgradeNextVersion','0',1,1,20040629012801,20040520011130)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('site_geoLocationNoPlotList','10.0.0.0/8,192.168.0.0/16,172.16.0.0/12',1,1,20040629012801,20040520011130)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('site_externalAddressLookup','http://whois.arin.net/rest/ip/{address}',1,1,20040629012801,20040520011130)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('site_datastoreSearchWindow','2',1,1,20040629012801,20040520011130)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('site_logConsole','1',1,1,20040629012801,20040520011130)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('site_logNotice','0',1,1,20040629012801,20040520011130)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('site_logWarning','1',1,1,20040629012801,20040520011130)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('site_logError','1',1,1,20040629012801,20040520011130)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('site_logDebug','0',1,1,20040629012801,20040520011130)");
		
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('site_refreshInterval', '300',1,1,20040629012801,20040520011130)");
	insertTableData("idsOps", "INSERT INTO idsOps VALUES ('site_refreshContent', 'prv_main,prv_bpuStatus,prv_myAccount,prv_myOptions,prv_myReports,prv_liveMonitor,prv_frequentEvents,prv_frequentOffenders,prv_frequentTargets,prv_frequentPorts,prv_frequentSensors,prv_frequentTags',1,1,20040629012801,20040520011130)");
	
	# idsTimezones
    insertTableData("idsTimezones", "INSERT INTO idsTimezones VALUES (1,'London, England',0)");
    insertTableData("idsTimezones", "INSERT INTO idsTimezones VALUES (2,'Dublin, Ireland',0)");
    insertTableData("idsTimezones", "INSERT INTO idsTimezones VALUES (3,'Edinburgh, Scotland',0)");
    insertTableData("idsTimezones", "INSERT INTO idsTimezones VALUES (4,'Lisbon, Portugal',0)");
    insertTableData("idsTimezones", "INSERT INTO idsTimezones VALUES (5,'Reykjavik, Iceland',0)");
    insertTableData("idsTimezones", "INSERT INTO idsTimezones VALUES (6,'Casablanca, Morocco',0)");
    insertTableData("idsTimezones", "INSERT INTO idsTimezones VALUES (7,'Paris, France',1)");
    insertTableData("idsTimezones", "INSERT INTO idsTimezones VALUES (8,'Berlin, Germany',1)");
    insertTableData("idsTimezones", "INSERT INTO idsTimezones VALUES (9,'Amsterdam, Holland',1)");
    insertTableData("idsTimezones", "INSERT INTO idsTimezones VALUES (10,'Netherlands',1)");
    insertTableData("idsTimezones", "INSERT INTO idsTimezones VALUES (11,'Brussels, Belgium',1)");
    insertTableData("idsTimezones", "INSERT INTO idsTimezones VALUES (12,'Vienna, Austria',1)");
    insertTableData("idsTimezones", "INSERT INTO idsTimezones VALUES (13,'Madrid, Spain',1)");
    insertTableData("idsTimezones", "INSERT INTO idsTimezones VALUES (14,'Rome, Italy',1)");
    insertTableData("idsTimezones", "INSERT INTO idsTimezones VALUES (15,'Bern, Switzerland',1)");
    insertTableData("idsTimezones", "INSERT INTO idsTimezones VALUES (16,'Stockholm, Sweden',1)");
    insertTableData("idsTimezones", "INSERT INTO idsTimezones VALUES (17,'Oslo, Norway',1)");
    insertTableData("idsTimezones", "INSERT INTO idsTimezones VALUES (18,'Athens, Greece',2)");
    insertTableData("idsTimezones", "INSERT INTO idsTimezones VALUES (19,'Helsinki, Finland',2)");
    insertTableData("idsTimezones", "INSERT INTO idsTimezones VALUES (20,'Istanbul, Turkey',2)");
    insertTableData("idsTimezones", "INSERT INTO idsTimezones VALUES (21,'Jerusalem, Israel',2)");
    insertTableData("idsTimezones", "INSERT INTO idsTimezones VALUES (22,'Harare, Zimbabwe',2)");
    insertTableData("idsTimezones", "INSERT INTO idsTimezones VALUES (23,'Kuwait',3)");
    insertTableData("idsTimezones", "INSERT INTO idsTimezones VALUES (24,'Nairobi, Kenya',3)");
    insertTableData("idsTimezones", "INSERT INTO idsTimezones VALUES (25,'Riyadh, Saudi Arabia',3)");
    insertTableData("idsTimezones", "INSERT INTO idsTimezones VALUES (26,'Moscow, Russia',3)");
    insertTableData("idsTimezones", "INSERT INTO idsTimezones VALUES (27,'Tehran, Iran',3)");
    insertTableData("idsTimezones", "INSERT INTO idsTimezones VALUES (28,'Adu Dhabi, UAE',4)");
    insertTableData("idsTimezones", "INSERT INTO idsTimezones VALUES (29,'Muscat',4)");
    insertTableData("idsTimezones", "INSERT INTO idsTimezones VALUES (30,'Tblisi',4)");
    insertTableData("idsTimezones", "INSERT INTO idsTimezones VALUES (31,'Volgograd',4)");
    insertTableData("idsTimezones", "INSERT INTO idsTimezones VALUES (32,'Kabul',4)");
    insertTableData("idsTimezones", "INSERT INTO idsTimezones VALUES (33,'Afghanistan',4)");
    insertTableData("idsTimezones", "INSERT INTO idsTimezones VALUES (34,'India',5)");
    insertTableData("idsTimezones", "INSERT INTO idsTimezones VALUES (35,'Cocos Islands',6)");
    insertTableData("idsTimezones", "INSERT INTO idsTimezones VALUES (36,'China',8)");
    insertTableData("idsTimezones", "INSERT INTO idsTimezones VALUES (37,'Japan',9)");
    insertTableData("idsTimezones", "INSERT INTO idsTimezones VALUES (38,'Darwin, Australia',9)");
    insertTableData("idsTimezones", "INSERT INTO idsTimezones VALUES (39,'Adelaide, Australia',9)");
    insertTableData("idsTimezones", "INSERT INTO idsTimezones VALUES (40,'Guam',10)");
    insertTableData("idsTimezones", "INSERT INTO idsTimezones VALUES (41,'Lord Howe Island',10)");
    insertTableData("idsTimezones", "INSERT INTO idsTimezones VALUES (42,'Norfolk Island',11)");
    insertTableData("idsTimezones", "INSERT INTO idsTimezones VALUES (43,'Wellington, New Zealand',12)");
    insertTableData("idsTimezones", "INSERT INTO idsTimezones VALUES (44,'Fiji',12)");
    insertTableData("idsTimezones", "INSERT INTO idsTimezones VALUES (45,'Marshall, Islands',12)");
    insertTableData("idsTimezones", "INSERT INTO idsTimezones VALUES (46,'Rawaki Islands',13)");
    insertTableData("idsTimezones", "INSERT INTO idsTimezones VALUES (47,'Line Islands',14)");
    insertTableData("idsTimezones", "INSERT INTO idsTimezones VALUES (48,'Azores, Cape Verde Islands',-1)");
    insertTableData("idsTimezones", "INSERT INTO idsTimezones VALUES (49,'Brasilia, Brazil',-3)");
    insertTableData("idsTimezones", "INSERT INTO idsTimezones VALUES (50,'Buenos Aires, Argentina',-3)");
    insertTableData("idsTimezones", "INSERT INTO idsTimezones VALUES (51,'Georgetown, Guyana',-3)");
    insertTableData("idsTimezones", "INSERT INTO idsTimezones VALUES (52,'Newfoundland',-3)");
    insertTableData("idsTimezones", "INSERT INTO idsTimezones VALUES (53,'Caracas',-4)");
    insertTableData("idsTimezones", "INSERT INTO idsTimezones VALUES (54,'La Paz',-4)");
    insertTableData("idsTimezones", "INSERT INTO idsTimezones VALUES (55,'Bogota',-5)");	
    insertTableData("idsTimezones", "INSERT INTO idsTimezones VALUES (56,'Lima, Peru',-5)");
    insertTableData("idsTimezones", "INSERT INTO idsTimezones VALUES (57,'New York, USA',-5)");
    insertTableData("idsTimezones", "INSERT INTO idsTimezones VALUES (58,'Miami, USA',-5)");
    insertTableData("idsTimezones", "INSERT INTO idsTimezones VALUES (59,'Boston, USA',-5)");
    insertTableData("idsTimezones", "INSERT INTO idsTimezones VALUES (60,'Mexico City, Mexico',-6)");
    insertTableData("idsTimezones", "INSERT INTO idsTimezones VALUES (61,'Saskatchewan, Canada',-6)");
    insertTableData("idsTimezones", "INSERT INTO idsTimezones VALUES (62,'Chicago, USA',-6)");
    insertTableData("idsTimezones", "INSERT INTO idsTimezones VALUES (63,'Dallas, USA',-6)");
    insertTableData("idsTimezones", "INSERT INTO idsTimezones VALUES (64,'Kansas City, USA',-6)");
    insertTableData("idsTimezones", "INSERT INTO idsTimezones VALUES (65,'Boise, USA',-7)");
    insertTableData("idsTimezones", "INSERT INTO idsTimezones VALUES (66,'Salt Lake City, USA',-7)");
    insertTableData("idsTimezones", "INSERT INTO idsTimezones VALUES (67,'Albuquerque, USA',-7)");
    insertTableData("idsTimezones", "INSERT INTO idsTimezones VALUES (68,'Seattle, USA',-8)");
    insertTableData("idsTimezones", "INSERT INTO idsTimezones VALUES (69,'Portland, USA',-8)");
    insertTableData("idsTimezones", "INSERT INTO idsTimezones VALUES (70,'Los Angeles, USA',-8)");
    insertTableData("idsTimezones", "INSERT INTO idsTimezones VALUES (71,'Alaska, USA',-10)");
    insertTableData("idsTimezones", "INSERT INTO idsTimezones VALUES (72,'Hawaii, USA',-10)");
    insertTableData("idsTimezones", "INSERT INTO idsTimezones VALUES (73,'Nome',-11)");
    insertTableData("idsTimezones", "INSERT INTO idsTimezones VALUES (74,'Jakarta, Indonesia',7)");
    insertTableData("idsTimezones", "INSERT INTO idsTimezones VALUES (75,'Warsaw, Poland',1)");
    insertTableData("idsTimezones", "INSERT INTO idsTimezones VALUES (76,'Riga, Latvia',2)");
    insertTableData("idsTimezones", "INSERT INTO idsTimezones VALUES (77,'Ukraine',2)");
    insertTableData("idsTimezones", "INSERT INTO idsTimezones VALUES (78,'Sydney, Australia',9)");

    # idsSignatureSources
    insertTableData("idsSignatureSources", "INSERT INTO idsSignatureSources VALUES (1,'Emerging Threats - 2.8.6','http://rules.emergingthreats.net/open/snort-2.8.6/emerging.rules.tar.gz','0','0',1)");

    insertTableData("idsSignatureSources", "INSERT INTO idsSignatureSources VALUES (2,'Snort Rules 2861 - Registered (via Aanval)','http://signature01.aanval.com/?pkg=snortrules-snapshot-2861.tar.gz&type=reg&omc=OMC','0','0',1)");
    insertTableData("idsSignatureSources", "INSERT INTO idsSignatureSources VALUES (3,'Snort Rules 2860 - Registered (via Aanval)','http://signature01.aanval.com/?pkg=snortrules-snapshot-2860.tar.gz&type=reg&omc=OMC','0','0',0)");
    insertTableData("idsSignatureSources", "INSERT INTO idsSignatureSources VALUES (4,'Snort Rules 2861 - Subscription (via Aanval)','http://signature01.aanval.com/?pkg=snortrules-snapshot-2861.tar.gz&type=sub&omc=OMC','0','0',0)");
    insertTableData("idsSignatureSources", "INSERT INTO idsSignatureSources VALUES (5,'Snort Rules 2860 - Subscription (via Aanval)','http://signature01.aanval.com/?pkg=snortrules-snapshot-2860.tar.gz&type=sub&omc=OMC','0','0',0)");

    insertTableData("idsSignatureSources", "INSERT INTO idsSignatureSources VALUES (6,'Snort Rules 2861 - Registered','http://www.snort.org/reg-rules/snortrules-snapshot-2861.tar.gz/OMC','0','0',0)");
    insertTableData("idsSignatureSources", "INSERT INTO idsSignatureSources VALUES (7,'Snort Rules 2860 - Registered','http://www.snort.org/reg-rules/snortrules-snapshot-2860.tar.gz/OMC','0','0',0)");
    insertTableData("idsSignatureSources", "INSERT INTO idsSignatureSources VALUES (8,'Snort Rules 2861 - Subscription','http://www.snort.org/sub-rules/snortrules-snapshot-2861.tar.gz/OMC','0','0',0)");
    insertTableData("idsSignatureSources", "INSERT INTO idsSignatureSources VALUES (9,'Snort Rules 2860 - Subscription','http://www.snort.org/sub-rules/snortrules-snapshot-2860.tar.gz/OMC','0','0',0)");

    insertTableData("idsSignatureSources", "INSERT INTO idsSignatureSources VALUES (10,'Local Rules File','/path/to/rules/file.tar.gz','0','0',0)");

	# Tags
	
    insertTableData("idsTags", "INSERT INTO idsTags VALUES (1, '0', 'False Positive', '')");
    insertTableData("idsTags", "INSERT INTO idsTags VALUES (2, '0', 'Not Applicable', '')");
    insertTableData("idsTags", "INSERT INTO idsTags VALUES (3, '0', 'Reviewed', '')");
    insertTableData("idsTags", "INSERT INTO idsTags VALUES (4, '0', 'Non Event', '')");
    insertTableData("idsTags", "INSERT INTO idsTags VALUES (5, '0', 'Network Anomaly', '')");
    insertTableData("idsTags", "INSERT INTO idsTags VALUES (6, '0', 'System Anomaly', '')");
    insertTableData("idsTags", "INSERT INTO idsTags VALUES (7, '0', 'Critical', '')");
    insertTableData("idsTags", "INSERT INTO idsTags VALUES (8, '0', 'High Risk', '')");
    insertTableData("idsTags", "INSERT INTO idsTags VALUES (9, '0', 'Medium Risk', '')");
    insertTableData("idsTags", "INSERT INTO idsTags VALUES (10, '0', 'Low Risk', '')");
    insertTableData("idsTags", "INSERT INTO idsTags VALUES (11, '0', 'Validated', '')");
    insertTableData("idsTags", "INSERT INTO idsTags VALUES (12, '0', 'Snort', '')");
    insertTableData("idsTags", "INSERT INTO idsTags VALUES (13, '0', 'Syslog', '')");

	# Device types
	
    insertTableData("idsDeviceTypes", "INSERT INTO idsDeviceTypes VALUES (1, 'Server', '5')");
    insertTableData("idsDeviceTypes", "INSERT INTO idsDeviceTypes VALUES (2, 'Workstation', '5')");
    insertTableData("idsDeviceTypes", "INSERT INTO idsDeviceTypes VALUES (3, 'Generic Host', '5')");
    insertTableData("idsDeviceTypes", "INSERT INTO idsDeviceTypes VALUES (4, 'Generic Device', '5')");
    insertTableData("idsDeviceTypes", "INSERT INTO idsDeviceTypes VALUES (5, 'Desktop Device', '5')");
    insertTableData("idsDeviceTypes", "INSERT INTO idsDeviceTypes VALUES (6, 'Media Device', '5')");
    insertTableData("idsDeviceTypes", "INSERT INTO idsDeviceTypes VALUES (7, 'Mobile Device', '5')");
    insertTableData("idsDeviceTypes", "INSERT INTO idsDeviceTypes VALUES (8, 'Security Device', '5')");
    insertTableData("idsDeviceTypes", "INSERT INTO idsDeviceTypes VALUES (9, 'Telephony Device', '5')");
    insertTableData("idsDeviceTypes", "INSERT INTO idsDeviceTypes VALUES (10, 'Honeypot', '5')");
    insertTableData("idsDeviceTypes", "INSERT INTO idsDeviceTypes VALUES (11, 'IDS / IPS', '5')");
    insertTableData("idsDeviceTypes", "INSERT INTO idsDeviceTypes VALUES (12, 'Firewall', '5')");
    insertTableData("idsDeviceTypes", "INSERT INTO idsDeviceTypes VALUES (13, 'Router', '5')");
    insertTableData("idsDeviceTypes", "INSERT INTO idsDeviceTypes VALUES (14, 'Switch', '5')");
    insertTableData("idsDeviceTypes", "INSERT INTO idsDeviceTypes VALUES (15, 'Syslog', '5')");
    insertTableData("idsDeviceTypes", "INSERT INTO idsDeviceTypes VALUES (16, 'Snort', '5')");
    insertTableData("idsDeviceTypes", "INSERT INTO idsDeviceTypes VALUES (17, 'Aanval', '5')");
    insertTableData("idsDeviceTypes", "INSERT INTO idsDeviceTypes VALUES (18, 'Test System', '5')");

}

function createTable($table, $createQuery) {

	if (mysql_query("SELECT * FROM $table LIMIT 1", $_ENV["appDB"])) {
		
	} else {

		if (mysql_query("$createQuery", $_ENV["appDB"])) {
		
		} else {
		
			$xml = "\t\t<fail>$table</fail>\n";
			
		}
	}
	
	return $xml;
}

function alterTable($table, $alterQuery) {

    if (mysql_query("$alterQuery", $_ENV["appDB"])) {

    } else {

		# If error contains "Duplicate" -- this is okay; it's for a duplicate column
	
		if (!stristr(mysql_error(), "duplicate")) {

			$xml = "\t\t<fail>$table</fail>\n";
			
		}
		
    }

}

function insertTableData($table, $insertQuery) {

	if (mysql_query("$insertQuery", $_ENV["appDB"])) {

	} else {
	
		# If error contains "Duplicate" -- this is okay; it's for a duplicate key
	
		if (!stristr(mysql_error(), "duplicate")) {
	
			$xml = "\t\t<fail>$table</fail>\n";
			
		}
		
	}

}

function updateTableData($table, $updateQuery) {

	if (mysql_query("$updateQuery", $_ENV["appDB"])) {

	} else {
	
		# If error contains "Duplicate" -- this is okay; it's for a duplicate key
	
		if (!stristr(mysql_error(), "duplicate")) {
	
			$xml = "\t\t<fail>$table</fail>\n";
			
		}
		
	}

}

function dbCreateTest() {

	$dbname = sanitize("dbname");
	$dbhost = sanitize("dbhost");
	$dbusername = sanitize("dbusername");
	$dbpassword = sanitize("dbpassword");

	if ($link = @mysql_connect("$dbhost", "$dbusername", "$dbpassword")) {

    	if (@mysql_select_db($dbname)) {
    	
    		// Database exists
    		
    		return true;
    	
    	} else {
    	
    		// Create database
    		
    		if (@mysql_unbuffered_query("CREATE DATABASE `" . $dbname . "`")) {
    		
    			// Create success

	    		return true;
    		
    		} else {
    		
    			// Create failure

	    		return "DB Creation Failure: " . mysql_error();
    		
    		}
    	
    	}
    	
    } else {

		// Database connection failure

		return "DB Connection Failure: " . mysql_error();
    
    }

}

function writeConfigFile() {

	$dbname = sanitize("dbname");
	$dbhost = sanitize("dbhost");
	$dbusername = sanitize("dbusername");
	$dbpassword = sanitize("dbpassword");

	$f .= "<?php\n";
	$f .= "\n";
	$f .= "#\n";
	$f .= "# Aanval Intrusion Detection and Correlation Console\n";
	$f .= "# Primary Configuration File\n";
	$f .= "#\n";
	$f .= "# Copyright (c) 2012 - Tactical FLEX, Inc. - All Rights Reserved\n";
	$f .= "#\n";
	$f .= "\n";
	$f .= "define(\"DBHOST\", '$dbhost');\n";
	$f .= "define(\"DBNAME\", '$dbname');\n";
	$f .= "define(\"DBUSER\", '$dbusername');\n";
	$f .= "define(\"DBPASS\", '$dbpassword');\n";
	$f .= "\n";
	$f .= "?>\n";

	if ($fp = fopen ("conf/conf.php", "w")) {
	
		fputs($fp, "$f");
		fclose($fp);

		$out = "Configuration written successfully";
		
	} else {

		$out = "ERROR! Configuration could not be written (permissions on conf/ directory?)";
		
	}

	return $out;
	
}

function installUpgradeCheck() {

	if (file_exists("installation/install.cert")) {
	
		// Upgrade
		
		return 2;
	
	} else {
	
		// Install

		return 1;
	
	}

}

function compatibilityTest() {

	$pass = true;

	$out .= "<p>Environment Compatibility Test</p>";
	$out .= "<hr>";
	$out .= "<br>";

	$dirArray[] = "conf";
	$dirArray[] = "installation";
	$dirArray[] = "logs";
	$dirArray[] = "smt";
	$dirArray[] = "smt/policyData";
	$dirArray[] = "smt/sensorData";
	$dirArray[] = "smt/snortRules";
	$dirArray[] = "smt/snortRules/data";
	$dirArray[] = "syslog";
	$dirArray[] = "tmp";
	$dirArray[] = "tmp/geo";
	$dirArray[] = "tmp/search";
	$dirArray[] = "version";

	$moduleArray = array("session", "mysql", "pcre", "zlib");
	
	$out .= "PHP Modules<br><br>";
	
	foreach ($moduleArray as $module) {
	
        if (!extension_loaded($module)) {

			$out .= "<span style=\"font-size: 0.9em; color: #CC0000;\">Module [$module] Does Not Exist!</span>";
			$out .= "<br>";

			$pass = false;

        } else {
        
			$out .= "<span style=\"font-size: 0.9em;\">Module [$module] Exists</span>";
			$out .= "<br>";
        
        }
	
	}

	$out .= "<br>";
	$out .= "Directory Structure & Permissions<br><br>";

	foreach ($dirArray as $dir) {
	
		if (is_dir($dir)) {
		
			$out .= "<span style=\"font-size: 0.9em;\">Directory [$dir] Exists</span>";
			$out .= "<br>";
			
			if ($fp = fopen("$dir/test", "w")) {
			
				$out .= "<span style=\"font-size: 0.9em;\">Directory [$dir] Write Success</span>";
				$out .= "<br>";
			
				@unlink("$dir/test");
			
			} else {
			
				$out .= "<span style=\"font-size: 0.9em; color: #CC0000;\">Directory [$dir] Write Failure! Allow write permissions and retest</span>";
				$out .= "<br>";
			
				$pass = false;
			
			}
		
		} else {

			$out .= "<span style=\"font-size: 0.9em; color: #CC0000;\">Directory [$dir] Does not exist! -- Create this directory and restest</span>";
			$out .= "<br>";
		
			$pass = false;
		
		}
	
	}
	
	if ($pass == true) {
	
		$out .= "<p style=\"color: #009900;\">Success!</p>";
		
		$out .= "<p><a href=\"?op=3\">Continue</a></p>";
	
	} else {

		$out .= "<p style=\"color: #CC0000;\">Failure!</p>";
		
		$out .= "<p>Resolve the errors or warnings listed above. You may <a href=\"?op=2\">Retest</a> or <a href=\"?op=3\">Continue</a> only if you are sure you know what you are doing.</p>";
	
	}
	
	return $out;

}

function upgradeSystem() {

	$op = sanitize("op");
	if (!$op) $op = 1;
	
	switch ($op) {
	
		case 1:
		
			$out .= EULADisplay();
		
			break;

		case 2:

			$out .= compatibilityTest();
		
			break;

		case 3:
		
			$out .= upgrade();
			
			break;

		case 4:
		
			$out .= upgradeComplete();

			break;
			
		default:
		
			$out .= EULADisplay();
		
			break;
	
	}
	
	return $out;
	
}

function installUpgradeHeader() {

	$out .= "<style type=\"text/css\" media=\"screen\">@import \"console/assets/css/default.css\";</style>";

	$out .= "<div id=\"headerBar2\">

				<div style=\"position: relative; min-width:900px; max-width:1800px; margin-left: auto; margin-right: auto; padding-left: 20px; padding-right: 20px;\">
			
					<span style=\"position: relative; top: 7px; font-size: 0.8em; color: #333333;\">Snort & Syslog Intrusion Detection, Correlation and Threat Management</span>
	
					<span style=\"position: relative; top: 7px; font-size: 0.8em; color: #333333; float: right;\">800-921-2584</span>
	
				</div>
	
			</div>		
	
			<div class=\"headerRule2\">&nbsp;</div>";
			
	$out .= "<div id=\"headerBar\">
							
				<div style=\"position: relative; min-width:900px; max-width:1800px; margin-left: auto; margin-right: auto; padding-left: 20px; padding-right: 20px;\">
	
					<div style=\"position: relative; top: 0px; float: left; text-align: left; vertical-align: middle; color: #333333;\">";

					if (installUpgradeCheck() == 1) {
					
						$out .= "<h3>Installation</h3>";
					
					} else {
					
						$out .= "<h3>Upgrade</h3>";
					
					}
	
					$out .= "</div>
				
					<div style=\"position: relative; top: 0px; width: 175px; height: 100%; float: right; text-align: right; vertical-align: middle;\">
				
						<div style=\"position: relative; top: 21px; float: right; text-align: center; vertical-align: middle; font-size: 1.2em; color: #333333; letter-spacing: +1px\">
	
							{ Aanval<span style=\"position: relative; font-size: 0.6em; top: -6px; padding-left: 1px;\">&reg</span> v7 }
	
						</div>
						
					</div>
				
				</div>
				
			</div>
			
			<div class=\"headerRule\">&nbsp;</div>";		

	return $out;

}

function installUpgradeBody() {
	
	$out = "<br>";
	$out .= "<div style=\"position: relative; max-width:980px; height: 100%; margin-left: auto; margin-right: auto; padding-left: 20px; padding-right: 50px;\">";

	if (installUpgradeCheck() == 2) {
	
		// Upgrade
		
		$out .= upgradeSystem();
	
	} else {
	
		// Install

		$out .= installSystem();
	
	}

	$out .= "</div>";

	return $out;

}

function installUpgradeFooter() {

	$out = "<br>";
	$out .= "<br>";
	$out .= "<hr>";
	
	$out .= "<div style=\"position: relative; min-width:900px; max-width:1800px; margin-left: auto; margin-right: auto; padding-left: 20px; padding-right: 20px;\">
			
				<span style=\"position: relative; top: 7px; font-size: 0.8em; color: #333333; float: right;\">Aanval&reg by Tactical FLEX, Inc.</span>
	
			</div>";
	
	$out .= "<br>";

//	return $out;
	
}

function sanitize($val) {

	$array = array_merge($_GET, $_POST);

	if (strlen($array[$val]) >= 1) {
	
		return $array[$val];
	
	}

	return false;
}

function installEmail($typeText) {

	$message = "$typeText Confirmation\n\n";
	$message .= "" . getVersionText() . "\n\n";
	$message .= "Client Network Address: " . $_SERVER['REMOTE_ADDR'] . "\nServer Network Address: " . $_SERVER['SERVER_ADDR'] . "\n\n";
	$message .= "This email is to confirm, and only confirm a successful installation or upgrade of Aanval.\n";
	$message .= "This email may contain non-sensitive information used to identify the unique installation of this console for license verification purposes.\n\n";
	$message .= "Aanval - Intrusion Detection and Correlation Console\nhttp://www.aanval.com/\n\n";
	$message .= time() . "\n\n";

	$headers .= "From: \"Aanval " . getVersionText() . "\" <" . "bin@aanval.com" . ">\r\n";
	
	if (function_exists("mail")) @mail("bin@aanval.com", "[$typeText] | v7 | Success", $message, $headers);
    
}

function getVersionText() {

    $version = @file("version/version.txt");

    $major = rtrim($version[0]);
    $minor = rtrim($version[1]);
    $name = rtrim($version[2]);
    $build = rtrim($version[3]);

    $out = "$major.$minor ($name) BUILD: $build";

    return $out;
    
}

?>