<?php

function prv_bpuStatus() {

	$_ENV['contentTitle'] = "BPU Status";

	$_ENV['templateData'] = bpuStatus();

	$_ENV['template'] = "template_bpuStatus.php";

}

function bpuStatus() {

	$out = array();
	$fArray = array();

	$fArray[] = array("file" => "bpuImport.last", "name" => "Import");
	$fArray[] = array("file" => "bpuImport.last", "name" => "Core");
	$fArray[] = array("file" => "bpuImport.last", "name" => "Queue");

	foreach ($fArray as $file) {
	
		$diff = 0;
	
		if (file_exists("tmp/" . $file['file'])) {
	
			$data = file("tmp/" . $file['file']);
			$diff = time() - trim($data[0]);
		
			if ($diff <= 30) {
			
				$image = "console/assets/images/icons/bullet_green.png";
				
				$title = $file['name'] . " BPU reported $diff seconds ago";
			
			} else if ($diff <= 120) {

				$image = "console/assets/images/icons/bullet_green.png";

				$title = $file['name'] . " BPU reported $diff seconds ago";
			
			} else {
			
				$image = "console/assets/images/icons/bullet_red.png";

				$title = $file['name'] . " BPU reported $diff seconds ago";
			
			}

		} else {
		
			$image = "console/assets/images/icons/bullet_white.png";
		
			$title = $file['name'] . " BPU is not running";
		
		}
	
		$out[] = array("file" => $file['file'], "name" => $file['name'], "status" => $title, "image" => $image, "diff" => $diff);
		
	}

	return $out;

}

function BPUStatusDisplay() {

	$fArray = bpuStatus();

	foreach ($fArray as $file) {

		$out[] = "<a href=\"?op=prv_bpuStatus\"><img id=\"bpuStatus\" src=\"" . $file['image'] . "\" title=\"" . $file['status'] . "\"></a>";
		
	}

	return implode(" ", $out);

}

?>