<?php

function prv_liveEventCorrelation() {

	if (!getVar("id")) setVar("id", 0);
	if (!getVar("risk")) setVar("risk", 0);
	if (!getVar("num")) setVar("num", 25);

	$_ENV['contentTitle'] = "Live Event Correlation";

	$_ENV['template'] = "template_liveEventCorrelation.php";

}

function poll_liveEventCorrelation() {

	if (!getVar("id")) setVar("id", 0);
	if (!getVar("risk")) setVar("risk", 0);
	if (!getVar("num")) setVar("num", 25);

	$_ENV['contentTitle'] = "Live Event Correlation";

	$_ENV['template'] = "template_liveEventCorrelationPoll.php";

}

function displayLiveCorrelationSensors() {
	
	// Sensor list

	$out .= itemRenderer("liveCorrelationSensorSelection", array("id" => 0, "name" => "All Sensors"));

	$result = $_ENV['appDB']->query("SELECT * FROM idsSensor WHERE id IN (" . $_SESSION["user"]["sensors"] . ") AND enabled = 1 ORDER BY module, name");
	
	if ($result) {
	
		while ($row = mysql_fetch_assoc($result)) {
	
			if ($row["module"] == 1) {
			
				$row["moduleName"] = "Snort";
			
			} else if ($row["module"] == 2) {
	
				$row["moduleName"] = "Syslog";
			
			} else {
	
				$row["moduleName"] = "";
			
			}
	
			$out .= itemRenderer("liveCorrelationSensorSelection", $row);
				
		}

	} else {
	
		$out = "No available sensors";
	
	}

	return $out;

}

function liveCorrelationResults($query = "recent:25") {

    // Set defaults    
    $limit = ops("site_corEngineLimitA");
    $level = ops("site_corEngineLevelA");
    
	if (!$level) $level = 1;
    
    if ($level == 1) {
    	$timeWindow1 = 90;
    	$timeWindow2 = 90;
    	$timeWindow3 = 90;
    	$timeWindow4 = 180;
    	$timeWindow5 = 600;
    	$timeWindow6 = 900;
    } else if ($level == 2) {
    	$timeWindow1 = 180;
    	$timeWindow2 = 180;
    	$timeWindow3 = 180;
    	$timeWindow4 = 360;
    	$timeWindow5 = 1200;
    	$timeWindow6 = 1800;
    } else if ($level == 3) {
    	$timeWindow1 = 1000;
    	$timeWindow2 = 1000;
    	$timeWindow3 = 1000;
    	$timeWindow4 = 3000;
    	$timeWindow5 = 6000;
    	$timeWindow6 = 9000;
    } else if ($level == 4) {
    	$timeWindow1 = 3000;
    	$timeWindow2 = 3000;
    	$timeWindow3 = 3000;
    	$timeWindow4 = 5000;
    	$timeWindow5 = 9000;
    	$timeWindow6 = 12000;
    } else if ($level == 5) {
    	$timeWindow1 = 15000;
    	$timeWindow2 = 15000;
    	$timeWindow3 = 15000;
    	$timeWindow4 = 20000;
    	$timeWindow5 = 25000;
    	$timeWindow6 = 30000;
    } else if ($level == 6) {
    	$timeWindow1 = 150000;
    	$timeWindow2 = 150000;
    	$timeWindow3 = 150000;
    	$timeWindow4 = 200000;
    	$timeWindow5 = 250000;
    	$timeWindow6 = 300000;
    }
    
	$searchObj = new coreSearch();
	$searchObj->setVar("query", $query);
	$searchObj->setVar("store", ops("site_activeDataStore"));

	if (sanitize("sensor") > 0) {
		$searchObj->setVar("sensor", sanitize("sensor"));
	}

	// Get event id's

	foreach ($searchObj->searchProcess() as $data) {

		$eventArray[] = $data;

	}
	
	// Reverse array for proper sort order (top is most recent for live monitor)
	
	rsort($eventArray);
	
	// Process event id's
	
	foreach ($eventArray as $data) {

		$tmp = explode(":", $data);
		
		$store = $tmp[0];
		$eventID = $tmp[1];

		$searchObj->setVar("store", $store);

		$eventData = $searchObj->getDetailsByID(trim($eventID));
		
    	$a_id[] = $eventData["id"];
    	$a_sip[] = $eventData["sip"];
    	$a_dip[] = $eventData["dip"];
    	$a_sport[] = $eventData["sport"];
    	$a_dport[] = $eventData["dport"];
    	$a_epoch[] = $eventData["intime"];
    	$a_timestamp[] = $eventData["timestamp"];
    	$a_ename[] = $eventData["signatureName"];
    	$a_enameid[] = $eventData["signature"];
    	$a_etypeid[] = $eventData["class"];
    	$a_sensorid[] = $eventData["sensorID"];

    	$cnt++;
    	
	}

    // Iterate through each queried row
    for ($i=0;$i<count($a_id);$i++) {
    	
    	if ($eid) {
    		if ($a_id[$i] != $eid) continue;
    	}
    	
    	// Check this array and skip inner-loop if the id is contained within (means it has been matched already)
		if ($cor) {
			if (in_array($a_id[$i], $cor)) continue;
		}
    	
		// Inner-loop to compare each of the events to the single outer-loop
    	for ($p=0;$p<count($a_id);$p++) {
    		
    		// Epoch calc to determine differnce in time between events
    		if ($a_epoch[$i] > $a_epoch[$p]) {
    			$higher = $a_epoch[$i];
    			$lower = $a_epoch[$p];
    		} else {
    			$higher = $a_epoch[$p];
    			$lower = $a_epoch[$i];
    		}
    		$ediff = $higher - $lower;
    		
    		// 1 (more strict matching)
    		if ($a_id[$i] != $a_id[$p] && $a_sip[$i] == $a_sip[$p] && $a_dip[$i] == $a_dip[$p] && $a_enameid[$i] == $a_enameid[$p] && $a_sensorid[$i] == $a_sensorid[$p] && $ediff < $timeWindow1) {

    			// !! Related  			
    				            
    			// Display TANK
				if (!$out) {

					$out .= lineDisplay($searchObj, 1, $a_id[$i], "99.99%");
					$idArray[] = $a_id[$i];
				}

				// Display AGRO				
				if (count($idArray) < 10) $out .= lineDisplay($searchObj, 0, $a_id[$p], "99.99%");
				$idArray[] = $a_id[$p];

				$cor[] = $a_id[$p];    		
    		
    		// 2
    		} else if ($a_id[$i] != $a_id[$p] && $a_sip[$i] == $a_dip[$p] && $a_dip[$i] == $a_sip[$p] && $a_sensorid[$i] == $a_sensorid[$p] && $ediff < $timeWindow2) {

    			// !! Related  			
    				            
    			// Display TANK
				if (!$out) {

					$out .= lineDisplay($searchObj, 1, $a_id[$i], "99.99%");
					$idArray[] = $a_id[$i];
				}

				// Display AGRO				
				if (count($idArray) < 10) $out .= lineDisplay($searchObj, 0, $a_id[$p], "98.99%");
				$idArray[] = $a_id[$p];

				$cor[] = $a_id[$p];

    		// 3
    		} else if ($a_id[$i] != $a_id[$p] && $a_sip[$i] == $a_sip[$p] && $a_dip[$i] == $a_dip[$p] && $a_enameid[$i] == $a_enameid[$p] && $ediff < $timeWindow3) {

    			// !! Related

    			// Display TANK
				if (!$out) {			
						
					$out .= lineDisplay($searchObj, 1, $a_id[$i], "99.99%");
					$idArray[] = $a_id[$i];
				}

				// Display AGRO				
				if (count($idArray) < 10) $out .= lineDisplay($searchObj, 0, $a_id[$p], "98.00%");
				$idArray[] = $a_id[$p];

				$cor[] = $a_id[$p];
				
			// 4
    		} else if ($a_id[$i] != $a_id[$p] && $a_sip[$i] == $a_sip[$p] && $a_dip[$i] == $a_dip[$p] && $a_etypeid[$i] == $a_etypeid[$p] && $ediff < $timeWindow4) {

    			// !! Related

    			// Display TANK
				if (!$out) {

					$out .= lineDisplay($searchObj, 1, $a_id[$i], "99.99%");
					$idArray[] = $a_id[$i];
				}

				// Display AGRO				
				if (count($idArray) < 10) $out .= lineDisplay($searchObj, 0, $a_id[$p], "95.00%");
				$idArray[] = $a_id[$p];

				$cor[] = $a_id[$p];
				
			// 5
    		} else if ($a_id[$i] != $a_id[$p] && $a_sip[$i] == $a_sip[$p] && $a_dip[$i] == $a_dip[$p] && $ediff < $timeWindow5) {

    			// !! Related

    			// Display TANK
				if (!$out) {

					$out .= lineDisplay($searchObj, 1, $a_id[$i], "99.99%");
					$idArray[] = $a_id[$i];
				}

				// Display AGRO				
				if (count($idArray) < 10) $out .= lineDisplay($searchObj, 0, $a_id[$p], "92.00%");
				$idArray[] = $a_id[$p];

				$cor[] = $a_id[$p];
				
			// 6
    		} else if ($a_id[$i] != $a_id[$p] && $a_sip[$i] == $a_sip[$p] && $ediff < $timeWindow6) {

    			// !! Related

    			// Display TANK
				if (!$out) {

					$out .= lineDisplay($searchObj, 1, $a_id[$i], "99.99%");
					$idArray[] = $a_id[$i];
				}

				// Display AGRO				
				if (count($idArray) < 10) $out .= lineDisplay($searchObj, 0, $a_id[$p], "89.00%");
				$idArray[] = $a_id[$p];

				$cor[] = $a_id[$p];
				
    		}
    	}
    	
    	// CorDisplay Sections
    	if ($out) {

			$total = 0;
	    	$total = count($idArray);
	    	
	    	if ($total > 10) {
	    		$tmp = count($idArray) - 10;
	    		$total = "$total ($tmp not shown)";
	    		$length = $length + 10;
	    	} else {
	    		$length = $length + $total;
	    	}

    		$result .= $out .= "<p>$total events related to the primary event</p>";
    		
    	} else if ($eid) {
    	
    	}

    	// Live monitor check
		if ($live == 1 && $length >= 30) break;

    	// unsets
    	unset($out, $idArray);
		
    }
    
	return $result;
	
}
    
function lineDisplay(&$searchObj, $type, $id, $perc) {
	
    if ($type == 1) $perc = "-";

	$eventData = $searchObj->getDetailsByID($id);

	if (!$eventData["sport"]) $eventData["sport"] = "-";
	if (!$eventData["dport"]) $eventData["dport"] = "-";

	$eventAge = consoleTimeConversion(time()) - sensorTimeConversion($eventData["sensorID"], $eventData["timestamp"]);
	if ($eventAge < 0) $eventAge = 0;

	$eventData["eventAge"] = $eventAge;
	$eventData["percent"] = $perc;
		
	$out .= itemRenderer('eventCorrelation', $eventData);

	return $out;

}

?>