<?php

function prv_deviceManagement() {

	// Build renderers

	$_ENV['templateRenderer'] = displayAlldevices();

	// Get details

	$_ENV['templateData'] = deviceDetails(sanitize("id"));

	// Template

	$_ENV['contentTitle'] = "Device Management";

	$_ENV['template'] = "template_deviceManagement.php";

}

function displayAlldevices() {
	
	// List

	$q = $_ENV['appDB']->query("SELECT idsDevices.*, idsDeviceTypes.name AS typeName FROM idsDevices JOIN idsDeviceTypes ON (idsDevices.type = idsDeviceTypes.id) ORDER BY name");
	while ($row = mysql_fetch_assoc($q)) {
	
		if (!getVar("id")) setVar("id", $row['id']);
	
		$out .= itemRenderer('deviceManagement', $row);	
		
	}
	
	return $out;

}

function deviceDetails($id) {
	
	$q = $_ENV['appDB']->query("SELECT * FROM idsDevices WHERE id = '$id'");
	$result = mysql_fetch_object($q);

	$result->addresses = array();

	$q = $_ENV['appDB']->query("SELECT * FROM idsDeviceAddresses WHERE deviceID = '$id'");
	while($row = mysql_fetch_object($q)) {
	
		$result->addresses[] = $row;
		
	}

	$q = $_ENV['appDB']->query("SELECT * FROM idsDeviceServices WHERE deviceID = '$id'");
	while($row = mysql_fetch_object($q)) {
	
		$result->services[] = $row;
		
	}
	
	return $result;
	
}

function prv_deviceManagementUpdate() {

	$id = sanitize("id");
	$name = sanitize("name");
	$description = sanitize("description");
	$type = sanitize("deviceType");

	// Update device details

	$_ENV['appDB']->query("UPDATE idsDevices SET name = '$name', description = '$description', type = '$type' WHERE id = '$id'");
		
    // Redirect

    $_ENV['redirect'] = array("prv_deviceManagement&id=$id", DEFAULT_REDIRECT_TIMEOUT);

    $_ENV['redirectMessage'] = "Updating Device";

    $_ENV['template'] = "template_redirectGeneral.php";
		
}

function prv_deviceManagementCreate() {

	// Create default device

	$q = $_ENV['appDB']->query("INSERT INTO idsDevices (name, description, type) VALUES ('New Device', '', '1')");
	
	$id = mysql_insert_id();
		
    // Redirect

    $_ENV['redirect'] = array("prv_deviceManagement&id=$id", DEFAULT_REDIRECT_TIMEOUT);

    $_ENV['redirectMessage'] = "Creating New Device";

    $_ENV['template'] = "template_redirectGeneral.php";
		
}

function prv_deviceManagementDelete() {

	$id = sanitize("id");

	// Delete device

	$_ENV['appDB']->query("DELETE FROM idsDevices WHERE id = '$id'");
		
    // Redirect

    $_ENV['redirect'] = array("prv_deviceManagement", DEFAULT_REDIRECT_TIMEOUT);

    $_ENV['redirectMessage'] = "Deleting Device";

    $_ENV['template'] = "template_redirectGeneral.php";
		
}

function prv_deviceAddressCreate() {

	$id = sanitize("id");

	// Create default device address

	$q = $_ENV['appDB']->query("INSERT INTO idsDeviceAddresses (deviceID, name, ip) VALUES ('$id', 'eth0', '0.0.0.0')");
	
    // Redirect

    $_ENV['redirect'] = array("prv_deviceManagement&id=$id", DEFAULT_REDIRECT_TIMEOUT);

    $_ENV['redirectMessage'] = "Creating New Device Address";

    $_ENV['template'] = "template_redirectGeneral.php";
		
}

function prv_deviceAddressUpdate() {

	$id = sanitize("id");
	$aid = sanitize("aid");

	$name = sanitize("name");
	$ip = sanitize("ip");

	// Update device address

	$_ENV['appDB']->query("UPDATE idsDeviceAddresses SET name = '$name', ip = '" . ip2long($ip) . "' WHERE id = '$aid'");
		
    // Redirect

    $_ENV['redirect'] = array("prv_deviceManagement&id=$id", DEFAULT_REDIRECT_TIMEOUT);

    $_ENV['redirectMessage'] = "Updating Device Address";

    $_ENV['template'] = "template_redirectGeneral.php";
		
}

function prv_deviceAddressDelete() {

	$id = sanitize("id");
	$aid = sanitize("aid");

	// Delete device address

	$_ENV['appDB']->query("DELETE FROM idsDeviceAddresses WHERE id = '$aid'");
		
    // Redirect

    $_ENV['redirect'] = array("prv_deviceManagement&id=$id", DEFAULT_REDIRECT_TIMEOUT);

    $_ENV['redirectMessage'] = "Deleting Device Address";

    $_ENV['template'] = "template_redirectGeneral.php";
		
}

function prv_deviceServiceCreate() {

	$id = sanitize("id");

	// Create default device service

	$q = $_ENV['appDB']->query("INSERT INTO idsDeviceServices (deviceID, name, port, protocol) VALUES ('$id', '', '0', '6')");
	
    // Redirect

    $_ENV['redirect'] = array("prv_deviceManagement&id=$id", DEFAULT_REDIRECT_TIMEOUT);

    $_ENV['redirectMessage'] = "Creating New Device Service";

    $_ENV['template'] = "template_redirectGeneral.php";
		
}

function prv_deviceServiceUpdate() {

	$id = sanitize("id");
	$sid = sanitize("sid");

	$name = sanitize("name");
	$port = sanitize("port");
	$protocol = sanitize("protocol");

	// Update device service

	$_ENV['appDB']->query("UPDATE idsDeviceServices SET name = '$name', port = '$port', protocol = '$protocol' WHERE id = '$sid'");
		
    // Redirect

    $_ENV['redirect'] = array("prv_deviceManagement&id=$id", DEFAULT_REDIRECT_TIMEOUT);

    $_ENV['redirectMessage'] = "Updating Device Service";

    $_ENV['template'] = "template_redirectGeneral.php";
		
}

function prv_deviceServiceDelete() {

	$id = sanitize("id");
	$sid = sanitize("sid");

	// Delete device service

	$_ENV['appDB']->query("DELETE FROM idsDeviceServices WHERE id = '$sid'");
		
    // Redirect

    $_ENV['redirect'] = array("prv_deviceManagement&id=$id", DEFAULT_REDIRECT_TIMEOUT);

    $_ENV['redirectMessage'] = "Deleting Device Service";

    $_ENV['template'] = "template_redirectGeneral.php";
		
}

?>