<?php

function prv_frequentEvents() {

	if (!getVar("num")) setVar("num", 50);
	if (!getVar("type")) setVar("type", 1);

	$_ENV['contentTitle'] = "Frequent Events";

	$_ENV['templateData'] = frequentEventsData();

	$_ENV['template'] = "template_frequentEvents.php";

}

function frequentEventsData() {

	$num = sanitize("num");
	if (!$num) $num = 50;
		
	$type = sanitize("type");
	if (!$type) $type = 1;

	$type == 1 ? $order = "DESC" : $order = "ASC";

	$chartArray = array();
	$resultArray = array();

	$total = 0;
	$otherCount = 0;

	if (ops("site_custom_snortGroup") == 1) {

		// Custom Grouping Results
	
		$result = $_ENV['appDB']->query("SELECT count(mas.id) AS cnt, evt.signatureName AS signame, evt.signature as sigid FROM idsDataStore_" . $_SESSION["user"]["activeSearchStore"] . "_Master as mas LEFT JOIN idsDataStore_" . $_SESSION["user"]["activeSearchStore"] . "_Events as evt USING (id) where evt.customGrouping RLIKE REPLACE ( REPLACE ( REPLACE ('" . $_SESSION["user"]["sensors"] . "','+','[+]'), ' ', ''), ',', '|') GROUP BY evt.signatureName ORDER BY cnt $order LIMIT $num");

	} else {

		// Standard Results

		$result = $_ENV['appDB']->query("SELECT count(mas.id) AS cnt, evt.signatureName AS signame, evt.signature as sigid FROM idsDataStore_" . $_SESSION["user"]["activeSearchStore"] . "_Master as mas LEFT JOIN idsDataStore_" . $_SESSION["user"]["activeSearchStore"] . "_Events as evt USING (id) where mas.sensorID in (" . $_SESSION["user"]["sensors"] . ") GROUP BY evt.signatureName ORDER BY cnt $order LIMIT $num");
	
	}

	if ($result) {

		while ($row = mysql_fetch_assoc($result)) {
	
			$total += $row["cnt"];
			
			$resultArray[] = $row;
			
		}
		
		foreach ($resultArray as $data) {
		
			$data["percent"] = number_format($data["cnt"] / $total * 100, 2);
		
			if (count($chartArray) < 10) {
				
				$chartArray[] = "{signature: '" . htmlentities($data["signame"]) . "', total: " . $data["cnt"] . "}";
				
			} else {
			
				$otherCount += $data["cnt"];
			
			}
		
			$out .= itemRenderer("frequentEvents", $data);
			
		}
		
		if ($otherCount) $chartArray[] = "{signature: 'Other', total: " . $otherCount . "}";
		
	} else {
	
		$out .= "No data available";
	
	}

	return arrayToObject(array("table" => $out, "chart" => "var chartData = [" . implode(",", $chartArray) . "]"));	
	
}

?>