<?php

function prv_frequentOffenders() {

	if (!getVar("num")) setVar("num", 50);
	if (!getVar("type")) setVar("type", 1);

	$_ENV['contentTitle'] = "Frequent Offenders";

	$_ENV['templateData'] = frequentOffendersData();

	$_ENV['template'] = "template_frequentOffenders.php";

}

function frequentOffendersData() {

	$num = sanitize("num");
	if (!$num) $num = 50;
		
	$type = sanitize("type");
	if (!$type) $type = 1;

	$type == 1 ? $order = "DESC" : $order = "ASC";

	$resolve = sanitize("resolve");
	if (!$resolve) $resolve = 0;

	$resolve == 0 ? $resolve = false : $resolve = true;

	$chartArray = array();
	$resultArray = array();

	$total = 0;
	$otherCount = 0;

	if (ops("site_custom_snortGroup") == 1) {

		// Custom Grouping Results
	
		$result = $_ENV['appDB']->query("SELECT count(mas.id) as cnt, INET_NTOA(evt.sip) as ip FROM idsDataStore_" . $_SESSION["user"]["activeSearchStore"] . "_Master as mas LEFT JOIN idsDataStore_" . $_SESSION["user"]["activeSearchStore"] . "_Events as evt USING (id) where evt.customGrouping RLIKE REPLACE ( REPLACE ( REPLACE ('" . $_SESSION["user"]["sensors"] . "','+','[+]'), ' ', ''), ',', '|') group by evt.sip order by cnt $order limit $num");
	
	} else {
	
		// Standard Results
	
		$result = $_ENV['appDB']->query("SELECT count(mas.id) as cnt, INET_NTOA(evt.sip) as ip FROM idsDataStore_" . $_SESSION["user"]["activeSearchStore"] . "_Master as mas LEFT JOIN idsDataStore_" . $_SESSION["user"]["activeSearchStore"] . "_Events as evt USING (id) where mas.sensorID in (" . $_SESSION["user"]["sensors"] . ") group by evt.sip order by cnt $order limit $num");
	
	}

	if ($result) {
	
		while ($row = mysql_fetch_assoc($result)) {
	
			$row["host"] = doHostnameLookup($row["ip"], $resolve);
			
			$total += $row["cnt"];
			
			$resultArray[] = $row;
			
		}
	
		foreach ($resultArray as $data) {
		
			$data["percent"] = number_format($data["cnt"] / $total * 100, 2);
		
			if (count($chartArray) < 10) {
			
				$chartArray[] = "{host: '" . htmlentities($data["host"]) . "', total: " . $data["cnt"] . "}";
				
			} else {
			
				$otherCount += $data["cnt"];
			
			}
		
			$out .= itemRenderer("frequentOffenders", $data);
		
		}
		
		if ($otherCount) $chartArray[] = "{host: 'Other', total: " . $otherCount . "}";

	} else {
	
		$out .= "No data available";
	
	}
	
	return arrayToObject(array("table" => $out, "chart" => "var chartData = [" . implode(",", $chartArray) . "]"));	
	
}

?>