<?php

function prv_frequentPorts() {

	if (!getVar("num")) setVar("num", 50);
	if (!getVar("type")) setVar("type", 1);
	if (!getVar("direction")) setVar("direction", 1);
	if (!getVar("protocol")) setVar("protocol", 6);

	$_ENV['contentTitle'] = "Frequent Ports";

	$_ENV['templateData'] = frequentPortsData();

	$_ENV['template'] = "template_frequentPorts.php";

}

function frequentPortsData() {

	$num = sanitize("num");
	if (!$num) $num = 50;
		
	$type = sanitize("type");
	if (!$type) $type = 1;

	$direction = sanitize("direction");
	if (!$direction) $direction = 1;

	$protocol = sanitize("protocol");
	if (!$protocol) $protocol = 6;

	$type == 1 ? $order = "DESC" : $order = "ASC";
	$direction == 1 ? $direction = "sport" : $direction = "dport";

	$chartArray = array();
	$resultArray = array();

	$total = 0;
	$otherCount = 0;

	if (ops("site_custom_snortGroup") == 1) {

		// Custom Grouping Results
	
		$result = $_ENV['appDB']->query("SELECT count(mas.id) AS cnt, evt.$direction AS port FROM idsDataStore_" . $_SESSION["user"]["activeSearchStore"] . "_Master as mas LEFT JOIN idsDataStore_" . $_SESSION["user"]["activeSearchStore"] . "_Events as evt USING (id) where evt.customGrouping RLIKE REPLACE ( REPLACE ( REPLACE ('" . $_SESSION["user"]["sensors"] . "','+','[+]'), ' ', ''), ',', '|') AND evt.protocol = '$protocol' group by evt.$direction order by cnt $order limit $num");

	} else {

		// Standard Results

		$result = $_ENV['appDB']->query("SELECT count(mas.id) AS cnt, evt.$direction AS port FROM idsDataStore_" . $_SESSION["user"]["activeSearchStore"] . "_Master as mas LEFT JOIN idsDataStore_" . $_SESSION["user"]["activeSearchStore"] . "_Events as evt USING (id) where mas.sensorID in (" . $_SESSION["user"]["sensors"] . ") AND evt.protocol = '$protocol' group by evt.$direction order by cnt $order limit $num");
	
	}

	if ($result) {

		while ($row = mysql_fetch_assoc($result)) {
	
			$total += $row["cnt"];
			
			$resultArray[] = $row;
			
		}
	
		foreach ($resultArray as $data) {
		
			$data["percent"] = number_format($data["cnt"] / $total * 100, 2);
		
			if (count($chartArray) <= 10) {
			
				$chartArray[] = "{port: '" . htmlentities($data["port"]) . "', total: " . $data["cnt"] . "}";
				
			} else {
			
				$otherCount += $data["cnt"];
			
			}
		
			$out .= itemRenderer("frequentPorts", $data);
		
		}
		
		if ($otherCount) $chartArray[] = "{host: 'Other', total: " . $otherCount . "}";
		
	} else {
	
		$out .= "No data available";
	
	}

	return arrayToObject(array("table" => $out, "chart" => "var chartData = [" . implode(",", $chartArray) . "]"));	
	
}

?>