<?php

function prv_frequentRisks() {

	if (!getVar("num")) setVar("num", 50);
	if (!getVar("type")) setVar("type", 1);

	$_ENV['contentTitle'] = "Frequent Risk Levels";

	$_ENV['templateData'] = frequentRisksData();

	$_ENV['template'] = "template_frequentRisks.php";

}

function frequentRisksData() {

	$num = sanitize("num");
	if (!$num) $num = 50;
		
	$type = sanitize("type");
	if (!$type) $type = 1;

	$type == 1 ? $order = "DESC" : $order = "ASC";

	$chartArray = array();
	$resultArray = array();

	$total = 0;

	if (ops("site_custom_snortGroup") == 1) {

		// Custom Grouping Results
	
		$result = $_ENV['appDB']->query("SELECT count(mas.id) AS cnt, evt.priority FROM idsDataStore_" . $_SESSION["user"]["activeSearchStore"] . "_Master as mas LEFT JOIN idsDataStore_" . $_SESSION["user"]["activeSearchStore"] . "_Events as evt USING (id) where evt.customGrouping RLIKE REPLACE ( REPLACE ( REPLACE ('" . $_SESSION["user"]["sensors"] . "','+','[+]'), ' ', ''), ',', '|') group by evt.priority order by cnt $order limit $num");

	} else {

		// Standard Results

		$result = $_ENV['appDB']->query("SELECT count(mas.id) AS cnt, evt.priority FROM idsDataStore_" . $_SESSION["user"]["activeSearchStore"] . "_Master as mas LEFT JOIN idsDataStore_" . $_SESSION["user"]["activeSearchStore"] . "_Events as evt USING (id) where mas.sensorID in (" . $_SESSION["user"]["sensors"] . ") group by evt.priority order by cnt $order limit $num");
	
	}

	if ($result) {

		while ($row = mysql_fetch_assoc($result)) {
	
			$total += $row["cnt"];
			
			$resultArray[] = $row;
			
		}
					
		foreach ($resultArray as $data) {
		
			$typeArray[] = $data["priority"];
		
			$data["percent"] = number_format($data["cnt"] / $total * 100, 2);
		
			if (count($chartArray) <= 10) {
			
				$chartArray[] = "{priority: " . $data["priority"] . ", total: " . $data["cnt"] . "}";
				
			}
		
			$out .= itemRenderer("frequentRisks", $data);
		
		}

		if (!in_array("1", $typeArray)) {
		
			$chartArray[] = "{priority: 1, total: 0}";
			$out .= itemRenderer("frequentRisks", array("priority" => 1, "cnt" => 0, "percent" => 0.00));
		
		}

		if (!in_array("2", $typeArray)) {
		
			$chartArray[] = "{priority: 2, total: 0}";
			$out .= itemRenderer("frequentRisks", array("priority" => 2, "cnt" => 0, "percent" => 0.00));
		
		}
		
		if (!in_array("3", $typeArray)) {
		
			$chartArray[] = "{priority: 3, total: 0}";
			$out .= itemRenderer("frequentRisks", array("priority" => 3, "cnt" => 0, "percent" => 0.00));
		
		}

		if (!in_array("4", $typeArray)) {
		
			$chartArray[] = "{priority: 4, total: 0}";
			$out .= itemRenderer("frequentRisks", array("priority" => 4, "cnt" => 0, "percent" => 0.00));
		
		}

		if (!in_array("5", $typeArray)) {
		
			$chartArray[] = "{priority: 5, total: 0}";
			$out .= itemRenderer("frequentRisks", array("priority" => 5, "cnt" => 0, "percent" => 0.00));
		
		}
		
	} else {
	
		$out .= "No data available";
	
	}

	return arrayToObject(array("table" => $out, "chart" => "var chartData = [" . implode(",", $chartArray) . "]"));	
	
}

?>