<?php

function prv_frequentSensors() {

	if (!getVar("num")) setVar("num", 50);
	if (!getVar("type")) setVar("type", 1);

	$_ENV['contentTitle'] = "Frequent Sensors";

	$_ENV['templateData'] = frequentSensorsData();

	$_ENV['template'] = "template_frequentSensors.php";

}

function frequentSensorsData() {

	$num = sanitize("num");
	if (!$num) $num = 50;
		
	$type = sanitize("type");
	if (!$type) $type = 1;

	$type == 1 ? $order = "DESC" : $order = "ASC";

	$resolve = sanitize("resolve");
	if (!$resolve) $resolve = 0;

	$resolve == 0 ? $resolve = false : $resolve = true;

	$chartArray = array();
	$resultArray = array();

	$total = 0;
	$otherCount = 0;

	if (ops("site_custom_snortGroup") == 1) {

		// Custom Grouping Results
	
		$result = $_ENV['appDB']->query("SELECT count(mas.id) AS cnt, sensorID FROM idsDataStore_" . $_SESSION["user"]["activeSearchStore"] . "_Master AS mas WHERE evt.customGrouping RLIKE REPLACE ( REPLACE ( REPLACE ('" . $_SESSION["user"]["sensors"] . "','+','[+]'), ' ', ''), ',', '|') GROUP BY mas.sensorID ORDER BY cnt $order limit $num");
	
	} else {
	
		// Standard Results
	
		$result = $_ENV['appDB']->query("SELECT count(mas.id) AS cnt, sensorID FROM idsDataStore_" . $_SESSION["user"]["activeSearchStore"] . "_Master AS mas WHERE mas.sensorID in (" . $_SESSION["user"]["sensors"] . ") GROUP BY mas.sensorID ORDER BY cnt $order limit $num");
	
	}

	if ($result) {

		while ($row = mysql_fetch_assoc($result)) {
	
			$row["sensorName"] = getSensorNameByID($row['sensorID']);
			
			$total += $row["cnt"];
			
			$resultArray[] = $row;
			
		}
	
		foreach ($resultArray as $data) {
		
			$data["percent"] = number_format($data["cnt"] / $total * 100, 2);
		
			if (count($chartArray) <= 10) {
			
				$chartArray[] = "{sensor: '" . htmlentities($data["sensorName"]) . "', total: " . $data["cnt"] . "}";
				
			} else {
			
				$otherCount += $data["cnt"];
			
			}
		
			$out .= itemRenderer("frequentSensors", $data);
		
		}
		
		if ($otherCount) $chartArray[] = "{sensor: 'Other', total: " . $otherCount . "}";

	} else {
	
		$out .= "No data available";
	
	}

	return arrayToObject(array("table" => $out, "chart" => "var chartData = [" . implode(",", $chartArray) . "]"));	

}

?>