<?php

function prv_frequentTags() {

	if (!getVar("num")) setVar("num", 50);
	if (!getVar("type")) setVar("type", 1);
	if (!getVar("direction")) setVar("direction", 1);
	if (!getVar("protocol")) setVar("protocol", 6);

	$_ENV['contentTitle'] = "Frequent Tags";

	$_ENV['templateData'] = frequentTagsData();

	$_ENV['template'] = "template_frequentTags.php";

}

function frequentTagsData() {

	$num = sanitize("num");
	if (!$num) $num = 50;
		
	$type = sanitize("type");
	if (!$type) $type = 1;

	$type == 1 ? $order = "DESC" : $order = "ASC";

	$chartArray = array();
	$resultArray = array();

	$total = 0;
	$otherCount = 0;

	$result = $_ENV['appDB']->query("SELECT idx.tagID, idsTags.name, count(idx.eventID) as cnt FROM idsDataStore_" . $_SESSION["user"]["activeSearchStore"] . "_Tag_Index AS idx JOIN idsTags ON (idsTags.id = idx.tagID) JOIN idsDataStore_" . $_SESSION["user"]["activeSearchStore"] . "_Master AS mas ON (mas.id = idx.eventID) WHERE mas.sensorID in (" . $_SESSION["user"]["sensors"] . ") GROUP by idx.tagID ORDER BY cnt $order limit $num");

	if ($result) {

		while ($row = mysql_fetch_assoc($result)) {
	
			$total += $row["cnt"];
			
			$resultArray[] = $row;
			
		}
	
		foreach ($resultArray as $data) {
		
			$data["percent"] = number_format($data["cnt"] / $total * 100, 2);
		
			if (count($chartArray) <= 10) {
			
				$chartArray[] = "{tag: '" . htmlentities($data["name"]) . "', total: " . $data["cnt"] . "}";
				
			} else {
			
				$otherCount += $data["cnt"];
			
			}
		
			$out .= itemRenderer("frequentTags", $data);
		
		}

		if ($otherCount) $chartArray[] = "{sensor: 'Other', total: " . $otherCount . "}";
		
	} else {
	
		$out .= "No data available";
	
	}

	return arrayToObject(array("table" => $out, "chart" => "var chartData = [" . implode(",", $chartArray) . "]"));	
	
}

?>